;*************************************************************************
; Formatted Source Listing
; Date : 05/26/93
; Time : 15:42:11
;
; System : CISMSG  The PARADOX-CIS Message Program
; File Name : C:\CIS\BATSYS.SC
; By : James Cap Walker and Mark Houpt with HELP from Freinds!
; Last modified 05/16/93  11:29:08 am
; Copyright (c) 1992-1993  BAT-Systems Consulting
; This program is represents a collection of code by:
; Tony Goodman
; Dan Erhmann
; Angelo Loudon
; Dan Paolini
; Desmond Nolan
; John Nelson
; Michael Hyatt
; James Cap Walker
; Michael J. Hyatt
;*************************************************************************



LIBNAME="Paradox"


PROCSTEP.N = 0
PROCTOTAL.N = 37

;BSC
; PROCEDURE   : MainMenu
; AUTHOR      : Mark T. Houpt
; PARAMETERS  : N\A
; RETURNS     :
; Special Info: Generated by Weston Brothers wbsLIB
;
;BSC

PROC MAINMENU()
    IF NOT ISASSIGNED(AUTOLIB) THEN
        AUTOLIB = "Paradox"
    ENDIF
    IF SETUP <> 1 THEN
       start.m()
    ENDIF

    SPLASHSCR(1)
    WHILE TRUE
        SYSINFO TO SYSVAL
        SETCANVAS DEFAULT
        PAINTCANVAS FILL "" ATTRIBUTE SYSCOLOR(1000) 1, 0, SYSVAL["SCREENHEIGHT"] - 2, SYSVAL["SCREENWIDTH"] - 1
        RELEASE VARS SYSVAL

        SHOWPULLDOWN
            "" : "System Menu" : ""
            SUBMENU
                "About" : "About Box" : "/About",
                "Clock" : "Clock" : "/Clock",
                "System" : "System Information" : "/System",
                "" : "" : "/",
                "Set~U~p" :  "SetUp Directory for MSG and CAT Files" : "/SetUp",
                "" : "" : "/",
                "Backup" : "Backup All Files" : "/Backup",
                "" : "" : "/",
                "Documentation" : "Program Documentation" : "/DocFile",
                "" : "" : "/",
                "Shell to ~D~OS" : "" : "/Shell to DOS"
            ENDSUBMENU,
            "Messages" : "Messages Menu" : "Messages"
            SUBMENU
                "View ALL Messages" : "View All Stored Messages" : "Messages/View ALL",
                "" : "" : "Messages/",
                "Convert New CIS Messages" : "Convert New CIS Messages" : "Messages/Convert New CIS Messages",
                "View ~L~ast Import" : "View most recent Inport of Messages" : "Messages/View Last Import",
                "" : "" : "Messages/",
                "Query Message Database" : "Query Message Database for Specific Forums" : ""
                SUBMENU
                   "Query By ~F~orum Only" : "Query Message Database for Specific Forums" : "Messages/Query Message Database",
                   "Query By ~S~ection Only" : "Query Message Database for Specific Section" : "Messages/Query Message Database Section",
                   "~Q~uery Section By Subject" : "Query Message Sections for Selected Subjects" : "Messages/Query Message Database Section-Subject"
                 ENDSUBMENU,
                "View Query ~R~esults" : "View Results table for Message Query" : "Messages/View Query Results"
            ENDSUBMENU,
            "Catalogs" : "Catalog Data Libraries" : "Catalogs"
            SUBMENU
                "View ALL Catalogs" : "View ALL files in CAT Table" : "Catalogs/View ALL Files",
                "" : "" : "Catalogs/",
                "Convert New CIS Catalogs" : "Convert and Import New CAT Files" : "Catalogs/Convert and Import CAT Files",
                "View ~L~ast Import" : "View most recent Inport of Catalog" : "Catalogs/View Last Import",
                "" : "" : "Catalogs/",
                "Query Catalog Database" : "Query Catalog Database for Specific Forums" : "Catalogs/Query Message Database",
                "View Query ~R~esults" : "View Results table for Catalog Query" : "Catalogs/View Query Results"
            ENDSUBMENU,
            "WorkSheets" : "WorkSheet Menu" : "WorkSheets"
            SUBMENU
                "Msg Count" : "Add Message Count To Qpro " : "WorkSheets/Msg Count"
            ENDSUBMENU,
            "Reports" : "Reports Menu" : "Reports"
            SUBMENU
                "All Forum Messages" : "Report all Forum Messages" : "Reports/All Forum Messages",
                "Last Forum Messages" : "Report forum Messages from Last Import" : "Reports/Last Forum Messages",
                "Query Message Report" : "Report all Messages in Most Recent Query" : "Reports/Query Message Report",
                "" : "" : "Reports/",
                "Catalog Report" : "Report ALL Catalog Entries" : "Reports/Catalog Report"
            ENDSUBMENU,
            "Exit" : "Exit Menu" : "Exit"
            SUBMENU
                "Exit to Paradox" : "Exit to Paradox if Available" : "Exit/Exit to Paradox",
                "Quit Program" : "" : "Exit/Quit Program"
            ENDSUBMENU
        ENDMENU

        GETMENUSELECTION KEYTO KEYCODE TO MENUSEL

        ; SaveAutolib = Autolib

        SWITCH
            CASE RETVAL = FALSE :
                QUITLOOP

            CASE MENUSEL = "/About" :
                CLEARMESSAGE.U()
                SHOWPULLDOWN
                ENDMENU
                WBSFILLSCREEN()
                SHOWABOUTBOX()
                SPLASHSCR(2)


            CASE MENUSEL = "/Clock" :
                CLEARMESSAGE.U()
                SHOWPULLDOWN
                ENDMENU
                WBSFILLSCREEN()
                TIMEDISPLAY()
                SPLASHSCR(2)

            CASE MENUSEL = "/System" :
                CLEARMESSAGE.U()
                SHOWPULLDOWN
                ENDMENU
                WBSFILLSCREEN()
                SYSINFOPROC()
                SPLASHSCR(2)

            CASE MENUSEL = "/SetUp" :
                CLEARMESSAGE.U()
                SHOWPULLDOWN
                ENDMENU
                WBSFILLSCREEN()
                start.m()
                SPLASHSCR(2)


            CASE MENUSEL = "/Backup" :
                CLEARMESSAGE.U()
                SHOWPULLDOWN
                ENDMENU
                WBSFILLSCREEN()
                BACKUPMANAGER()
                SPLASHSCR(2)

            CASE MENUSEL = "/DocFile" :
                CLEARMESSAGE.U()
                SHOWPULLDOWN
                ENDMENU
                WBSFILLSCREEN()
                VIEWDOC()
                SPLASHSCR(2)

            CASE MENUSEL = "/" :

            CASE MENUSEL = "/Shell to DOS" :
                CLEARMESSAGE.U()
                RUN BIG "command"
                SPLASHSCR(2)


            CASE MENUSEL = "Messages/View ALL" :
                CLEARMESSAGE.U()
                SHOWPULLDOWN
                ENDMENU
                WBSFILLSCREEN()
                ICISTAT1UPDATE("Icistat")
                SPLASHSCR(2)

            CASE MENUSEL = "Messages/" :
            CASE MENUSEL = "Messages/Convert New CIS Messages" :
                CLEARMESSAGE.U()
                SHOWPULLDOWN
                ENDMENU
                WBSFILLSCREEN()

                SWITCH
                    CASE FILEHANDLE[1] = 1 OR FILEHANDLE[1] = 3 OR FILEHANDLE[1] =BLANKNUM():
                        MtHImportFile(1,1,TRUE,1,1)  ;msg not ozcis
                    CASE FILEHANDLE[1] = 2:
                        MtHImportFile(1,2,TRUE,1,1)  ;msg not
                ENDSWITCH
                SPLASHSCR(2)

            CASE MENUSEL = "Messages/View Last Import" :
                CLEARMESSAGE.U()
                SHOWPULLDOWN
                ENDMENU
                WBSFILLSCREEN()
                ICISTAT1UPDATE("Last")
                SPLASHSCR(2)

            CASE MENUSEL = "Messages/" :
            CASE MENUSEL = "Messages/Query Message Database" :
                CLEARMESSAGE.U()
                SHOWPULLDOWN
                ENDMENU
                WBSFILLSCREEN()
                GETDIAG(1)
                SPLASHSCR(2)

            CASE MENUSEL = "Messages/Query Message Database Section" :
                CLEARMESSAGE.U()
                SHOWPULLDOWN
                ENDMENU
                WBSFILLSCREEN()
                GETDIAG(3)
                release vars allsect.y, showsect.y
                SPLASHSCR(2)

            CASE MENUSEL = "Messages/Query Message Database Section-Subject" :
                CLEARMESSAGE.U()
                SHOWPULLDOWN
                ENDMENU
                WBSFILLSCREEN()
                GETDIAG(4)
                release vars allsect.y, showsect.y
                SPLASHSCR(2)


            CASE MENUSEL = "Messages/View Query Results" :
                CLEARMESSAGE.U()
                SHOWPULLDOWN
                ENDMENU
                WBSFILLSCREEN()
                ICISTAT1UPDATE("QueryMsg")
                SPLASHSCR(2)

            CASE MENUSEL = "Catalogs/View ALL Files" :
                CLEARMESSAGE.U()
                SHOWPULLDOWN
                ENDMENU
                WBSFILLSCREEN()
                ICISTAT1UPDATE("Idl")
                SPLASHSCR(2)

            CASE MENUSEL = "Catalogs/Convert and Import CAT Files" :
                CLEARMESSAGE.U()
                SHOWPULLDOWN
                ENDMENU
                WBSFILLSCREEN()
                SWITCH
                    CASE FILEHANDLE[1] = 1 OR FILEHANDLE[1] = 3 OR FILEHANDLE[1] =BLANKNUM():
                        MtHImportFile(2,1,TRUE,1,1)  ;cat not ozcis
                    CASE FILEHANDLE[1] = 2:
                        MtHImportFile(2,2,TRUE,1,1)  ;cat ozcis
                ENDSWITCH
                SPLASHSCR(2)

            CASE MENUSEL = "Catalogs/View Last Import" :
                CLEARMESSAGE.U()
                SHOWPULLDOWN
                ENDMENU
                WBSFILLSCREEN()
                ICISTAT1UPDATE("lastdl")
                SPLASHSCR(2)

            CASE MENUSEL = "Catalogs/" :
            CASE MENUSEL = "Catalogs/Query Message Database" :
                CLEARMESSAGE.U()
                SHOWPULLDOWN
                ENDMENU
                WBSFILLSCREEN()
                GETDIAG(2)
                SPLASHSCR(2)

            CASE MENUSEL = "Catalogs/View Query Results" :
                CLEARMESSAGE.U()
                SHOWPULLDOWN
                ENDMENU
                WBSFILLSCREEN()
                ICISTAT1UPDATE("lastdl")
                SPLASHSCR(2)


            CASE MENUSEL = "WorkSheets/Msg Count" :
                CLEARMESSAGE.U()
                SHOWPULLDOWN
                ENDMENU
                WBSFILLSCREEN()
                GETMSGCOUNT()
                SPLASHSCR(2)

            CASE MENUSEL = "Reports/All Forum Messages" :
                CLEARMESSAGE.U()
                SHOWPULLDOWN
                ENDMENU
                WBSFILLSCREEN()
                GETRPT(1)
                SPLASHSCR(2)

            CASE MENUSEL = "Reports/Last Forum Messages" :
                CLEARMESSAGE.U()
                SHOWPULLDOWN
                ENDMENU
                WBSFILLSCREEN()
                GETRPT(2)
                SPLASHSCR(2)

            CASE MENUSEL = "Reports/Query Message Report" :
                CLEARMESSAGE.U()
                SHOWPULLDOWN
                ENDMENU
                WBSFILLSCREEN()
                GETRPT(3)
                SPLASHSCR(2)

            CASE MENUSEL = "Reports/" :
            CASE MENUSEL = "Reports/Catalog Report" :
                CLEARMESSAGE.U()
                SHOWPULLDOWN
                ENDMENU
                WBSFILLSCREEN()
                GETRPT(4)
                SPLASHSCR(2)

            CASE MENUSEL = "Exit/Exit to Paradox" :

                CLEARMESSAGE.U()
                SHOWPULLDOWN
                ENDMENU
                WBSFILLSCREEN()
                LEAVEAPP(1)


            CASE MENUSEL = "Exit/Quit Program" :
                CLEARMESSAGE.U()
                SHOWPULLDOWN
                ENDMENU
                WBSFILLSCREEN()
                LEAVEAPP(2)


        ENDSWITCH

        ; Autolib = SaveAutolib
    ENDWHILE

    CLEARPULLDOWN

ENDPROC
WRITELIB LIBNAME MAINMENU
RELEASE VARS MAINMENU
LB_DISPLAYPROGRESS.U(PROCTOTAL.N, "MainMenu" )



;BSC
; PROCEDURE   : Icistat1Update
; AUTHOR      : Mark T. Houpt
; PARAMETERS  : N\A
; RETURNS     :
; Special Info: View Message and Catalog Procedure
;
;BSC

PROC ICISTAT1UPDATE(TBLS)
    PRIVATE TBLS
    WINM = 1
    WinToClose = 1
    DYNARRAY BUTTONS[]

    DYNARRAY BUTTONS[]
    BUTTONS["Quit"]="QuitView()"
    BUTTONS["System"]="SysInfoProc()"
    BUTTONS["Print"]="DT_Rec_PRINT_CUSTOM()"
    BUTTONS[">>"]="End"
    BUTTONS[">"]= "PgDn"
    BUTTONS["<"]= "PgUp"
    BUTTONS["<<"]="Home"
    BUTTONS["Find"]="Zoom"
    BUTTONS["Sort"]= "OrderTable"
    BUTTONS["Help"]= "HelpMeDlg(3)"


    ;-- Wait with an Event Proc ---------------------------------
    ECHO OFF
    IF NRECORDS(TBLS) >= 1 THEN

        VIEW TBLS
        SOURCETBLWIN = GETWINDOW()
        WINDOW MOVE SOURCETBLWIN TO 10,-200
        ;WINDOW HANDLE FORM TO SOURCEFRM
        Pickform 1
        FORMWINDOW=GETWINDOW()
        MAXWINDOW(FORMWINDOW)
        FIXMSGBOX(1)
        BUTTON_OBJECTS(BUTTONS)        ;Setup the Buttons
        SHOWPULLDOWN
            ""       :  "Display Systems Information"             : "AppInfo",
            "~T~able"    :  "Save Records and Return"                 : ""
            SUBMENU
                "~F~irst"    :   " Moveto Leaselog Table"  : "FirstRec",
                "~L~ast"    :   " Moveto Leaselog Table"  : "LastRec",
                "~N~ext"    :   " Moveto Leaselog Table"  : "NextRec",
                "~P~revious"    :   " Moveto Leaselog Table"  : "PrevRec",
                "P~r~int"     :   " Print Current Record"  : "PrintRec",
                "Memo Window" :   "Move to Memo Window"    : "SelWin1",
                "Form ~W~indow" :   "Move to Form Window"    : "SelWin2",
                "Help"        : "Open Help Window"         : "HelpWind"

            ENDSUBMENU,
            "~E~xit"      :  "Exit View Screen"                     : "QuitView"
        ENDMENU
        PROMPT ""
        ECHO NORMAL
        WAIT WORKSPACE
            PROC "ViewWaitProc"
            KEY "DOS" , "DOSBIG" , "F2" , "ZOOM" , "FIELDVIEW" , -108, "F4" , "F3", 16, "PgDn", "PgUp"
            MESSAGE "MENUSELECT", "MAXIMIZE"
            MOUSE "DOWN","AUTO"
            trigger "ARRIVETABLE"
        ENDWAIT
        PROMPT ""
        ECHO OFF
    ELSE
        OK.U("FILE EMPTY", "There are NO records//in the Table", TRUE,TRUE)
        ECHO OFF
    ENDIF
ENDPROC

WRITELIB LIBNAME ICISTAT1UPDATE
RELEASE PROCS ICISTAT1UPDATE
LB_DISPLAYPROGRESS.U(PROCTOTAL.N, "Icistat1Update" )


;BSC
; PROCEDURE   : ViewWaitProc
; AUTHOR      : Mark T. Houpt
; PARAMETERS  : N\A
; RETURNS     :
; Special Info: View Message and Catalog Procedure WaitProc
;
;BSC

PROC VIEWWAITPROC(EVENTTYPE, EVENTRECORD, CYCLENUMBER)
    SWITCH
            ; Tony Goodman's GUIBUTON handling routine
            ;
        CASE EVENTRECORD["TYPE"] = "MOUSE":
            WINHANDLE=WINDOWAT(EVENTRECORD["Row"],EVENTRECORD["Col"])
            IF WINHANDLE >0 THEN
                WINDOW GETATTRIBUTES WINHANDLE TO WINATTRIB

                IF MATCH(WINATTRIB["Title"],"..;METHOD") THEN
                    GUIFRAME(WINHANDLE,"In")
                    IF EVENTRECORD["Action"]="DOWN" THEN
                        SLEEP 100
                    ENDIF
                    GUIFRAME(WINHANDLE,"Out")

                    EXECUTE WINATTRIB["Title"] ;Execute Button Method
                    IF ISASSIGNED(RETVAL) AND
                        (RETVAL=1 OR RETVAL=2 OR RETVAL=0) THEN
                        RETURN RETVAL ;Return a 0 or 1 or 2
                    ELSE
                        RETURN 1 ;Return to Wait
                    ENDIF
                ELSE

                    RETURN 0
                ENDIF
            ENDIF
            RETURN 0 ;Process the Mouse event normally
            ;
            ;
        CASE EVENTTYPE = "DEPARTFIELD" :
            RETURN 0
        CASE EVENTTYPE = "ARRIVEROW" :
            RETURN 0
        CASE EVENTTYPE= "ARRIVETABLE" :
            Moveto [FORUM]
            RETURN 1
        CASE EVENTRECORD["TYPE"] = "KEY":
            SWITCH
                CASE EVENTRECORD["KEYCODE"] = ASC("F2"):
                    QUITVIEW()
                    RETURN 2
                CASE EVENTRECORD["KEYCODE"] = ASC("F3"):
                    DOWNIMAGE
                    RETURN 1
                CASE EVENTRECORD["KEYCODE"] = ASC("F4"):
                    UPIMAGE
                    RETURN 1
                CASE EVENTRECORD["KEYCODE"] = ASC("PgUp"):
                    PGUP
                    RETURN 1
                CASE EVENTRECORD["KEYCODE"] = ASC("PgDn"):
                    PGDN
                    RETURN 1

                CASE EVENTRECORD["KEYCODE"] = ASC(16):
                    POSTRECORD NOPOST LEAVELOCKED
                    RETURN 1
                CASE EVENTRECORD["KEYCODE"] = -108:
                    RETURN 0
                CASE EVENTRECORD["KEYCODE"] = ASC("FIELDVIEW"):
                    RETURN 0
                OTHERWISE:
                    RETURN 0
            ENDSWITCH

        CASE EVENTRECORD["MESSAGE"] = "MENUSELECT" :
            SWITCH
                CASE EVENTRECORD["MENUTAG"] = "AppInfo":
                    SHOWABOUTBOX()
                    RETURN 1
                CASE EVENTRECORD["MENUTAG"] = "QuitView":
                    QUITVIEW()
                    RETURN 2
                CASE EVENTRECORD["MENUTAG"] = "FirstRec":
                    HOME
                    RETURN 1
                CASE EVENTRECORD["MENUTAG"] = "LastRec":
                    END
                    RETURN 1
                CASE EVENTRECORD["MENUTAG"] = "PrevRec":
                    PGUP
                    RETURN 1
                CASE EVENTRECORD["MENUTAG"] = "NextRec":
                    PGDN
                    RETURN 1
                CASE EVENTRECORD["MENUTAG"] = "PrintRec":
                    ; Kallista's Print Current Record
                    DT_REC_PRINT_CUSTOM()
                    RETURN 1
                CASE EVENTRECORD["MENUTAG"] = "SelWin1":
                    Window Select MemoWindow
                    RETURN 1
                CASE EVENTRECORD["MENUTAG"] = "SelWin2":
                    Window Select FormWindow
                    Moveto [FORUM]
                    WinToClose = 2
                    RETURN 1
                CASE EVENTRECORD["MENUTAG"] = "HelpWind":
                    HelpMeDlg(3)
                    RETURN 1
                OTHERWISE:
                    RETURN 0
            ENDSWITCH
        CASE EVENTRECORD["MESSAGE"] = "MAXIMIZE" :
            IF WINM = 1 THEN
                WINDOW RESIZE GETWINDOW() TO 21, 80
                WINDOW MOVE GETWINDOW() TO 1, 0
                SETWINDOW(GETWINDOW(),1)
                WINM = 2
            ELSE
                WINDOW RESIZE GETWINDOW() TO 11, 80
                WINDOW MOVE GETWINDOW() TO 11, 0
                SETWINDOW(GETWINDOW(),1)
                WINM = 1
            ENDIF
            RETURN 1
        OTHERWISE :
            RETURN 0
    ENDSWITCH
ENDPROC
WRITELIB LIBNAME VIEWWAITPROC
RELEASE PROCS VIEWWAITPROC
LB_DISPLAYPROGRESS.U(PROCTOTAL.N, "ViewWaitProc")



;BSC
; PROCEDURE   : QuitView
; AUTHOR      : Mark T. Houpt
; PARAMETERS  : N\A
; RETURNS     :
; Special Info: Closes all open windows when exiting View
;               including ButtonBar
;BSC

PROC QUITVIEW()
   IF ISFIELDVIEW() THEN
      IF SEARCH("M", FIELDTYPE()) > 0 THEN
         WINDOW
         CLOSE ; cancel memo field changes
      ELSE
         DO_IT! ; end non-memo fieldview
      ENDIF
   ENDIF

   MESSAGE ""
   ECHO OFF
   WINDOW LIST TO ALLWINDOWS
   SWITCH
      CASE WinToClose = 1:
         FOR WINDOWHANDLE FROM 1 TO ARRAYSIZE(ALLWINDOWS)-1
            WINDOW SELECT ALLWINDOWS[windowhandle]
            WINDOW
            CLOSE
         ENDFOR
      CASE WinToClose = 2:
         FOR WINDOWHANDLE FROM 1 TO ARRAYSIZE(ALLWINDOWS)-2
            WINDOW SELECT ALLWINDOWS[windowhandle]
            WINDOW
            CLOSE
         ENDFOR
   ENDSWITCH
   MESSAGE ""
   WBSFILLSCREEN()
   CLEARALL

   RETURN 2
ENDPROC
WRITELIB LIBNAME QUITVIEW
RELEASE PROCS QUITVIEW
LB_DISPLAYPROGRESS.U(PROCTOTAL.N, "QuitView")





PROC GETDIAG(NBR)
    PRIVATE  NBR

    CLEARALL
    SWITCH
        CASE NBR = 1:
            ANS=CISDIAG(1)
            IF ANS = TRUE THEN
                QUERYFORMSG(1)
            ELSE
                MESSAGE.U("Cancel", "Operation Canceled..." , TRUE, TRUE)
                SLEEP 2000
                CLEARMESSAGE.U()
            ENDIF
        CASE NBR = 2:
            ANS=CISDIAG(2)
            IF ANS = TRUE THEN
                QUERYFORCAT()
            ELSE
                MESSAGE.U("Cancel", "Operation Canceled..." , TRUE, TRUE)
                SLEEP 2000
                CLEARMESSAGE.U()
            ENDIF
        CASE NBR = 3:
            ANS=GetSectionsDLG.a()
            IF ANS <> "Cancel" THEN
                QUERYFORMSG(2)
            ELSE
                MESSAGE.U("Cancel", "Operation Canceled..." , TRUE, TRUE)
                SLEEP 2000
                CLEARMESSAGE.U()
            ENDIF

        CASE NBR = 4:
            ANS=GetSectionsDLG.a()
            IF ANS <> "Cancel" THEN
                QUERYFORMSG(3)
            ELSE
                MESSAGE.U("Cancel", "Operation Canceled..." , TRUE, TRUE)
                SLEEP 2000
                CLEARMESSAGE.U()
            ENDIF

    ENDSWITCH
ENDPROC
WRITELIB LIBNAME GETDIAG
RELEASE PROCS GETDIAG
LB_DISPLAYPROGRESS.U(PROCTOTAL.N, "GetDiag" )





;BSC
; PROCEDURE   : CisDiag
; AUTHOR      : Mark T. Houpt
; PARAMETERS  : N\A
; RETURNS     : RetVal
; Special Info: Build array of Forum Names for Diag Box
;               Uses Dickford Conn's Not_In.sc Code
;BSC

PROC CISDIAG(NBR)
   PRIVATE  I,J,NBR,mtable1, mtable2, fname

   ; PaintPAL_Generated_Code_Begin(428099811)
   rsp=YesNo.l("UPDATE", "Do you wish to Update your Forum List?" ,true,true)
   IF rsp= TRUE THEN

      MESSAGE.U("FORUMS", "Gathering Forum Names/" + "Please Wait..." , TRUE, FALSE)
      SWITCH
         CASE NBR = 1:

            mtable1="Forum"
            mtable2="Icistat"
            fname = "FORUM"


            MENU {Ask} SELECT mtable1
            MOVETO FIELD fname
            [] = "_c,COUNT=0"
            MENU {Ask} SELECT mtable2
            ;CTRLHOME CHECK                       ;Substitute THESE lines for the next one
            ;MOVETO fname                         ;IF you want complete records
            MOVETO FIELD fname CHECK
            [] = "_c!"
            DO_IT!
         CASE NBR = 2:
            mtable1="Forum"
            mtable2="Idl"
            fname = "FORUM"



            MENU {Ask} SELECT mtable1
            MOVETO FIELD fname
            [] = "_c,COUNT=0"
            MENU {Ask} SELECT mtable2
            ;CTRLHOME CHECK                       ;Substitute THESE lines for the next one
            ;MOVETO fname                         ;IF you want complete records
            MOVETO FIELD fname CHECK
            [] = "_c!"
            DO_IT!

      ENDSWITCH
      IF nrecords("Answer") >=1 THEN
         ADD "Answer" "Forum"
      ENDIF
   ENDIF

   VIEW "forum"
   J = NRECORDS("forum")
   ARRAY FORUMS[j+1]
   FORUMS[1] = "ALL"
   FOR I FROM 1 TO J
      MOVETO RECORD(I)
      FORUMS[i+1] = [forum]
   ENDFOR
   CLEARALL
   CLEARMESSAGE.U()

   FORUM.A=1
   SDATE=BLANKDATE()
   EDATE=BLANKDATE()
   PICKRB=2


   SHOWDIALOG
      "Forum Query Dialog"
      @3,15 HEIGHT 18 WIDTH 49

      PAINTCANVAS FILL "Pick Forum" ATTRIBUTE 112 2,5,2,14

      PAINTCANVAS FILL "Date Range" ATTRIBUTE 112 5,31,5,40

      ; PaintPAL_Frame_Begin
      FRAME SINGLE FROM 1,2 TO 3,18
      PAINTCANVAS ATTRIBUTE 127 1,2,1,18
      PAINTCANVAS ATTRIBUTE 127 1,2,3,2
      PAINTCANVAS ATTRIBUTE 112 3,3,3,18
      PAINTCANVAS ATTRIBUTE 112 1,18,3,18
      ; PaintPAL_Frame_End

      ; PaintPAL_Frame_Begin
      FRAME SINGLE FROM 4,27 TO 6,44
      PAINTCANVAS ATTRIBUTE 127 4,27,4,44
      PAINTCANVAS ATTRIBUTE 127 4,27,6,27
      PAINTCANVAS ATTRIBUTE 112 6,28,6,44
      PAINTCANVAS ATTRIBUTE 112 4,44,6,44
      ; PaintPAL_Frame_End

      PICKARRAY @5,2 HEIGHT 9 WIDTH 17
         COLUMNS 1
         FORUMS
         TAG "ForumTag"
         TO FORUM.A

      RADIOBUTTONS @1,28 HEIGHT 2 WIDTH 12
         "All",
         "Todays"
         TAG "RBtag"
         TO PICKRB

      ACCEPT @8,30 WIDTH 12
      "D"
      TAG "SdateTag"
      TO SDATE

      LABEL @7,30
         "Start Date"
         FOR "SdateTag"

      ACCEPT @10,30 WIDTH 12
      "D"

      TAG "EdateTag"
      TO EDATE

      LABEL @9,30
         "End Date"
         FOR "EdateTag"


      PUSHBUTTON @13,24 WIDTH 8
         "~O~k"
         OK
         DEFAULT
         VALUE "Ok"
         TAG "OkTag"
         TO OKCANCEL

      PUSHBUTTON @13,33 WIDTH 12
         "~C~ancel"
         CANCEL
         VALUE ""
         TAG "CancelTag"
         TO OKCANCEL


   ENDDIALOG
   RETURN RETVAL
   ; PaintPAL_Generated_Code_End(428099811)

ENDPROC
WRITELIB LIBNAME CISDIAG
RELEASE PROCS CISDIAG
LB_DISPLAYPROGRESS.U(PROCTOTAL.N, "CisDiag" )



;BSC
; PROCEDURE   : QueryForMsg
; AUTHOR      : Mark T. Houpt
; PARAMETERS  : N\A
; RETURNS     :
; Special Info: Query for designated messages
;
;BSC

PROC QUERYFORMSG(nbr)
   PRIVATE  nbr
   if nbr <> 3 then
       MESSAGE.U("MESSAGE QUERY", "Getting messages/" + "Please wait..." , TRUE, FALSE)
   else
       MESSAGE.U("MESSAGE QUERY", "Getting Subjects/" + "Please wait..." , TRUE, FALSE)
   endif
   DAT=""
   SWITCH
      CASE nbr=1:
         FM=FORUMS[forum.a]
      CASE Nbr = 2 or nbr = 3:
         atf=search("|",ShowSectindex.a)
         FM=substr(ShowSectindex.a,1,(atf-1))

         QUERY

 Icistat | Forum | Sect Number | Sect Name |
         | ~fm   | Check       | ~ans      |

 Icistat |
         |

         ENDQUERY
         DO_IT!
         VIEW "answer"
         sect = [sect number]
         CLEARALL

   ENDSWITCH



   QUERY

 Icistat | Start Msg | In Reply To | Msg Number | Forum  | Sect Number |
         | Check     | Check       | Check      | Check  | Check       |

 Icistat | Sect Name |    Date     |  Time  | Subject | From Name |
         | Check     | Check       | Check  | Check   | Check     |

 Icistat | From PPN | To Name | To PPN | Message |
         | Check    | Check   | Check  | Check   |

   ENDQUERY



   IF SDATE = BLANKDATE() AND EDATE= BLANKDATE() THEN
      IF PICKRB = 2 THEN
         DAT = TODAY()
      ENDIF
   ENDIF
   IF SDATE > BLANKDATE() AND EDATE = BLANKDATE() THEN
      DAT = ">=" + STRVAL(SDATE)
   ENDIF
   IF SDATE= BLANKDATE() AND EDATE> BLANKDATE() THEN
      DAT= "<=" + STRVAL(EDATE)
   ENDIF
   IF SDATE > BLANKDATE() AND EDATE > BLANKDATE() THEN
      DAT = ">=" + STRVAL(SDATE) + ", <=" + STRVAL(EDATE)
   ENDIF
   SWITCH

      CASE nbr= 1:
         IF FORUM.A > 1 THEN
            MOVETO [Forum]
            TYPEIN FM
         ENDIF

      CASE nbr = 2 or nbr = 3:
         IF FM > "" THEN
            MOVETO [Forum]
            TYPEIN FM
         ENDIF
         IF ans > "" THEN
            MOVETO [SECT NUMBER]
            TYPEIN sect
         ENDIF
   ENDSWITCH


   IF DAT > "" OR PICKRB = 2 THEN
      MOVETO [date]
      TYPEIN DAT
   ENDIF

   DO_IT!

   EMPTY "QueryMsg"
   ADD "Answer" "QueryMsg"
   CLEARMESSAGE.U()
   CLEARALL
   IF NRECORDS("Answer") > 0 THEN
      goon1 = ""
      if nbr = 3 then
         goon1=GetSubject()
      endif
      if goon1 <> "Esc" then
         OK.U("MESSAGE QUERY", "You May View Your Messages Now..." , TRUE, TRUE)
      else
         MESSAGE.U("Cancel", "Operation Canceled..." , TRUE, TRUE)
         SLEEP 2000
         CLEARMESSAGE.U()
         SLEEP 2000
      ENDIF
   ELSE
      OK.U("So Sorry", "No Records Found..." , TRUE,TRUE)
      SLEEP 3000
   ENDIF

;   RELEASE VARS FORUM, FORUM.A,FORUMS, SDATE, EDATE, PICKRB,DAT, Forum.Y, SHOWSECT.Y, ANS, ATF, ALLSECT.Y, A, INDEX.A
ENDPROC
WRITELIB LIBNAME QUERYFORMSG
RELEASE PROCS QUERYFORMSG
LB_DISPLAYPROGRESS.U(PROCTOTAL.N, "QueryForMsg" )




;BSC
; PROCEDURE   : getSectionsDLG.a
; AUTHOR      : Mark T. Houpt
; COPYRIGHT   : (C) 1993 BAT-Systems Consulting
; PARAMETERS  :
;
; RETURNS     : Forun Section Name or Cancel
;
; Special Info: Adapted from Example D9 from Pdox Video Conference by
;               Kevin Smith
;BSC

PROC getSectionsDLG.a()
   PRIVATE  mtable1,mtable2,mtable3,fname,fname2,rsp,helpme.a, forums.y

   rsp=YesNo.l("UPDATE", "Do you wish to Update your Forum List?" ,true,true)
   IF rsp = TRUE THEN
      MESSAGE.U("FORUMS", "Gathering Forum Names/" + "Please Wait..." , TRUE, FALSE)
      mtable1="Forum"
      mtable2="Icistat"
      fname = "FORUM"


      MENU {Ask} SELECT mtable1
      MOVETO FIELD fname
      [] = "_c,COUNT=0"
      MENU {Ask} SELECT mtable2
      ;CTRLHOME CHECK                       ;Substitute THESE lines for the next one
      ;MOVETO fname                         ;IF you want complete records
      MOVETO FIELD fname CHECK
      [] = "_c!"
      DO_IT!

      IF Nrecords("answer") >= 1 THEN
         ADD "answer" "forum"
      ENDIF
      CLEARALL
      ClearMessage.u()
      MESSAGE.U("FORUMS", "Gathering Section Names/" + "Please Wait..." , TRUE, FALSE)


      mtable1="MsgDlg1"
      mtable2="Icistat"
      fname = "FORUM"
      Fname2 = "SECT NUMBER"


      MENU {Ask} SELECT mtable1
      MOVETO FIELD fname
      [] = "_c,COUNT=0"
      MENU {Ask} SELECT mtable2
      ;CTRLHOME CHECK                       ;Substitute THESE lines for the next one
      ;MOVETO fname                         ;IF you want complete records
      MOVETO FIELD fname CHECK
      MOVETO FIELD fname2 CHECK
      [] = "_c!"
      DO_IT!
      CLEARALL
      IF nrecords("Answer") >= 1 THEN
         ADD "Answer" "MsgDlg1"
      ENDIF
      QUERY

 Msgdlg1 |  Forum   | Sect Number |
         | Check _a | _b          |

 Icistat | Forum | Sect Number | Sect Name |
         | _a    | _b          | Check     |

 Icistat |
         |

      ENDQUERY
      DO_IT!
      IF Nrecords("answer") >= 1 THEN
         ADD "answer" "MsgDlg2"
      ENDIF
      CLEARALL
      CLEARMESSAGE.U()
   ENDIF

   VIEW "forum"
   VIEW "msgdlg2"
   DYNARRAY forums.y[]
   DYNARRAY AllSect.y []
   DYNARRAY ShowSect.y []
   SYSINFO TO sys.y
   MOVETO "forum"
   SCAN
      forums.y[ [forum] ] = [forum]
   ENDSCAN
   MOVETO "msgdlg2"
   SCAN
      AllSect.y[ [forum] + "|" + STRVAL([#]) ] = [sect name]
   ENDSCAN
   CLEARALL

   ; PaintPAL_Generated_Code_Begin(449009266)

   Sdate=BlankDate()
   Edate=BlankDate()
   OkCancel = "Cancel"
   PickRb=2

   SHOWDIALOG
      "Forums and Sections" ; H:\PALP\SECTION.DLG
      PROC "updateDLG.l"
      TRIGGER "OPEN" , "UPDATE"

      @2,4 HEIGHT 21 WIDTH 72

      ; PaintPAL_Frame_Begin
      FRAME SINGLE FROM 0,0 TO 18,69
      PAINTCANVAS ATTRIBUTE 127 0,0,0,69
      PAINTCANVAS ATTRIBUTE 112 18,0,18,69
      PAINTCANVAS ATTRIBUTE 127 0,0,18,0
      PAINTCANVAS ATTRIBUTE 112 0,69,18,69
      ; PaintPAL_Frame_End

      ; PaintPAL_Frame_Begin
      FRAME SINGLE FROM 2,1 TO 11,31
      PAINTCANVAS ATTRIBUTE 112 2,1,2,31
      PAINTCANVAS ATTRIBUTE 127 11,1,11,31
      PAINTCANVAS ATTRIBUTE 112 2,1,11,1
      PAINTCANVAS ATTRIBUTE 127 2,31,11,31
      ; PaintPAL_Frame_End

      ; PaintPAL_Frame_Begin
      FRAME SINGLE FROM 2,34 TO 11,66
      PAINTCANVAS ATTRIBUTE 112 2,34,2,66
      PAINTCANVAS ATTRIBUTE 127 11,34,11,66
      PAINTCANVAS ATTRIBUTE 112 2,34,11,34
      PAINTCANVAS ATTRIBUTE 127 2,66,11,66
      ; PaintPAL_Frame_End

      ; PaintPAL_Static_Text_Begin
      PAINTCANVAS FILL " " ATTRIBUTE 112 1,3,1,8
      @1,3
      ?? "Forums"
      PAINTCANVAS ATTRIBUTE 112 1,3,1,8
      ; PaintPAL_Static_Text_End

      ; PaintPAL_Static_Text_Begin
      PAINTCANVAS FILL " " ATTRIBUTE 112 1,36,1,43
      @1,36
      ?? "Sections"
      PAINTCANVAS ATTRIBUTE 112 1,36,1,43
      ; PaintPAL_Static_Text_End

      PICKDYNARRAY @3,2 HEIGHT 8 WIDTH 28
         Forums.y
         TAG "showTag"
         TO showIndex.a

      PICKDYNARRAY @3,35 HEIGHT 8 WIDTH 30
         ShowSect.y
         TAG "charTag"
         TO ShowSectIndex.a

      RADIOBUTTONS @13,2 HEIGHT 2 WIDTH 15
         "ALL Dates",
         "Today"
         TAG "RBtag"
         TO PickRB

      LABEL @12,2
         "Date Set"
         FOR "RBtag"

      ACCEPT @13,32 WIDTH 12
      "D"
      TAG "SdateTag"
      TO Sdate

      LABEL @13,19
         "Start Date:"
         FOR "SdateTag"

      ACCEPT @13,56 WIDTH 12
      "D"
      TAG "EdateTag"
      TO Edate

      LABEL @13,45
         "End Date:"
         FOR "EdateTag"

      PUSHBUTTON @16,13 WIDTH 10
         "~O~K"
         OK
         DEFAULT
         VALUE ""
         TAG "okTag"
         TO OKCancel

      PUSHBUTTON @16,30 WIDTH 8
         "~H~elp"
         VALUE HelpMeDLG(4)
         TAG "HelpTag"
         TO Helpme.a

      PUSHBUTTON @16,46 WIDTH 10
         "~C~ancel"
         CANCEL
         VALUE ""
         TAG "cancelTag"
         TO OKCancel
   ENDDIALOG

   ; PaintPAL_Generated_Code_End(449009266)


   IF RETVAL THEN
      RETURN ShowSect.y[ShowSectIndex.a]
   ELSE
      RETURN "Cancel"
   ENDIF


ENDPROC
WRITELIB LIBNAME GetSectionsDLG.a
RELEASE PROCS GetSectionsDLG.a
LB_DISPLAYPROGRESS.U(PROCTOTAL.N, "GetSectionsDLG" )




;BSC
; PROCEDURE   :
;
; Special Info: Adapted from Example D9 from Pdox Video Conference by
;               Kevin Smith
;BSC
PROC updateShowSect.u(showCode.a)
  DYNARRAY ShowSect.y []
  FOREACH index.a IN AllSect.y
    IF MATCH( index.a +"|", showcode.a +"|..") THEN
      ShowSect.y[index.a] = AllSect.y[index.a]
    ENDIF
  ENDFOREACH
ENDPROC
WRITELIB LIBNAME updateShowSect.u
RELEASE PROCS updateShowSect.u
LB_DISPLAYPROGRESS.U(PROCTOTAL.N, "UpdateShowSet.u" )




;BSC
; PROCEDURE   :
; PARAMETERS  :
;
; Special Info: Adapted from Example D9 from Pdox Video Conference by
;               Kevin Smith
;BSC
PROC updateDLG.l (Trigger.a, Tag.a, EventValue.v, cbLabel.a)
 IF trigger.a = "OPEN" OR tag.a = "showTag" THEN
    updateShowSect.u(CONTROLVALUE("showTag"))
    ; Don't simply use EventValue.v because this could be an OPEN trigger.
    REFRESHCONTROL "charTag"
 ENDIF
 RETURN TRUE
ENDPROC
WRITELIB LIBNAME updateDLG.l
RELEASE PROCS updateDLG.l
LB_DISPLAYPROGRESS.U(PROCTOTAL.N, "UpdateDLG.l" )





;BSC
; PROCEDURE   : QueryForCAT
; AUTHOR      : Mark T. Houpt
; PARAMETERS  : N\A
; RETURNS     :
; Special Info: Query for designated Catalog Files
;
;BSC

PROC QUERYFORCAT()
    MESSAGE.U("CATALOG QUERY", "Getting catalogs/" + "Please wait..." , TRUE, FALSE)
    DAT=""

    {Ask} SELECT "Idl"
    CTRLHOME CHECK


    FM=FORUMS[forum.a]

    IF SDATE = BLANKDATE() AND EDATE= BLANKDATE() THEN
        IF PICKRB = 2 THEN
            DAT = TODAY()
        ENDIF
    ENDIF
    IF SDATE > BLANKDATE() AND EDATE = BLANKDATE() THEN
        DAT = ">=" + STRVAL(SDATE)
    ENDIF
    IF SDATE= BLANKDATE() AND EDATE> BLANKDATE() THEN
        DAT= "<=" + STRVAL(EDATE)
    ENDIF
    IF SDATE > BLANKDATE() AND EDATE > BLANKDATE() THEN
        DAT = ">=" + STRVAL(SDATE) + ", <=" + STRVAL(EDATE)
    ENDIF


    IF FORUM.A > 1 THEN
        MOVETO [Forum]
        TYPEIN FM
    ENDIF

    IF DAT > "" OR PICKRB = 2 THEN
        MOVETO [date]
        TYPEIN DAT
    ENDIF

    DO_IT!

    EMPTY "lastdl"
    ADD "Answer" "lastdl"
    CLEARMESSAGE.U()
    CLEARALL
    IF NRECORDS("Answer") > 0 THEN

        OK.U("MESSAGE QUERY", "You May View Your Messages Now..." , TRUE, TRUE)
        SLEEP 2000
    ELSE
        OK.U("So Sorry", "No Records Found..." , TRUE,TRUE)
        SLEEP 3000
    ENDIF
    ; clearmessage.u()
    RELEASE VARS FORUM, FORUM.A,FORUMS, SDATE, EDATE, PICKRB,DAT
ENDPROC
WRITELIB LIBNAME QUERYFORCAT
RELEASE PROCS QUERYFORCAT
LB_DISPLAYPROGRESS.U(PROCTOTAL.N, "QueryForCat" )



;BSC
; PROCEDURE   : MtHImportFile
; AUTHOR      : Mark T. Houpt
; PARAMETERS
; Typ.n= 1 for MSG files 2 for Cat Files
; nbr =1 for TapCis 2 for OzCIS
; goon1 goon and mthgoon (as in go on) are branching params used
; in proceedure below  all start at 1
; RETURNS     :
; Special Info: Import MSG and CAT file routine
;
;BSC

PROC MtHImportFile(Typ.n, NBR,goon1,goon,mthgoon)
   PRIVATE  NBR,GOON, Z, I, M, X, MthGoon, Cw.n, msg.a

   IF NOT ISASSIGNED(FILEHANDLE[3]) THEN
      start.m()
   ENDIF
   IF IsAssigned(FILEHANDLE[3]) THEN
      {Tools} {Info} {Inventory} {Files}
      SWITCH
         CASE NBR = 2 and typ.n= 1 :
            IF UPPER(FILEHANDLE[2]) <> UPPER(DIRECTORY()) THEN
               TYPEIN FILEHANDLE[2]+"*.mes"
               ENTER
            ELSE
               {*.mes}
               ENTER ; DO_IT!
            ENDIF
         CASE NBR = 1 and typ.n = 1:
            IF UPPER(FILEHANDLE[2]) <> UPPER(DIRECTORY()) THEN
               TYPEIN FILEHANDLE[2]+"*.msg"
               ENTER
            ELSE
               {*.msg}
               ENTER ;DO_IT!
            ENDIF
         CASE NBR = 2 and typ.n = 2:
            IF UPPER(FILEHANDLE[2]) <> UPPER(DIRECTORY()) THEN
               TYPEIN FILEHANDLE[2]+"*.l??"
               ENTER
            ELSE
               {*.l??}
               ENTER ; DO_IT!
            ENDIF
         CASE NBR = 1 and typ.n = 2:
            IF UPPER(FILEHANDLE[2]) <> UPPER(DIRECTORY()) THEN
               TYPEIN FILEHANDLE[2]+"*.Cat"
               ENTER
            ELSE
               {*.Cat}
               ENTER ;DO_IT!
            ENDIF
      ENDSWITCH



      CLEARALL
      IF NRECORDS("List") >= 1 THEN
         IF UPPER(FILEHANDLE[2]) <> UPPER(DIRECTORY()) THEN
            GOON1 = DlgGetFiles()
            IF GOON1 = TRUE THEN
               SWITCH
                  CASE typ.n = 1:
                     MtHProgressMsg.u(8, 18, "Processing Message File" , "" , 127, 113,0)
                  CASE typ.n = 2:
                     MtHProgressMsg.u(8, 18, "Processing Catalog File" , "" , 127, 113,0)
               ENDSWITCH
               FOREACH element IN MtHFileSelect
                  SWITCH
                     CASE typ.n = 1:
                        MtHProgressMsg.u(8, 18, "Processing Message File" , element, 127, 113, 1)
                     CASE typ.n = 2:
                        MtHProgressMsg.u(8, 18, "Processing Catalog File" , element, 127, 113, 1)
                  ENDSWITCH

                  SWITCH
                     CASE Typ.n = 1:
                        IF NBR = 2 THEN
                           RUN BIG NOREFRESH "Import Oz1msg " + FILEHANDLE[2] + " " + element + " " + FILEHANDLE[4]
                           GOON = 2
                        ELSE
                           RUN BIG NOREFRESH "Import Tc1msg " + FILEHANDLE[2] + " " + element + " " + FILEHANDLE[4]
                           GOON = 1
                        ENDIF
                     CASE typ.n = 2:
                        IF NBR = 2 THEN
                           RUN BIG NOREFRESH "Import Oz1cat " + FILEHANDLE[2] + " " + element + " " + FILEHANDLE[4]
                           GOON = 2
                        ELSE
                           RUN BIG NOREFRESH "Import Tc1cat " + FILEHANDLE[2] + " " + element + " " + FILEHANDLE[4]
                           GOON = 1
                        ENDIF
                  ENDSWITCH
               ENDFOREACH

               SWITCH
                  CASE typ.n = 1:
                     MtHProgressMsg.u(8, 18, "Processing Message File" , "" , 127, 113,-1)
                     MESSAGE.U("IMPORTING", "    Importing CIS Messages    //Please Wait..." ,TRUE,FALSE)
                  CASE typ.n = 2:
                     MtHProgressMsg.u(8, 18, "Processing Catalog File" , "" , 127, 113,-1)
                     MESSAGE.U("IMPORTING", "    Importing CIS Catalogs    //Please Wait..." ,TRUE,FALSE)
               ENDSWITCH
            ENDIF
         ELSE
            IF GOON1 = TRUE THEN
               SWITCH
                  CASE typ.n = 1:
                     IF NBR = 2 THEN
                        MESSAGE.U("IMPORTING", "    Importing CIS Messages    //Please Wait..." ,TRUE,FALSE)
                        RUN BIG NOREFRESH "Import Oz2msg"
                        GOON = 2
                     ELSE
                        MESSAGE.U("IMPORTING", "    Importing CIS Messages    //Please Wait..." ,TRUE,FALSE)
                        RUN BIG NOREFRESH "CISTATS > junk"
                        GOON = 1
                     ENDIF
                  CASE typ.n = 2:
                     IF NBR = 2 THEN
                        MESSAGE.U("IMPORTING", "    Importing CIS Catalog    //Please Wait..." ,TRUE,FALSE)
                        RUN BIG NOREFRESH "Import Oz2cat"
                        GOON = 2
                     ELSE
                        MESSAGE.U("IMPORTING", "    Importing CIS Catalogs    //Please Wait..." ,TRUE,FALSE)
                        RUN BIG NOREFRESH "DLS > junk"
                        GOON = 1
                     ENDIF
               ENDSWITCH
            ENDIF
         ENDIF

         CLEARALL
         ; Ŀ
         ;  OZCIS embeds carridge return line feed characters in the memo     
         ;  field at the start of the memo on the first line.  The following  
         ;  code reads opems the memo field and eliminates the first          
         ;  CR/LF character.                                                  
         ; 

         SWITCH
            CASE typ.n = 1:
               EMPTY "last"
               IF ISTABLE("Cistat") THEN
                  ADD "cistat" "Last"
                  DELETE "cistat"
                  IF NBR = 2 AND GOON <> 1 THEN
                     COEDIT "last"
                     Recs.n=NRECORDS("last")
                     CURSOR OFF
                     Clearmessage.u()
                     CW.n = 1
                     MSPROGRESSBAR.U(8,8,"Fixing OzCIS Message Entries","",127,123,116,0)
                     FOR z FROM 1 TO Recs.n
                        PCT=INT((z/Recs.n)*100)
                        msg.a = strval(z) + " of " + strval(Recs.n)
                        MSPROGRESSBAR.U(8,8,"Fixing OzCIS Messsage Entries",msg.a,127,123,116,PCT)
                        MOVETO RECORD(Z)
                        MOVETO [message]
                        FIELDVIEW
                        DEL
                        DO_IT!
                     ENDFOR
                     DO_IT!
                     MSPROGRESSBAR.U(8,8,"Fixing Message CAT Entries","",127,123,116,-1)
                     CURSOR NORMAL
                     CLEARALL
                     MESSAGE.U("IMPORTING", "    Updating Database    //Please Wait..." ,TRUE,FALSE)
                  ENDIF
                  ADD "Last" "icistat"
                  CLEARALL
                  CLEARMESSAGE.U()
                  OK.U("RECORDS IMPORTED", "You may view your most recent imported/" + "Forum Messages now..." , TRUE, TRUE)
               ELSE
                  CLEARALL
                  IF goon1 = FALSE THEN
                     MESSAGE.U("Cancel", "Operation Canceled..." , TRUE, TRUE)
                     SLEEP 2000
                     CLEARMESSAGE.U()
                  ELSE
                     OK.U("NOTICE","No files to import",TRUE,TRUE)
                  ENDIF
               ENDIF

            CASE TYP.N = 2:

               EMPTY "lastdl"
               IF ISTABLE("dl") THEN
                  ADD "dl" "Lastdl"
                  DELETE "dl"
                  IF NBR = 2 AND GOON <> 1 THEN
                     COEDIT "lastdl"
                     Recs.n=NRECORDS("lastdl")
                     CURSOR OFF
                     CW.n = 1
                     ClearMessage.u()
                     MSPROGRESSBAR.U(8,8,"Fixing OzCIS CAT Entries","",127,123,116,0)

                     FOR z FROM 1 TO Recs.n
                        PCT=INT((z/Recs.n)*100)
                        msg.a = strval(z) + " of " + strval(Recs.n)
                        MSPROGRESSBAR.U(8,8,"Fixing OzCIS CAT Entries",msg.a,127,123,116,PCT)
                        MOVETO RECORD(Z)
                        MOVETO [description]
                        FIELDVIEW
                        DEL
                        DO_IT!
                     ENDFOR
                     DO_IT!
                     MSPROGRESSBAR.U(8,8,"Fixing OzCIS CAT Entries","",127,123,116,-1)
                     CLEARALL
                     MESSAGE.U("IMPORTING", "    Updating Database    //Please Wait..." ,TRUE,FALSE)
                     CURSOR NORMAL
                  ENDIF
                  ADD "Lastdl" "idl"
                  CLEARALL
                  CLEARMESSAGE.U()
                  OK.U("RECORDS IMPORTED", "You may view your most recent imported/" + "Forum Catalogs now..." , TRUE, TRUE)
               ELSE
                  CLEARALL
                  OK.U("NOTICE","No files to import",TRUE,TRUE)
               ENDIF
         ENDSWITCH
      ELSE
         CLEARALL
         IF goon1 = FALSE THEN
            MESSAGE.U("Cancel", "Operation Canceled..." , TRUE, TRUE)
            SLEEP 2000
            CLEARMESSAGE.U()
         ELSE
            OK.U("NOTICE","No files to import",TRUE,TRUE)
         ENDIF
      ENDIF
   ELSE
      CLEARALL
      IF goon1 = FALSE THEN
          MESSAGE.U("Cancel", "Operation Canceled..." , TRUE, TRUE)
          SLEEP 2000
          CLEARMESSAGE.U()
      ELSE
         OK.U("NOTICE","No files to import",TRUE,TRUE)
      ENDIF
   ENDIF
ENDPROC
WRITELIB LIBNAME MtHImportFile
RELEASE PROCS MtHImportFile
LB_DISPLAYPROGRESS.U(PROCTOTAL.N, "MtHImportFile")




;================================================
;     System Menu and Associated Procedures
;================================================
; Desmond Nolan
;================================================
PROC TIMEUPDATE(TRIGGERTYPE, TAGVALUE, EVENTVALUE, ELEMENTVALUE)

    REPAINTDIALOG
    RETURN TRUE

ENDPROC
WRITELIB LIBNAME TIMEUPDATE
RELEASE PROCS TIMEUPDATE
LB_DISPLAYPROGRESS.U(PROCTOTAL.N, "TimeUpdate" )


;================================================
; Desmond Nolan
;================================================
;==================================================

PROC TIMEDISPLAY()
    ; PaintPAL_Generated_Code_Begin(448642109)

    SHOWDIALOG "Current Time"  ; H:\PALP\CLOCK.DLG
       PROC "TimeUpdate"
          IDLE

       @6,28 HEIGHT 12 WIDTH 24

       PAINTCANVAS BORDER ATTRIBUTE 112 1,5,5,16

       ; PaintPAL_Frame_Begin
       FRAME SINGLE FROM 1,4 TO 5,17
       PAINTCANVAS ATTRIBUTE 127 1,4,1,17
       PAINTCANVAS ATTRIBUTE 112 5,4,5,17
       PAINTCANVAS ATTRIBUTE 127 1,4,5,4
       PAINTCANVAS ATTRIBUTE 112 1,17,5,17
       ; PaintPAL_Frame_End

       ; PaintPAL_Frame_Begin
       FRAME SINGLE FROM 0,1 TO 9,20
       PAINTCANVAS ATTRIBUTE 112 0,1,0,20
       PAINTCANVAS ATTRIBUTE 127 9,1,9,20
       PAINTCANVAS ATTRIBUTE 112 0,1,9,1
       PAINTCANVAS ATTRIBUTE 127 0,20,9,20
       ; PaintPAL_Frame_End

       @3,6
       ?? FORMAT("W10,AC",TIME())

       PAINTCANVAS ATTRIBUTE 15+16 2,6,4,15

       PUSHBUTTON @7,6 WIDTH 10
          "~O~k"
          OK
          DEFAULT
          VALUE "Accept"
          TAG "Yes"
          TO BUTTONVALUE
    ENDDIALOG

    ; PaintPAL_Generated_Code_End(448642109)

ENDPROC
WRITELIB LIBNAME TIMEDISPLAY
RELEASE PROCS TIMEDISPLAY
LB_DISPLAYPROGRESS.U(PROCTOTAL.N, "TimeDisplay" )



;================================================
; Desmond Nolan
;================================================

;==================================================
PROC SYSINFOPROC()

    PRIVATE  WINATTRS,
    SYSARRAY,
    WAITFORUSER,
    PDOXCNTRLMEMPOOLSIZE,
    PDOXCODEPOOLFREE,
    PDOXMEMLEFT,
    DISKSPACE,
    PDOXRUNTIME,
    PDOXVERSION

    DYNARRAY WINATTRS[]
    WINATTRS["TITLE"] = "System Information"

    SYSINFO TO SYSARRAY

    SWITCH
        CASE SYSARRAY["LANGUAGE"] = "001" :
            SYSARRAY["LANGUAGE"] = "English"
        CASE SYSARRAY["LANGUAGE"] = "033" :
            SYSARRAY["LANGUAGE"] = "French"
        CASE SYSARRAY["LANGUAGE"] = "034" :
            SYSARRAY["LANGUAGE"] = "Spanish"
        CASE SYSARRAY["LANGUAGE"] = "039" :
            SYSARRAY["LANGUAGE"] = "Italian"
        CASE SYSARRAY["LANGUAGE"] = "045" :
            SYSARRAY["LANGUAGE"] = "Danish"
        CASE SYSARRAY["LANGUAGE"] = "046" :
            SYSARRAY["LANGUAGE"] = "Swedish"
        CASE SYSARRAY["LANGUAGE"] = "049" :
            SYSARRAY["LANGUAGE"] = "German"
    ENDSWITCH

    PDOXCODEPOOLFREE = RMEMLEFT()
    PDOXCNTRLMEMPOOLSIZE = MEMLEFT()
    DISKSPACE = DRIVESPACE(SUBSTR(DIRECTORY(),1,1))

    SYSARRAY["PDOXRUNTIME"] = ISRUNTIME()
    SYSARRAY["PDOXVERSION"] = VERSION()
    SYSARRAY["EXTENDED"] = FORMAT("W12,AR,EC", SYSARRAY["EXTENDED"])
    SYSARRAY["EXPANDED"] = FORMAT("W12,AR,EC", SYSARRAY["EXPANDED"])
    SYSARRAY["DISKSPACE"] = FORMAT("W12,AR,EC",DISKSPACE)
    SYSARRAY["PDOXCODEPOOLFREE"] = FORMAT("W12,AR,EC",PDOXCODEPOOLFREE)
    SYSARRAY["PDOXCNTRLMEMPOOLSIZE"] = FORMAT("W12,AR,EC", PDOXCNTRLMEMPOOLSIZE)

    MESSAGE ""

    NHEIGHT=21
    NWIDTH=45
    TAGVALUE=""
    SHOWDIALOG
        "System"
        PROC "DiagProc"
        @2,19 HEIGHT NHEIGHT WIDTH NWIDTH
        FRAME SINGLE FROM 0,0 TO (NHEIGHT-1)-2,(NWIDTH-1)-2
        PAINTCANVAS ATTRIBUTE 112 ALL
        PAINTCANVAS ATTRIBUTE 127 0,0,0,(NWIDTH-1)-2
        PAINTCANVAS ATTRIBUTE 127 0,0,(NHEIGHT-1)-2,0
        @ 1,2 ?? "Extended memory  =  " , SYSARRAY["EXTENDED"]
        @ 2,2 ?? "Expanded memory  =  " , SYSARRAY["EXPANDED"]
        @ 3,2 ?? "Disk space free  =  " , SYSARRAY["DISKSPACE"]
        @ 4,2 ?? "Code pool free   =  " , SYSARRAY["PDOXCODEPOOLFREE"]
        @ 5,2 ?? "Central mem pool =  " , SYSARRAY["PDOXCNTRLMEMPOOLSIZE"]

        @ 7,2 ?? "Mouse present    =  " , SYSARRAY["MOUSE"]
        @ 8,2 ?? "Language         =  " , SYSARRAY["LANGUAGE"]
        @ 9,2 ?? "Autosave (secs)  =  " , SYSARRAY["AUTOSAVE"]

        @11,2 ?? "Paradox mode     =  " , SYSARRAY["UIMODE"]
        @12,2 ?? "Screen rows/cols =  " , SYSARRAY["SCREENHEIGHT"], "/" ,
        SYSARRAY["SCREENWIDTH"]
        @13,2 ?? "Paradox runtime  =  " , SYSARRAY["PDOXRUNTIME"]
        @14,2 ?? "Paradox version  =  " , SYSARRAY["PDOXVERSION"]
        @15,2 ?? "Paradox build    =  " , SYSARRAY["BUILD"]

        PUSHBUTTON @16,15 WIDTH 10
            "~O~k"
            OK
            DEFAULT
            VALUE "Yes"
            TAG "OkTag"
            TO BUTTONVALUE

    ENDDIALOG

ENDPROC
WRITELIB LIBNAME SYSINFOPROC
RELEASE PROCS SYSINFOPROC
LB_DISPLAYPROGRESS.U(PROCTOTAL.N, "SysInfoProc" )

;================================================
; Desmond Nolan
;================================================

PROC DIAGPROC(TRIGGERTYPE,TAGVELUE,EVENTVALUE,ELEMENTVALUE)
    IF TRIGGERTYPE= "OPEN" AND TAGVALUE ="OKTag" THEN
        WINDOW HANDLE DIALOG TO HDLDIALOG
        DYNARRAY DIAGATTR[]
        DIAGATTR["HASFRAME"]=FALSE
        DIAGATTR["HASSHADOW"]=FALSE
        WINDOW SETATTRIBUTES HDLDIALOG FROM DIAGATTR
    ENDIF
ENDPROC
WRITELIB LIBNAME DIAGPROC
RELEASE PROCS DIAGPROC
LB_DISPLAYPROGRESS.U(PROCTOTAL.N, "DiagProc" )



; ---------------------------------------------------------------------------
; Proc name : MaxWindow()
; Purpose   : Maximizes and removes frame/shadow from a named window
; Returns   : *None*
; Comments  : Used primarily for main Invoice form
; Adapted from Greaves and Lindsay Paradox 4 Developer's Guide
; ---------------------------------------------------------------------------
PROC MAXWINDOW(WINHANDLE)
    PRIVATE  PROCWIN

    IF ISWINDOW(WINHANDLE)
        THEN
        DYNARRAY PROCWIN[]
        PROCWIN["HASSHADOW"] = FALSE
        PROCWIN["HASFRAME"] = FALSE
        PROCWIN["CANMOVE"] = FALSE
        PROCWIN["CANRESIZE"] = FALSE
        PROCWIN["CANCLOSE"] = FALSE
        PROCWIN["MAXIMIZED"] = FALSE
        WINDOW SETATTRIBUTES WINHANDLE FROM PROCWIN
    ENDIF
    RETURN ISWINDOW(WINHANDLE)
ENDPROC

WRITELIB LIBNAME MAXWINDOW
RELEASE PROCS MAXWINDOW
LB_DISPLAYPROGRESS.U(PROCTOTAL.N, "MaxWindow" )



PROC SETWINDOW(WINHANDLE,NBR)
    PRIVATE  SPROCWIN,NBR

    IF ISWINDOW(WINHANDLE)
        THEN
        DYNARRAY SPROCWIN[]
        SPROCWIN["HASSHADOW"] = FALSE
        IF NBR=1 THEN
            SPROCWIN["HASFRAME"] = TRUE
        ELSE
            SPROCWIN["HASFRAME"] = FALSE
        ENDIF
        SPROCWIN["CANMOVE"] = FALSE
        SPROCWIN["CANRESIZE"] = FALSE
        SPROCWIN["CANCLOSE"] = FALSE
        WINDOW SETATTRIBUTES WINHANDLE FROM SPROCWIN
    ENDIF
    RETURN ISWINDOW(WINHANDLE)
ENDPROC
WRITELIB LIBNAME SETWINDOW
RELEASE PROCS SETWINDOW
LB_DISPLAYPROGRESS.U(PROCTOTAL.N, "SetWindow" )



PROC TAMEMEMOBOX(WINHANDLE)
    PRIVATE  MEMOATTS

    ECHO OFF
    IF ISWINDOW(WINHANDLE)
        THEN
        DYNARRAY MEMOATTS[]
        MEMOATTS["TITLE"] = "MESSAGE"
        MEMOATTS["ORIGINROW"] = 11
        MEMOATTS["ORIGINCOL"] = 1
        MEMOATTS["HEIGHT"] = 13
        MEMOATTS["WIDTH"] = 78
        MEMOATTS["CANCLOSE"] = FALSE
        MEMOATTS["HASFRAME"] = TRUE

        WINDOW SETATTRIBUTES WINHANDLE FROM MEMOATTS
    ENDIF
    ECHO NORMAL
    WHILE TRUE
        WAIT FIELD
        UNTIL "F2" , "F7" , "Esc" , "DOS" , "DOSBIG"
        SWITCH
            CASE RETVAL = "F2" :
                DO_IT!
                IF UPPER(TABLE())="IDL" THEN
                    MOVETO [Library]
                ELSE
                    MOVETO [Start Msg]
                ENDIF
                QUITLOOP
            CASE RETVAL = "F7" :
                DO_IT!
                IF UPPER(TABLE())="IDL" THEN
                    MOVETO [Library]
                ELSE
                    PGDN
                    MOVETO [Message]
                ENDIF
                QUITLOOP
            CASE RETVAL = "Esc":
                CANCELEDIT
                IF UPPER(TABLE())="IDL" THEN
                    MOVETO [Library]
                ELSE
                    MOVETO [Start Msg]
                ENDIF
                QUITLOOP
            OTHERWISE :
                LOOP
        ENDSWITCH
        RETURN TRUE
    ENDWHILE

ENDPROC
WRITELIB LIBNAME TAMEMEMOBOX
RELEASE PROCS TAMEMENOBOX
LB_DISPLAYPROGRESS.U(PROCTOTAL.N, "TameMemoBox" )





PROC LEAVEAPP(ALL)

    IF ALL = 1 THEN

        IF ISRUNTIME() THEN
            OK.U("NOTICE","You may not enter Paradox//when using the Run-Time Version//Please choose Quit to Exit Program...",TRUE,TRUE)
            SPLASHSCR(2)
        ELSE
            IF SYSMODE() <> "Main"
                THEN DO_IT!
            ENDIF
            APPINTRO()
            ALTSPACE {Desktop} {Empty}
            RESET
            QUIT "Back in Paradox Now..."
        ENDIF
    ELSE
        IF SYSMODE() <> "Main"
            THEN DO_IT!
        ENDIF
        APPINTRO()
        ALTSPACE {Desktop} {Empty}
        RESET
        EXIT
    ENDIF
ENDPROC
WRITELIB LIBNAME LEAVEAPP
RELEASE PROCS LEAVEAPP
LB_DISPLAYPROGRESS.U(PROCTOTAL.N, "LeaveApp" )





PROC APPINTRO()
    PRIVATE  WINDOWATTS

    DYNARRAY WINDOWATTS[]
    WINDOWATTS["HASFRAME"] = FALSE
    WINDOWATTS["ORIGINROW"] = 6
    WINDOWATTS["ORIGINCOL"] = 17
    WINDOWATTS["FLOATING"] = TRUE
    WINDOWATTS["HEIGHT"] = 10
    WINDOWATTS["WIDTH"] = 45
    WINDOWATTS["HASSHADOW"] = FALSE

    WINDOW
    CREATE ATTRIBUTES WINDOWATTS TO INFOWINDOW

    CURSOR OFF
    CANVAS OFF

    @1,0 ?? FORMAT("W44,AC", "CIS ACTIVITY CENTER" )
    @3,0 ?? FORMAT("W44,AC", "Mouse & Squirrel Software" )
    @4,0 ?? FORMAT("W44,AC", "Copyright @1992-93" )
    @7,0 ?? FORMAT("W44,D2,AC", TODAY())
    @8,12 ?? "Leaving Application..."

    PAINTCANVAS ATTRIBUTE 15+16 0,0,9,44
    STYLE ATTRIBUTE 15+16+128
    ?? "..."
    STYLE
    CANVAS ON
    SLEEP 2000
ENDPROC

WRITELIB LIBNAME APPINTRO
RELEASE PROCS APPINTRO
LB_DISPLAYPROGRESS.U(PROCTOTAL.N, "AppIntro" )




;BSC
; PROCEDURE   : GetRsp
; AUTHOR      : Mark T. Houpt
; COPYRIGHT   : (C) 1993 BAT-Systems Consulting
; PARAMETERS  : N\A
; RETURNS     : N\A
;
; Special Info: Diag to get printer output location
;
;BSC
PROC GETRSP()
    PRIVATE  NHEIGHT, NWIDTH

    RSP = ""
    NHEIGHT=12
    NWIDTH=21

    ; PaintPAL_Generated_Code_Begin(447826908)

    SHOWDIALOG "Print To"
        @6,29 HEIGHT NHEIGHT WIDTH NWIDTH

        ; PaintPAL_Frame_Begin
        FRAME SINGLE FROM 0,1 TO 9,17
        PAINTCANVAS ATTRIBUTE 112 0,1,0,17
        PAINTCANVAS ATTRIBUTE 127 9,1,9,17
        PAINTCANVAS ATTRIBUTE 112 0,1,9,1
        PAINTCANVAS ATTRIBUTE 127 0,17,9,17
        ; PaintPAL_Frame_End

        PUSHBUTTON @1,4 WIDTH 11
            "~S~creen"
            OK
            VALUE "S"
            TAG "Stag"
            TO RSP

        PUSHBUTTON @4,4 WIDTH 11
            "~P~rinter"
            OK
            DEFAULT
            VALUE "P"
            TAG "Ptag"
            TO RSP

        PUSHBUTTON @7,4 WIDTH 11
            "~C~ancel"
            CANCEL
            VALUE ""
            TAG "Cancel"
            TO CANCELTAG
    ENDDIALOG

    ; PaintPAL_Generated_Code_End(447826908)

    IF ISBLANK (RSP)
        THEN
        RETURNED = 1
        RETURN RSP
    ELSE
        RETURNED = 2
        RETURN RSP
    ENDIF
ENDPROC
WRITELIB LIBNAME GETRSP
RELEASE PROCS GETRSP
LB_DISPLAYPROGRESS.U(PROCTOTAL.N, "GetRsp" )



;BSC
; PROCEDURE   : GetPort
; AUTHOR      : Mark T. Houpt
; COPYRIGHT   : (C) 1993 BAT-Systems Consulting
; PARAMETERS  : N\A
; RETURNS     : N\A
;
; Special Info: Diag to get printer Port and Type info
;
;BSC
PROC GETPORT()
    PRIVATE OKCANCEL,PRINTVAL
    ; Portions adapted from PrintM.zip in PDODOS libs by John Nelson
    ; JRN Enterprise

    ; PaintPAL_Generated_Code_Begin(447839100)

    OKCANCEL=""
    PRINTERTYPE=BLANKNUM()
    PRINTVAL= BLANKNUM()

    SHOWDIALOG
        "Select Printer Type and Port" ; C:\CIS\RPT.DLG
        @6,16 HEIGHT 12 WIDTH 47

        ; PaintPAL_Frame_Begin
        FRAME SINGLE FROM 0,1 TO 9,43
        PAINTCANVAS ATTRIBUTE 127 0,1,0,43
        PAINTCANVAS ATTRIBUTE 112 9,1,9,43
        PAINTCANVAS ATTRIBUTE 127 0,1,9,1
        PAINTCANVAS ATTRIBUTE 112 0,43,9,43
        ; PaintPAL_Frame_End

        ; PaintPAL_Frame_Begin
        FRAME SINGLE FROM 1,20 TO 5,41
        PAINTCANVAS ATTRIBUTE 112 1,20,1,41
        PAINTCANVAS ATTRIBUTE 127 5,20,5,41
        PAINTCANVAS ATTRIBUTE 112 1,20,5,20
        PAINTCANVAS ATTRIBUTE 127 1,41,5,41
        ; PaintPAL_Frame_End

        ; PaintPAL_Frame_Begin
        FRAME SINGLE FROM 1,3 TO 8,16
        PAINTCANVAS ATTRIBUTE 112 1,3,1,16
        PAINTCANVAS ATTRIBUTE 127 8,3,8,16
        PAINTCANVAS ATTRIBUTE 112 1,3,8,3
        PAINTCANVAS ATTRIBUTE 127 1,16,8,16
        ; PaintPAL_Frame_End

        RADIOBUTTONS @3,5 HEIGHT 5 WIDTH 10
            "Lpt1",
            "Lpt2",
            "Lpt3",
            "Com1",
            "Com2"
            TAG "PrinttoTag"
            TO PRINTVAL

        LABEL @2,5
            "Print To"
            FOR "PrinttoTag"

        RADIOBUTTONS @3,22 HEIGHT 2 WIDTH 19
            "Dot Matrix",
            "Laser Printer"
            TAG "PrinterTag"
            TO PRINTTYPE

        LABEL @2,22
            "Printer Type"
            FOR "PrinterTag"

        PUSHBUTTON @7,21 WIDTH 6
            "~O~k"
            OK
            DEFAULT
            VALUE "OK"
            TAG "OKTag"
            TO OKCANCEL

        PUSHBUTTON @7,31 WIDTH 10
            "~C~ancel"
            CANCEL
            VALUE "Cancel"
            TAG "CancelTag"
            TO OKCANCEL
    ENDDIALOG

    ; PaintPAL_Generated_Code_End(447839100)

    IF OKCANCEL > "" THEN
        RETURNED = 2
        SWITCH
            CASE PRINTVAL = 1:
                PRTV="LPT1"
            CASE PRINTVAL = 2:
                PRTV="LPT2"
            CASE PRINTVAL = 3:
                PRTV="LPT3"
            CASE PRINTVAL = 4:
                PRTV="COM1"
            CASE PRINTVAL = 5:
                PRTV="COM2"
        ENDSWITCH
        RETURN COPIES
    ELSE
        RETURNED = 1
        RETURN PRINTERTYPE
    ENDIF
ENDPROC
WRITELIB LIBNAME GETPORT
RELEASE VARS GETPORT
LB_DISPLAYPROGRESS.U(PROCTOTAL.N, "GetPort")



PROC GETRPT(NBR)
    PRIVATE  NBR,RSP,PRINTERTYPE,PRTV,RETURNED
    ; Portions adapted from PrintM.zip in PDODOS libs by John Nelson
    ; JRN Enterprise

    RSP=GETRSP()
    IF UPPER(RSP) = "S" OR UPPER(RSP) = "P" THEN
        SWITCH
            CASE NBR = 1:
                SWITCH
                    CASE UPPER(RSP) = "P":
                        PRINTERTYPE=GETPORT()
                        IF RETURNED <> 1 THEN
                            IF PRTV <> "LPT1" THEN
                                IF PRINTTYPE = 1 THEN
                                    ;select the report and change the settings
                                    MENU {Report} {Change} {Icistat} {1}
                                    ENTER
                                    {Setting} {Setup} {Custom} SELECT PRTV
                                    ENTER
                                    ENTER
                                    DO_IT!
                                ELSE
                                    ;select the report and change the settings
                                    MENU {Report} {Change} {Icistat} {2}
                                    ENTER
                                    {Setting} {Setup} {Custom} SELECT PRTV
                                    ENTER
                                    ENTER
                                    DO_IT!
                                ENDIF
                            ENDIF
                            MESSAGE.U("REPORT", "Printing Report//Please Wait..." ,TRUE,FALSE)
                            IF PRINTTYPE=1 THEN
                                REPORT "Icistat" 1
                            ELSE
                                REPORT "Icistat" 2
                            ENDIF
                            CLEARMESSAGE.U()
                        ENDIF
                    CASE UPPER(RSP) = "S":
                        MESSAGE.U("REPORT", "Printing Report to Screen//Please Wait..." ,TRUE,FALSE)
                        {Report} {Output} {Icistat} {1} {File} {CisMsg} {Replace}
                        CLEARALL
                        CLEARMESSAGE.U()
                        VIEWFILEEDITORWIN("CisMsg.rpt" ;" file name to edit
                        ,"MESSAGE REPORT" ; title of window
                        ,"FileEditWaitMenu" ;procedure to call on startup
                        ,"" ;procedure on close
                        ,"FileEditWaitMenuHandler") ;procedure to evaluate menu choices
                ENDSWITCH
            CASE NBR = 2:
                SWITCH
                    CASE UPPER(RSP) = "P":
                        PRINTERTYPE=GETPORT()
                        IF RETURNED <> 1 THEN
                            IF PRTV <> "LPT1" THEN
                                IF PRINTTYPE = 1 THEN
                                    ;select the report and change the settings
                                    MENU {Report} {Change} {Last} {1}
                                    ENTER
                                    {Setting} {Setup} {Custom} SELECT PRTV
                                    ENTER
                                    ENTER
                                    DO_IT!
                                ELSE
                                    ;select the report and change the settings
                                    MENU {Report} {Change} {Last} {2}
                                    ENTER
                                    {Setting} {Setup} {Custom} SELECT PRTV
                                    ENTER
                                    ENTER
                                    DO_IT!
                                ENDIF
                            ENDIF
                            MESSAGE.U("REPORT", "Printing Report//Please Wait..." ,TRUE,FALSE)
                            IF PRINTTYPE=1 THEN
                                REPORT "Last" 1
                            ELSE
                                REPORT "Last" 2
                            ENDIF
                            CLEARMESSAGE.U()
                        ENDIF
                    CASE UPPER(RSP) = "S":
                        MESSAGE.U("REPORT", "Printing Report to Screen//Please Wait..." ,TRUE,FALSE)
                        {Report} {Output} {last} {1} {File} {CisMsg} {Replace}
                        CLEARALL
                        CLEARMESSAGE.U()
                        VIEWFILEEDITORWIN("CisMsg.rpt" ;"Readme.txt" file name to edit
                        ,"MESSAGE REPORT" ;title of window
                        ,"FileEditWaitMenu" ;procedure to call on startup
                        ,"" ;procedure on close
                        ,"FileEditWaitMenuHandler") ;procedure to evaluate menu choices
                ENDSWITCH
            CASE NBR = 3:
                SWITCH
                    CASE UPPER(RSP) = "P":
                        PRINTERTYPE=GETPORT()
                        IF RETURNED <> 1 THEN
                            IF PRTV <> "LPT1" THEN
                                IF PRINTTYPE = 1 THEN
                                    ;select the report and change the settings
                                    MENU {Report} {Change} {QueryMsg} {1}
                                    ENTER
                                    {Setting} {Setup} {Custom} SELECT PRTV
                                    ENTER
                                    ENTER
                                    DO_IT!
                                ELSE
                                    ;select the report and change the settings
                                    MENU {Report} {Change} {QueryMsg} {2}
                                    ENTER
                                    {Setting} {Setup} {Custom} SELECT PRTV
                                    ENTER
                                    ENTER
                                    DO_IT!
                                ENDIF
                            ENDIF
                            MESSAGE.U("REPORT", "Printing Report//Please Wait..." ,TRUE,FALSE)
                            IF PRINTTYPE=1 THEN
                                REPORT "QueryMsg" 1
                            ELSE
                                REPORT "QueryMsg" 2
                            ENDIF
                            CLEARMESSAGE.U()
                        ENDIF
                    CASE UPPER(RSP) = "S":
                        MESSAGE.U("REPORT", "Printing Report to Screen//Please Wait..." ,TRUE,FALSE)
                        {Report} {Output} {QueryMsg} {1} {File} {CisMsg} {Replace}
                        CLEARALL
                        CLEARMESSAGE.U()
                        VIEWFILEEDITORWIN("CisMsg.rpt" ;"Readme.txt" file name to edit
                        ,"MESSAGE REPORT" ;title of window
                        ,"FileEditWaitMenu" ;procedure to call on startup
                        ,"" ;procedure on close
                        ,"FileEditWaitMenuHandler") ;procedure to evaluate menu choices
                ENDSWITCH
            CASE NBR = 4:
                SWITCH
                    CASE UPPER(RSP) = "P":
                        PRINTERTYPE=GETPORT()
                        IF RETURNED <> 1 THEN
                            IF PRTV <> "LPT1" THEN
                                IF PRINTTYPE = 1 THEN
                                    ;select the report and change the settings
                                    MENU {Report} {Change} {Idl} {1}
                                    ENTER
                                    {Setting} {Setup} {Custom} SELECT PRTV
                                    ENTER
                                    ENTER
                                    DO_IT!
                                ELSE
                                    ;select the report and change the settings
                                    MENU {Report} {Change} {Idl} {2}
                                    ENTER
                                    {Setting} {Setup} {Custom} SELECT PRTV
                                    ENTER
                                    ENTER
                                    DO_IT!
                                ENDIF
                            ENDIF
                            MESSAGE.U("REPORT", "Printing Report//Please Wait..." ,TRUE,FALSE)
                            IF PRINTTYPE=1 THEN
                                REPORT "Idl" 1
                            ELSE
                                REPORT "Idl" 2
                            ENDIF
                            CLEARMESSAGE.U()
                        ENDIF
                    CASE UPPER(RSP) = "S":
                        MESSAGE.U("REPORT", "Printing Report to Screen//Please Wait..." ,TRUE,FALSE)
                        {Report} {Output} {Idl} {1} {File} {CisCat} {Replace}
                        CLEARALL
                        CLEARMESSAGE.U()

                        VIEWFILEEDITORWIN("CisCat.rpt" ;"Readme.txt" file name to edit
                        ,"MESSAGE REPORT" ;title of window
                        ,"FileEditWaitMenu" ;procedure to call on startup
                        ,"" ;procedure on close
                        ,"FileEditWaitMenuHandler") ;procedure to evaluate menu choices
                ENDSWITCH
        ENDSWITCH
        CLEARALL
    ENDIF
ENDPROC
WRITELIB LIBNAME GETRPT
RELEASE PROCS GETRPT
LB_DISPLAYPROGRESS.U(PROCTOTAL.N, "GetRpt" )



; This Scirpt is a collection of proceedures for using the Paradox 4.0 File
; editor like you would Readme com in your script
;
;             Written 1/25/93
;             Brian Bushay
;             1715 Emerson Ave N
;             Minneapolis, MN 55411
;             CIS 76711,516
;
;
; More great work by Brian
; ================================================================================
; ==============================ViewFileEditorWin()  ==============================
; ================================================================================
; View a report in the Editor Window
PROC VIEWFILEEDITORWIN(FILE.A ;file name to edit
    ;the followning paramaters can be blank strings ""
    ,TITLE.A ;title of window
    ,STARTUP.PROC ;procedure to call on startup
    ,CLOSE.PROC ;procedure on close
    ,MENUHANDLER.PROC) ;procedure to evaluate menu choices
    PRIVATE  RET,PROCNAME.A

    ,STARTKEYS.Y ;keyboard state on entry to this Proc
    ,WIND.Y ;dynarray holding attributes of editor Window
    ,EDITOR.W ;holds handle of editor window
    ,SCROLL.Y ;dynarray to hold state of Scroll lock
    PROCNAME.A = "ViewFileEditorWin"
    ;Echo Off
    EDITOR
    OPEN FILE.A ;open the edit session
    WINDOW LIST TO WINS
    ALLWIN=ARRAYSIZE(WINS)
    WINDOW SELECT WINS[allwin]
    EDITOR.W = GETWINDOW() ;try to get editor window handle
    WINDOW SELECT EDITOR.W
    WINDOW GETATTRIBUTES EDITOR.W TO WIND.Y
    ;check if the handle GetWindow() returned is for an editor session
    IF SEARCH(UPPER(FILE.A),UPPER(WIND.Y["Title"])) = 0 THEN ;oops not the correct handle
        EDITOR.W = GETEDITORWINDOW(WIND.Y,FILE.A)
    ENDIF
    IF ISASSIGNED(WINDOWLBL.A) THEN ;If a custom window title is to be used
        WIND.Y["Title"] = WINDOWLBL.A
    ELSE
        WIND.Y["Title"] = "" ;Use no title for window
    ENDIF
    {Options} {WordWrap} {Clear} ;remove default WordWrap behavior
    GETKEYBOARDSTATE TO STARTKEYS.Y ;record current keyboard state
    DYNARRAY SCROLL.Y[] ;create dynarray
    SCROLL.Y["Scroll Lock"]= TRUE ;start out with scroll lock on
    SETKEYBOARDSTATE FROM SCROLL.Y
    WINDOW SETATTRIBUTES EDITOR.W FROM WIND.Y ;sets new window title
    WINMAX ;Maximize editor window
    ;IF you don't want the following default Prompt then use the startUp.proc
    ;paramater to set up a custom prompt
    PROMPT "*Print to Screen*    "
    MESSAGE ""
    IF NOT ISBLANK(STARTUP.PROC) THEN ;use startup proceedure to set custom
        EXECPROC STARTUP.PROC ;showPullDown and Promts ect
    ENDIF
    ECHO NORMAL
    IF NIMAGES() > 0 THEN ;images on workspace use WAIT
        WAIT WORKSPACE
            PROC "FileEditWaitHandler"
            ; no event argument traps for all events except Idle
        ENDWAIT
    ELSE ;No images so use GetEvent
        WHILE TRUE
            GETEVENT TO EVENT.Y
            FILEEDITWAITHANDLER("EVENT",EVENT.Y,0) ;event Processing procedure
            SWITCH ;can be shared with WAIT
                CASE RETVAL = 0 :
                    EXECEVENT EVENT.Y
                CASE RETVAL = 1 :
                    ;do nothing
                OTHERWISE:
                    QUITLOOP
            ENDSWITCH
        ENDWHILE
    ENDIF
    ECHO OFF
    SETKEYBOARDSTATE FROM STARTKEYS.Y ;Restore keyboard state on entry
    WINDOW SELECT EDITOR.W ;make sure the editor window is current
    WINDOW
    CLOSE

    IF NOT ISBLANK(CLOSE.PROC) THEN ;Use close.proc to reset menus and Prompt if desired
        EXECPROC CLOSE.PROC ;ect
    ENDIF

ENDPROC

WRITELIB LIBNAME VIEWFILEEDITORWIN
RELEASE PROCS VIEWFILEEDITORWIN
LB_DISPLAYPROGRESS.U(PROCTOTAL.N, "ViewFileEditorWin" )


; ================================================================================
; ==============================GetEditorWindow()  ==============================
; ================================================================================
; Gets a window handle of an Edit session even when floating window is on workspace
; Thanks to Dan Paolini for this technique

PROC GETEDITORWINDOW(WINATT.Y ;dynarray to hold window attributes
    ,FILENM.A);file name same as window title
    PRIVATE  RET,PROCNAME.A,
    WINDOWS.R,
    ELEMENTS.N,
    CNTR

    PROCNAME.A = "GetEditorWindow"
    WINDOW LIST TO WINDOWS.R ;Get a list of all Windows
    ELEMENTS.N = ARRAYSIZE(WINDOWS.R)
    FOR CNTR FROM 1 TO ELEMENTS.N
        WINDOW SELECT WINDOWS.R[cntr]
        WINDOW GETATTRIBUTES WINDOWS.R[cntr] TO WINATT.Y
        IF SEARCH(UPPER(FILE.A),UPPER(WIND.Y["Title"])) >0 THEN
            QUITLOOP
        ENDIF
    ENDFOR
    RETURN IIF(CNTR>ELEMENTS.N,0,WINDOWS.R[cntr]) ; 0 no Editor Window found
ENDPROC
WRITELIB LIBNAME GETEDITORWINDOW
RELEASE PROCS GETEDITORWINDOW
LB_DISPLAYPROGRESS.U(PROCTOTAL.N, "GetEditorWindow" )

; ================================================================================
; ==============================FileEditWaitHandler()  ==============================
; ================================================================================
; Handles keys passed from Wait sessions on the Editor

PROC FILEEDITWAITHANDLER(TRIGER.A,EVENT.Y,CYCLE.N)
    PRIVATE  RET,PROCNAME.A

    PROCNAME.A = "FileEditWaitHandler"
    RET = 1
    SWITCH
        CASE TRIGER.A <> "EVENT":
            SWITCH
                CASE TRIGER.A = "ARRIVEWINDOW" :
                    ;if a different window is selected the Editor window will be closed
                    IF GETWINDOW() <> EDITOR.W AND GETWINDOW() <> 0 THEN
                        RET = 2 ;2 leaves Wait
                    ENDIF
                OTHERWISE:
            ENDSWITCH
        CASE EVENT.Y["Type"] = "MOUSE" :
            RET = 0
        CASE EVENT.Y["Type"] = "KEY" :
            SWITCH
                CASE EVENT.Y["KEYCODE"] =-24 :
                    ;don't allow ;to DOS keys
                CASE EVENT.Y["KEYCODE"] =15 :
                    ;don't allow
                    ;Internal windows like Zoom have handle of 0
                    ;so no more key strokes excluded if handle is 0
                CASE GETWINDOW() = 0 :
                    RET = 0
                CASE
                    EVENT.Y["KEYCODE"] <= -71 AND ;Home, Up, PgUp, Left
                    EVENT.Y["KEYCODE"] >= -81 : RET = 0 ;End,Down,PgDn,Right
                CASE
                    EVENT.Y["KEYCODE"] <= -115 AND ;Ctrl/Left Ctrl/Right
                    EVENT.Y["KEYCODE"] >= -119 : RET = 0 ;Ctrl/Home Ctrl/End Ctrl/PgDn
                CASE EVENT.Y["KEYCODE"] = -132 :
                    RET = 0 ;Ctrl/PgUp
                CASE EVENT.Y["KEYCODE"] = 26 :
                    RET = 0 ;Zoom
                CASE EVENT.Y["KEYCODE"] = -44 :
                    RET = 0 ;ZoomNext
                CASE EVENT.Y["KEYCODE"] = 27 :
                    RET = 2 ;Esc
                OTHERWISE: RET = 1 ;All other keys do not process
            ENDSWITCH
        CASE EVENT.Y["Type"] = "MESSAGE" :
            SWITCH
                CASE
                    EVENT.Y["Message"] = "MENUSELECT"
                    OR EVENT.Y["Message"] = "MENUKEY" :
                    ;check if a Proc is defined to handle Menu selections
                    IF NOT ISBLANK(MENUHANDLER.PROC) THEN ;use menu handling proceed ure if
                        EXECPROC MENUHANDLER.PROC ;it is defined
                        RET = RETVAL
                    ENDIF
                CASE EVENT.Y["Message"] = "CLOSE" :
                    RETURN 2 ;user moused close Bar
                OTHERWISE: RET = 0
            ENDSWITCH
        OTHERWISE:
            MESSAGE EVENT.Y["type"] ;just incase anything slips by
    ENDSWITCH
    RETURN RET
ENDPROC
WRITELIB LIBNAME FILEEDITWAITHANDLER
RELEASE PROCS FILEEDITWAITHANDLER
LB_DISPLAYPROGRESS.U(PROCTOTAL.N, "FileditWaitHandler" )

; ================================================================================
; ==============================FileEditWaitMenu()  ==============================
; ================================================================================
; Menu to put up for File Edit Session
PROC FILEEDITWAITMENU()
    PRIVATE  RET,PROCNAME.A

    PROCNAME.A = "FileEditWaitMenu"
    ;puts up single choice show Pulldown
    SHOWPULLDOWN
        "Quit"          : "Leave File Viewer "                : "27",
        "Scroll Toggel" : "Toggel Scroll Lock"                : "Scroll"
    ENDMENU
ENDPROC

WRITELIB LIBNAME FILEEDITWAITMENU
RELEASE PROCS FILEEDITWAITMENU
LB_DISPLAYPROGRESS.U(PROCTOTAL.N, "FileEditWaitMenu" )

; ================================================================================
; ==============================FileEditWaitMenuHandler()  ==============================
; ================================================================================
; Proceedure to handle Menu selections while in File editor
PROC FILEEDITWAITMENUHANDLER()
    PRIVATE  RET,PROCNAME.A

    PROCNAME.A = "FileEditWaitMenuHandler"
    SWITCH
        CASE EVENT.Y["MENUTAG"] = "27" :
            RET = 2 ;leave the wait
        CASE EVENT.Y["MENUTAG"] = "Scroll" :
            GETKEYBOARDSTATE TO SCROLL.Y ;make sure information is current
            SCROLL.Y["Scroll Lock"]= (NOT SCROLL.Y["Scroll Lock"])
            SETKEYBOARDSTATE FROM SCROLL.Y
            RET = 1
        OTHERWISE: RET = 1 ;Do nothhing
    ENDSWITCH
    RETURN RET
ENDPROC
WRITELIB LIBNAME FILEEDITWAITMENUHANDLER
RELEASE PROCS FILEEDITWAITMENUHANDLER
LB_DISPLAYPROGRESS.U(PROCTOTAL.N, "FileEditWaitMenuHandler" )


PROC VIEWDOC()
    VIEWFILEEDITORWIN("CisMsg.txt" ;" file name to edit
    ,"Program Documentation" ; title of window
    ,"FileEditWaitMenu" ;procedure to call on startup
    ,"" ;procedure on close
    ,"FileEditWaitMenuHandler") ;procedure to evaluate menu choices
ENDPROC
WRITELIB LIBNAME VIEWDOC
RELEASE PROCS VIEWDOC
LB_DISPLAYPROGRESS.U(PROCTOTAL.N, "ViewDoc" )


; -------------------------------------------------------------------
; DesktopPlus for Paradox, version 4.0
; PRINTREC.SC
; Copyright 1988-92 Kallista, Inc. - All Rights Reserved
; used with expressed consent for CISMSG Application
; -------------------------------------------------------------------
PROC DT_REC_PRINT_CUSTOM()
   PRIVATE  FIELDVALUES, ; fixed array to hold the record's values
            WASFORMVIEW, ; Were we in formview when the routine startred
            CURRENTWINDOW,;
            CURRENTTABLE, ;
            REPORTSPEC ;
   Window Select FormWindow
   Moveto [FORUM]
   WinToClose = 2
   MODE=SYSMODE()
   TBL=TABLE()
   FRM=FORM()
   BU=2
   IF MODE="View" OR MODE= "Main" THEN
      ECHO OFF
      MESSAGE "Checking printer status"
      IF NOT PRINTERSTATUS() THEN
         EXITMESSAGE = "Print not found"
         RETURN TRUE
      ENDIF

      IF IMAGETYPE() <> "Display" THEN
         EXITMESSAGE = "Not in a display image"
         RETURN TRUE
      ENDIF

      IF NIMAGERECORDS() = 0 THEN
         EXITMESSAGE = "Current image is empty"
         RETURN TRUE
      ENDIF

      MESSAGE "Building report list"

      CURRENTTABLE = TBL
      DYNARRAY REPORTLIST[]

      ; Build a list of the available report specs
      DO_IT!
      MENU {Report} {Change} SELECT CURRENTTABLE
      CURRENTCHOICE = MENUCHOICE()
      WHILE TRUE
         REPINDEX = MENUCHOICE()
         REPORTLIST[RepIndex] = REPINDEX
         ENTER
         REPORTLIST[RepIndex] = REPORTLIST[RepIndex] + " - " + MENUCHOICE()
         ESC
         DOWN
         IF MENUCHOICE() = CURRENTCHOICE THEN
            QUITLOOP
         ENDIF
         CURRENTCHOICE = MENUCHOICE()
      ENDWHILE
      MENU ESC

      ; Hide the Paradox menu


      MESSAGE ""
      REPORTSPEC = ""
      EXITCONTROL = FALSE

      SHOWDIALOG
         "Custom Reports" @6,20 HEIGHT 14 WIDTH 40

         PICKDYNARRAY @1,1 HEIGHT 8 WIDTH 36
            REPORTLIST
            TAG "ReportList" TO REPORTSPEC

         PUSHBUTTON @10,7 WIDTH 10
            "~O~K" OK DEFAULT VALUE TRUE
            TAG "Accept" TO EXITCONTROL

         PUSHBUTTON @10,22 WIDTH 10
            "~C~ancel" CANCEL VALUE FALSE
            TAG "Cancel" TO EXITCONTROL

      ENDDIALOG

      IF NOT EXITCONTROL THEN
         FIXMSGBOX(2)
         RETURN FALSE
      ENDIF

      MESSAGE "Printing current record"

;       Check whether form or table view

;         if isformview() then
;            formkey
;            WasFormView = True
;         else
;            WasFormView = false
;         endif
      CTRLHOME
      MOVETO TBL
      COPYTOARRAY FIELDVALUES

      ; Query table to get the current record
      DTTBL="MH"
      CREATE DTTBL+"$temp$" LIKE CURRENTTABLE
      VIEW DTTBL+"$temp$"
      COEDITKEY
      COPYFROMARRAY FIELDVALUES
      DO_IT!
      CLEARIMAGE

      COPYREPORT CURRENTTABLE REPORTSPEC DTTBL+"$temp$" REPORTSPEC
      REPORT DTTBL+"$temp$" REPORTSPEC

      ; Cleanup

      DELETE DTTBL+"$temp$"
      MESSAGE ""
      MOVETO TBL
      PICKFORM FRM
      FIXMSGBOX(2)
      RETURN TRUE
   ELSE
      FIXMSGBOX(2)
      RETURN FALSE
   ENDIF
   ECHO NORMAL
ENDPROC

WRITELIB LIBNAME DT_REC_PRINT_CUSTOM
RELEASE PROCS DT_REC_PRINT_CUSTOM
LB_DISPLAYPROGRESS.U(PROCTOTAL.N, "DT_REC_PRINT_CUSTOM")


;BSC
; PROCEDURE   :start.m
; AUTHOR      : Mark T. Houpt
; COPYRIGHT   : (C) 1993 BAT-Systems Consulting
; PARAMETERS  : N\A
; RETURNS     : N\A
;
; Special Info: Diag to get CIS Prog Type and directory
;
;BSC

PROC START.m()
    Private HelpMe.a, ProgType, FileDir, dlg.h
     ; PaintPAL_Generated_Code_Begin(448222737)

    IF NOT ISASSIGNED(FILEHANDLE[1]) THEN
      FILEHANDLE[1] = 1
    ENDIF
    IF NOT ISASSIGNED(FILEHANDLE[2]) THEN
      FILEHANDLE[2] = DIRECTORY()
    ENDIF


    ProgType = FileHandle[1]
    FileDir = FileHandle[2]
    OKCancel = "Cancel"
    HelpMe.a = ""

    SHOWDIALOG "Program SetUp"
       PROC "DlgGetHelp"
          TRIGGER "OPEN", "UPDATE", "ACCEPT"

       @5,16 HEIGHT 15 WIDTH 48

       ; PaintPAL_Frame_Begin
       FRAME SINGLE FROM 0,1 TO 12,44
       PAINTCANVAS ATTRIBUTE 127 0,1,0,44
       PAINTCANVAS ATTRIBUTE 112 12,1,12,44
       PAINTCANVAS ATTRIBUTE 127 0,1,12,1
       PAINTCANVAS ATTRIBUTE 112 0,44,12,44
       ; PaintPAL_Frame_End

       ; PaintPAL_Frame_Begin
       FRAME SINGLE FROM 1,7 TO 5,37
       PAINTCANVAS ATTRIBUTE 112 1,7,1,37
       PAINTCANVAS ATTRIBUTE 127 5,7,5,37
       PAINTCANVAS ATTRIBUTE 112 1,7,5,7
       PAINTCANVAS ATTRIBUTE 127 1,37,5,37
       ; PaintPAL_Frame_End

       RADIOBUTTONS @3,17 HEIGHT 2 WIDTH 12
          "TapCis",
          "OzCIS"
          TAG "ProgTag"
          TO ProgType

       LABEL @2,11
          "CIS Navigation Program"
          FOR "ProgTag"

       ACCEPT @8,3 WIDTH 40
          "A50"
          TAG "LocationTag"
          TO FileDir

       LABEL @7,7
          "Location of MSG and CAT Files "
          FOR "LocationTag"

       PUSHBUTTON @10,5 WIDTH 8
          "~O~k"
          OK
          DEFAULT
          VALUE "OK"
          TAG "OkTag"
          TO OKCancel

       PUSHBUTTON @10,18 WIDTH 8
          "~H~elp"
          VALUE HelpMeDlg(1)
          TAG "HelpTag"
          TO HelpMe.a

       PUSHBUTTON @10,31 WIDTH 10
          "~C~ancel"
          CANCEL
          VALUE "Cancel"
          TAG "CancelTag"
          TO OKCancel
    ENDDIALOG

     ; PaintPAL_Generated_Code_End(448222737)

    IF OKCancel = "OK" THEN
        COEDIT "Start"
        [type] = PROGTYPE
        FILEHANDLE[1] = PROGTYPE
        IF FILEDIR > "" THEN
            A=LEN(FILEDIR)
            IF SUBSTR(FILEDIR, A,1) <> "\\" THEN
                FILEDIR = FILEDIR +"\\"
            ENDIF
            [directory] = FILEDIR
            FILEHANDLE[2] = FILEDIR
        ELSE FILEHANDLE[2] = DIRECTORY()
        ENDIF
        [done] = "Y"
        FILEHANDLE[3] = "Y"
        DO_IT!
        CLEARALL
    ENDIF
ENDPROC
WRITELIB LIBNAME start.m
RELEASE PROCS start.m
LB_DISPLAYPROGRESS.U(PROCTOTAL.N, "Start.m")



PROC DlgGetHelp(EventType, TagValue, EventValue, ElementValue)
  SWITCH
    CASE EventType = "ACCEPT" :
         If HelpMe.a > ""  Then
           REPAINTDIALOG
           RETURN False
         ENDIF
    CASE EventType = "UPDATE" :
    CASE eventtype = "OPEN" :
         WINDOW HANDLE DIALOG TO dlg.h
  ENDSWITCH
ENDPROC
WRITELIB LIBNAME DlgGetHelp
RELEASE PROCS DlgGetHelp
LB_DISPLAYPROGRESS.U(PROCTOTAL.N, "DlgGetHelp")



PROC HelpMeDlg(nbr) ; Displays available printer
   PRIVATE  nbr

   SWITCH
      CASE nbr = 1:
         Ok.u("HELP", "Use the Arrow Keys or Mouse to choose the/correct CIS program.//Enter the directory where your message and /catalog files are located..." ,true,false)
      CASE nbr = 2:
         Ok.u("HELP", "Use the Arrow Keys and Space Bar/or Mouse to choose the/files to import..." ,true,false)
      CASE nbr = 3:
         OK.U("Help","Use Mouse on SpeedBar to move back/and forth through the records//Or Press F10 for Menu Items//Memo Window can be Maximized",true,false)
      CASE nbr = 4:
         OK.U("Help","Select you Forum by scrolling through list/Tab or Mouse to Sections list/Choose Section//Enter date range/or Choose ALL or Today...",true,false)
      CASE nbr = 5:
         Ok.u("HELP", "Use the Arrow Keys and Space Bar/or Double-Click with the Mouse/to choose the Subjects..." ,true,false)
   ENDSWITCH
   RETURN false
ENDPROC
WRITELIB LIBNAME HelpMeDlg
RELEASE PROCS HelpMeDlg
LB_DISPLAYPROGRESS.U(PROCTOTAL.N, "HelpMeDlg")



;Ŀ
;                                                                           
; Copyright (c) 1992   Martin W. Rudy   All Rights Reserved                 
; This program can be used/copied/modified without charge provided this     
; copyright notice is included without change, and that any accompanying    
; documentation includes "Portions of this code Copyright (c) 1992,         
; Martin W. Rudy  All Rights Reserved"                                      
;                                                                           
;

; This is an example of displaying a list of values in a picklist and allowing
; multiple values to be selected.  As elements in the picklist are selected
; they are placed in a second picklist.  Dynarray elements can be moved
; between the picklists using the pushbuttons, spacebar on the current
; element, or double click with the mouse.


PROC DlgGetFiles()
 PRIVATE sysinfo_bag,                            ;  Dynamic array for SYSINFO
         OkCancel,                         ;  Pushbutton variable
         additem,                                ;  Pushbutton variable
         addall,                                 ;  Pushbutton variable
         removeitem,                             ;  Pushbutton variable
         removeall,                              ;  Pushbutton variable
         MtHInFile,                                   ;  Picklist variable
         MtHOutFile,                                ;  Picklist variable
         HelpMe.a

    DYNARRAY MtHFileChoice[]                      ; values does not exist
    VIEW "List"                                  ; create it
    SCAN
      MtHFileChoice[[Name]] = [Name]
    ENDSCAN
    CLEARIMAGE

  DYNARRAY MtHFileSelect[]                        ;  Create dynarray for selected
                                                 ; values
  SYSINFO TO sysinfo_bag                         ;  Get screen height and width
  HelpMe.a = ""
  ; PaintPAL_Generated_Code_Begin(448885377)

  SHOWDIALOG "Files to Import"  ; D:\CIS\IMPORT1.DLG
     PROC "DlgGetFilesProc"
        TRIGGER "UPDATE", "SELECT"

     @INT((sysinfo_bag["ScreenHeight"]-17)/2),INT((sysinfo_bag["ScreenWidth"]-66)/2) HEIGHT 19 WIDTH 68

     ; PaintPAL_Frame_Begin
     FRAME SINGLE FROM 0,0 TO 16,65
     PAINTCANVAS ATTRIBUTE 112 0,0,0,65
     PAINTCANVAS ATTRIBUTE 127 16,0,16,65
     PAINTCANVAS ATTRIBUTE 112 0,0,16,0
     PAINTCANVAS ATTRIBUTE 127 0,65,16,65
     ; PaintPAL_Frame_End

     PICKDYNARRAYINDEX @2,2 HEIGHT 13 WIDTH 21
        MtHFileChoice
        TAG "mthinfilelist"
        TO MtHInFile

     LABEL @1,1
        "Files Available"
        FOR "mthinfilelist"

     PUSHBUTTON @2,24 WIDTH 17
        "Add ~I~tem >"
        VALUE "AddItem"
        TAG "AddItem"
        TO additem

     PUSHBUTTON @4,24 WIDTH 17
        "~A~dd All >>"
        VALUE "AddAll"
        TAG "AddAll"
        TO addall

     PUSHBUTTON @6,24 WIDTH 17
        "< Re~m~ove Item"
        VALUE "RemoveItem"
        TAG "RemoveItem"
        TO removeitem

     PUSHBUTTON @8,24 WIDTH 17
        "<< ~R~emove All"
        VALUE "RemoveAll"
        TAG "RemoveAll"
        TO removeall

     PICKDYNARRAYINDEX @2,42 HEIGHT 13 WIDTH 21
        MtHFileSelect
        TAG "MtHOutFile"
        TO MtHOutFile

     LABEL @1,41
        "Files Chosen"
        FOR "MtHOutFile"

     PUSHBUTTON @10,24 WIDTH 17
        "~O~K"
        OK
        VALUE "OK"
        TAG "OK"
        TO OkCancel

     PUSHBUTTON @12,24 WIDTH 17
        "~C~ancel"
        CANCEL
        VALUE "Cancel"
        TAG "Cancel"
        TO OkCancel

     PUSHBUTTON @14,24 WIDTH 17
        "~H~elp"
        VALUE HelpMeDlg(2)
        TAG ""
        TO HelpMe.a
  ENDDIALOG

  ; PaintPAL_Generated_Code_End(448885377)


  IF retval = False OR                           ;  If the dialog box was
     DYNARRAYSIZE(MtHFileSelect) = 0 THEN         ; cancelled or no departments
       RETURN False                              ; selected than return False
  ELSE                                           ; otherwise return True
    RETURN True
  ENDIF

ENDPROC
WRITELIB LIBNAME DlgGetFiles
RELEASE PROCS DlgGetFiles
LB_DISPLAYPROGRESS.U(PROCTOTAL.N, "DlgGetFiles")




PROC DlgGetFilesProc(triggertype,tagvalue,eventvalue,elementvalue)
  SWITCH
    CASE triggertype="UPDATE":
      SWITCH
        CASE tagvalue = "AddItem" :
             IF DYNARRAYSIZE(MtHFileChoice) = 0 THEN
               RETURN False
             ENDIF
             MtHFileSelect[CONTROLVALUE("mthinfilelist")] = MtHFileChoice[CONTROLVALUE("mthinfilelist")]
             RELEASE VARS MtHFileChoice[CONTROLVALUE("mthinfilelist")]
             SELECTCONTROL "mthinfilelist"
             REFRESHDIALOG
        CASE tagvalue = "AddAll" :
             IF DYNARRAYSIZE(MtHFileChoice) = 0 THEN
               RETURN False
             ENDIF
             FOREACH element In MtHFileChoice
               MtHFileSelect[element] = MtHFileChoice[element]
             ENDFOREACH
             DYNARRAY MtHFileChoice[]
             SELECTCONTROL "MtHOutFile"
             REFRESHDIALOG
        CASE tagvalue = "RemoveItem" :
             IF DYNARRAYSIZE(MtHFileSelect) = 0 THEN
               RETURN False
             ENDIF
             MtHFileChoice[CONTROLVALUE("MtHOutFile")] = MtHFileSelect[CONTROLVALUE("MtHOutFile")]
             RELEASE VARS MtHFileSelect[CONTROLVALUE("MtHOutFile")]
             REFRESHDIALOG
             IF DYNARRAYSIZE(MtHFileSelect) > 0 THEN
               SELECTCONTROL "mthinfilelist"
             ELSE
               SELECTCONTROL "MtHOutFile"
             ENDIF
        CASE tagvalue = "RemoveAll" :
             IF DYNARRAYSIZE(MtHFileSelect) = 0 THEN
               RETURN False
             ENDIF
             FOREACH element IN MtHFileSelect
               MtHFileChoice[element] = MtHFileSelect[element]
             ENDFOREACH
             DYNARRAY MtHFileSelect[]
             SELECTCONTROL "mthinfilelist"
             REFRESHDIALOG
      ENDSWITCH
    CASE triggertype = "SELECT" :
         SWITCH
           CASE tagvalue = "mthinfilelist" :
             MtHFileSelect[CONTROLVALUE("mthinfilelist")] = MtHFileChoice[CONTROLVALUE("mthinfilelist")]
             RELEASE VARS MtHFileChoice[CONTROLVALUE("mthinfilelist")]
             REFRESHDIALOG
             REPAINTDIALOG
           CASE tagvalue = "MtHOutFile" :
             MtHFileChoice[CONTROLVALUE("MtHOutFile")] = MtHFileSelect[CONTROLVALUE("MtHOutFile")]
             RELEASE VARS MtHFileSelect[CONTROLVALUE("MtHOutFile")]
             REFRESHDIALOG
             REPAINTDIALOG
         ENDSWITCH
  ENDSWITCH
  RETURN TRUE
ENDPROC
WRITELIB LIBNAME DlgGetFilesProc
RELEASE PROCS DlgGetFilesProc
LB_DISPLAYPROGRESS.U(PROCTOTAL.N, "DlgGetFilesProc")



PROC GetSubject()
   QUERY

 Querymsg | Start Msg | In Reply To | Msg Number |  Forum    | Sect Number |
          |           |             |            | Check ~fm | Check ~sect |

 Querymsg | Sect Name |  Date  |  Time  | Subject  | From Name |
          |           |        |        | Check    |           |

 Querymsg | From PPN | To Name | To PPN | Message |
          |          |         |        |         |

   ENDQUERY

   DO_IT!
   clearall
   IF nrecords("answer") >= 1 THEN
      MENU {Modify} {Restructure} {Answer}
      END
      DOWN "get"
      RIGHT
      "a1" Do_It!
      EMPTY "Subject"
      ADD "answer" "Subject"
      clearall
      rec=nrecords("Subject")
      ARRAY files[rec]
      ARRAY selfiles[rec]

      autolib= "paradox,crm"

      VIEW "Subject"
      SCAN
         files[recno()] = [subject]
      ENDSCAN
      CLEARALL
      DynArray Opts[]
      Opts["TITLE"]="Subjects"
      goon1 = ""
      goon1=wbsarraycheckboxplus(99,99,files,selfiles,Opts,"gray")
      autolib="Paradox"
      IF goon1 <> "Esc" THEN
         COEDIT "subject"
         FOR x FROM 1 TO rec
            IF isassigned(selfiles[x]) AND selfiles[x] = true THEN
               MOVETO record(x)
               [get] = "X"
            ENDIF
         ENDFOR
         DO_IT!



         QUERY

 subject | Forum   | Sect Number  | Subject | Get |
         | _a, ~fm | _b, ~sect    | _c      | X   |

 Querymsg | Start Msg | In Reply To | Msg Number |  Forum   | Sect Number |
          | Check     | Check       | Check      | Check _a | Check _b    |

 Querymsg | Sect Name |  Date  |  Time  | Subject  | From Name |
          | Check     | Check  | Check  | Check _c | Check     |

 Querymsg | From PPN | To Name | To PPN | Message |
          | Check    | Check   | Check  | Check   |

         ENDQUERY
         DO_IT!
         clearall
         IF nrecords("Answer") >=1 THEN
            EMPTY "querymsg"
            ADD "answer" "querymsg"
         ELSE
            goon1 = "Esc"
         ENDIF
      ELSE
         goon1 = "Esc"

      ENDIF
   ELSE
      goon1 = "Esc"

   ENDIF
   EMPTY "Subject"
   clearall
   RETURN goon1
ENDPROC
WRITELIB LIBNAME GetSubject
RELEASE PROCS GetSubject
LB_DISPLAYPROGRESS.U(PROCTOTAL.N, "GetSubject")



