/*Ŀ
 ݳ                                                                      
 ݳ Program Name: ERRSAVE.PRG       Copyright: (c) 1991 M&T Books        
 ݳ Date Created: 1991               Language: Clipper 5.0               
 ݳ Time Created:                      Author: Craig Yellick             
 ݳ                                                                      
 ݳ 02/05/93 KSG                                                         
 ݳ * removed default() in favor of curdrive()                           
 ݳ * removed save/restore environment stuff                             
 ݳ * added section to test for clock linked in, and if so uninstall it. 
 ݳ * removed most comments from this program file (i do not need um)!   
 ݳ * tided up a little                                                  
 
            */


//  Convert integers to left-trimmed strings.
#define lstr(n)  (ltrim(str(n)))

//  Convert logicals to text.
#define YN(L)    if(L, "Yes", "No ")

//  Short-hand.
#translate ifempty(<a>, <b>) => if(empty(<a>), <b>, <a>)

function ErrorSaver(e, defError, appTitle, filename)

local errEnv
local varList_, trace_
local i, r, c, sel, argStr, argCnt, osDescr

  i := 1
  trace_ := {}
  do while .not. empty(procname(i))
    aadd(trace_, procname(i) +" (" +lstr(procline(i)) +")")
		i++
  enddo

  //  Build list of arguments (if any)
  if valtype(e:args) = "A"
    argStr := ""
    aeval(e:args, { |s| argStr += (XtoS(s) +", ")} )
    argStr := left(argStr, min(len(argStr) -2, 35))
    argCnt := lstr(len(e:args))
  else
    argStr := "<none>"
    argCnt := "0"
  endif

  //  Build description of operating systen error
  if e:osCode > 0
    osDescr := lstr(e:osCode) +": " +left(DosErrText(e:osCode), 35)
  else
    osDescr := "0: n/a"
  endif

  varList_ := {"arg count         " +argCnt,              ;
               "args              " +argStr,              ;
               "canDefault        " +YN(e:canDefault),    ;
               "canRetry          " +YN(e:canRetry),      ;
               "canSubstitute     " +YN(e:canSubstitute), ;
               "description       " +e:description,       ;
               "filename          " +e:filename,          ;
               "genCode           " +lstr(e:genCode),     ;
               "operation         " +e:operation,         ;
               "osCode            " +osDescr,             ;
               "severity          " +lstr(e:severity),    ;
               "subCode           " +lstr(e:subCode),     ;
               "subSystem         " +e:subSystem,         ;
               "tries             " +lstr(e:tries),       ;
               "----------------- ",                      ;
               "Free memory   (0) " +lstr(memory(0)),     ;
               "Largest block (1) " +lstr(memory(1)),     ;
               "Run area      (2) " +lstr(memory(2))  }


  //  Display screen heading
  if valtype(appTitle) <> "C"
    appTitle := ""
  endif

  //  If filename was specified, open it up and append error info.
  if valtype(filename) = "C"
    set alternate to (filename) additive
    set alternate on
    set console off
    ? replicate("=", 70)
    ?  "ErrorSaver: This run-time error logged on "
    ?? dtoc(date()) +" at " +time()
    if .not. empty(appTitle)
      ?  "Application: " +appTitle
    endif
    ?  "Operating system = " +os() +", network = "
    ?? ifempty(netname(), "<none>")
    ?  "Available diskspace = "
    ??  ltrim(transform(diskspace(), "999,999,999,999")) +" in "
    ?? curdrive()    + curdir()
    ?  "PATH    = "  +ifempty(gete("PATH"),    "<none>")
    ?  "COMSPEC = "  +ifempty(gete("COMSPEC"), "<none>")
    ? replicate("-", 70)
    ? "Traceback: Proc (Line)   Error Information"
    ? "~~~~~~~~~~~~~~~~~~~~~~   ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~"
    for i := 1 to max(len(trace_), len(varList_))
      if i <= len(trace_)
        ? "  " +padr(trace_[i], 20)
      else
        ? space(22)
      endif
      ?? space(3)
      if i <= len(varList_)
         ?? varList_[i]
      endif
    next i
    set console on
    set alternate off
    set alternate to
  endif
  setcolor('w/n')
  scroll()
  CMDHELP("BOMBOUT")
return .f.

static function XtoS(x)
    local s
    if     valtype(x) = "C"
        s := x
    elseif valtype(x) = "N"
        s := lstr(x)
    elseif valtype(x) = "D"
        s := dtoc(x)
    elseif valtype(x) = "L"
        s := if(x, ".t.", ".f.")
    endif
return s                                         // return a string

static function DosErrText(n)
/*
   Return description of DOS error code.
   (Descriptions based on table D-1 in
   Clipper 5.0 Programming & Utilities Guide.)
*/
local descr_ := {;
    "Invalid function number",                         ;  // 1
    "File not found",                                  ;  // 2
    "Path not found",                                  ;  // 3
    "Too many files open (no handles left)",           ;  // 4
    "Access denied",                                   ;  // 5
    "Invalid handle",                                  ;  // 6
    "Memory control blocks destroyed",                 ; // 7
    "Insufficient memory",                             ;  // 8
    "Invalid memory block address",                    ;  // 9
    "Invalid environment",                             ;  // 10
    "Invalid format",                                  ;  // 11
    "Invalid access code",                             ;  // 12
    "Invalid data",                                    ;  // 13
    ,                                                  ;  // 14
    "Invalid drive was specified",                     ;  // 15
    "Attempt to remove the current directory",         ;  // 16
    "Not same device",                                 ;  // 17
    "No more files",                                   ;  // 18
    "Attempt to write on write-protected diskette",    ;  // 19
    "Unknown unit",                                    ;  // 20
    "Drive not ready",                                 ;  // 21
    "Unknown command",                                 ;  // 22
    "Data error (CRC)",                                ;  // 23
    "Bad request structure length",                    ;  // 24
    "Seek error",                                      ;  // 25
    "Unknown media type",                              ;  // 26
    "Sector not found",                                ;  // 27
    "Printer out of paper",                            ;  // 28
    "Write fault",                                     ;  // 29
    "Read fault",                                      ;  // 30
    "General failure",                                 ;  // 31
    "Sharing violation",                               ;  // 32
    "Lock violation",                                  ;  // 33
    "Invalid disk change",                             ;  // 34
    "FCB unavailable",                                 ;  // 35
    "Sharing buffer overflow",                         ;  // 36
    ,,,,,,,,,,,,,                                      ;  // 37-49
    "Network request not supported",                   ;  // 50
    "Remote computer not listening",                   ;  // 51
    "Duplicate name on network",                       ;  // 52
    "Network name not found",                          ;  // 53
    "Network busy",                                    ;  // 54
    "Network device no longer exists",                 ;  // 55
    "Network BIOS command limit exceeded",             ;  // 56
    "Network adapter hardware error",                  ;  // 57
    "Incorrect response from network",                 ;  // 58
    "Unexpected network error",                        ;  // 59
    "Incompatible remote adapter",                     ;  // 60
    "Print queue full",                                ;  // 61
    "Not enough space for print file",                 ;  // 62
    "Print file deleted (not enough space)",           ;  // 63
    "Network name deleted",                            ;  // 64
    "Access denied",                                   ;  // 65
    "Network device type incorrect",                   ;  // 66
    "Network name not found",                          ;  // 67
    "Network name limit exceeded",                     ;  // 68
    "Network BIOS session limit exceeded",             ;  // 69
    "Temporarily paused",                              ;  // 70
    "Network request not accepted",                    ;  // 71
    "Print or disk redirection paused",                ;  // 72
    ,,,,,,,                                            ;  // 73-79
    "File already exists",                             ;  // 80
    ,                                                  ;  // 81
    "Cannot make directory entry",                     ;  // 82
    "Fail on INT 24h",                                 ;  // 83
    "Too many redirections",                           ;  // 84
    "Duplicate redirection",                           ;  // 85
    "Invalid password",                                ;  // 86
    "Invalid parameter",                               ;  // 87
    "Network device fault",                            ;  // 88
                                                       ;
    "Undefined or reserved error code!" }                 // +1

  /*
  *  Check that code number is within known upper limit,
  *  and that a description is available for it.
  */
  if (n > (len(descr_) -1)) .or. (descr_[n] = nil)
    n := len(descr_)
  endif

return descr_[n]

