*-------------------------------------------------------------------------------
*-- Program...: TIME.PRG
*-- Programmer: Ken Mayer (CIS: 71333,1030)
*-- Date......: 04/19/1993
*-- Notes.....: These are a series of routines that deal with time strings,
*--             and so on. Very useful. See README.TXT for more details on
*--             the use of this library file.
*-------------------------------------------------------------------------------

FUNCTION Delay
*-------------------------------------------------------------------------------
*-- Programmer..: Jay Parsons (CIS: 70160,340)
*-- Date........: 03/01/1992
*-- Notes.......: Delay Loop.  Returns .T. after lapse of given number of 
*--               seconds.  Accurate to one tick, about 1/18.2 secs.
*-- Written for.: dBASE IV, Version 2.0 or higher
*-- Rev. History: 03/01/1992 -- Original function
*--               04/20/1993 -- modified for dBASE IV 2.0 syntax, bug fixed
*-- Calls.......: TIME2SEC()           Function in TIME.PRG
*-- Called by...: Any
*-- Usage.......: Delay(<nSeconds>)
*-- Example.....: lX= Delay(10.25)
*-- Returns.....: Logical
*-- Parameters..: nSeconds = number of seconds to delay
*-------------------------------------------------------------------------------

	parameters nSeconds         && up to 86400, one day
        private nTimeout, nTimenow, lRollover
        nTimeout = 100 * ( Time2Sec( time( 0 ) ) + nSeconds )
        if nTimeout > 8640000
          lRollover = .T.
          nTimeout = nTimeout - 8640000
        else
          lRollover = .F.
        endif
        do while .T.
          nTimenow = 100 * Time2Sec( time( 0 ) )
          if nTimenow < nTimeout
            lRollover = .F.
          else
            if .not. lRollover
              exit
            endif
          endif
        enddo

RETURN .T.
*-- EoF: Delay()

FUNCTION Time2Sec
*-------------------------------------------------------------------------------
*-- Programmer..: Jay Parsons (CIS: 70160,340)
*-- Date........: 03/01/1992
*-- Notes.......: Convert HH:MM:SS or HH:MM:SS.SS string to seconds.
*-- Written for.: dBASE IV
*-- Rev. History: 03/01/1992 -- Original
*-- Calls.......: None
*-- Called by...: Any
*-- Usage.......: Time2Sec("<cTime>")
*-- Example.....: ?Time2Sec("01:24:15")
*-- Returns.....: Numeric
*-- Parameters..: cTime = Time string in format HH:MM:SS or HH:MM:SS.SS
*-------------------------------------------------------------------------------
	
	parameters cTime
	private cTemp, nSecs
	cTemp = cTime
	nSecs = 3600 * val( cTemp )
	cTemp = substr( cTemp, at( ":", cTemp ) + 1 )
	nSecs = nSecs + 60 * val( cTemp )
	
RETURN nSecs + val( substr( cTemp, at( ":", cTemp ) + 1 ) )
*-- EoF: Time2Sec()

FUNCTION Sec2Time
*-------------------------------------------------------------------------------
*-- Programmer..: Jay Parsons (CIS: 70160,340)
*-- Date........: 03/01/1992
*-- Notes.......: Convert number of seconds to time string in format of
*--               HH:MM:SS or HH:MM:SS.SS.
*-- Written for.: dBASE IV
*-- Rev. History: 03/01/1992 -- Original 
*-- Calls.......: None
*-- Called by...: Any
*-- Usage.......: Sec2Time("<cTime>")
*-- Example.....: ?Sec2Time(30001.3)
*-- Returns.....: Character String
*-- Parameters..: nSeconds = Seconds to be converted 
*-------------------------------------------------------------------------------

	parameters nSeconds
	private nHrs, nMins , nSecs, cTemp
	nSecs = mod( nseconds, 86400 )
	nHrs  = int( nSecs / 3600 )
	nSecs = nSecs - nHrs * 3600
	nMins = int( nSecs / 60 )
	nSecs = nSecs - nMins * 60
	cTemp = transform( nHrs, "@L 99" ) + ":" + transform( nMins, "@L 99" ) ;
	  + ":"

RETURN cTemp+iif(nSecs=int(nSecs),transform(nSecs,"@L 99"),;
                 transform(nSecs,"@L 99.99"))
*-- EoF: Sec2Time()

FUNCTION DiffTime
*-------------------------------------------------------------------------------
*-- Programmer..: Jay Parsons (CIS: 70160,340)
*-- Date........: 03/01/1992
*-- Notes.......: Calculate difference between two times given as HH:MM:SS 
*--               strings. If second time is smaller than first, assumes 
*--               midnight passage. Returns HH:MM:SS string, or HH:MM:SS.SS 
*--               string if fractional seconds passed.
*-- Written for.: dBASE IV
*-- Rev. History: 03/01/1992 -- Original
*-- Calls.......: TIME2SEC()           Function in TIME.PRG
*--               SEC2TIME()           Function in TIME.PRG
*-- Called by...: Any
*-- Usage.......: DiffTime("<cTime1>","<cTime2>")
*-- Example.....: ?DiffTime("2:03:24","5:12:33")
*-- Returns.....: Character String
*-- Parameters..: cTime1 = Time to subtract from cTime2
*--               cTime2 = Time to subtract from (larger value, unless
*--                            after midnite)
*-------------------------------------------------------------------------------

	parameters cTime1, cTime2

RETURN Sec2Time( 86400 + Time2Sec( cTime2 ) - Time2Sec( cTime1 ) )
*-- EoF: DiffTime()

FUNCTION Civ2Mil
*-------------------------------------------------------------------------------
*-- Programmer..: Jay Parsons (CIS: 70160,340)
*-- Date........: 03/01/1992
*-- Notes.......: Converts string like "12:59 a.m." to standard 24-hour 
*--               HH:MM:SS. If the string contains neither "a" nor "p", the 
*--               hours will not be converted.
*-- Written for.: dBASE IV
*-- Rev. History: 03/01/1992 -- Original 
*-- Calls.......: None
*-- Called by...: Any
*-- Usage.......: Civ2Mil("<cCivilTime>")
*-- Example.....: ?Civ2Mil("2:03:24 a.m.")
*-- Returns.....: Character String
*-- Parameters..: cCivilTime = Time to convert to 24 hour time.
*-------------------------------------------------------------------------------

	parameters cCiviltime
	private cTstring, nTime
	cTstring =  trim( lower( cCiviltime ) )
	nTime = val( cTstring )
	do case
	  case "p" $ cTstring
	    cTstring = left( cTstring, at( "p", cTstring ) - 1 )
            nTime = mod( nTime, 12 ) + 12
	  case "a" $ cTstring
	    cTstring = left( cTstring, at( "a", cTstring ) - 1 )
	    nTime = mod( nTime, 12 )
	endcase
	cTstring = transform( nTime, "@L 99" ) ;
	  + trim( substr( cTstring, at( ":", cTstring ) ) )
	
RETURN cTstring + iif( len( cTstring ) = 5, ":00", "" )
*-- EoF: Civ2Mil()

FUNCTION Mil2Civ
*-------------------------------------------------------------------------------
*-- Programmer..: Jay Parsons (CIS: 70160,340)
*-- Date........: 03/01/1992
*-- Notes.......: Converts HH:MM:SS 24-hour string to a.m or p.m. notation.
*-- Written for.: dBASE IV
*-- Rev. History: 03/01/1992 -- Original 
*-- Calls.......: None
*-- Called by...: Any
*-- Usage.......: Mil2Civ("<cMilTime>")
*-- Example.....: ?Mil2Civ("14:03:24")
*-- Returns.....: Character String
*-- Parameters..: cMilTime = Time to convert to 24 hour time.
*-------------------------------------------------------------------------------

	parameters cMiltime
	private cCivtime, nHours, cMins
	cCivtime = ltrim( trim( cMiltime ) )
	nHours = val( cCivtime )
	cMins = substr( cCivtime, at( ":", cCivtime ) ) + " " ;
	  + iif( nHours > 11, "p.m.", "a.m." )
	
RETURN ltrim( str( mod( nHours + 11, 12 ) + 1 ) ) + cMins
*-- EoF: Mil2Civ()

FUNCTION IsAmPm
*-------------------------------------------------------------------------------
*-- Programmer..: Charles Miedzinksi (Borland Technical Support)
*-- Date........: 11/05/1992
*-- Notes.......: Taken from TechNotes (??), Checks to see if a character
*--               string is in proper AM/PM time format.
*-- Written for.: dBASE IV 1.1, 1.5
*-- Rev. History: 11/05/1992 -- Modified a bit for the Library ...
*-- Calls.......: None
*-- Called by...: Any
*-- Usage.......: IsAmPm(<cTime>)
*-- Example.....: ?IsAmPm("20:15:05")   && should return .F.
*-- Returns.....: Logical
*-- Parameters..: cTime = a time string in format: "HH:MM:SS a/pm"
*--                       Seconds part of string is optional, as is A/PM
*-------------------------------------------------------------------------------
	
	parameters cTime

RETURN iif(val(left(cTime, 2)) >= 1 .and. val(left(cTime, 2)) <= 12, ;
	 iif(val(substr(cTime, 4, 2)) >= 0 .and. val(substr(cTime, 4, 2)) <= 59, ;
	 iif(substr(cTime, 6, 1) $ 'aApP', .T., ;
	 iif(val(substr(cTimer, 6, 2)) >= 0 .and. val(substr(cTime, 6, 2)) <= 59, ;
	 .T., .F.)), .F.), .F.)
*-- EoF: IsAmPm()

FUNCTION AddTimes
*-------------------------------------------------------------------------------
*-- Programmer..: Angus Scott-Fleming (CIS: 75500,3223)
*-- Date........: 05/28/1992
*-- Notes.......: Add two times
*-- Written for.: dBASE IV
*-- Rev. History: 05/28/1992 -- Original
*-- Calls.......: Time2Sec               Function in TIME.PRG
*--               Sec2Time               Function in TIME.PRG
*-- Called by...: Any
*-- Usage.......: AddTimes("<cTime1>","<cTime2>") 
*--                OR 
*--               AddTimes("<cTime1>",<nHours>)
*-- Example.....: ?AddTimes("01:24:15","02:00:00") 
*--                    OR 
*--               ?AddTimes("01:24:15",2.5)
*-- Returns.....: cTime    = Time string in format HH:MM:SS or HH:MM:SS.SS
*-- Parameters..: cTime1,2 = Time string in format HH:MM:SS or HH:MM:SS.SS
*--               nHours   = Numeric (number of hours to add to cTime1
*-------------------------------------------------------------------------------

parameters Time_One,Time_Two

if type("Time_Two") = "N"
  RETURN Sec2Time(Time2Sec(Time_One)+Time_Two*3600)
endif

RETURN Sec2Time(Time2Sec(Time_One)+Time2Sec(Time_Two))
*-- EoF: AddTimes()

*-------------------------------------------------------------------------------
*-- EoP: TIME.PRG
*-------------------------------------------------------------------------------
