   /* tbFilt2.prg: Filtered browse of supplier.dbf.
   
   Builds an array of records that pass the filter criterion, and then
   uses goTopBlock, goBottomBlock and skipBlock to display only the 
   records whose record numbers are in the array.
   
   Copyright (C) Dave Boettcher 1993. This source code, and functional 
   fragments thereof, may only be distributed unchanged and as part of 
   the file POWER_TB.ARJ. See POWER_TB.TXT for full copyright details.

   Last change:  14 May 93       6:49 pm
   */
   
   #include "setcurs.ch"
   #include "inkey.ch"
   #include "box.ch"
   
function main()
   
   local oBrowse
   local oColumn
   local nKey
   local lCont := .T.
   local oldColour := setcolor("w+/b")
   local oldCursor := setcursor(SC_NONE)
   
   local currElement := 1
   local maxElement := 0
   local bScope := {|| alltrim(supplier->name) == "Nantucket UK Ltd"}
   
   use supplier new
   
   clear screen
   @ 0, 0, 24, 79 box B_DOUBLE
   
   oBrowse := tbrowsedb(1, 1, 23, 78)
   oBrowse:headsep   := ""
   oBrowse:colsep    := "  "
   oBrowse:goBottomBlock := {|| dbgoto (oBrowse:cargo[1]), currElement := 1}
   oBrowse:goTopBlock := {|| dbgoto (aTail(oBrowse:cargo)), currElement := maxElement}
   oBrowse:skipBlock := {|n| skipper(n, oBrowse, @currElement, maxElement)}
   oBrowse:cargo := {}
   
   if .not. eval(bScope)
      do while .not. eval(bScope)
         skip
      enddo
   endif
   
   do while eval(bScope) .and. !eof()
      aadd(oBrowse:cargo, recno())
      maxElement++
      skip
      do while .not. eval(bScope) .and. .not. eof()
         skip
      enddo
   enddo
   
   dbgoto(oBrowse:cargo[1])
   
   oColumn := TBColumnNew("Name", {|| supplier->name})
   oColumn:width := 30
   oColumn:footsep := ""
   oBrowse:AddColumn(oColumn)
   
   oColumn := TBColumnNew("Street", {|| supplier->street})
   oColumn:width := 30 
   oColumn:footsep := ""
   oBrowse:AddColumn(oColumn)
   
   oColumn := TBColumnNew("Town", {|| supplier->town})
   oColumn:width := 30
   oColumn:footsep := ""
   oBrowse:AddColumn(oColumn)
   
   oColumn := TBColumnNew("County", {|| supplier->county})
   oColumn:width := 30
   oColumn:footsep := ""
   oBrowse:AddColumn(oColumn)
   
   oColumn := TBColumnNew("Postcode", {|| supplier->product})
   oColumn:width := 7
   oColumn:footsep := ""
   oBrowse:AddColumn(oColumn)
   
   oColumn := TBColumnNew("Product", {|| supplier->product})
   oColumn:width := 250
   oColumn:footsep := ""
   oBrowse:AddColumn(oColumn)
   
   
   do while lCont
      
      //... Stabilize browse (until done, or keystroke hit)
      do while .not. oBrowse:stable .AND. (nKey := InKey()) == 0
         oBrowse:Stabilize()
      enddo
      
      //... Everything stabilized
      if oBrowse:stable
         if (oBrowse:hitTop .OR. oBrowse:hitBottom)
            Tone(125,0)
         endif
         nKey := InKey(0)
      endif
      
      //... Handle keystrokes
      Do Case
         Case nKey == K_DOWN        ;  oBrowse:Down()
         Case nKey == K_UP          ;  oBrowse:Up()
         Case nKey == K_LEFT        ;  oBrowse:Left()
         Case nKey == K_RIGHT       ;  oBrowse:Right()
         Case nKey == K_PGDN        ;  oBrowse:PageDown()
         Case nKey == K_PGUP        ;  oBrowse:PageUp()
         Case nKey == K_CTRL_PGUP   ;  oBrowse:GoTop()
         Case nKey == K_CTRL_PGDN   ;  oBrowse:GoBottom()
         Case nKey == K_ESC         ;  lCont := .F.
      endcase
      
   enddo
   
   setcolor(oldColour)
   setcursor(oldCursor)
   clear screen
   
   return nil
   
   
function skipper(nRequest, oBrowse, currElement, maxElement)
   
   local nAllowed := 0
   
   do case
         
      case nRequest == 0
         skip 0
      case nRequest > 0
         do while nAllowed < nRequest .and. currElement < maxElement
            dbgoto(oBrowse:cargo[++currElement])
            nAllowed++
         enddo
      case nRequest <0
         do while nAllowed > nRequest .and. currElement > 1
            dbgoto(oBrowse:cargo[--currElement])
            nAllowed--
         enddo
         
   endcase
   
   return nAllowed
