   /* tbStack2.prg: This is similar to tbStack1, with all supplier 
   address details stacked vertically in column 2 of the browse 
   display, but this one omits blank entries. It therefore has to 
   dynamically vary the number of lines used to display each record.
   Hot stuff! I was pleased when I got this to work!!
   
   Copyright (C) Dave Boettcher 1993. This source code, and functional 
   fragments thereof, may only be distributed unchanged and as part of 
   the file POWER_TB.ARJ. See POWER_TB.TXT for full copyright details.
   
   Last change:  14 May 93       6:52 pm
   */
   
   #include "setcurs.ch"
   #include "inkey.ch"
   #include "box.ch"
   
   static nLines := 6
   static nLineNumber := 1
   static nLineLength := 20
   
function main()
   
   local oBrowse
   local oColumn
   local nKey
   local lCont := .T.
   local oldColour := setcolor("w+/b")
   local oldCursor := setcursor(SC_NONE)   
   
   use supplier new
   
   clear screen
   @ 0, 0, 24, 79 box B_DOUBLE
   
   oBrowse := tbrowsedb(1, 1, 23, 78)
   oBrowse:headsep   := ""
   oBrowse:colsep    := "  "
   oBrowse:goBottomBlock := { || dbGoBottom(), nLineNumber := nLines }
   oBrowse:goTopBlock := { || dbGoTop(), nLineNumber := 1 }
   oBrowse:skipBlock := { |n| multiskip(n) }
   
   oColumn := TBColumnNew("Name", {|| col1Conts() })
   oColumn:width := 30
   oColumn:footsep := ""
   oBrowse:AddColumn(oColumn)
   
   oColumn := TBColumnNew("Details", {|| col2Conts() })
   oColumn:width := nLineLength 
   oColumn:footsep := ""
   oBrowse:AddColumn(oColumn)
   
   do while lCont
      
      do while .not. oBrowse:stable .AND. (nKey := InKey()) == 0
         oBrowse:Stabilize()
      enddo
      
      if oBrowse:stable
         if (oBrowse:hitTop .OR. oBrowse:hitBottom)
            Tone(125,0)
         endif
         nKey := InKey(0)
      endif
      
      Do Case
         Case nKey == K_DOWN        ;  oBrowse:Down()
         Case nKey == K_UP          ;  oBrowse:Up()
         Case nKey == K_LEFT        ;  oBrowse:Left()
         Case nKey == K_RIGHT       ;  oBrowse:Right()
         Case nKey == K_PGDN        ;  oBrowse:PageDown()
         Case nKey == K_PGUP        ;  oBrowse:PageUp()
         Case nKey == K_CTRL_PGUP   ;  oBrowse:GoTop()
         Case nKey == K_CTRL_PGDN   ;  oBrowse:GoBottom()
         Case nKey == K_ESC         ;  lCont := .F.
      endcase
      
   enddo
   
   setcolor(oldColour)
   setcursor(oldCursor)
   clear screen
   
   return nil
   
   
function col1Conts()
   
   local cStr
   
   if nLineNumber == 1
      cStr := supplier->name
   else
      cStr := " "
   endif
   
   return cStr
   
   
function col2Conts()
   
   local cStr
   
   do case
      case nLineNumber == 1
         cStr := supplier->street
      case nLineNumber == 2
         cStr := supplier->village
      case nLineNumber == 3
         cStr := supplier->town
      case nLineNumber == 4
         cStr := supplier->county
      case nLineNumber == 5
         cStr := supplier->postcode
      case nLineNumber == 6
         cStr := replicate("-", nLineLength) 
   endcase
   
   return cStr
   
   
   
function MultiSkip( nRequested )
   
   local nAllowed := 0
   
   do case
         
      case nRequested == 0
         
         skip 0
         
      case nRequested > 0
         
         do while (!eof()) .and. nAllowed < nRequested
            
            nLineNumber++
            nAllowed++
            
            if nLineNumber > 1 .and. nLineNumber < nLines
               if empty(col2Conts())
                  nAllowed--
               endif
            endif
            
            if nLineNumber > nLines
               skip 1
               nLineNumber := 1
            endif
            
         enddo
         
         if eof()
            nAllowed--
            nLineNumber := nLines
            skip -1
         endif
         
      case nRequested < 0
         
         do while (!bof()) .and. nAllowed > nRequested
            
            nLineNumber--
            nAllowed--
            
            if nLineNumber > 1 .and. nLineNumber < nLines
               if empty(col2Conts())
                  nAllowed++
               endif
            endif
            
            if nLineNumber == 0
               skip -1
               nLineNumber := nLines
            endif
            
         enddo
         
         if bof()
            nAllowed++
            nLineNumber := 1
         endif
         
   endcase
   
   return (nAllowed)
