*ķ
*                                                         
*                       FILE_BLD.PRG                      
*                                                         
*Ķ
*                                                         
* Scott D. Grabo                                          
*                                                         
* Copyright (c) 1992 Third Wave Software                  
* 4529 Logsdon Drive                                      
* Annandale, VA  22003                                    
*                                                         
*Ķ
*	COMMENTS :	This is the interface through which the     
*              end user can pick which files will be       
*              built.                                       
*                                                           
*  SYNTAX   :  IF file_bld(<ExpC1>, <ExpL1>, <ExpC2>)       
*              <ExpC1>  path to be used as default          
*              <ExpL1>  called by developer, or in app      
*              <ExpC2>  default file to placed in target    
*                       list box                            
*                                                           
*  RETURNS  :  Logical                                      
*                                                           
*  CALLED BY:  MAIN_VAL.PRG                                
*                                                          
*  CALLS    :  PICKERV.PRG                                 
*              MAKE_CDX.PRG                                 
*              MAKE_DBF.PRG                                 
*              OPEN_DBF.PRG                                 
*Ľ
PARAMETER ;
  file_path, ;
  interactiv, ;
  dbf_2_bld
  
PRIVATE ;
  m.file_path, ;
  m.interactiv, ;
  m.dbf_2_bld, ;
  old_defa, ;
  old_path, ;
  window_str, ;
  source_str, ;
  target_str, ;
  counter, ;
  length, ;
  was_built

WAIT WINDOW ;
  "Setting up the File Builder..." ;
  NOWAIT
	  
*
* Let's save the default for restoration later
m.old_defa = SET("DEFAULT") + SYS(2003)
m.old_path = SET("PATH")

*
* If no path was provided, just use the current path
IF NOT TYPE("m.file_path") = "C" OR EMPTY(m.file_path)
	m.file_path = m.old_defa
ENDIF

m.window_str = "Rebuild files in " + TRIM(UPPER(m.file_path))
m.source_str = "System files" 
m.target_str = "Files to be rebuilt"

*
* Since this routine can be used for both development
* _and_ the final product, provide a flag for handling it
* with the development environment (interactive) vs. in
* the field.
IF m.interactiv
	IF USED("structur")
		SELECT structur
	 ELSE
		SELECT 0
		USE structur NOUPDATE
	ENDIF
	SET ORDER TO TAG name_filtr
	GOTO TOP

	SET DEFAULT TO (m.file_path)
 ELSE
	CLOSE DATA
	SET DEFAULT TO (m.file_path)

	IF USED("structur")
		SELECT structur
	 ELSE
		SELECT 0
		USE structur NOUPDATE
	ENDIF
	SET ORDER TO TAG name_filtr
	GOTO TOP
ENDIF

*
* If we told it to build a specific file, flesh out the
* target array for the picker.
IF TYPE("m.dbf_2_bld") = "C" AND SEEK(m.dbf_2_bld)
	*
	* Seed the target array with the name of the .DBF
	* that was passed.
	COPY TO ARRAY a_dbf_tgt ;
	  NEXT 1 ;
	  FIELDS ;
	    structur.dbf_call, ;
	    structur.dbf_name
	    
	COUNT TO m.length
	GOTO TOP
	
	*
	* Build out the source array for all .DBFs except
	* the one that was passed.
	IF m.length > 1
		COPY TO ARRAY a_dbf_src ;
		  FOR NOT structur.dbf_name = m.dbf_2_bld ;
		  FIELDS ;
		    structur.dbf_call, ;
    		structur.dbf_name
	 ELSE
	 	DIMENSION a_dbf_src[01, 02]
		STORE "" TO ;
		  a_dbf_src[01, 01], a_dbf_src[01, 02]
	ENDIF
 ELSE
	*
	* If this is during development, assume the developer
	* will pick and choose the files to rebuild.
	IF m.interactiv
		DIMENSION a_dbf_tgt[01, 02]
		STORE "" TO ;
		  a_dbf_tgt[01, 01], a_dbf_tgt[01, 02]
	
		GOTO TOP
		
		COPY TO ARRAY a_dbf_src ;
		  FIELDS ;
		   	structur.dbf_call, ;
		    structur.dbf_name
	 ELSE
	 	*
	 	* Otherwise, assume the user will want to rebuild
	 	* _all_ the files...
		DIMENSION a_dbf_src[01, 02]
		STORE "" TO ;
		  a_dbf_src[01, 01], a_dbf_src[01, 02]
	
		GOTO TOP
		
		COPY TO ARRAY a_dbf_tgt ;
		  FIELDS ;
		   	structur.dbf_call, ;
		    structur.dbf_name
	ENDIF		
ENDIF

*
* We should only use this during development:  let's use
* the DOS database name _and_ the dbf_call field for the
* display, since we'll recognize it more quickly by its
* system name than by its description.  Normally, the
* arrays are initialized with only the dbf_call value
* be used for display.
IF m.interactive
	PRIVATE src_len, tgt_len
	m.src_len = ALEN(a_dbf_src, 01)
	m.tgt_len = ALEN(a_dbf_tgt, 01)
	FOR m.counter = 1 TO m.src_len
		
		a_dbf_src[m.counter, 01] = ;
		  a_dbf_src[m.counter, 02] + "  " + ;
		  a_dbf_src[m.counter, 01]

	ENDFOR
	
	FOR m.counter = 1 TO m.tgt_len
		
		a_dbf_tgt[m.counter, 01] = ;
		  a_dbf_tgt[m.counter, 02] + "  " + ;
		  a_dbf_tgt[m.counter, 01]

	ENDFOR
	
	RELEASE m.src_len, m.tgt_len
ENDIF		
	
*
* Let's LOOP until we've either built all the selected files, 
* or the user says, "That's enough."  First, initialize a 
* flag that'll tell us whether or not a build was even 
* attempted.
m.was_built = .F.

DO WHILE .T.
	m.counter = 0
	
	*
	* If at least one was picked, and ESCape was not pressed
	IF pickerv( ;
	  @a_dbf_src, ;
	  @a_dbf_tgt, ;
	  m.window_str, ;
	  m.source_str, ;
	  m.target_str, ;
	  0, ;
	  .F.)
		m.was_built = .T.
	  	m.length = ALEN(a_dbf_tgt, 01) 
	
		*
		* We'll now scroll through the target array
		* for as long as there are target array elements
		DO WHILE m.length > 0
	
			*
			* If the build was successful, then put the
			* build file data back into the source array.
			IF make_dbf(TRIM(a_dbf_tgt[01, 02]), "", .T.)
				DIMENSION a_dbf_src[ALEN(a_dbf_src, 01) + 1, 02]
				a_dbf_src[ALEN(a_dbf_src, 01), 01] = ;
				  a_dbf_tgt[01, 01]
				a_dbf_src[ALEN(a_dbf_src, 01), 02] = ;
				  a_dbf_tgt[01, 02]
			 ELSE
				*
				* Otherwise, we'll build out a temp array
				* to hold the failed build filenames.  This
				* temp array will then be turned back into
				* our target at the end of the process, and
				* we'll loop back to the picker again, with
				* the failed builds in the target box.
			 	m.counter = m.counter + 1 
		 		DIMENSION a_not_made[m.counter, 02]
			 	a_not_made[m.counter, 01] = a_dbf_tgt[01, 01] 
			 	a_not_made[m.counter, 02] = a_dbf_tgt[01, 02] 
			ENDIF

			*
			* Either way, we'll shorten the target array
			= ADEL(a_dbf_tgt, 01)
			m.length = m.length - 1 

			IF m.length > 0
				DIMENSION a_dbfname[m.length, 02]
			ENDIF
	
		ENDDO
	ENDIF

	*
	* The only way that m.counter could be > 0 is if a build
	* failed.  If so, we'll copy the error-holding array to the
	* target array, and LOOP back to try it again for just 
	* those that didn't build correctly.
	IF m.counter >= 1
		m.length = ALEN(a_not_made, 01)
		DIMENSION a_dbf_tgt[m.length, 02]
		= ACOPY(a_not_made, a_dbf_tgt)
		
		RELEASE a_not_made

		m.target_str = "Build failed for these" 
		m.window_str = "File Rebuild - Trying again..." 
	 ELSE
	 	EXIT
	ENDIF

ENDDO

WAIT WINDOW ;
  "Resetting files..." ;
  NOWAIT
	  
SET DEFAULT TO &old_defa
SET PATH TO &old_path

*
* You might want to disable these three lines if you intend
* to use the dictionary for more than file rebuilds in your
* application.
IF NOT m.interactiv
 	USE IN structur
ENDIF	

WAIT CLEAR

RETURN m.was_built