//=================================
//  RING0, by Matt Pietrek, 1993
//  File: RING0.C
//=================================
#include <windows.h>
#include <stdio.h>
#include "descript.h"

DWORD far pascal GET_CR(WORD cmd);
DWORD far pascal GET_CR_RING3(WORD cmd);

typedef DWORD (FAR PASCAL * DWORD_FARPROC)(WORD);

int PASCAL WinMain( HANDLE hInstance, HANDLE hPrevInstance,
                    LPSTR lpszCmdLine, int nCmdShow )
{
    char buffer[256];
    DWORD_FARPROC GET_CR_ptr;
    unsigned long ring0CR0, ring0CR2, ring0CR3;     // GRETCHEN - New Line
    unsigned short ourCS;                           // GRETCHEN - New Line

    //
    // Call the ring 3 version of GET_CR() to show that you
    // can't access these registers from normal ring 3 code.
    // Comment the first set of sprintf()/MessageBox() calls
    // below if you want to run in standard mode or on Windows
    // 3.0.  The call to Get_CR0_At_Ring_3() will GP fault
    // unless run under Windows 3.1 in enhanced mode.
    //
    sprintf(buffer, "From ring 3, CR0 = %08lX\r\n"
                    "From ring 3, CR2 = %08lX\r\n"
                    "From ring 3, CR3 = %08lX\r\n",
                    GET_CR_RING3(0), GET_CR_RING3(2),
                    GET_CR_RING3(3) );
    MessageBox(0, buffer, "First try", MB_OK);

    //
    // Now we'll get a function pointer that uses a call gate.
    // The second parameter indicates how many WORD parameters
    // should be copied to the ring 0 stack.  If the destination
    // was a 32 bit segment, the parameter would be the number
    // of DWORDs to copy.
    //
    GET_CR_ptr = (DWORD_FARPROC)CreateCallgate( GET_CR, 1 );

   // !!!!!  GRETCHEN !!!! - THINGS ARE PRETTY CHANGED FROM HERE
   // DOWN TO THE CLOSING COMMENT BELOW!!!

    if ( GET_CR_ptr == 0 )
    {
        MessageBox(0, "ERROR!!!", "Second try", MB_OK);
        return 0;
    }

    // Pagelock the segment containing the code to be executed in
    // Ring 0.  This is a small model program, so CS is what we want.
    _asm    mov [ourCS], cs
    GlobalPageLock(ourCS);

    //
    // Use the call gate to show that at ring 0, the
    // instructions can be accessed.  We disable interrupts
    // around the 3 calls to ring 0.
    //
    _asm    cli
    ring0CR0 = GET_CR_ptr(0);
    ring0CR2 = GET_CR_ptr(2);
    ring0CR3 = GET_CR_ptr(3);
    _asm    sti

    // We don't need the segment pagelocked anymore
    GlobalPageUnlock(ourCS);

    sprintf(buffer, "From ring 0, CR0 = %08lX\r\n"
                    "From ring 0, CR2 = %08lX\r\n"
                    "From ring 0, CR3 = %08lX\r\n",
                    ring0CR0, ring0CR2, ring0CR3 );

    MessageBox(0, buffer, "Second try", MB_OK);

   // !!!!! GRETCHEN !!!!! THIS IS THE END OF THE BIG CHANGES

    //
    // Deallocate the 2 selectors we used.
    //
    FreeCallgate( (GENERIC_PROC)GET_CR_ptr );

    return 0;
}
