;=================================
;  RING0, by Matt Pietrek, 1993
;  File: RING0ASM.ASM
;=================================
.model small
.386P
.code
public GET_CR
public GET_CR_RING3

GET_CR proc
    push    ebp
    mov     ebp, esp
    xor     eax, eax

    cmp     word ptr [ebp+8], 0
    jne     not_cr0
    mov     eax, cr0
    jmp     done

not_cr0:
    cmp     word ptr [ebp+8], 2
    jne     not_cr2
    mov     eax, cr2
    jmp     done

not_cr2:
    cmp     word ptr [ebp+8], 3
    jne     done
    mov     eax, cr3

done:
    mov     edx, eax
    shr     edx, 16
    pop     ebp
    retf    2
GET_CR endp

;
; GET_CR3_RING3 is identical in function to GET_CR.  The only
; difference is that it will be called while running on the
; 16 bit stack of the calling app, instead of on the ring 0
; stack.  You might think that the "push ebp / mov ebp,esp"
; code for GET_CR would work in either case, but there is
; some strangeness in the "mov ebp, esp" instruction that
; forces us to use to very slightly different versions.
;
GET_CR_RING3 proc
    push    bp
    mov     bp, sp
    xor     eax, eax

    cmp     word ptr [bp+6], 0
    jne     not_cr0_ring3
    mov     eax, cr0
    jmp     done_ring3

not_cr0_ring3:
    cmp     word ptr [bp+6], 2
    jne     not_cr2_ring3
    mov     eax, cr2
    jmp     done_ring3

not_cr2_ring3:
    cmp     word ptr [bp+6], 3
    jne     done_ring3
    mov     eax, cr3

done_ring3:
    mov     edx, eax
    shr     edx, 16
    pop     bp
    retf    2
GET_CR_RING3 endp

end
