/* 
PUSHKEYS.C
Windows app: send keystrokes to Windows app or DOS app
Andrew Schulman (CIS 76320,302)
Microsoft Systems Journal, February 1993 
Requires generic VxD (VXD.386)
*/

#include <stdlib.h>
#include <string.h>
#include <dos.h>
#include <ctype.h>
#include "windows.h"
#include "protmode.h"
#include "vxdcalls.h"

void fail(const char *s)
{
    MessageBox(NULL, (LPSTR) s, "PUSHKEYS", MB_OK);
    exit(1);
}

#ifdef __BORLANDC__
// Borland must have followed (incorrect) doc in SDK Guide, p. 14-3
#define argc _argc
#define argv _argv
#else
// Microsoft C code per MSJ, May 1991, pp. 135-6
#define argc __argc
#define argv __argv
#endif
extern int argc;
extern char **argv;

#ifdef __cplusplus
extern "C" BOOL FAR PASCAL IsWinOldApTask(HANDLE hTask);
extern "C" DWORD FAR PASCAL OEMKeyScan(WORD wOemChar);
#else
extern BOOL FAR PASCAL IsWinOldApTask(HANDLE hTask);
extern DWORD FAR PASCAL OEMKeyScan(WORD wOemChar);
#endif

BOOL SendKeys(char *wndtitle, char *keys);
BOOL PostWindowString(HWND hwnd, char *keys);
BYTE *KeysToScans(char *keys, int *pnumscans);
DWORD VKDGetKbdOwner(void);
BOOL VKDForceKeys(DWORD vm, BYTE *scans, WORD numscans);

int PASCAL WinMain(HANDLE hInstance, HANDLE hPrevInstance, 
    LPSTR lpCmdLine, int nCmdShow)
{
    if (argc < 3)
        fail("usage: pushkeys <window-title> <keys>");
    else
        if (! SendKeys(argv[1], argv[2]))
            fail("SendKeys failed");
    return 0;
}

BOOL SendKeys(char *wndtitle, char *keys)
{
    HWND hwnd, hsave;
    BOOL ret = TRUE;
    
    if (! (hwnd = FindWindow(0, wndtitle))) 
        return FALSE;
    hsave = GetFocus();
    BringWindowToTop(hwnd);
    if (IsWinOldApTask(GetWindowTask(hwnd)))
    {
        // DOS box: send keys to VM with keyboard focus
        int numscans;
        BOOL iconic = IsIconic(hwnd);
        BYTE *scans;
        DWORD vm;
        
        if (iconic) ShowWindow(hwnd, SW_SHOWNORMAL);    // unfortunate
        scans = KeysToScans(keys, &numscans);
        vm = VKDGetKbdOwner();
        if (! VKDForceKeys(vm, scans, numscans))
            ret = FALSE;
        if (iconic) ShowWindow(hwnd, SW_MINIMIZE);
    }
    else
    {
        // send keys to Windows app
        if (! PostWindowString(GetFocus(), keys))
            ret = FALSE;
    }
    BringWindowToTop(hsave);
    return ret;
}

// For Keybd_Event, see Jeff Richter, "Simulating
// Keyboard Input," MSJ, December 1992
void k(int c)
{
	static void (FAR PASCAL *Keybd_Event)(void) = 0;
	if (! Keybd_Event)	// one-time initialization
		if (! ((FARPROC) Keybd_Event = GetProcAddress(GetModuleHandle("USER"),
			"Keybd_Event")))
				fail("This program requires USER.Keybd_Event");
	_asm mov ax, c
	_asm xor bx, bx
	(*Keybd_Event)();
	Yield();
}

BOOL PostWindowString(HWND hwnd, char *keys)
{
    char *s;
    for (s=keys; *s; s++)
    {
        if (*s == '~') *s = VK_RETURN;  // hack for ENTER key
#if 1
		// can ignore hwnd parameter: already brought to top
		k(toupper(*s));	// quick hack -- use Keybd_Event
#else
        if (! PostMessage(hwnd, WM_CHAR, *s, 0L))
            return FALSE;
#endif		
    }
    return TRUE;
}

#define MAX_KEYS    1024

BYTE *KeysToScans(char *keys, int *pnumscans)
{
    // use OEMKeyScan() function provided by KEYBOARD driver
    static BYTE buf[MAX_KEYS];
    BYTE *s;
    int len = strlen(keys);
    int i;
    
    AnsiToOemBuff(keys, buf, len);
    for (i=0, s=buf; i<len; i++, s++)   // '~' is hack for ENTER
        *s = (BYTE) OEMKeyScan((*s == '~') ? VK_RETURN : *s);
    *pnumscans = len;   // for now
    return buf;
}

DWORD VKDGetKbdOwner(void)
{
    VxDParams p;
    p.CallNum = VKD_Get_Kbd_Owner;
    VxDCall(&p);
    return p.OutEBX;
}

BOOL VKDForceKeys(DWORD vm, BYTE *scans, WORD numscans)
{
    // ignoring vm parameter for now -- maybe use VKD_API_Force_Keys
    VxDParams p;
    p.CallNum = VKD_Force_Keys;
    p.InESI = MapFlat(scans);
    p.InECX = numscans;
    VxDCall(&p);
	UnmapFlat(scans);
    return (! (p.OutEFLAGS & CARRYFLAG));
}

