/* 
VMINT.C
Andrew Schulman (CIS 76320,302)
Microsoft Systems Journal, February 1993
Illustrates generic VxD (VXD.386) -- generate interrupt in other Windows VM
*/

#include <stdlib.h>
#include <stdio.h>
#include <time.h>
#include <dos.h>
#ifdef DPMI_APP
#include <conio.h>
#include "dpmishel.h"
#else
#include "windows.h"
#include "winio.h"
#endif
#include "vxdcalls.h"

DWORD GetCurVMHandle(void);
DWORD GetSysVMHandle(void);
WORD GetVMPSP(DWORD vm, WORD mode);
void far *GetVMSysVars(DWORD vm, WORD mode);

#ifdef DPMI_APP
void fail(const char *s) { puts(s); _dos_exit(1); }
#else
void fail(const char *s) { puts(s); exit(1); }
#endif

int test(DWORD vm);

#ifdef DPMI_APP
int v86_main(int, char*[])
{
    return 0;
}
    
int pmode_main(int argc, char *argv[])
{
    
    puts("in pmode");
#else
int main(int argc, char *argv[])
{
#endif

    DWORD vm;
    if (argc < 2)
        vm = GetSysVMHandle();
    else
    {
        sscanf(argv[1], "%08lX", &vm);
        if (vm == 0)
            vm = GetCurVMHandle();
    }
    for (;;)
    {
        test(vm);
    }
    return 0;
}

int test(DWORD vm)
{
    static WORD mode = MODE_V86;
    printf("[%08lX, %s] PSP = %04X\n",
        vm, (mode) ? "PM" : "V86", GetVMPSP(vm, mode));
    printf("[%08lX, %s] SysVars = %Fp\n",
        vm, (mode) ? "PM" : "V86", GetVMSysVars(vm, mode));
    if (mode == MODE_V86) mode = MODE_PM;
    else mode = MODE_V86;
    return 0;
}

WORD GetVMPSP(DWORD vm, WORD mode)
{
    VMInt vmint;
    vmint.VM = vm;
    vmint.Mode = mode;
    vmint.Intno = 0x21;
    vmint.AX = 0x6200;
    vmint.DS = vmint.ES = 0;
    if (! VMInt86(&vmint, 0))
        fail("GetVMPSP failed");
    return vmint.BX;
}

void far *GetVMSysVars(DWORD vm, WORD mode)
{
    VMInt vmint;
    vmint.VM = vm;
    vmint.Mode = mode;
    vmint.Intno = 0x21;
    vmint.AX = 0x5200;
    vmint.DS = vmint.ES = 0;
    if (! VMInt86(&vmint, 0))
        fail("GetVMSysVars failed");
    return MK_FP(vmint.ES, vmint.BX);
}

DWORD GetCurVMHandle(void)
{
    VxDParams p;
    p.CallNum = Get_Cur_VM_Handle;
    VxDCall(&p);
    return p.OutEBX;
}

DWORD GetSysVMHandle(void)
{
    VxDParams p;
    p.CallNum = Get_Sys_VM_Handle;
    VxDCall(&p);
    return p.OutEBX;
}

