/* 
VMPAGES.C -- what % of each VM pages are swapped out?
Andrew Schulman (CIS 76320,302)
Microsoft Systems Journal, February 1993
*/

#include <stdlib.h>
#include <stdarg.h>
#include <string.h>
#include <dos.h>
#include "windows.h"
#include "protmode.h"
#include "vxdcalls.h"

typedef struct {
    DWORD CB_VM_Status;
    DWORD CB_High_Linear;
    DWORD CB_Client_Pointer;
    DWORD CB_VMID;
    } VM_CB;    // Virtual Machine Control Block
        
typedef BOOL (*WALKFUNC)(DWORD vm, VM_CB far *);        

int vmwalk(WALKFUNC walkfunc);
BOOL walkfunc(DWORD vm, VM_CB far *vm_cb);
int wprintf(char *fmt, ...);
BOOL GetVMPgCount(DWORD vm, DWORD *ptotal, DWORD *pnotmapped);
DWORD GetSysVMHandle(void);
DWORD GetNextVMHandle(DWORD vm);

void fail(const char *s)
{
    MessageBox(NULL, (LPSTR) s, "VMPAGES", MB_OK);
    exit(1);
}

static char buf[1024] = {0};

int PASCAL WinMain(HANDLE hInstance, HANDLE hPrevInstance, 
    LPSTR lpCmdLine, int nCmdShow)
{
    for (;;)
    {
        vmwalk(walkfunc);
        if (MessageBox(0, buf, "VMPAGES", MB_OKCANCEL) == IDCANCEL)
            break;
        buf[0] = '\0';
    }
    return 0;
}

int vmwalk(WALKFUNC walkfunc)
{
    DWORD sys_vm = GetSysVMHandle();
    void far *vm_cb;
    VM_CB my_vm_cb;
    DWORD vm;
    int num_vm;
    for (vm=sys_vm, num_vm=0;; num_vm++)
    {
        vm_cb = map_linear(vm, sizeof(VM_CB));
        _fmemcpy(&my_vm_cb, vm_cb, sizeof(VM_CB));
        free_mapped_linear(vm_cb);
        if (! (*walkfunc)(vm, &my_vm_cb))
            return num_vm;
        if ((vm = GetNextVMHandle(vm)) == sys_vm)
            break;  // circular list
    }
    return num_vm;
}
        
BOOL walkfunc(DWORD vm, VM_CB far *vm_cb)
{
    static DWORD sys_vm = 0;
    DWORD total, notmapped, mapped;
    if (! sys_vm) sys_vm = GetSysVMHandle();
    GetVMPgCount(vm, &total, &notmapped);
	mapped = total - notmapped;
    wprintf("%s - VM %lu\n", 
        (char far *) ((vm == sys_vm) ? "System VM" : "DOS Box"),
        vm_cb->CB_VMID);
    wprintf("    Total = %lu pages (%lu bytes)\n", total, total << 12L);
    wprintf("    Mapped = %lu pages (%lu bytes)\n", mapped, mapped << 12L);
    wprintf("    %lu%% mapped\n", (mapped * 100) / total);
    return TRUE;
}
        
int wprintf(char *fmt, ...)
{
	char tmp[128];
    int ret;
    va_list marker;
    va_start(marker, fmt);
    ret = wvsprintf((LPSTR) tmp, (LPSTR) fmt, (LPSTR) marker);
	strcat(buf, tmp);
    return ret;
}

BOOL GetVMPgCount(DWORD vm, DWORD *ptotal, DWORD *pnotmapped)
{
    VxDPushParams p;
    p.CallNum = _GetVMPgCount;
    p.NumP = 2;
    p.P[0] = vm;
    p.P[1] = 0;     // flags=0
    if (! VxDPushCall(&p))
        return FALSE;
    if (! (p.OutEAX || p.OutEDX))
        return FALSE;
    else
    {
        *ptotal = p.OutEAX;
        *pnotmapped = p.OutEDX;
        return TRUE;
    }
}

DWORD GetSysVMHandle(void)
{
    VxDParams p;
    p.CallNum = Get_Sys_VM_Handle;
    return (VxDCall(&p)) ? p.OutEBX : 0;
}

DWORD GetNextVMHandle(DWORD vm)
{
    VxDParams p;
    p.CallNum = Get_Next_VM_Handle;
    p.InEBX = vm;
    return (VxDCall(&p)) ? p.OutEBX : 0;
}

