comment~
VXD.ASM
Generic Virtual Device Driver for Windows 3.x 386 Enhanced mode
from Microsoft Systems Journal
by Andrew Schulman and David S. Maxey, 1991-1992

Provides applications running under Windows Enhanced mode (Windows
apps, real-mode DOS apps, and protected-mode DPMI DOS apps) with
access to the VMM and VxD functions documented in the Windows DDK.
A program calls VXD.386 using its V86 or PM API; the API entry
point is retrieved with INT 2Fh AX=1684h BX=28C0h (VXD.386's device
ID).  The entry point is called with AX set to a subfunction
number:
    0 -- Get VXD.386 version number 
    1 -- MyVxDCall: Call VMM or VxD function with register parameters
    2 -- MapFlat: Turn seg:ofs address into 32-bit FLAT address
    3 -- VxDPushCall: Call VMM or VxD function with stack parameters
    4 -- VMInt86: Schedule PM or V86 interrupt in another virtual machine

Possible future enhancements:
    Allocate callbacks
    Ability to hook Control events
    Call non-INT code in another VM

The files VXDCALLS.C and VXDCALLS.H provide C/C++ wrappers.

To build:
   set include=\ddk\include
   masm5 -p -w2 vxd;
   link386 vxd,vxd.386,,,vxd.def
   addhdr vxd.386

Add device=vxd.386 to SYSTEM.INI [386Enh]
~

.386p

INCLUDE VMM.INC

;*****************************************************************************
;           E Q U A T E S
;*****************************************************************************

VXD_V_HI        EQU 1
VXD_V_LO        EQU 0

; VxD ID assigned by vxdid@microsoft.com
VxD_ID          EQU 28C0h

CFlag           EQU 1

;*****************************************************************************
;           V I R T U A L    D E V I C E   D E C L A R A T I O N
;*****************************************************************************

Declare_Virtual_Device VXD, VXD_V_HI, VXD_V_LO, VxD_Control, \
    VxD_ID, Undefined_Init_Order, \
    API_Handler, API_Handler,

;*****************************************************************************
;           S T U B   C O N T R O L   P R O C
;*****************************************************************************

VxD_LOCKED_CODE_SEG

BeginProc   VxD_Control
    clc
    ret
EndProc     VxD_Control

VxD_LOCKED_CODE_ENDS

;*****************************************************************************
;           D A T A   S E G M E N T
;*****************************************************************************

VxD_DATA_SEG

API_Call    label dword         ; table used by API_Handler
    dd      offset32 VxDVersion
    dd      offset32 MyVxDCall
    dd      offset32 MyMapFlat
    dd      offset32 VxDPushCall
    dd      offset32 VMInt86

API_MaxCall EQU ( $ - API_Call ) / 4

; Miscellaneous data used by MyVxDCall and VxDPushCall
Store_ESI       dd  ?
Save_Call_Num   dd  0       ; was call same as last time?
Sem             dd  0       ; semaphore -- protect self-modifying code
Save_Call_Num_2 dd  0       ; was call same as last time?
Stack_Restore   dd  0       ; number of bytes to add to esp
Sem2            dd  0       ; semaphore -- protect self-modifying code

VxD_DATA_ENDS

;*****************************************************************************
;           C O D E   S E G M E N T
;*****************************************************************************

VxD_CODE_SEG

;*****************************************************************************
;           API_Handler
;           for both V86 and Protected mode
;*****************************************************************************

BeginProc   API_Handler
    movzx   eax, [ebp.Client_AX]
    cmp     eax, API_MaxCall                ; Is this a valid function?
    jae     SHORT API_Failed
    and     [ebp.Client_EFlags], NOT CFlag  ; Set up for success
    call    API_Call[eax * 4]
    ret
API_Failed:
    or      [ebp.Client_EFlags], CFlag
    ret
EndProc     API_Handler

;*****************************************************************************
;           VxDVersion (Function 0)
;           Get VXD.386 version number 
;           Input: None
;           Output: Version number in AX
;*****************************************************************************

BeginProc   VxDVersion
    mov     [ebp.Client_AX], ((VXD_V_HI SHL 8) OR VXD_V_LO)
    ret
EndProc     VxDVersion

;*****************************************************************************
;           MyVxDCall (Function 1)
;           Call VMM or VxD function with register parameters
;           Input: Ptr to VxDParams struct in ES:BX
;           Output: VxDParams OUT regs changed; carry flag
;*****************************************************************************

VxDParams       STRUC
    CallNum     dd  ?
    Reserved1   dd  ?
    InEAX       dd  ?
    InEBX       dd  ?
    InECX       dd  ?
    InEDX       dd  ?
    InEBP       dd  ?
    InESI       dd  ?
    InEDI       dd  ?
    Reserved2   dd  ?
    Reserved3   dd  ?
    OutEAX      dd  ?
    OutEBX      dd  ?
    OutECX      dd  ?
    OutEDX      dd  ?
    OutEBP      dd  ?
    OutESI      dd  ?
    OutEDI      dd  ?
    OutFS       dw  ?
    OutGS       dw  ?
    OutEFLAGS   dd  ?
VxDParams       ENDS

BeginProc   MyVxDCall
    mov     ax, (Client_ES shl 8) + Client_BX
    VMMcall Map_Flat        ; Get FLAT address for caller's VxDParams
    mov     esi, eax
    mov     [Store_ESI], esi    ; ESI -> VxDParams

    ; self-modifying code below: only one caller at a time
    cmp     Sem, 0
    jnz     short Busy
    inc     Sem

    mov     eax, [esi.CallNum]  ; get requested function call number
    cmp     eax, ds:[Save_Call_Num]
    je      short Do_InRegs     ; function hasn't changed since last time

SetUp_Function:
    mov     ds:[Save_Call_Num], eax
    mov     ds:[Call_Num], eax
    ; the following is crucial:  after first call, Windows changes
    ; the INT 20h/DD into a CALL instruction; change it back!
    mov     word ptr ds:[Int_20], 020cdh

Do_InRegs:
    mov     eax, [esi.InEAX]
    mov     ebx, [esi.InEBX]
    mov     ecx, [esi.InECX]
    mov     edx, [esi.InEDX]
    mov     ebp, [esi.InEBP]
    mov     edi, [esi.InEDI]
    mov     esi, [esi.inESI]        ; do ESI last

Int_20:
; following will get changed to 32-bit near call; breakpoints will be lost
    int     20h
Call_Num    dd      0       ; This is the most important line in VXD.ASM

    xchg    esi, [Store_ESI]        ; we need ESI restored immediately
    pushfd                          ; and we don't want to damage the flags
    pop     [esi.OutEFLAGS]
    dec     Sem                     ; don't want to affect flags
    mov     [esi.OutEAX], eax
    mov     [esi.OutEBX], ebx
    mov     [esi.OutECX], ecx
    mov     [esi.OutEDX], edx
    mov     [esi.OutEBP], ebp
    mov     [esi.OutEDI], edi
    mov     [esi.OutFS], fs
    mov     [esi.OutGS], gs
    mov     eax, [Store_ESI]
    mov     [esi.OutESI], eax
Done:
    ret
Busy:
    or      [ebp.Client_EFlags], CFlag
    ret
EndProc     MyVxDCall

;*****************************************************************************
;           MyMapFlat (Function 2)
;           Turn seg:ofs address into 32-bit FLAT address
;           Input: Seg:ofs address (PM or V86) in ES:DI
;           Output: Equivalent FLAT32 address in DX:AX
;*****************************************************************************

BeginProc   MyMapFlat
    mov     ax, (Client_ES shl 8) + Client_DI   ; uses structure offsets!
    VMMcall Map_Flat
    mov     [ebp.Client_AX], ax
    shr     eax, 16
    mov     [ebp.Client_DX], ax
    ret
EndProc     MyMapFlat

;*****************************************************************************
;           VxDPushCall (Function 3)
;           Call VMM or VxD function with stack parameters
;           Input: VxDPushParams struct in ES:BX
;           Output: VxDPushParams OUT regs changed; carry flag
;*****************************************************************************

VxDPushParams   STRUC
    CallNum_2   dd  ?
    NumP        dd  ?
    ; PushCParams macro in VMM.INC allows 10 params
    P           dd  10 dup  (?)
    OutEAX_2    dd  ?
    OutEDX_2    dd  ?
VxDPushParams   ENDS

BeginProc   VxDPushCall
    mov     ax, (Client_ES shl 8) + Client_BX
    VMMcall Map_Flat        ; Get FLAT address for caller's parameter block
    mov     esi, eax

    cmp     Sem2, 0
    jnz     short Busy2
    inc     Sem2

    mov     eax, [esi.CallNum_2]    ; get requested function call number
    cmp     eax, ds:[Save_Call_Num_2]
    je      short DoPush            ; function hasn't changed since last time

SetUp_Function_2:
    mov     ds:[Save_Call_Num_2], eax
    mov     ds:[Call_Num_2], eax
    ; the following is crucial:  after first call, Windows changes
    ; the INT 20h/DD into a CALL instruction; change it back!
    mov     word ptr ds:[Int_20_2], 020cdh

DoPush:
    mov     ecx, [esi.NumP]                 ; number of arguments
    mov     eax, ecx
    shl     eax, 2                          ; number of bytes
    mov     ds:[Stack_Restore], eax         ; save to add later to ESP
    or      ecx, ecx
    jz      short Int_20_2                  ; no params
    lea     ebx, [esi.P]                    ; EBX = offset into regs struct
    add     ebx, eax                        ; going to push in reverse order
PushLoop:
    sub     ebx, 4                          ; get offset to next arg
    push    [ebx]                           ; push next arg
    dec     ecx
    jnz     short PushLoop

Int_20_2:
; following will get changed to 32-bit near call; breakpoints will be lost
    int     20h
Call_Num_2  dd      0
    add     esp,    ds:[Stack_Restore]      ; C calling convention: clean up
    dec     Sem2
    mov     [esi.OutEAX_2], eax
    mov     [esi.OutEDX_2], edx
    ret
Busy2:
    or      [ebp.Client_EFlags], CFlag
    ret
EndProc     VxDPushCall

;*****************************************************************************
;           VMInt86 (Function 4)
;           Schedule a PM or V86 interrupt in another virtual machine
;           Input: VMINT struct in ES:BX
;           Output: VMINT struct changed (Caller polls Ok field); carry flag
;*****************************************************************************

VMINT STRUC
    Ok      dw  ?
    Intno   dw  ?
    VM      dd  ?
    Mode    dw  ?
    rAX     dw  ?
    rBX     dw  ?
    rCX     dw  ?
    rDX     dw  ?
    rSI     dw  ?
    rDI     dw  ?
    rDS     dw  ?
    rES     dw  ?
    rFlags  dw  ?       ; for output only
VMINT ENDS

; a macro for memory-to-memory moves
movmm MACRO m1, m2
    mov ax, m2
    mov m1, ax
    ENDM

; Function that gets scheduled by VMInt86
; EDX = refdata = FLAT address of caller's VMINT struct
BeginProc   VMEvent
VMEvent_PM:
    pushad
    Push_Client_State
    VMMCall Begin_Nest_Exec
    jmp     short Do_Regs
VMEvent_V86:
    pushad
    Push_Client_State
    VMMCall Begin_Nest_V86_Exec
Do_Regs:
    movmm   [ebp.Client_AX], [edx.rAX]
    movmm   [ebp.Client_BX], [edx.rBX]
    movmm   [ebp.Client_CX], [edx.rCX]
    movmm   [ebp.Client_DX], [edx.rDX]
    movmm   [ebp.Client_SI], [edx.rSI]
    movmm   [ebp.Client_DI], [edx.rDI]
    movmm   [ebp.Client_DS], [edx.rDS]
    movmm   [ebp.Client_ES], [edx.rES]
    ; don't set Flags on input
    movzx eax, [edx.Intno]
    VMMCall Exec_Int
    VMMCall End_Nest_Exec
    movmm   [edx.rAX], [ebp.Client_AX]
    movmm   [edx.rBX], [ebp.Client_BX]
    movmm   [edx.rCX], [ebp.Client_CX]
    movmm   [edx.rDX], [ebp.Client_DX]
    movmm   [edx.rSI], [ebp.Client_SI]
    movmm   [edx.rDI], [ebp.Client_DI]
    movmm   [edx.rDS], [ebp.Client_DS]
    movmm   [edx.rES], [ebp.Client_ES]
    movmm   [edx.rFlags], [ebp.Client_Flags]
    mov     [edx.Ok], 1                 ; tell caller that data is ready
    Pop_Client_State
    popad
    ret
EndProc     VMEvent

Do_V86      EQU     0

BeginProc   VMInt86
    mov     ax, (Client_ES shl 8) + Client_BX   ; ES:BX -> VMINT struct
    VMMcall Map_Flat        ; Get FLAT address for caller's VMINT struct
    mov     edx, eax        ; EDX = ref data passed to event function
    mov     [edx.Ok], 0     
    mov     ebx, [edx.VM]               ; target virtual machine
    VMMcall Validate_VM_Handle
    jc      short Error
    and     [ebp.Client_EFlags], NOT CFlag  ; Set up for success
    cmp     [edx.Mode], Do_V86          ; depending on requested Mode,  
    jnz     short Set_PM                ; schedule V86 or PM event
    mov     esi, OFFSET32 VMEvent_V86
    VMMcall Schedule_VM_Event
    ret
Set_PM:
    mov     esi, OFFSET32 VMEvent_PM
    VMMcall Schedule_VM_Event
    ret
Error:
    or      [ebp.Client_EFlags], CFlag
    ret
EndProc     VMInt86

VxD_CODE_ENDS

    END
