/* 
VXDCALLS.C -- C interface to generic VxD (VXD.386)
Andrew Schulman (CIS 76320,302)
Microsoft Systems Journal, February 1993

To build programs for generic VxD:

protected-mode DOS programs (sample program vminfo.c; see dpmishel.c for
building dpmi_app.lib):
bcc -2 -DDPMI_APP vminfo.c vxdcalls.c dpmi_app.lib

Windows programs (sample program vmpages.c):
bcc -2 -DDPMI_APP -WS vmpages.c vxdcalls.c protmode.c
*/

#ifndef DPMI_APP
#include "windows.h"
#endif

#include <dos.h>
#include "vxdcalls.h"

static void far *API = 0;
static BOOL API_is_V86 = 1;
static char *requires_msg = "This program requires VXD.386";

extern void fail(const char *s);
    
/* Get entry point for the VxD API using Int 2Fh AX=1684h */
api_entry GetVxDAPI(WORD vxd_id)
{
    _asm push di
    _asm mov ax, 1684h
    _asm mov bx, vxd_id
    _asm xor di, di
    _asm mov es, di
    _asm int 2fh
    _asm mov ax, di
    _asm mov dx, es
    _asm pop di
    // returns in DX:AX
}

// This is only accurate with DPMI
BOOL IsProtMode(void)
{
    unsigned _ax;
    _asm mov ax, 1686h
    _asm int 2Fh
    _asm mov _ax, ax
    return (! _ax);
}

/* check if generic VxD installed */
BOOL GenericVxDInstalled(void)
{
    return (GetVxDAPI(Generic_Dev_ID) != (api_entry) 0);
}

static void InitVxDAPI(void)
{
    if (! API)
    {
        if (! (API = GetVxDAPI(Generic_Dev_ID)))
            fail(requires_msg);
        API_is_V86 = (! IsProtMode());
    }
    else if (API_is_V86 && IsProtMode())
    {
        // API was last set in V86 mode, and are now in protected mode
        API = GetVxDAPI(Generic_Dev_ID);    // get PM API
        API_is_V86 = 0;
    }
}

DWORD MapFlat(void far *fp)
{
    InitVxDAPI();

#ifndef DPMI_APP    
    GlobalFix(FP_SEG(fp));
#endif

    _asm push di
    _asm les di, fp
    _asm mov ax, VXD_MapFlat
    _asm call dword ptr [API]
    _asm pop di
    // returns in DX:AX
}

void UnmapFlat(void far *fp)
{
#ifndef DPMI_APP    
    GlobalUnfix(FP_SEG(fp));
#endif
}

BOOL VxDCall(VxDParams far *fp)
{
    InitVxDAPI();

    _asm les bx, dword ptr fp
    _asm mov ax, VXD_VxDCall
    _asm call dword ptr [API]
    _asm jc Error
    return TRUE;
Error:
    return FALSE;
}

BOOL VxDPushCall(VxDPushParams far *fp)
{
    InitVxDAPI();
    
    _asm les bx, dword ptr fp
    _asm mov ax, VXD_VxDPushCall
    _asm call dword ptr [API]
    _asm jc Error
    return TRUE;
Error:
    return FALSE;
}

BOOL VMInt86(VMInt far *fp, BOOL (*yieldfunc)())
{
    BOOL ret = TRUE;
    InitVxDAPI();
    
#ifndef DPMI_APP    
    GlobalFix(FP_SEG(fp));
#endif
    
    fp->Ok = 0;
    
    _asm les bx, dword ptr fp
    _asm mov ax, VXD_VMInt86
    _asm call dword ptr [API]
    _asm jc Error
    while (! fp->Ok)
        if (yieldfunc && ! (*yieldfunc)())
            goto Error;
    
Done:   
#ifndef DPMI_APP
    GlobalUnfix(FP_SEG(fp));
#endif
    return ret;
Error:
    ret = FALSE;
    goto Done;
}

