/* 
VXDCALLS.H -- C interface to generic VxD (VXD.386)
Andrew Schulman (CIS 76320,302)
Microsoft Systems Journal, February 1993
*/

#ifdef DPMI_APP
typedef int BOOL;
typedef unsigned short WORD;
typedef unsigned long DWORD;
#endif

#ifndef FALSE
#define FALSE   0
#define TRUE    (! FALSE)
#endif

/* Structure used with VxDCall */
typedef struct {
    DWORD CallNum;
    DWORD Reserved1;
    DWORD InEAX, InEBX, InECX, InEDX, InEBP, InESI, InEDI;
    DWORD Reserved2, Reserved3;
    DWORD OutEAX, OutEBX, OutECX, OutEDX, OutEBP, OutESI, OutEDI;
    WORD  OutFS, OutGS;
    DWORD OutEFLAGS;
    } VxDParams;
    
/* Structure used with VxDPushCall */   
typedef struct {
    DWORD CallNum;
    DWORD NumP;
    DWORD P[10];
    DWORD OutEAX, OutEDX;
    } VxDPushParams;
    
/* Structure used with VMInt86 */
typedef struct {
    WORD Ok;        // Poll to determine when event completed
    WORD Intno;     // interrupt number
    DWORD VM;       // VM handle, e.g., from GetSysVMHandle or GetNextVMHandle
    WORD Mode;      // MODE_V86 or MODE_PM
    WORD AX, BX, CX, DX, SI, DI;
    WORD DS, ES;    // must be valid for mode, or 0
    WORD Flags;     // used only on output
    } VMInt;

#define MODE_V86            0
#define MODE_PM             1

#define CARRYFLAG           1
#define ZEROFLAG            (1 << 6)
#define OVERFLOWFLAG        (1 << 11)

#define Generic_Dev_ID      0x28c0

/* Functions supplied by VXD.386 */
#define VXD_Version         0
#define VXD_VxDCall         1
#define VXD_MapFlat         2
#define VXD_VxDPushCall     3
#define VXD_VMInt86         4

/* 
File generated from w3map -verbose:
#define Get_VMM_Version     0x010000L
#define Get_Cur_VM_Handle   0x010001L
#define Test_Cur_VM_Handle  0x010002L
#define Get_Sys_VM_Handle   0x010003L
#define Test_Sys_VM_Handle  0x010004L
etc.
*/
#include "w3map.h"

/* function calls */
typedef void (far *api_entry)(void);

api_entry GetVxDAPI(WORD vxd_id);
BOOL GenericVxDInstalled(void);
DWORD MapFlat(void far *fp);
void UnmapFlat(void far *fp);
BOOL VxDCall(VxDParams far *fp);
BOOL VxDPushCall(VxDPushParams far *fp);
BOOL VMInt86(VMInt far *fp, BOOL (*yieldfunc)());

