# VXDDEF.AWK
# AWK script to turn DDK .INC files into W3MAP.H
# requires Thompson AWK
# Andrew Schulman (CIS 76320,302)
# Microsoft Systems Journal, February 1993

function hex(s)  { return ("0x" s) + 0; }

BEGIN {
    vmm_inc = "VMM.INC";
    while (getline < vmm_inc)
        if ($1 ~ /_Device_ID/ && $2 ~ /EQU/)
        {
            sub(/_Device_ID/, "", $1);
            sub(/h/, "", $3);
            vxd[$1] = hex($3);
        }
    close(vmm_inc);
    printf("/* W3MAP.H */\n\n");
    }

/Begin_Service_Table/ {
    sub(/,/, "", $2);
    vxd_name = $2;
    pat = vxd_name "_Service";
    vxd_num = vxd[vxd_name];
    func_num = 0;
    in_service_table = 1;
    }

/End_Service_Table/ {
    in_service_table = 0;
    }

in_service_table && ($1 == pat) {
    sub(/,/, "", $2);
    printf("#define %s\t", $2); 
    if (vxd_num < 255)
        printf("0x%02X%04XL\n", vxd_num, func_num);
    else
        printf("0x%04X%04XL\n", vxd_num, func_num);
        
    func_num++;
    }
