HCURSOR IconToCursor( HINSTANCE hInst, HWND hwnd, HICON hIcon );

////////////////////////////////////////////////////////////////

extern  HCURSOR         IconToCursor

                                    (HINSTANCE       hInst,
                                     HWND            hwnd,
                                     HICON           hIcon)

{
auto    HCURSOR         hCursor;

auto    HDC             hdc = 0;
auto    HDC             hdcMonochrome = 0;
auto    HDC             hdcWhiteBkgnd = 0;
auto    HDC             hdcBlackBkgnd = 0;

auto    HBITMAP         hBmpMonochrome = 0;
auto    HBITMAP         hBmpWhiteBkgnd = 0;
auto    HBITMAP         hBmpBlackBkgnd = 0;

auto    HBITMAP         hBmpOrigMonochromeHdc = 0;
auto    HBITMAP         hBmpOrigWhiteBkgndHdc = 0;
auto    HBITMAP         hBmpOrigBlackBkgndHdc = 0;

auto    HBITMAP         hDIBitmap = 0;

auto    HBRUSH          hBrStockWhite = 0;
auto    HBRUSH          hBrStockBlack = 0;

auto    LPBITMAPINFO    lpBitmapInfo = NULL;

auto    int             iPlanes;
auto    int             iBitsPixel;
auto    int             iWidth;
auto    int             iHeight;
auto    BITMAP          bitmap;
auto    LPSTR           lpBitsColor;
auto    LPSTR           lpBitsAND;
auto    LPSTR           lpBitsXOR;
auto    RECT            rclBitmap;

hBrStockWhite = GetStockObject( WHITE_BRUSH );
hBrStockBlack = GetStockObject( BLACK_BRUSH );

hdc = GetDC( hwnd );
if (hdc)
   {
   // Create the Memory DCs
   hdcMonochrome = CreateCompatibleDC( hdc );
   hdcWhiteBkgnd = CreateCompatibleDC( hdc );
   hdcBlackBkgnd = CreateCompatibleDC( hdc );

   if (hdcMonochrome  &&  
       hdcWhiteBkgnd  && 
       hdcBlackBkgnd)
      {
      iWidth     = GetSystemMetrics( SM_CXCURSOR );
      iHeight    = GetSystemMetrics( SM_CYCURSOR );
      iPlanes    = GetDeviceCaps( hdc, PLANES );
      iBitsPixel = GetDeviceCaps( hdc, BITSPIXEL );

      // Create the Bitmaps
      hBmpWhiteBkgnd = CreateBitmap( iWidth, iHeight,
                                     iPlanes, iBitsPixel, NULL );
      hBmpBlackBkgnd = CreateBitmap( iWidth, iHeight,
                                     iPlanes, iBitsPixel, NULL );
      hBmpMonochrome = CreateBitmap( iWidth, iHeight,
                                     1, 1, NULL );

      if (hBmpWhiteBkgnd  &&  
          hBmpBlackBkgnd  && 
          hBmpMonochrome)
         {
         // Select the Bitmaps into the DCs
         hBmpOrigWhiteBkgndHdc = SelectObject( hdcWhiteBkgnd, hBmpWhiteBkgnd );
         hBmpOrigBlackBkgndHdc = SelectObject( hdcBlackBkgnd, hBmpBlackBkgnd );
         hBmpOrigMonochromeHdc = SelectObject( hdcMonochrome, hBmpMonochrome );

         rclBitmap.left   = 0;
         rclBitmap.top    = 0;
         rclBitmap.right  = iWidth;
         rclBitmap.bottom = iHeight;

// Step 1:
         // Create a Color Bitmap with white everywhere there is no icon
         FillRect( hdcWhiteBkgnd, &rclBitmap, hBrStockWhite );
         DrawIcon( hdcWhiteBkgnd, 0, 0, hIcon );

// Step 2:
         // Create a Color Bitmap with black everywhere there is no icon
         FillRect( hdcBlackBkgnd, &rclBitmap, hBrStockBlack );
         DrawIcon( hdcBlackBkgnd, 0, 0, hIcon );

// Step 3:
         // Create a Monochrome Bitmap, all white
         FillRect( hdcMonochrome, &rclBitmap, hBrStockWhite );

         GetObject( hBmpMonochrome, sizeof( BITMAP ), &bitmap );

         // Allocate memory for our AND and XOR bit masks
         lpBitsAND = (LPSTR)malloc( bitmap.bmPlanes *
                                    bitmap.bmHeight *
                                    bitmap.bmWidthBytes );

         lpBitsXOR = (LPSTR)malloc( bitmap.bmPlanes *
                                    bitmap.bmHeight *
                                    bitmap.bmWidthBytes );

         if (lpBitsXOR  &&  lpBitsAND)
            {
            // Set background/foreground  colors for automatic conversion
            // by windows on color to monochrome bitmap.
            // Background color goes to white, all others go to black

            SetBkColor  ( hdcWhiteBkgnd, RGB( 255,255,255 ) );
            SetTextColor( hdcWhiteBkgnd, RGB( 0, 0, 0 ) );

            SetBkColor  ( hdcBlackBkgnd, RGB( 255,255,255 ) );
            SetTextColor( hdcBlackBkgnd, RGB( 0, 0, 0 ) );

// Step 4:
            // BitBlit the Color Bitmat w/Icon and White Background onto
            // Monochrome White Bitmap using the AND raster operation
            BitBlt( hdcMonochrome, 0, 0, iWidth, iHeight, 
                    hdcWhiteBkgnd, 0, 0, SRCAND );

// Step 5:
            // BitBlit the Color Bitmat w/Icon and Black Background onto
            // Monochrome Bitmap just used as destination using the XOR
            // raster operation
            BitBlt( hdcMonochrome, 0, 0, iWidth, iHeight, 
                    hdcBlackBkgnd, 0, 0, SRCINVERT );

// Step 6:
            // Retrieve the bits for our AND bit mask
            GetBitmapBits( hBmpMonochrome, bitmap.bmPlanes *
                                           bitmap.bmHeight *
                                           bitmap.bmWidthBytes, lpBitsAND );

// Step 7:
            // Create a Monochrome Bitmap, all black
            FillRect( hdcMonochrome, &rclBitmap, hBrStockBlack );

            GetObject( hBmpWhiteBkgnd, sizeof( BITMAP ), &bitmap );

            // Set up/create a DIB
            lpBitsColor  = (LPSTR)malloc( bitmap.bmPlanes *
                                          bitmap.bmHeight *
                                          bitmap.bmWidthBytes );
            if (lpBitsColor)
               {
               lpBitmapInfo = (LPBITMAPINFO)malloc( sizeof( BITMAPINFOHEADER ) +
                                                  ( sizeof( RGBQUAD ) * 16 ) );

               if (lpBitmapInfo)
                  {
                  _fmemset( lpBitmapInfo, 0, sizeof( BITMAPINFOHEADER ) +
                                           ( sizeof( RGBQUAD ) * 16 ) );

                  lpBitmapInfo->bmiHeader.biSize          =
                                                       sizeof( BITMAPINFOHEADER );
                  lpBitmapInfo->bmiHeader.biWidth         = iWidth;
                  lpBitmapInfo->bmiHeader.biHeight        = iHeight;
                  lpBitmapInfo->bmiHeader.biPlanes        = 1;
                  lpBitmapInfo->bmiHeader.biBitCount      = bitmap.bmPlanes;
                  lpBitmapInfo->bmiHeader.biCompression   = BI_RGB;
                  lpBitmapInfo->bmiHeader.biSizeImage     = 0;
                                                    // pixels/inch * inch/meter
                  lpBitmapInfo->bmiHeader.biXPelsPerMeter =
                        GetDeviceCaps( hdcMonochrome, LOGPIXELSX ) * 394 / 10;
                  lpBitmapInfo->bmiHeader.biYPelsPerMeter =
                        GetDeviceCaps( hdcMonochrome, LOGPIXELSY ) * 394 / 10;
                  lpBitmapInfo->bmiHeader.biClrUsed       = 0;
                  lpBitmapInfo->bmiHeader.biClrImportant  = 0;

                  // Retrieve the bits (in DIB format) from our Color
                  // Bitmap with an Icon and Black background
                  GetDIBits( hdcMonochrome, hBmpBlackBkgnd, 0,
                             bitmap.bmHeight, lpBitsColor,
                             lpBitmapInfo, DIB_RGB_COLORS );

// Step 8:
                  // Create a DIB from the bits just retrieved
                  hDIBitmap = CreateDIBitmap( hdcMonochrome,
                                              (LPBITMAPINFOHEADER)lpBitmapInfo,
                                              CBM_INIT, lpBitsColor,
                                              lpBitmapInfo, DIB_RGB_COLORS );
                  if (hDIBitmap)
                     {
                     SelectObject( hdcBlackBkgnd, hDIBitmap );

// Step 9:
                     // BitBlit the Color DIB w/Icon and Black Background
                     // onto Monochrome Black Bitmap using the OR raster
                     // operation
                     BitBlt( hdcMonochrome, 0, 0, iWidth, iHeight,
                             hdcBlackBkgnd, 0, 0, SRCPAINT );

                     // Retrieve the bits for our XOR bit mask
                     GetBitmapBits( hBmpMonochrome, bitmap.bmPlanes *
                                                    bitmap.bmHeight *
                                                    bitmap.bmWidthBytes,
                                                    lpBitsXOR );

                     // Create the Cursor from AND and XOR bit mask
                     // with the hot spot being the center of the cursor
                     hCursor = CreateCursor( hInst, iWidth / 2, iHeight / 2,
                                                    iWidth, iHeight,
                                                    lpBitsAND, lpBitsXOR );

                     // Restore and cleanup the DIB
                     SelectObject( hdcBlackBkgnd, hBmpOrigBlackBkgndHdc );
                     DeleteObject( hDIBitmap );
                     }
                  else  // hDIBitmap = = 0
                     hCursor = 0;

                  free( lpBitmapInfo );
                  }
               else  // malloc for lpBitmapInfo = = NULL
                  hCursor = 0;

               free( lpBitsColor );
               }
            else  // malloc for lpBitsColor = = NULL
               hCursor = 0;
            }
         else  // lpBitsXOR and/or lpBitsAND NULL
            hCursor = 0;

         if (lpBitsXOR)
            free( lpBitsXOR );
         if (lpBitsAND )
            free( lpBitsAND );

         // Reselect the original BITMAPS into the DCs so our
         // Created Bitmaps can be deleted
         SelectObject( hdcWhiteBkgnd, hBmpOrigWhiteBkgndHdc );
         SelectObject( hdcBlackBkgnd, hBmpOrigBlackBkgndHdc );
         SelectObject( hdcMonochrome, hBmpOrigMonochromeHdc );
         }
      else  // one/two/all of hBmpWhiteBkgnd, hBmpBlackBkgnd, hBmpMonochrome 0
         hCursor = 0;

      // Delete the bitmaps
      if (hBmpMonochrome)
         DeleteObject( hBmpMonochrome );
      if (hBmpWhiteBkgnd)
         DeleteObject( hBmpWhiteBkgnd );
      if (hBmpBlackBkgnd)
         DeleteObject( hBmpBlackBkgnd );
      }
   else  // one/two/all of hdcMonochrome ,hdcWhiteBkgnd, hdcBlackBkgnd 0
      hCursor = 0;

   // Delete the Memory DCs
   if (hdcMonochrome)
      DeleteDC( hdcMonochrome );
   if (hdcWhiteBkgnd)
      DeleteDC( hdcWhiteBkgnd );
   if (hdcBlackBkgnd)
      DeleteDC( hdcBlackBkgnd );

   ReleaseDC( hwnd, hdc );
   }
else
   hCursor = 0;

return hCursor;
}
