//   HeapPeep (c) 1991 Chiverton Graphics, Inc. 
//
//               Microsoft Windows Debugging Utility
//
//
#include <windows.h>
#include "hpeep2.h"


#define IDM_ABOUT   1
#define IDD_LOGO  101


long  FAR PASCAL WndProc      (HWND hWnd, unsigned message, WORD wParam, LONG lParam);
BOOL  FAR PASCAL AboutDlgProc (HWND hWnd, unsigned message, WORD wParam, LONG lParam);


int PASCAL WinMain (HANDLE hInstance, HANDLE hPrevInstance, LPSTR lpszCmdLine, int nCmdShow)
     {
     MSG      msg;
     WNDCLASS wc;
     HWND     hwnd;


  if (hwnd = FindWindow ("HeapPeep_ToolHelp", NULL))
     {
     // Found another running application with the same class
     // name... so one instance is already running. Don't run a 2nd instance.

     BringWindowToTop (hwnd); 
     return (FALSE);
     }

     wc.hCursor       = LoadCursor (NULL, IDC_ARROW);
     wc.hIcon         = LoadIcon (hInstance, "HeapPeep");
     wc.cbClsExtra    = 0;
     wc.cbWndExtra    = 0;
     wc.lpszMenuName  = NULL;
     wc.lpszClassName = "HeapPeep_ToolHelp";
     wc.hbrBackground = GetStockObject (WHITE_BRUSH);
     wc.hInstance     = hInstance;
     wc.style         = CS_VREDRAW | CS_HREDRAW;
     wc.lpfnWndProc   = WndProc;

     RegisterClass (&wc);

     hwnd = CreateWindow ("HeapPeep_ToolHelp",
                          "HeapPeep",
                          WS_OVERLAPPEDWINDOW,
                          CW_USEDEFAULT, 0,
                          CW_USEDEFAULT, 0,
                          NULL, NULL, hInstance,
                          NULL);


     //    set up timer (2 updates/sec) 
     //
     if (!SetTimer (hwnd, 1, 500, NULL))
          {
          MessageBox (GetFocus(), "Too many Timers or Clocks!",
                                  "HeapPeep", MB_OK | MB_SYSTEMMODAL);
          return (FALSE);
          }

     ShowWindow (hwnd, nCmdShow);

     while (GetMessage (&msg, NULL, 0, 0))
          {
          TranslateMessage (&msg);
          DispatchMessage  (&msg);
          }

     return (int) msg.wParam;
     }



BOOL FAR PASCAL AboutDlgProc (HWND hDlg, unsigned m, WORD w, LONG l)
     {
     static HBITMAP hbm;

     switch (m)
          {
          case WM_INITDIALOG:
               {
               int cxScreen, cyScreen, cxDialog, cyDialog;
               RECT rcDialog;
   
               //
               //   Create the logo bitmap, and
               //   center the dialogbox on the display.
               //
               hbm = LoadBitmap (GetWindowWord (hDlg, GWW_HINSTANCE), "logo");


               //   Get the Display size
               //
               cxScreen = GetSystemMetrics (SM_CXSCREEN);
               cyScreen = GetSystemMetrics (SM_CYSCREEN);

               //   Get the DialogBox size
               //
               GetWindowRect (hDlg, &rcDialog);
               cxDialog = rcDialog.right  - rcDialog.left;
               cyDialog = rcDialog.bottom - rcDialog.top ;

               SetWindowPos (hDlg, NULL, (cxScreen - cxDialog)/2, // x
                                         (cyScreen - cyDialog)/2, // y
                                          cxDialog,               // cx
                                          cyDialog,               // cy
                                          SWP_NOZORDER);
               }
               return FALSE;

          case WM_PAINT:
               {
               HDC hdcMem;
               PAINTSTRUCT ps;
               HBITMAP hbmOld;
               HWND hwndLogo;
               RECT rcLogo,
                    rcDialog;
               int  x,y;

               BeginPaint (hDlg, &ps);

               hdcMem = CreateCompatibleDC (ps.hdc);
               hbmOld = SelectObject (hdcMem, hbm);

               SetTextColor (ps.hdc, RGB (255, 0, 255));

               hwndLogo = GetDlgItem (hDlg, IDD_LOGO);
               GetWindowRect (hwndLogo, &rcLogo);
               GetWindowRect (hDlg,     &rcDialog );
               x = rcLogo.left - rcDialog.left;
               y = rcLogo.top  - rcDialog.top ;

               BitBlt (ps.hdc, x, y, 200, 200, hdcMem, 0, 0, SRCCOPY);
               SelectObject (hdcMem, hbmOld) ;
               DeleteDC (hdcMem);

               EndPaint (hDlg, &ps);

               return FALSE;
               }

          case WM_DESTROY:
               DeleteObject (hbm);
               return FALSE;

          case WM_COMMAND:
               EndDialog (hDlg, 0);
               return TRUE;
          }

     return FALSE ;
     }



long FAR PASCAL WndProc (HWND hwnd, unsigned message, WORD wParam, LONG lParam)
     {
     switch (message)
          {
          case WM_CREATE:    
               {
               HMENU hMenu    = GetSystemMenu (hwnd, FALSE);
               int   cxScreen = GetSystemMetrics (SM_CXSCREEN),
                     cyScreen = GetSystemMetrics (SM_CYSCREEN);

               dds_create (hwnd);


               //   Add "About Heappeep..." to system menu

               ChangeMenu (hMenu, 0, NULL, 0, MF_APPEND);
               ChangeMenu (hMenu, 0, "A&bout Heappeep...", IDM_ABOUT, MF_APPEND);


               //   Position the window in the lower 1/3 of the display.
               
               SetWindowPos (hwnd, NULL, 0,                 // x
                                         (2 * cyScreen)/3,  // y
                                         cxScreen,          // cx
                                         cyScreen/3,        // cy
                                         SWP_NOZORDER);
               }
               return  0L;

          case WM_TIMER:
               dds_walk ();
               return 0L;

          case WM_SYSCOMMAND:
               if (wParam == IDM_ABOUT)
                    {
                    HANDLE  hInstance = (HANDLE)GetWindowWord (hwnd, GWW_HINSTANCE);
                    FARPROC lpfn      = MakeProcInstance ((FARPROC)AboutDlgProc, hInstance);

                    DialogBox (hInstance, "AboutBox", hwnd, lpfn);
                    FreeProcInstance (lpfn) ;
                    return 0L;
                    }
               break;

          case WM_PAINT:
               dds_paint ();
               return  0L;

          case WM_DESTROY:
               dds_destroy ();
               KillTimer (hwnd, 1);
               PostQuitMessage (0);
               return  0L;

          default:
               break;
          }

     return DefWindowProc (hwnd, message, wParam, lParam);
     }
