//=============================================================================
//   CKPACK.CPP  --  Quickie to check callers log for need to run PCBPACK
//                   (used for PCBoard 15.0 IDX/NDX updating old doors)
//-----------------------------------------------------------------------------
//   Status:  Released to public domain
//-----------------------------------------------------------------------------
//   Revision history:
//      Sat Jun 05 1993 - v1.00  Robert Vostreys, FTL Sysop, 404-292-8761
//=============================================================================

#include "io.h"
#include "stdio.h"
#include "share.h"
#include "stdlib.h"
#include "process.h"
#include "string.h"
#include "ctype.h"

//=============================================================================

unsigned char *Program="CKPACK v1.00";

unsigned char config_file [128]="";  // config file (ascii text, line count)
unsigned char callers_file[128]="";  //   line 1
unsigned char search_for  [128]="";  //   line 2
unsigned char execute     [512]="";  //   line 3
unsigned char exec_str    [512]="";  // (built using %u -- danger!!!)

unsigned char confflag[30000]="";    // don't think anyone has that many...

//=============================================================================
void syntax(void)
 {
   puts(Program);
   puts("\tUtility to check callers log for PCB15 NDX/IDX packing needed.\n"
        "\tRobert Vostreys, FTL Sysop (404-292-8761; 296-3120; 299-3930)\n"
        "\t*Released to the Public Domain*\n"
        "\n"
        "Syntax:  CKPACK c:\\dir\\ckpack.cfg\n"
        "\n"
        "ckpack.cfg should contain:\n"
        "  Line 1: Full filename of callers log to examine for last user\n"
        "  Line 2: Text to search for in callers log to identify a message left\n"
        "  Line 3: commandline to execute with %u=confnumber when msg been left\n"
        "  WARNING: Only one '%' should be in the line and it should be the %u!\n"
        "\n"
        "  This program has minimal error checking -- use at your own risk!\n"
        "  I'll write a cleaner one if the need remains present much longer.\n"
        "\n"
        "  If calling PCBPACK.EXE, you must be in your \\PCB directory!");
   fcloseall();
   exit(100);
 }

//=============================================================================
unsigned int read_callers_log(void) // uses global callers_file; search_for...
 {
   unsigned char buffer[100];
   FILE *fhandle=NULL;
   signed long   offset=0L;
   signed long   len=0L;
   unsigned int  have_something=0;
   unsigned int  in_user=0;

   puts("reading callers log...");
   fhandle=_fsopen(callers_file,"rt",SH_DENYNONE);

   if (fhandle!=NULL)
    {
      len=filelength(fileno(fhandle));
      offset=len;

      // until top of file or break on **** line after gotten into user log
      while (offset>64L)
       {
         offset-=64L;
         fseek(fhandle,offset,SEEK_SET);
         memset(buffer,0,sizeof(buffer));
         fread(buffer,64,1,fhandle);
         if (buffer[0]=='*' && in_user)  break;
         if (buffer[0]!=' ')          continue;
         in_user=1;

         strupr(buffer);  // convert to all uppercase
         if (NULL!=strstr(buffer,search_for))  // found search string
          {
            unsigned char *tp=(unsigned char *)memchr(&buffer[0],'(',64);
            if (NULL!=tp) // found a '('
             {
               tp++;
               if (isdigit(*tp))  // has a number in it
                {
                  unsigned int conf=atoi(tp);   // get as conference number
                  if (conf<sizeof(confflag)-1)  // valid (er, maybe)
                   {
                     confflag[conf]=1;  // flag conference number
                     have_something=1;  // flag we have something to update
                   }
                }
             }
          }
       }
      fclose(fhandle);
    }
   else
    {
      puts("Failed to open callers:");
      puts(callers_file);
      puts(sys_errlist[errno]);
    }

   return(have_something);
 }

//=============================================================================
unsigned int main (unsigned int argc, unsigned char *argv[])
 {
   FILE *fhandle=NULL;

   if (argc!=2)  syntax();  // no params/too many params = syntax and abort(1)
   strcpy(config_file,argv[1]);
   if (access(config_file,0))  syntax();

   // read config file (minimal checking)
   fhandle=fopen(config_file,"rt");
   if (fhandle==NULL)  syntax();
   if (NULL==fgets(callers_file,sizeof(callers_file)-2,fhandle)) syntax();
   if (NULL==fgets(search_for,  sizeof(search_for)-2,  fhandle)) syntax();
   if (NULL==fgets(execute,     sizeof(execute)-2,     fhandle)) syntax();
   fclose(fhandle);

   // strip CR off end of incoming
   if (strlen(callers_file)) callers_file[strlen(callers_file)-1]=0;
   if (strlen(search_for))   search_for  [strlen(search_for)-1]  =0;
   if (strlen(execute))      execute     [strlen(execute)-1]     =0;

   // make sure incoming wasn't a blank line
   if (!strlen(callers_file)) syntax();
   if (!strlen(search_for))   syntax();
   if (!strlen(execute))      syntax();

   // do non-case sensitive search
   strupr(search_for);

   // clear confflags
   memset(confflag,0,sizeof(confflag));

   // set confflags via read_callers_log() function
   puts(Program);
   if (read_callers_log())
    {
      unsigned int  i=0; //temp
      unsigned char *tp=&confflag[0];
      puts("Executing specified command string for each conference...");

      // confflags set.. find conferences
      for (i=0; i<sizeof(confflag); i++, tp++)
       {
         if (*tp)  // this conf needs updating
          {
            sprintf(exec_str,execute,i); // *ICK!* not safe!
            system(exec_str);            // *ICK!* crank up command.com
          }
       }
    }

   return(0);  // successful (er, perhaps...)
 }

//-----------------------------------------------------------------------------
