; MODECHNG.ASM - Sample program for ASMLIB graphics
; Programmer: Douglas Herr
; date: 5/24/1992

; detect video equipment and switch to highest resolution mode available
; does not attempt to detect non-default monitor or SVGA or VESA equipment

include	asm.inc

public	graphmode, textmode

extrn	getcrt:proc, hgraph0:proc, htext:proc
;extrn	svga16:proc, whichvga:proc

.data
crt	dw 0
nocard	db 'graphics card required',0Dh,0Ah,7,'$'

grmode	db 0,0

.code
graphmode	proc
;	call	whichvga
;	mov	ax,1
;	call	svga16
;	ret
	call	getcrt
	mov	crt,ax
	cmp	al,-1
	je	cga
	cmp	al,127
	ja	hercules
	or	al,al
	jnz	evga

	or	ah,ah
	jnz	egamono
	lea	dx,nocard	; point to error message
	jmp	oops		; exit with CF = 1

egamono:mov	ax,000Fh
	int	10h
	mov	ah,07h
	jmp	short g10

; if CGA, use 2-color "high" resolution mode
cga:	mov	ax,6
	push	bp
	int	10h
	pop	bp
	mov	ah,03h
	jmp	short g10

; EGA color, VGA color or MCGA
evga:	add	al,0Fh
	int	10h
	mov	ah,03h
	jmp	short g10

hercules:
	call	hgraph0
	mov	ax,0708h

g10:	mov	word ptr grmode,ax
	clc
	ret
oops:	stc
	ret
graphmode	endp


; use TextMode to return to text mode after calling GraphMode
; call with: no parameters
; returns: nothing in particular
; uses: AX, flags
textmode	proc
	mov	ax,word ptr grmode
	cmp	al,08h
	je	herctext
	mov	al,ah
	xor	ah,ah

	push	bp
	int	10h
	pop	bp
	ret

herctext:
	call	htext
	ret
textmode	endp

	end
