/*
 -------------------------------------
 Filename: x816a.c
 Version 1.013
 Portions are Copyright (c)1990 DataQue Software
 65816 Assembler
 -------------------------------------
*/

#include <stdio.h>
#include "x816a.h"

FILE      *optr;
FILE      *iptr;
FILE      *lptr;
FILE      *mptr;

char      *abuff;
char      *ibuff;
char      *lbuff;
char      *obuff;

struct    symtype *exprsym;        /* expression extern reference symbol */
int       ch;                      /* current input character            */
unsigned  errcnt;                  /* error counter                      */
unsigned  warcnt;                  /* warning counter                    */
unsigned  exprmc;                  /* expression modification code       */
unsigned  romsiz;                  /* rom size designator                */
unsigned  rombase;                 /* rom base designator                */
unsigned  mvalue;                  /* temp                               */
unsigned  slnum;                   /* source line number counter         */
unsigned  opoff;                   /* operation code offset              */
unsigned  opflg;                   /* operation code flags               */
unsigned  objloc;                  /* current object location            */
unsigned  offset;                  /* location counter offset            */
unsigned  fullvalue;               /* operand value before ZP truncation */
char      fulbnk;                  /* temporary bank value               */
unsigned  value;                   /* operand field value                */
char      valbnk;                  /* operand field bank value           */
unsigned  codloc;                  /* location counter                   */
char      codbnk;                  /* operand code segment bank value    */
unsigned  datloc;                  /* data seg location counter          */
char      datbnk;                  /* operand data segnebt bank value    */
char      nflag;                   /* disable string byte output         */
char      lflag;                   /* disable listing flag               */
char      cflag;                   /* conditional listing flag           */
char      oflag;                   /* object output flag                 */
char      sflag;                   /* symbol table output flag           */
char      mflag;                   /* cross link map table output        */
char      aflag;                   /* absolute code flag                 */
char      rflag;                   /* rom code flag                      */
char      dflag;                   /* data segment flag                  */
char      ataflg;                  /* atascii mode flag                  */
char      segnum;                  /* segment counter                    */
char      opval;                   /* operation code value               */
char      accsiz;                  /* accumulator size                   */
char      indsiz;                  /* index register size                */
char      pass;                    /* pass counter                       */
char      zpref;                   /* zero page reference flag           */
char      undef;                   /* expression contains undef symbol   */
char      casmflg;                 /* 0 to inhibit assembly              */
char      cpos;                    /* current character position         */
char      listed;                  /* listing line has been printed      */
char      exprtyp;                 /* expression type                    */
char      hex[8];                  /* hexadecimal character buffer       */
char      filename[20];            /* current filename                   */
char      prlnbuf[LAST_CH_POS+1];  /* print line buffer                  */
char      symbol[SBOLSZ+1];        /* temporary symbol storage           */
unsigned  begadr[MAXSEG];          /* base of segment                    */
unsigned  endadr[MAXSEG];          /* end of segment                     */

struct symtype *lablptr;   /* label pointer into symbol table */
struct symtype *hash_tbl[HTSIZE];/* pointers to starting symbols */

/*
  ------------------------------------
  The opcode mnemonics are stored as
  an array of fixed length strings
  ------------------------------------
*/

char *opmnem[NUMOPS] =
{
        ".accb",
        ".accw",
        ".asc ",
        ".ata ",
        ".cseg",
        ".dcb ",
        ".dcc ",
        ".dcd ",
        ".dcs ",
        ".dcw ",
        ".dsb ",
        ".dseg",
        ".dsw ",
        ".else",
        ".end ",
        ".ext ",   /* .ref */
        ".fi  ",
        ".ifeq",
        ".ifge",
        ".ifgt",
        ".ifle",
        ".iflt",
        ".ifne",
        ".indb",
        ".indw",
        ".list",
        ".offs",
        ".pub ",   /* .def */
        ".rel ",
        ".rom ",
        "=    ",

        "adc  ",
        "and  ",
        "asl  ",
        "bcc  ",
        "bcs  ",
        "beq  ",
        "bge  ",   /* 65816 */
        "bit  ",
        "blt  ",   /* 65816 */
        "bmi  ",
        "bne  ",
        "bpl  ",
        "bra  ",   /* 65816 */
        "brk  ",
        "brl  ",   /* 65816 */
        "bvc  ",
        "bvs  ",
        "clc  ",
        "cld  ",
        "cli  ",
        "clv  ",
        "cmp  ",
        "cop  ",   /* 65816 */
        "cpx  ",
        "cpy  ",
        "dea  ",   /* 65816 */
        "dec  ",
        "dex  ",
        "dey  ",
        "eor  ",
        "ina  ",   /* 65816 */
        "inc  ",
        "inx  ",
        "iny  ",
        "jml  ",   /* 65816 */
        "jmp  ",
        "jsl  ",   /* 65816 */
        "jsr  ",
        "lda  ",
        "ldx  ",
        "ldy  ",
        "lsr  ",
        "mvn  ",   /* 65816 */
        "mvp  ",   /* 65816 */
        "nop  ",
        "ora  ",
        "pea  ",   /* 65816 */
        "pei  ",   /* 65816 */
        "per  ",   /* 65816 */
        "pha  ",
        "phb  ",   /* 65816 */
        "phd  ",   /* 65816 */
        "phk  ",   /* 65816 */
        "php  ",
        "phx  ",   /* 65816 */
        "phy  ",   /* 65816 */
        "pla  ",
        "plb  ",   /* 65816 */
        "pld  ",   /* 65816 */
        "plp  ",
        "plx  ",   /* 65816 */
        "ply  ",   /* 65816 */
        "rep  ",   /* 65816 */
        "rol  ",
        "ror  ",
        "rti  ",
        "rtl  ",   /* 65816 */
        "rts  ",
        "sbc  ",
        "sec  ",
        "sed  ",
        "sei  ",
        "sep  ",
        "sta  ",
        "stp  ",   /* 65816 */
        "stx  ",
        "sty  ",
        "stz  ",   /* 65816 */
        "swi  ",
        "tax  ",
        "tay  ",
        "tcd  ",   /* 65816 */
        "tcs  ",   /* 65816 */
        "tdc  ",   /* 65816 */
        "trb  ",   /* 65816 */
        "tsb  ",   /* 65816 */
        "tsc  ",   /* 65816 */
        "tsx  ",
        "txa  ",
        "txs  ",
        "txy  ",   /* 65816 */
        "tya  ",
        "tyx  ",   /* 65816 */
        "wai  ",   /* 65816 */
        "wdm  ",   /* 65816 */
        "xba  ",   /* 65816 */
        "xce  "    /* 65816 */
};             
               
/*             
  ------------------------------------
  The opcode definitions consist of 2
  word pairs: The first word is the
  instruction class or legal mode flag
  word.  The second word is the base 
  value of the opcode.
  ------------------------------------

  pseudo = pseudo ops (directives)
  condit = conditionals
  class1 = single byte implied
  class2 = relative
  class3 = imm+abs+zer+indx+indy+zerx+absx+absy

  imm    = immediate
  abs    = absolute
  absx   = absolute,x
  absy   = absolute,y
  ind    = (absolute)
  zer    = zero page (direct)
  zerx   = zero page,x
  zery   = zero page,y
  indx   = (zero page,x)
  indy   = (zero page),y
  ------------------------------------
*/

unsigned optab[2*NUMOPS] =               /* nmemonic  operation code table       */
{
/*      ______________________ opoff: offset into this table
       /    __________________ opmne: mnemonic or directive
      /    /         _________ opflg: type or class
     /    /         /     ____ opval: offset or base
    /    /         /     /                           */
/* 00 .accb */  PSEUDO, 0,
/* 02 .accw */  PSEUDO, 1,
/* 04 .asc  */  PSEUDO, 22,
/* 06 .ata  */  PSEUDO, 2,
/* 08 .cseg */  PSEUDO, 3,
/* 0a .dcb  */  PSEUDO, 4,
/* 0c .dcc  */  PSEUDO, 20,
/* 0e .dcd  */  PSEUDO, 5,
/* 10 .dcs  */  PSEUDO, 21,
/* 12 .dcw  */  PSEUDO, 6,
/* 14 .dsb  */  PSEUDO, 7,
/* 16 .dseg */  PSEUDO, 8,
/* 18 .dsw  */  PSEUDO, 9,
/* 1a .else */  CONDIT,  1,
/* 1c .end  */  PSEUDO, 10,
/* 1e .ext  */  PSEUDO, 11,
/* 20 .fi   */  CONDIT,  2,
/* 22 .ifeq */  CONDIT,  3,
/* 24 .ifge */  CONDIT,  4,
/* 26 .ifgt */  CONDIT,  5,
/* 28 .ifle */  CONDIT,  6,
/* 2a .iflt */  CONDIT,  7,
/* 2c .ifne */  CONDIT,  8,
/* 2e .indb */  PSEUDO, 12,
/* 30 .indw */  PSEUDO, 13,
/* 32 .list */  PSEUDO, 14,
/* 34 .offs */  PSEUDO, 16,
/* 36 .pub  */  PSEUDO, 17,
/* 38 .rel  */  PSEUDO, 15,
/* 3a .rom  */  PSEUDO, 18,
/* 3c =     */  PSEUDO, 19,

/* 3e adc   */  CLASS3,0x61,
/* 40 and   */  CLASS3,0x21,
/* 42 asl   */  ABS|ZER|ZERX|ABSX|ACC,0x02,
/* 44 bcc   */  CLASS2,0x90,
/* 46 bcs   */  CLASS2,0xb0,
/* 48 beq   */  CLASS2,0xf0,
/* 4a bge   */  CLASS2,0xb0,
/* 4c bit   */  ABS|ZER|ZERX|ABSX|IMM2,0x20,
/* 4e blt   */  CLASS2,0x90,
/* 50 bmi   */  CLASS2,0x30,
/* 52 bne   */  CLASS2,0xd0,
/* 54 bpl   */  CLASS2,0x10,
/* 56 bra   */  CLASS2,0x80,
/* 58 brk   */  CLASS1,0x00,
/* 5a brl   */  CLASSW,0x82,
/* 5c bvc   */  CLASS2,0x50,
/* 5e bvs   */  CLASS2,0x70,
/* 60 clc   */  CLASS1,0x18,
/* 62 cld   */  CLASS1,0xd8,
/* 64 cli   */  CLASS1,0x58,
/* 66 clv   */  CLASS1,0xb8,
/* 68 cmp   */  CLASS3,0xc1,
/* 6a cop   */  ZER,0xfe,
/* 6c cpx   */  IMM1|ABS|ZER,0xe0,
/* 6e cpy   */  IMM1|ABS|ZER,0xc0,
/* 70 dea   */  CLASS1,0x3a,
/* 72 dec   */  ABS|ZER|ZERX|ABSX,0xc2,
/* 74 dex   */  CLASS1,0xca,
/* 76 dey   */  CLASS1,0x88,
/* 78 eor   */  CLASS3,0x41,
/* 7a ina   */  CLASS1,0x1a,
/* 7c inc   */  ABS|ZER|ZERX|ABSX,0xe2,
/* 7e inx   */  CLASS1,0xe8,
/* 80 iny   */  CLASS1,0xc8,
/* 82 jml   */  ABS|IND,0x50,
/* 84 jmp   */  ABS|IND|AINDX,0x40,
/* 86 jsl   */  ABS,0x16,
/* 88 jsr   */  ABS|AINDX,0x14,
/* 8a lda   */  CLASS3,0xa1,
/* 8c ldx   */  IMM1|ABS|ZER|ABSY2|ZERY,0xa2,
/* 8e ldy   */  IMM1|ABS|ZER|ABSX|ZERX,0xa0,
/* 90 lsr   */  ABS|ZER|ZERX|ABSX|ACC,0x42,
/* 92 mvn   */  ABS,0x48,
/* 94 mvp   */  ABS,0x38,
/* 96 nop   */  CLASS1,0xea,
/* 98 ora   */  CLASS3,0x01,
/* 9a pea   */  ABS,0xe8,
/* 9c pei   */  ZER,0xd0,
/* 9e per   */  CLASSW,0x62,
/* a0 pha   */  CLASS1,0x48,
/* a2 phb   */  CLASS1,0x8b,
/* a4 phd   */  CLASS1,0x0b,
/* a6 phk   */  CLASS1,0x4b,
/* a8 php   */  CLASS1,0x08,
/* aa phx   */  CLASS1,0xda,
/* ac phy   */  CLASS1,0x5a,
/* ae pla   */  CLASS1,0x68,
/* b0 plb   */  CLASS1,0xab,
/* b2 pld   */  CLASS1,0x2b,
/* b4 plp   */  CLASS1,0x28,
/* b6 plx   */  CLASS1,0xfa,
/* b8 ply   */  CLASS1,0x7a,
/* ba rep   */  IMM2,0xba,
/* bc rol   */  ABS|ZER|ZERX|ABSX|ACC,0x22,
/* be ror   */  ABS|ZER|ZERX|ABSX|ACC,0x62,
/* c0 rti   */  CLASS1,0x40,
/* c2 rtl   */  CLASS1,0x6b,
/* c4 rts   */  CLASS1,0x60,
/* c6 sbc   */  CLASS3,0xe1,
/* c8 sec   */  CLASS1,0x38,
/* ca sed   */  CLASS1,0xf8,
/* cc sei   */  CLASS1,0x78,
/* ce sep   */  IMM2,0xda,
/* d0 sta   */  ABS|ABSY|ABSX|ZER|ZERX|ZIND|INDX|INDY,0x81,
/* d2 stp   */  CLASS1,0xdb,
/* d4 stx   */  ABS|ZER|ZERY,0x82,
/* d6 sty   */  ABS|ZER|ZERX,0x80,
/* d8 stz   */  ABS|ZER|ZERX|ABSX,0x60,
/* da swi   */  ZER,0xfc,
/* dc tax   */  CLASS1,0xaa,
/* de tay   */  CLASS1,0xa8,
/* e0 tcd   */  CLASS1,0x5b,
/* e2 tcs   */  CLASS1,0x1b,
/* e4 tdc   */  CLASS1,0x7b,
/* e6 trb   */  ABS|ZER,0x10,
/* e8 tsb   */  ABS|ZER,0x00,
/* ea tsc   */  CLASS1,0x3b,
/* ec tsx   */  CLASS1,0xba,
/* ee txa   */  CLASS1,0x8a,
/* f0 txs   */  CLASS1,0x9a,
/* f2 txy   */  CLASS1,0x9b,
/* f4 tya   */  CLASS1,0x98,
/* f6 tyx   */  CLASS1,0xbb,
/* f8 wai   */  CLASS1,0xcb,
/* fa wdm   */  ZER,0x3e,
/* fc xba   */  CLASS1,0xeb,
/* fe xce   */  CLASS1,0xfb
};
  
  
  
