/*
 -------------------------------------
 Filename: X816A.H
 Version 1.013
 Portions are Copyright (c)1990 DataQue Software
 65816 Assembler - Data Definitions
 -------------------------------------
*/

#define index strchr

/* Limit Values */

#define NUMOPS  128             /* number of diff mne/dirs 74 */
#define HTSIZE  32              /* hash table size 32 */
#define MAXSEG  50              /* segment counter */
#define LAST_CH_POS  132
#define OPSZ    5               /* length of mnemonic entries 5 */
#define SFIELD  23
#define SBOLSZ  12              /* maximum symbol label size */ 

#define ABSIZE  24576           /* i/o buffer size for main 'a' file */
#define IBSIZE  24576           /* i/o buffer size for include files */
#define LBSIZE  32256           /* i/o buffer size for list file */
#define OBSIZE  16384           /* i/o buffer size for object file */

/* symbol flags */

#define DEFNOT  1               /* undefined - may be zero page */
#define DEFMUL  2               /* multiply defined             */
#define DEFZRO  3               /* page zero address            */
#define DEFABS  4               /* two byte address             */
#define DEFLNG  5               /* three byte address           */
#define DEFREL  6               /* relocatable                  */
#define DEFEXT  7               /* external reference           */
#define DEFPUB  0x80            /* public reference             */

#define isrel(t) (t==DEFREL)

/* directive type definitions */

#define CONDIT  0xa000          /* conditionals */
#define PSEUDO  0xb000          /* directives   */
#define CLASS1  0xc000          /* branches */
#define CLASS2  0xd000
#define CLASSW  0xe000
#define CLASS3  ABS|ABSY|ABSX|ZER|ZERX|INDX|INDY|ZIND|IMM2

/* addressing mode type definitions */

#define INDX    0x0001          /* lda (dd,x)     opval + 0x00 2 byte  */
#define ZER     0x0002          /* lda dd         opval + 0x04 2 byte  */
#define IMM1    0x0004          /* lda #ii        opval + 0x00 2 byte  */
#define IMM3    0x4004          /* lda #iiii      opval + 0x00 3 byte  */
#define IMM2    0x0008          /* ldx #ii        opval + 0x08 2 byte  */
#define IMM4    0x4008          /* ldx #iiii      opval + 0x08 3 byte  */
#define ACC     0x0010          /* ror a          opval + 0x08 1 byte  */
#define ABS     0x0020          /* lda aaaa       opval + 0x0C 3 byte  */
#define INDY    0x0040          /* lda (dd),y     opval + 0x10 2 byte  */
#define ZIND    0x0080          /* lda (dd)       opval + 0x11 2 byte  */
#define ZERY    0x0100          /* lda dd,y       opval + 0x14 2 byte  */
#define ZERX    0x0200          /* lda dd,x       opval + 0x14 2 byte  */
#define ABSY    0x0400          /* lda aaaa,y     opval + 0x18 3 byte  */
#define ABSY2   0x0800          /* ldx aaaa,y     opval + 0x1C 3 byte  */
#define ABSX    0x1000          /* lda aaaa,x     opval + 0x1C 3 byte  */
#define IND     0x2000          /* jmp (aaaa)     opval + 0x2C 3 byte  */

#define SZER    0x8200          /* lda dd,s       opval + 0x02 2 byte  */
#define LIND    0x8080          /* lda [dd]       opval + 0x06 2 byte  */
#define LABS    0x8020          /* lda aaaaaa     opval + 0x0E 4 byte  */
#define SINDY   0x4040          /* lda (dd,s),y   opval + 0x12 2 byte  */
#define LINDY   0x8040          /* lda [dd],y     opval + 0x16 2 byte  */
#define LABSX   0x9000          /* lda aaaaaa,x   opval + 0x1E 3 byte  */
#define AINDX   0x2001          /* jmp (aaaa,x)   opval + 0x2C 3 byte  */

/* assembler pass flags */

#define FIRST_PASS      0
#define LAST_PASS       1

/* Types */

struct symtype {
  struct symtype *next;
  char *name;
  char flag;
  int value;
  char valbnk;
};
