/*
 -------------------------------------
 Filename: X816B.H
 Version 1.013
 Portions are Copyright (c)1990 DataQue Software
 6502 Assembler - External Definitions
 -------------------------------------
*/

typedef FILE *FILETYPE;

extern  FILETYPE optr;
extern  FILETYPE iptr;
extern  FILETYPE lptr;
extern  FILETYPE mptr;

extern  char *abuff;
extern  char *ibuff;
extern  char *lbuff;
extern  char *obuff;

extern  struct symtype *exprsym; /* expression external reference sym  */
extern  int      ch;             /* current character                  */
extern  unsigned errcnt;         /* error counter                      */
extern  unsigned warcnt;         /* warning counter                    */
extern  unsigned exprmc;         /* expression modification code       */
extern  unsigned romsiz;         /* rom size designator                */
extern  unsigned rombase;        /* rom base designator                */
extern  unsigned mvalue;         /* temp                               */
extern  unsigned slnum;          /* source line number counter         */
extern  unsigned opoff;          /* operation code offset              */
extern  unsigned opflg;          /* operation code flags               */
extern  unsigned objloc;         /* current object location            */
extern  unsigned offset;         /* location counter offset            */
extern  unsigned fullvalue;      /* operand value before 0-pg trunc    */
extern  char     fulbnk;         /* temporary bank value               */
extern  unsigned value;          /* operand field value                */
extern  char     valbnk;         /* operand field bank value           */
extern  unsigned codloc;         /* location counter                   */
extern  char     codbnk;         /* operand code segment bank value    */
extern  unsigned datloc;         /* data seg location counter          */
extern  char     datbnk;         /* operand data segnebt bank value    */
extern  char     nflag;          /* disable string byte output         */
extern  char     lflag;          /* disable listing flag               */
extern  char     cflag;          /* conditional listing flag           */
extern  char     oflag;          /* object output flag                 */
extern  char     sflag;          /* symbol table output flag           */
extern  char     mflag;          /* cross link map table output        */
extern  char     aflag;          /* absolute code flag                 */
extern  char     rflag;          /* rom code flag                      */
extern  char     dflag;          /* data segment flag                  */
extern  char     ataflg;         /* atascii mode flag                  */
extern  char     segnum;         /* segment counter                    */
extern  char     opval;          /* operation code value               */
extern  char     accsiz;         /* accumulator size                   */
extern  char     indsiz;         /* index register size                */
extern  char     pass;           /* pass counter                       */
extern  char     zpref;          /* zero page reference flag           */
extern  char     undef;          /* expression contains undef symbol   */
extern  char     casmflg;        /* zero to inhibit assembly           */
extern  char     cpos;           /* current character position         */
extern  char     listed;         /* source line has been listed        */
extern  char     exprtyp;        /* expression relocation type flag    */
extern  char     hex[];          /* hexadecimal character buffer       */
extern  char     filename[];     /* current filename                   */
extern  char     prlnbuf[];      /* print line buffer                  */
extern  char     symbol[];       /* temporary symbol storage           */
extern  unsigned begadr[MAXSEG]; /* base of segment                    */
extern  unsigned endadr[MAXSEG]; /* end of segment                     */

extern  struct symtype *lablptr;   /* statement label pointer */
extern  struct symtype *hash_tbl[]; /* pointers to symbol lists */

#define VOID int

extern FILETYPE fileopen();
extern VOID initialize();
extern VOID usage();
extern VOID include();
extern VOID error();
extern VOID wrapup();
extern VOID stprnt();
extern VOID assemble();
extern VOID println();
extern VOID loadlc();
extern VOID loadlw();
extern VOID loadv();
extern VOID hexcon();
extern VOID class1();
extern VOID class2();
extern VOID classw();
extern VOID class3();
extern VOID pseudo();
extern VOID cassm();
extern VOID clearln();
extern VOID put1r();
extern VOID put1();
extern VOID put2();
extern VOID put3();
extern VOID quit();
extern VOID ca_op();
extern char nextch();
extern char getch();
extern char *makerec();
extern char *index();
extern char *malloc();
extern char skip();
extern char cskip();
extern char tolower ();
extern char noasm();
extern int readline();
extern int oplook();
extern int labldef();
extern unsigned colsym();
extern unsigned evaluate();
extern unsigned colexpr();
extern unsigned colterm();
extern unsigned colnum();
extern unsigned isabs();
extern unsigned islstrt();
extern struct symtype *stlook();
extern struct symtype *stinstal();
