/*
 -------------------------------------
 Filename: x816d.c
 Version 1.013
 Portions are Copyright (c)1990 DataQue Software
 65816 Assembler
 -------------------------------------
 directory of functions in this module:

 class1()
 class2()
 class3()
 pseudo()
 cassm()
 ca_op()
 noasm()
 clearln()
 
 -------------------------------------
*/

#include <stdio.h>
#include "x816a.h"
#include "x816b.h"

/* 
  -------------------------------------
  class 1 machine operations processor
  1 byte, no operand field 
  for implied and accumulator mnemonics
  -------------------------------------
*/

VOID class1()
{
  if (dflag == 2) termseg();
  if (pass) {
    loadlw(codbnk, codloc);
    loadv(opval, 0);
    if (oflag) put1(opval);
  }
  codloc++;
}

/* 
  -------------------------------------
  class 2 machine operations processor
  2 or 3 byte, relative addressing 
  -------------------------------------
*/

VOID class2()
{
  if (dflag == 2) termseg();
  loadlw(codbnk, codloc);
  loadv(opval, 0);
  skip();
  if((opoff == 0x5a) ||     /* brl word */
    (opoff == 0x9e)) {      /* per word */
     if (!pass || evaluate()) { 
        codloc ++;
        codloc ++;
        codloc ++;
        return;
     }
     codloc ++;
     codloc ++;
     codloc ++;
     if (!isrel(exprtyp)) warning(1);              /* not relocatable */
     value -= codloc;
     loadv(value, 1);
     loadv(value >> 8, 2);
     if (oflag) {
        exprtyp = NULL;
        put3(opval,value);
     }
  } else {
     if (!pass || evaluate()) {
        codloc ++;
        codloc ++;
        return;
     }
     codloc ++;
     codloc ++;
     if (!isrel(exprtyp)) error(15);               /* not relocatable */
     if ((int)(value -= codloc) < -128 || (int) value > 127) {
        error(7);
        return;                                    /* branch range */
     }
     loadv(value, 1);
     if (oflag) {
        exprtyp = NULL;
        put2(opval,value);
     }
  }
}

/*
  ----------------------------------------- 
  class 3 machine operations processor
  various addressing modes
  ----------------------------------------- 
*/

VOID class3()
{
  unsigned code,flag,i,ztmask,extend;
  char c;

  if (dflag == 2) termseg();
  skip();
  loadlw(codbnk, codloc);
  extend = 0;

  switch(ch) {
    case 0:              /* EOL */
    case ';':            /* comment */
      error(8);          /* missing operand */
      return;

    case 'A':                                /* accumulator addressing */
    case 'a':
      if ((c = prlnbuf[cpos + 1])==' ' || (!c)) { /* sp or eol? *//*  == 0 */
        flag = ACC;
        break;
      }
    default:                                   /* immediate addressing */

  switch(ch) {
    case '#':
      flag = IMM1|IMM2;
      if (((indsiz) && ((opoff == 0x6c) ||  /* cpx # */
                        (opoff == 0x6e) ||  /* cpy # */
                        (opoff == 0x8c) ||  /* ldx # */
                      (opoff == 0x8e))) ||  /* ldy # */
                             (accsiz)) { 
           extend = IMM3|IMM4;
        flag = ABS;
        valbnk = 0;
      }
      nextch();
      break;

    case '=':
      flag = IMM1|IMM2;
      nextch();
      break;
 
    case '(':                                  /* indirect addressing */
      flag = ZIND|INDX|INDY|IND|0x8000;
      nextch();
      break;

    case '[':
      flag = LIND|LINDY;                  /* indirect long addressing */
      nextch();
      break;

    case '>':
      flag = LABS|LABSX;                /* forced abs long addressing */
      extend = 0x8000;
      nextch();
      break;

    case '<':
      flag = ZER|ZERX|ZERY;            /* forced zero page addressing */
      extend = 0xc000;
      nextch();
      break;

    default:                                            /* all others */
      flag = ABS|ABSX|ABSY2|ABSY|ZER|ZERX|ZERY|0x8000;
    }

    if (evaluate())                               /* evaluate operand */
    {
      codloc ++;
      codloc ++;
      codloc ++;
      if (flag & IMM1) codloc --;
      if (ch == ')' && prlnbuf[cpos+1] == ',' ) codloc --;
      if (ch == ']' && prlnbuf[cpos+1] == ',' ) codloc --;
      return;
    }
    if (undef) ztmask = ABS|ABSX|ABSY|ABSY2;
    else if (zpref) {
      flag &= (ABS|ABSX|ABSY|ABSY2|IND);
      ztmask = 0;
    }
    else ztmask = ZER|ZERX|ZERY;

    if(extend == 0xc000) { 
       flag = ZER|ZERX|ZERY;            /* forced zero page addressing */
       extend = valbnk = 0;
    }
    code = i = 0;
    
    while (ch != ' ' && ch != ';' && (ch) && i++ < 7) {   /*  != 0 */
      code *= 3;
      switch(ch) {

      case ']':   /* ] = 6 */
        ++code ;
      case 'X':   /* X = 5 */
      case 'x':
        ++code ;
      case 'Y':   /* Y = 4 */
      case 'y':
        ++code ;
      case ')':   /* ) = 3 */
        ++code ;
      case 'S':   /* S = 2 */
      case 's':
        ++code ;
      case ',':   /* , = 1 */
        ++code ;
        break;

      default:
        flag = 0;

      }
      nextch();
    }
    switch(code) {
    case 0:                               /* no termination characters */
      if (extend == (IMM3|IMM4)) {
         extend = 0x4000;
         flag = (IMM3|IMM4);
      } 
      if (valbnk) extend = 0x8000;
      flag &= (LABS|ZER|IMM1|IMM2);
      break;
    case 3:                                      /* termination = ")"  */
      flag &= ZIND|IND;
      break;
    case 5:                                      /* termination = ",S" */
      flag &= SZER;
      extend = 0x8000;
      break;
    case 6:                                      /* termination = "]"  */
      flag &= LIND;
      extend = 0x8000;
      break;
    case 7:                                      /* termination = ",Y" */
      flag &= (ABSY|ABSY2|ZERY);
      break;
    case 8:                                      /* termination = ",X" */
      flag &= (LABSX|ZERX);
      if (valbnk) extend = 0x8000;
      break;
    case 27:                                    /* termination = ",X)" */
      flag &= (AINDX|INDX);
      break;
    case 34:                                    /* termination = "),Y" */
      flag &= INDY;
      break;
    case 61:                                    /* termination = "],Y" */
      flag &= LINDY;
      extend = 0x8000;
      break;
    case 169:                                 /* termination = "S,),Y" */
      flag &= SINDY;
      extend = 0x4000;
      break;
    default:
      flag = 0;

    }
  }
  if ((opflg &= flag) == 0) {
    codloc ++;
    codloc ++;
    codloc ++;
    error(9);                               /* invalid addressing mode */
    return;
  }
  
  if (opflg & ztmask) opflg &= ztmask;

  opflg |= extend; 
  
  switch(opflg) {
  case ACC:                                   /* single byte - class 3 */
    loadv(opval + 8, 0);
    if (pass) put1(opval + 8);
    codloc++;
    return;

  case LINDY:                                 /* double byte - class 3 */
    opval += 2;  /* $16 */
  case ZERX:
  case ZERY:
    opval += 2;  /* $14 */
  case SINDY:
    opval ++;    /* $12 */
  case ZIND:
    opval ++;    /* $11 */
  case INDY:
    opval += 8;  /* $10 */
  case IMM2:
    opval += 2;  /* $08 */
  case LIND:
    opval += 2;  /* $06 */
  case ZER:
    opval += 2;  /* $04 */
  case SZER:
    opval += 2;  /* $02 */
  case INDX:
  case IMM1:

    if ((opoff == 0x4c) && (opval == 0x28)) opval = 0x89;  /* bit # */

    loadv(opval, 0);
    loadv(value, 1);
    if (pass) put2(opval,value); 
    codloc ++;
    codloc ++;
    return;

  case IND:                                /* triple byte - class 3 */
  case AINDX:
    opval += 16;  /* $2c */
  case ABSX:
  case ABSY2:
    opval += 4;   /* $1c */
  case ABSY:
    opval += 12;  /* $18 */
  case ABS:
    opval += 4;   /* $0c */
  case IMM4:
    opval += 8;   /* $08 */
  case IMM3:
     if(opoff == 0xd8) {
       if(opval == 0x6c) opval = 0x9c;                     /* stz a   */
       else if (opval == 0x7c) opval = 0x9e;               /* stz a,x */
    }
    if((opoff == 0x82) && (opval == 0x7c)) opval = 0xdc;   /* jml (a)   */
    if((opoff == 0x88) && (opval == 0x40)) opval = 0xfc;   /* jsr (a,x) */
    if((opoff == 0x84) && (opval == 0x6c) &&
        (code == 27)) opval = 0x7c;                        /* jmp (a,x) */

    if(((opoff == 0x82) && (opval == 0x5c)) || 
      ((opoff == 0x86) && (opval == 0x22))) goto fudge;
    loadv(opval, 0);
    loadv(value, 1);
    loadv(value >> 8, 2);
    if (pass) put3(opval,value);
    codloc ++;
    codloc ++;
    codloc ++;
    return;

  case LABSX:                                    /* quad byte - class 3 */
    opval += 16;  /* $1e */
  case LABS:
    opval += 14;  /* $0e */

    if((opoff == 0x86) && (opval == 0x24)) opval = 0x22;  /* jsl al */
    if((opoff == 0x82) && (opval == 0x5e)) opval = 0x5c;  /* jml al */
    if((opoff == 0x84) && (opval == 0x4e)) opval = 0x5c;  /* jmp al */

fudge:
    loadv(opval, 0);
    loadv(value, 1);
    loadv(value >> 8, 2);
    loadv(valbnk, 3);
    if (pass) put4(valbnk,opval,value);
    codloc ++;
    codloc ++;
    codloc ++;
    codloc ++;
    return;

  default:
    error(25);             /* Bad addressing mode */
    codloc ++;
    codloc ++;
    codloc ++;
    return;
  }
}

/*
  -------------------------------------
  pseudo operations processor
  -------------------------------------
*/

VOID pseudo()
{
  unsigned tvalue,temp,count,pflag,invert;
  char tflg;
  count = pflag = invert = 0;

  switch(opval) {
  case 0:
    accsiz = 0;                                          /* accb size */
    return;

  case 1:
    accsiz = 1;                                          /* accw size */
    return;

  case 2:
    ataflg ^= 1;                 /* .ata mode (graphic translation) */
    loadv(ataflg, 0);
    return;

  case 3:                                                    /* .cseg */
    if (dflag) dflag = 1;
    labldef(codbnk,codloc,DEFREL);
    loadlw(codbnk, codloc);
    if (evaluate()) return;
    if (undef) {
      error(12);                                  /* symbol undefined */
      return;
    }
    endadr[segnum-1] = (codloc - 1);
    if (!isabs(exprtyp)) warning(1);            /* not absolute label */
    if ((rflag) && (!codloc)) tvalue = rombase;
    else tvalue = codloc;
    if ((codloc > value) && (rflag)) warning(3);     /* overlap segs */
    codloc = value;
    codbnk = valbnk;
    begadr[segnum] = codloc;
    if (pass) {
       if (!rflag) {
          if (oflag) {
            if (segnum == 1) putw(0xffff, optr);
            if ((begadr[segnum]) != (endadr[segnum]+1)) {
              putw((begadr[segnum] + offset), optr);
              putw((endadr[segnum] + offset), optr);
            }
          }
       } else putn((offset + codloc) - (tvalue));
    }
    if (segnum >= MAXSEG) error(27);             /* too many seg nums */
    else segnum++;
    return;
          
  case 4:                                              /* .dcb pseudo */
    if (dflag == 2) termseg();
    labldef(codbnk,codloc,DEFREL);
    loadlw(codbnk, codloc);
    do {
      skip();
      if ((ch == '-') && (prlnbuf[cpos+1] == '"')) {
         ch=nextch();
         invert = 0x80;
      }
      if (ch == '"') {
        while ((ch=nextch()) != '"') {
          if ((tvalue=ch) == 0) {
            error(10);
            return;
          }
          if (tvalue == '\\') {
            if ((tvalue=nextch())=='l') tvalue = '\014';
            else if (tvalue=='n') tvalue = '\n';
          }
          codloc++;
          if (pass) {
            if(ataflg == 1) {
              mvalue = tvalue;
              asc2ata();
              tvalue = mvalue;
            }
            tvalue |= invert;
            put1(tvalue);
            loadv(tvalue, count);
            if (++count >= 4) {
              if (!pflag) println();
              pflag = nflag;
              clearln();
              count = 0;
              loadlw(codbnk, codloc);
            }
            if (pflag) {
              clearln();
              count = 0;
            }
          }
        }
        nextch();
      } else {
        evaluate();
        if (value > 0xff) {
          error(11);
          value = 0;
        }
        codloc++;
        if (pass) {
          put1r(value);
          loadv(value, count);
          if (++count >= 4) {
            println();
            clearln();
            count = 0;
            loadlw(codbnk, codloc);
          }
        }
      }
    } while (ch == ',');
    listed = (count == 0);
    return;

  case 5:                                          /* .dcd pseudo */
    if (dflag == 2) termseg();
    labldef(codbnk,codloc,DEFREL);
    loadlw(codbnk, codloc);
    do {
      skip();
      listed = evaluate();
      codloc ++;
      codloc ++;
      if (pass) {
        loadv(value>>8, 0);
        loadv(value,1);
        put1r(value>>8);
        put1r(value);
        if (!listed) println();
        loadlw(codbnk, codloc);
      }
      clearln();
    } while (ch == ',');
    listed = 1;
    return;

  case 6:                                           /* .dcw pseudo */
    if (dflag == 2) termseg();
    labldef(codbnk,codloc,DEFREL);
    do {
      loadlw(codbnk, codloc);
      skip();
      listed = evaluate();
      if (pass) {
        loadv(value, 0);
        loadv(value>>8, 1);
        put2(value,value>>8);
        if (!listed) println();
        clearln();
      }
      codloc ++;
      codloc ++;
    } while (ch == ',');
    listed = 1;
    return;

  case 7:                                           /* .dsb pseudo */
    if(dflag) {
      datbnk = 0;
      if (dflag == 1) datloc = codloc;
      labldef(datbnk,datloc,DEFREL);
      loadlw(datbnk,datloc);
      skip();
      evaluate();
      tvalue = value;
      if (rflag) putn(tvalue); 
      datloc += tvalue;
      dflag = 2;                                    /* set dsb flag */
    } else {
      labldef(datbnk,datloc,DEFREL);
      loadlw(datbnk, datloc);
      skip();
      evaluate();
      datloc += value;
    }
    return;

  case 8:                                           /* .dseg pseudo */
    if (dflag == 2) datloc = codloc;
    labldef(datbnk,datloc,DEFREL);
    loadlw(datbnk, datloc);
    skip();
    evaluate();
    datloc = value;
    datbnk = valbnk;
    dflag = 0;
    return;

  case 9:                                           /* .dsw pseudo */
    if(dflag) {
      if (dflag == 1) datloc = codloc;
      labldef(datbnk,datloc,DEFREL);
      loadlw(datbnk,datloc);
      skip();
      evaluate();
      tvalue  = (value << 1);
      if (rflag) putn(tvalue); 
      datloc += tvalue;
      dflag = 2;                                /* set dsb flag */
    } else {
      labldef(datbnk,datloc,DEFREL);
      loadlw(datbnk, datloc);
      skip();
      evaluate();
      datloc += (value << 1);
    }
    return;

  case 10:                                          /* .end of source */
    loadlw(codbnk, codloc);
    endadr[segnum-1] = (codloc - 1);
    if ((rflag) && ((codloc + offset) > (rombase + romsiz))) warning(2);
    if ((pass) && (rflag)) putn((rombase + romsiz) - (codloc + offset));
    segnum++;
    return;

  case 11:                                          /* .ext (extern?) */
    if (lablptr) {
      error(24);                                   /* cant be labeled */
      return;
    }
    do {
      skip();
      if (!colsym()) {                             /* must have symbol */
        error(13);
        return;
      }
      lablptr = stlook();                          /* define label */
      if (pass) { 
        if (lablptr->flag != DEFNOT) error(14);
        else lablptr->flag = DEFEXT; 
      }
    } while (ch == ',');
  return;

  case 12: indsiz = 0;                             /* indb size */
           return;

  case 13: indsiz = 1;                             /* indw size */
           return;

  case 14:                                         /* .list pseudo */
    if (lablptr) {
      error(24);
      return;
    }
    lflag ^= 0x80;                                 /* clear nolist bit */
    return;

  case 15:                                         /* relocatable code */
    aflag = 1;
    return;

  case 16:                                         /* .offs pseudo */
    skip();
    evaluate();
    offset = value;
    if(pass) loadlc(offset, 0);
    return;

  case 17:                                         /* .pub (public?) */
    if (lablptr) {                                 /* cant be labeled */
      error(24);
      return;
    }
    do {
      skip();
      if (!colsym()) {                             /* no symbol? */
        error(13);
        return;
      }
      lablptr = stlook();                          /* define label */
      if (pass) {
        if (lablptr->flag == DEFNOT) error(12);   /* undefined */
        else lablptr->flag |= DEFPUB; 
      }
    } while (ch == ',');
    return;

  case 18:                                               /* rom mode */
    if (codloc) {
      error(26);                     /* rom spec must be before code */
      return;
    }
    skip();
    evaluate();
    romsiz = value;
    rflag = 1;
    skip();
    evaluate();
    rombase = value;
    if(pass) {
      loadlc(romsiz, 0);
      loadlc(rombase, 1);
    }
    return;

  case 19:                                         /* equate '=' pseudo */
    if (!lablptr) {
      error(23);
      return;
    }
    skip();                                /* oplook leaves '=' current */
    if (evaluate()) return;
    if (!isrel(exprtyp) && !isabs(exprtyp)) warning(1);
    labldef(valbnk,value,exprtyp);
    if (pass) {
      loadv(valbnk, 1);
      loadlc(value, 2);
    }
    return;
         
  case 20:                                              /* .dcc pseudo */
    if (dflag == 2) termseg();
    labldef(codbnk,codloc,DEFREL);
    loadlw(codbnk, codloc);
    count = 0;                     /* define string, with last chr inv */
    do {
      skip();
      if (ch == '"') {
        while ((ch=nextch()) != '"') {
          if ((tvalue=ch) == 0) {
            error(10);                          /* missing string term */
            return;
          }
          codloc++;
          if (pass) {
            if(ataflg == 1) {
              mvalue = tvalue;
              asc2ata();
              tvalue = mvalue;
            }
            if (prlnbuf[cpos+1] == '"') tvalue |= 0x80;
            put1(tvalue);
            loadv(tvalue, count);
            if (++count >= 4) {
              if (!pflag) println();
              pflag = nflag;
              clearln();
              count = 0;
              loadlw(codbnk, codloc);
            }
            if (pflag) {
              clearln();
              count = 0;
            }
          }
        }
        nextch();
      }
    } while (ch == ',');
    listed = (count == 0);
    return;
         
  case 21:                                             /* .dcs pseudo */
    if (dflag == 2) termseg();
    labldef(codbnk,codloc,DEFREL);                   /* define string */
    loadlw(codbnk, codloc);
    count = 0;
    do {
      skip();
      if ((ch == '-') && (prlnbuf[cpos+1] == '"')) {
         ch=nextch();
         invert = 0x80;
      }
      if (ch == '"') {
        while ((ch=nextch()) != '"') {
          if ((tvalue=ch) == 0) {
            error(10);                         /* missing string term */
            return;
          }
          codloc++;
          if (pass) {
            if(ataflg == 1) {
              mvalue = tvalue;
              asc2ata();
              tvalue = mvalue;
            }
            tvalue |= invert;
            temp = tvalue & 0x60;
            if (!temp) tvalue += 0x40;
            if ((temp == 0x20) || (temp == 0x40)) tvalue -= 0x20;
            put1(tvalue);
            loadv(tvalue, count);
            if (++count >= 4) {
              if (!pflag) println();
              pflag = nflag;
              clearln();
              count = 0;
              loadlw(codbnk, codloc);
            }
            if (pflag) {
              clearln();
              count = 0;
            }
          }
        }
        nextch();
      }
    } while (ch == ',');
    listed = (count == 0);
    return;
  }
}

/*
  ----------------------------------------------
  routine to terminate a code segment if a
  code byte follows a data byte in the code seg.

  datloc = current data segment value
  codloc = last code segment value
  rflag = rom enable
  dflag = data segment flag (zero = seperate)
  rombase = base of rom (if rflag = 1)
  ----------------------------------------------
*/

VOID termseg()
{
  unsigned temp1,temp2;

  endadr[segnum-1] = (codloc - 1);

  if((rflag) && (!codloc)) temp1 = rombase;
  else temp1 = codloc;

  codloc = datloc;
  dflag = 1;

  begadr[segnum] = codloc;
  if (pass) {
     if (!rflag) {
        if (oflag) {
          if (segnum == 1) putw(0xffff, optr);
          if ((begadr[segnum]) != (endadr[segnum]+1)) {
            putw((begadr[segnum] + offset), optr);
            putw((endadr[segnum] + offset), optr);
          }
        }
     } else putn((offset + codloc) - (temp1));
  }
  if (segnum >= MAXSEG) error(27);             /* too many seg nums */
  else segnum++;
}

/*
  ----------------------------------------------
  routine to generate atascii codes
  ----------------------------------------------
*/

VOID asc2ata()
{
   mvalue &= 0x00ff;
   switch (mvalue) {
   case 218:        /*  ($11) 218 =   */
     mvalue = 0x11;
     break;
   case 195:        /*  ($01) 195 =   */
     mvalue = 0x01;
     break;
   case 192:        /*  ($1A) 192 =   */
     mvalue = 0x1a;
     break;
   case 191:        /*  ($05) 191 =   */
     mvalue = 0x05;
     break;
   case 180:        /*  ($04) 180 =   */
     mvalue = 0x04;
     break;
   case 217:        /*  ($03) 217 =   */
     mvalue = 0x03;
     break;
   case 194:        /*  ($17) 194 =   */
     mvalue = 0x17;
     break;
   case 197:        /*  ($13) 197 =   */
     mvalue = 0x13;
     break;
   case 193:        /*  ($18) 193 =   */
     mvalue = 0x18;
     break;
   case 179:        /*  ($7C) 179 =   */
     mvalue = 0x7c;
     break;
   case 196:        /*  ($12) 196 =   */
     mvalue = 0x12;
     break;
   }
}

/*
  -------------------------------------
  conditional directives processor
   1a .else  1
   1e .fi    2
   22 .ifeq  3
   24 .ifge  4
   26 .ifgt  5
   28 .ifle  6
   2a .iflt  7
   2c .ifne  8
  -------------------------------------
*/

VOID cassm()
{
  unsigned tval,t;

  if (lablptr) error(24);                      /* invalid label */
  if (opval == 2) {                            /* .fi */
    if (casmflg == 1) error(22);               /* .fi without .if */
    else casmflg >>= 1;
    return;
  }
  else if (opval == 1) {                       /* .else */
    casmflg = casmflg ^ 1;
    return;
  }
  casmflg <<= 1;
  casmflg |= 1;
  if (noasm()) return;
  if (ca_op()) return;
  tval = value;
  if (ch != ',') {
    error(8);                                  /* missing operand */
    return;
  }
  nextch();
  if (ca_op()) return;
  casmflg &= 0xfffe;
  if (casmflg & 0x80) {
    error(16);                                 /* nesting too deep */
    quit();
  }
  switch (opval) {
  case 3:                                      /* .ifeq  = */
    casmflg |= (tval == value);
    break;
  case 4:                                      /* .ifge >= */
    casmflg |= (tval >= value);
    break;
  case 5:                                      /* .ifgt  > */
    casmflg |= (tval > value);
    break;
  case 6:                                      /* .ifle <= */
    casmflg |= (tval <= value);
    break;
  case 7:                                      /* .iflt  < */
    casmflg |= (tval < value);
    break;
  case 8:                                      /* .ifne /= */
    casmflg |= (tval != value);
    break;
  }
  loadv((casmflg & 0x01),0);
}

/* 
  -------------------------------------
  evaluate operand #f for cond asm
  -------------------------------------
*/

VOID ca_op()
{
  if (evaluate()) return 1;
  if (undef) {
    error(12);                                 /* symbol undefined */
    return 1;
  }
  return 0;
}

/* 
  -------------------------------------
  determine whether to assemble code
  due to conditional assembly 
  -------------------------------------
 */

char noasm()
{
  return !index("\01\03\07\017\037\077\177", casmflg);
}

/* 
  -------------------------------------
  Clear contents of print line buffer 
  -------------------------------------
*/

VOID clearln()
{
  unsigned i;

  for (i = 0; i < SFIELD; i++) prlnbuf[i] = ' ';
  prlnbuf[i] = 0;
}
