/*
 -------------------------------------
 Filename: x816e.c
 Version 1.013
 Portions are Copyright (c)1990 DataQue Software
 65816 Assembler
 -------------------------------------
 directory of functions in this module:

 evaluate()
 colexpr()
 colterm(ts)
 colnum()
 isabs(t)
 
 -------------------------------------
*/

#include <stdio.h>
#include <string.h>
#include "x816a.h"
#include "x816b.h"

static char err;

/* 
  -------------------------------------
  evaluate expression
  -------------------------------------
*/

unsigned evaluate()
{
   if (colexpr()) {
      error (err);
      return err;
   }
   if (undef && pass) {
      error (12);
      return 12;
   }
   return 0;
}

/*
  -------------------------------------
  calculate the value and type of an
  expression.  returns 0 if no errors;
  else error message number.  sets globals:
    value = value of expression
    exprtyp = type of expression
    exprsym = ptr to symbol table entry for
             expressions which consist of a
             single symbolic entry
    exprmc = 1 or 2 if high byte or low byte
    undef = 1 if any term is undefined.  in
           that case, value, exprtyp, exprsym
           are meaningless.
  -------------------------------------
*/

unsigned colexpr()
{
   char force;
   static char terms[] = "\n ,;)]";

   *terms = '\0';

   exprmc = NULL;
   exprsym = NULL;
   exprtyp = NULL;
   undef = err = value = valbnk = 0;

   cskip();
   if (index ("!<>^",ch)) {
      force = ch;
      nextch ();
   }
   else force = ' ';
   zpref = 1;

   if (colterm(terms)||undef) {
      exprtyp = NULL;
      value = 0;
      valbnk = 0;
   }

   fullvalue = value;
   if (isabs(exprtyp) && value < 256) zpref = 0;

   switch (force) {
   case '!': zpref = 1;
             valbnk = 0;
             break;
   case '<': zpref = 0;    /* lower byte of word */
             exprmc = 2;
             value &= 0xff;
             valbnk = 0;
             break;
   case '>': zpref = 0;    /* upper byte of word */
             exprmc = 1;
             value >>= 8;
             valbnk = 0;
             break;
   case '^': zpref = 0;    /* bank byte of word */
             exprmc = 1;
             value = valbnk;
             valbnk = 0;
             break;
   }
   return err;
}

/*
  -------------------------------------
  ts is a string of valid terminators.  If
  end of line is to be a terminator, \0 must
  be the first character of the string.
  -------------------------------------
*/

unsigned colterm (ts)
char *ts;

{
   unsigned tvalue, ttype, evalue, etype;
   char op, monop;
   struct symtype *xsym;

   tvalue = evalue = 0;
   etype = NULL;
   op = monop = ' ';

   while (1) {
      if (index("~-+", ch )) {             /* recognize monadic operators */
         monop = ch;
         nextch ();
      }
      if (etype == DEFEXT) {               /* recognize a term */
         cpos--; getch();                  /* include + or - as monadic */
         op = '+';
         xsym = exprsym;                   /* save ext sym data */
         if (colterm (ts)) return err;     /* evaluate offset */
         exprsym = xsym;
         tvalue = value;
         ttype = exprtyp;
      }
      else if ( index ("0123456789$@%", ch) ) {
         tvalue = colnum();
         valbnk = fulbnk;
         ttype = DEFABS;
      }
      else if (islstrt()) {
         colsym();
         exprsym = stlook();
         if (exprsym->flag == DEFNOT) {
            undef = 1;
            tvalue = 0;
            ttype = DEFNOT;
         } else {
            tvalue = exprsym->value;
            valbnk = exprsym->valbnk;   
            ttype = exprsym->flag;
         }
      }
      else switch ( ch ) {
      case '*':
         tvalue = codloc;
         ttype = DEFREL;
         nextch ();
         break;
      case '\'':
         tvalue = nextch ();
         ttype = DEFABS;
         if (tvalue) nextch();
         else tvalue = ' ';
         break;
      case '{':                    /* replaced bracket '[]' with brace */
         nextch ();
         if (colterm ("}")) return err;
         if (ch != '}') return (err = 17);
         tvalue = value;
         ttype = exprtyp;
         nextch ();
         break;

      default:
         return (err = 20); 
      }
      switch (monop) {                /* do any monadic operator */
      case '+':
      case ' ':
         break;
      case '~':
      case '-':
         exprsym = NULL;
         if (isabs(ttype)) tvalue = (monop=='-'? -tvalue: ~tvalue);
         else return(err = 15);
         break;
      default:
         return (err = 16);
      }
      monop = ' ';

      /* Relocatability checks */

      if ( etype == DEFEXT )
         if ((isabs(ttype) || undef) && op == '+') evalue = tvalue;
         else return (err = 15);
      else if (op != ' ')
      {
         exprsym = NULL;
         if (ttype == DEFEXT) return (err = 15);
      }

      if ( etype != DEFEXT && !undef)      /* Do any dyadic operation */
      switch(op) {
      case ' ':
         evalue = tvalue;
         etype = ttype;
         break;
      case '+':
         if (isrel(etype) && isrel(ttype)) return(err = 15);
         evalue += tvalue;
         if (isrel(etype) || isrel(ttype)) etype = DEFREL;
         else etype = DEFABS;
         break;
      case '-':
         if (isabs(etype) && isrel(ttype)) return(err = 15);
         evalue -= tvalue;
         if (isrel(etype) && isabs(ttype)) etype = DEFREL;
         else etype = DEFABS;
         break;
      default:
         if (isrel(etype) || isrel(ttype)) return(err = 15);
         switch (op)
         {
         case '/':
            if (!tvalue) return (err = 18);
            evalue /= tvalue;
            break;
         case '%':
            if (!tvalue) return (err = 18);
            evalue %= tvalue;
            break;
         case '*':
            evalue *= tvalue;
            break;
         case '^':
            evalue ^= tvalue;
            break;
         case '&':
            evalue &= tvalue;
            break;
         case '|':
            evalue |= tvalue;
            break;
         default:
            return (err = 1);
         }
      }

      /* get next dyadic operator */

      if (index("+-*/%^&|", ch))
      {
         op = ch;
         nextch ();
      }

      else if 
         (ch == *ts || index(ts+1,ch)) {   /* check for end of expression */
         value = evalue;
         exprtyp = etype;
         return err;
      } else return (err = 20);
   }
}

/*
  -------------------------------------
  collect number operand  
  -------------------------------------
*/

unsigned colnum()
{
  char c;                                      /* local copy of 'ch' */
  unsigned t,mul,nval,j;
  
  fulbnk = j = mul = nval = 0;
  c=ch;                                        /* copy to local */

  if (c == '$') mul = 16;
  else if (c >= '1' && c <= '9') {
    mul = 10;
    nval = c - '0';
  }
  else if (c == '@' || c == '0') mul = 8;
  else if (c == '%') mul = 2;

  c = nextch();
  while ((c = tolower(c)) >= '0') {
    if((j == 4) && (mul == 16)) {
       t = nval;
       t >>= 8;
       nval &= 0x00ff;
       fulbnk = t; 
    }
    j++;
    if (c > '9') c = c - 'a' + 10;
    else c -= '0';
    if (c >= mul) break;
    nval = (nval * mul) + c;
    c = nextch();
  }
  return(nval);
}

/*
  -------------------------------------
  check for ABS or ZER definition
  -------------------------------------
*/

unsigned isabs(t)
unsigned t;
{
   return t==DEFABS || t==DEFZRO;
}
