/*
 -------------------------------------
 Filename:  x816f.c
 Version 1.013
 Portions are Copyright (c)1990 DataQue Software
 65816 Assembler
 -------------------------------------
 directory of functions in this module:

 makerec(size)
 put1r(v)
 put1(v)
 put2(v1,v2)
 put3(v1,v2)
 put4(v0,v1,v2)
 putn(n)
 index(s,c)
 
 -------------------------------------
*/

#include <stdio.h>
#include "x816a.h"
#include "x816b.h"

/*
  -------------------------------------
  Allocate size bytes of storage
  Returns: pointer to empty entry.
  -------------------------------------
*/

char *makerec(size)
unsigned size;
{
  char *ptr;
  char *malloc();

  ptr = malloc(size);
  if (ptr==NULL) {
    error(21);             /* memory allocate error */
    quit();
  }
  return (ptr);
}

/*
  -------------------------------------
  Put 1 byte value to object file,
  including relocation check
  -------------------------------------
*/

VOID put1r(v)
unsigned v;
{
  if (oflag) put1(v);
}

/*
  -------------------------------------
  Put 1 byte value to object file
  Note: no relocation check performed
  -------------------------------------
*/

VOID put1(v)
unsigned v;
{
  if (oflag) fputc(v,optr);
  objloc++;
}

/*
  -------------------------------------
  Put 2 byte value to object file
  -------------------------------------
*/

VOID put2(v1,v2)
unsigned v1,v2;
{
  if (oflag) {
    fputc(v1,optr);
    fputc(v2,optr);
  }
  objloc += 2;
}

/*
  -------------------------------------
  Put 3 bytes to object file.
  First value is opcode, second is
  operand.
  -------------------------------------
*/

VOID put3(v1,v2)
unsigned v1,v2;
{
  if (oflag) {
    fputc(v1,optr);
    putw(v2,optr);
  }
  objloc += 3;
}

/*
  -------------------------------------
  Put 4 bytes to object file.
  First value is opcode, second is
  operand, third is bank.
  -------------------------------------
*/

VOID put4(v0,v1,v2)
char v0;
unsigned v1,v2;
{
  if (oflag) {
    fputc(v1,optr);
    putw(v2,optr);
    fputc(v0,optr);
  }
  objloc += 4;
}

/*
  -------------------------------------
  put 'n' number of 0xff's into obj
  -------------------------------------
*/

VOID putn(n)
int n;
{
  char buf[256];
  int i;

  objloc += n;
  if (oflag) {
    for (i=0; i<256; i++) buf[i] = 0xff;
    while (n > 0) {
      if (n >= 256) i = 256;
      else i = n;
      n -= i;
      fwrite(buf,i,1,optr);
    }
  }
}

/*
  -------------------------------------
  find index count of comparision byte
  in a string
  -------------------------------------
*/

char *index(s,c)
char *s, c;
{
  while (*s)
    if (c == *s) return s;
    else s++;
  return 0;
}

/*
  -------------------------------------
  return to dos
  -------------------------------------
*/

VOID quit()
{
  fcloseall();
  exit (1);
}
