'   +----------------------------------------------------------------------+
'   |                                                                      |
'   |        BASWIZ  Copyright (c) 1990-1993  Thomas G. Hanlin III         |
'   |                                                                      |
'   |                      The BASIC Wizard's Library                      |
'   |                                                                      |
'   +----------------------------------------------------------------------+

   DECLARE FUNCTION FGetLocate& (BYVAL Handle%)
   DECLARE FUNCTION FGetSize& (BYVAL Handle%)
   DECLARE FUNCTION ZeroFill$ (Num%, NumSize%)
   DECLARE SUB FClose0 (BYVAL Handle%)
   DECLARE SUB FDate0 (BYVAL Handle%, St$)
   DECLARE SUB FDone0 ()
   DECLARE SUB FInit0 (BYVAL Handles%, ErrCode%)
   DECLARE SUB FLocate (BYVAL Handle%, Posn&)
   DECLARE SUB FOpen0 (File$, BYVAL FAccess%, BYVAL BufferLen%, Handle%, ErrCode%)
   DECLARE SUB FTime0 (BYVAL Handle%, St$)
   DECLARE SUB Peel (MainSt$, SubSt$)

   DEFINT A-Z

FUNCTION FEOF% (Handle)
   FEOF% = (FGetLocate&(Handle) > FGetSize&(Handle))
END FUNCTION

FUNCTION ZeroFill$ (Num, NumSize)
   Tmp$ = MID$(STR$(Num), 2)
   IF LEN(Tmp$) > NumSize THEN
      ZeroFill$ = LEFT$(Tmp$, NumSize)
   ELSE
      ZeroFill$ = STRING$(NumSize - LEN(Tmp$), "0") + Tmp$
   END IF
END FUNCTION

SUB FClose (Handle)
   FClose0 Handle
   junk = SETMEM(999999)
END SUB

SUB FDate (Handle, St$)
   IF LEN(St$) = 10 THEN
      FDate0 Handle, St$
   ELSE
      D$ = DATE$
      Peel St$, tmp$
      IF LEN(tmp$) THEN
         MonthX = VAL(tmp$)
      ELSE
         MonthX = VAL(LEFT$(D$, 2))
      END IF
      Peel St$, tmp$
      IF LEN(tmp$) THEN
         DayX = VAL(tmp$)
      ELSE
         DayX = VAL(MID$(D$, 4, 2))
      END IF
      IF LEN(St$) THEN
         YearX = VAL(St$)
         IF YearX < 1900 THEN YearX = YearX + 1900
      ELSE
         YearX = VAL(RIGHT$(D$, 4))
      END IF
      Tmp$ = ZeroFill$(MonthX, 2) + "-" + ZeroFill$(DayX, 2)
      Tmp$ = Tmp$ + "-" + ZeroFill$(YearX, 4)
      FDate0 Handle, Tmp$
   END IF
END SUB

SUB FDone
   FDone0
   junk = SETMEM(999999)
END SUB

SUB FInit (Handles, ErrCode)
   IF Handles <= 15 THEN
      FInit0 15, ErrCode
   ELSE
      junk& = SETMEM(-Handles * 10&)
      FInit0 Handles, ErrCode
      junk& = SETMEM(999999)
   END IF
END SUB

SUB FOpen (File$, FMode$, BufferLen, Handle, ErrCode)
   IF BufferLen < 0 THEN
      ErrCode = 1
   ELSEIF INSTR(Mo$, "W") > 0 THEN
      IF BufferLen > 0 OR INSTR(Mo$, "R") > 0 AND INSTR(Mo$, "T") > 0 THEN
         ErrCode = 1
      END IF
   END IF

   IF ErrCode THEN EXIT SUB

   FAccess = 0

   Mo$ = UCASE$(FMode$)
   IF INSTR(Mo$, "R") THEN
      FAccess = FAccess OR 1
      IF INSTR(Mo$, "W") THEN
         BufLen = 0
      ELSE
         BufLen = BufferLen
      END IF
   ELSE
      BufLen = 0
   END IF
   IF INSTR(Mo$, "W") THEN FAccess = FAccess OR 2
   IF INSTR(Mo$, "C") THEN
      FAccess = FAccess OR 4
      IF INSTR(Mo$, "R") = 0 THEN
         FAccess = FAccess OR 2
      END IF
   END IF
   IF INSTR(Mo$, "T") THEN
      FAccess = FAccess OR 8
      IF BufferLen = 0 AND INSTR(Mo$, "R") > 0 THEN
         BufLen = 512
      END IF
   END IF
   junk& = SETMEM(-BufLen - 32&)
   FOpen0 File$, FAccess, BufLen, Handle, ErrCode
   junk& = SETMEM(999999)
   IF ErrCode = 0 THEN
      IF INSTR(Mo$, "A") THEN
         FLocate Handle, FGetSize&(Handle) + 1&
      END IF
   END IF
END SUB

SUB FTime (Handle, St$)
   IF LEN(St$) = 8 THEN
      FTime0 Handle, St$
   ELSE
      T$ = TIME$
      Peel St$, tmp$
      IF LEN(tmp$) THEN
         HourX = VAL(tmp$)
      ELSE
         HourX = VAL(LEFT$(T$, 2))
      END IF
      Peel St$, tmp$
      IF LEN(tmp$) THEN
         MinuteX = VAL(tmp$)
      ELSE
         MinuteX = VAL(MID$(T$, 4, 2))
      END IF
      IF LEN(St$) THEN
         SecondX = VAL(St$)
      ELSE
         SecondX = VAL(RIGHT$(T$, 2))
      END IF
      Tmp$ = ZeroFill$(HourX, 2) + ":" + ZeroFill$(MinuteX, 2)
      Tmp$ = Tmp$ + "-" + ZeroFill$(SecondX, 2)
      FTime0 Handle, Tmp$
   END IF
END SUB

SUB Peel (MainSt$, SubSt$)
   SubSt$ = ""
   DO UNTIL LEN(MainSt$) = 0 OR INSTR("0123456789", LEFT$(MainSt$, 1)) = 0
      SubSt$ = SubSt$ + LEFT$(MainSt$, 1)
      MainSt$ = MID$(MainSt$, 2)
   LOOP
   MainSt$ = MID$(MainSt$, 2)
END SUB
