'S3 Collection of functions and subroutines to ease
'in the checking of PC memory.
'
'By:  George Spafford Copyright 1993
'
'No additional libraries required
'
'v1.0  05/01/93
'
'**************************************************

'If you use these routines, please have the courtesy
'of registering the tutorial.

'Make sure that you have all of your variables typed
'correctly before you use one of the following
'routines.  Use integers where integers are identified (%).
'Use long integers where long integers are identified (&).

'Int2Long& is a function that accepts a signed
'integer and returns an unsigned long integer. Since
'BASIC uses the high bit to toggle the sign of an
'integer, you must convert it to a long integer before
'you perform any bit operations on it.

DECLARE FUNCTION Int2Long& (IntNumber%)

'BASIC does NOT have a built in facility to PEEK
'words!  Tell the PeekWord% function where to look,
'and it will read in a word at that segment and offset.

DECLARE FUNCTION PeekWord% (Segment%, Offset%)

'As with Peeks, BASIC does not support a POKE function
'for words.  This next subroutine adds that capability.
'Tell the subroutine the segment, offset and word that
'you wish it to POKE in and it will do so.

DECLARE SUB PokeWord (Segment%, Offset%, Word%)

'As you code more and more programs, try to make your code
'as modular as possible.  By creating objects (OOP systems),
'you can significantly increase your code reusability.
'Try to only create the wheel once!  Some of the demos would
'benefit greatly by judicial use of subroutines.  In order to
'have top-down readability, I did not modularize the code.
'Just a FYI   -- George

FUNCTION Int2Long& (IntNumber%)
    'If the integer is negative, we need to add 65536
    'to the number (which is 2 * integer limit) to get
    'our new long integer.

    IF IntNumber% < 0 THEN
       Int2Long& = 65536 + IntNumber%
    ELSE
       Int2Long& = IntNumber%
    END IF
END FUNCTION

FUNCTION PeekWord% (Segment%, Offset%)
    DEF SEG = Segment%              'set segment
    High = PEEK(Offset% + 1)        'High byte is at offset + 1
    Low = PEEK(Offset%)             'Low byte is at offset   
    PeekWord% = (High * 256) + Low  'Compute the word value
    DEF SEG                         'return to default segment
END FUNCTION

SUB PokeWord (Segment%, Offset%, Word%)
    DEF SEG = Segment%          'Set segment
    High = (Word \ 256)         'perform integer division
                                'to compute the high byte
    Low = Word - (High * 256)   'compute the low byte
    POKE (Offset% + 1), High    'POKE in the high byte
    POKE Offset%, Low           'POKE in the low byte
    DEF SEG                     'return to the default segment
END SUB

