(*$C-,U-,R-,V-,K-*)
PROGRAM DumbTrm;

(*--------------------------------------------------------------------------*)
(*                                                                          *)
(*   Program:   DumbTrm                                                     *)
(*                                                                          *)
(*   Author:    Philip R. Burns                                             *)
(*                                                                          *)
(*   Date:      November 1, 1986                                            *)
(*                                                                          *)
(*   Purpose:   Dumb terminal emulator to demonstrate PibAsync routines.    *)
(*                                                                          *)
(*   Usage:     Compile to .COM file using Turbo Pascal and execute the     *)
(*              .COM file by typing  DUMBTRM  at the DOS prompt.            *)
(*                                                                          *)
(*              You will be prompted for the required communications        *)
(*              parameters.  If the serial port can be opened successfully, *)
(*              then a dumb terminal mode is entered.                       *)
(*                                                                          *)
(*              To exit dumb terminal mode, type ^C (ascii 03).  To send    *)
(*              a break, type ^B (ascii 02).                                *)
(*                                                                          *)
(*   Needs:     See includes below for files included from PibAsync.Arc.    *)
(*                                                                          *)
(*   Remarks:   This program doesn't check for input mistakes when the      *)
(*              communications parameters are being entered.                *)
(*                                                                          *)
(*--------------------------------------------------------------------------*)

(*$I GLOBTYPE.GLO *)
(*$I ASCII.GLO    *)

VAR
   Baud_Rate   : INTEGER           (* Baud rate for connection, e.g., 1200  *);
   Com_Port    : INTEGER           (* Which port, e.g., 1 for COM1:         *);
   Parity      : CHAR              (* Parity, e.g., E for even parity       *);
   Data_Bits   : INTEGER           (* How many bits per character, e.g., 8  *);
   Stop_Bits   : INTEGER           (* How many stop bits -- nearly always 1 *);

VAR
   InBufSize   : INTEGER           (* Size of input buffer                  *);
   OutBufSize  : INTEGER           (* Size of output buffer                 *);
   Do_XonXoff  : CHAR              (* 'Y' to do XON/XOFF flow control       *);
   Do_HardWired: CHAR              (* 'Y' to do XON/XOFF flow control       *);
   Do_CTS      : CHAR              (* 'Y' to do CTS checking                *);
   Do_DSR      : CHAR              (* 'Y' to do DSR checking                *);

(*$I PIBASYNC.GLO *)
(*$I PIBASYN1.MOD *)
(*$I PIBASYN2.MOD *)
(*$I PIBASYN3.MOD *)

(*--------------------------------------------------------------------------*)
PROCEDURE Get_Comm_Params;

VAR
   YesNo : CHAR;

BEGIN (* Get_Comm_Params *)
   ClrScr;
   textcolor(12);
   WRITE('Com Port  [1,2]     : ');textcolor(11);
   READLN( Com_Port );textcolor(12);
   WRITE('Baud Rate [300-9600]: ');textcolor(11);
   READLN( Baud_Rate );
   Parity := 'N';
   Data_bits:=8;
   Stop_Bits:=1;
   textcolor(15);
END   (* Get_Comm_Params *);

(*--------------------------------------------------------------------------*)

Procedure baudchange;
var brate:integer;
begin
  textcolor(12);
  write('New Baud Rate: ');readln( baud_rate );
  async_reset_port(com_port,baud_rate,parity,data_bits,stop_bits);
end;

procedure skey(c:char);
begin
  case ord(c) of
    59:baudchange;
   end;
end;

FUNCTION Initialize_Communications : BOOLEAN;
BEGIN (* Initialize_Communications *)
   Async_Break_Length   := 500;
   Async_Init( InBufSize, OutBufSize, 0, 0, 0);
   IF ( NOT Async_Open( Com_Port, Baud_Rate, Parity, Data_Bits, Stop_Bits ) ) THEN
      BEGIN
         WRITELN('Cannot open serial port.');
         Initialize_Communications := FALSE;
      END
   ELSE
      BEGIN
         WRITELN('Serial port opened, DumbTrm ready.');
         Initialize_Communications := TRUE;
      END;

END   (* Initialize_Communications *);

(*--------------------------------------------------------------------------*)

PROCEDURE Emulate_Dumb_Terminal;

VAR
   Kch: CHAR;
   Ch : CHAR;
   cha: integer;
   chs: integer;
   chst: string[1];

BEGIN (* Emulate_Dumb_Terminal *)
Clrscr;
window(1,1,80,3);
textcolor(12);
writeln('     Spectrum Commodore C/G Terminal Emulator by Scott Deming v1.00');
textcolor(11);
writeln('');
textcolor(15);
window(1,4,80,25);
                                   (* Begin loop over serial port   *)
                                   (* and keyboard.                 *)
   REPEAT
                                   (* Pick up and display character *)
                                   (* from port, if any.            *)

      IF Async_Receive( Ch ) THEN
         IF ( Ch <> CHR( 0 ) ) THEN
           case Ch of
              #20:write(#8' '#8);
              #59:skey(#59);
              #28:textcolor(4);
              #30:textcolor(2);
              #31:textcolor(1);
             #144:textcolor(15);
             #156:textcolor(13);
             #158:textcolor(14);
             #159:textcolor(11);
              #18:textbackground(15);
             #146:textbackground(0);
               #5:textcolor(15);
              #13:writeln;
              #15:write(' ');
             #176:write('');
             #174:write('');
             #173:write('');
             #189:write('');
             #177:write('');
             #178:write('');
             #179:write('');
             #171:write('');
             #166:write('');
             #129:textcolor(5);
             #150:textcolor(12);
             #149:textcolor(6);
             #151:textcolor(7);
             #152:textcolor(15);
             #153:textcolor(10);
             #154:textcolor(9);
             #155:textcolor(15);
             #147:clrscr;
             #148:write(#8);
              #10:write;
             #162:write('');
             #164:write('_');
             #161:write('');
             #180:write('');
             #181:write('');
             #182:write('');
             #175:write('');
             #184:write('');
             #185:write('');
             #183:write('');
             #168:write('');
             #167:write('');
             #165:write('');
             #163:write('');
             #124:write('');
             #125:write('');
              #96:write('');
             #123:write('');
             #160:write(' ');
             #192:write('');
             #193:write('A');
             #194:write('B');
             #195:write('C');
             #196:write('D');
             #197:write('E');
             #198:write('F');
             #199:write('G');
             #200:write('H');
             #201:write('I');
             #202:write('J');
             #203:write('K');
             #204:write('L');
             #205:write('M');
             #206:write('N');
             #207:write('O');
             #208:write('P');
             #209:write('Q');
             #210:write('R');
             #211:write('S');
             #212:write('T');
             #213:write('U');
             #214:write('V');
             #215:write('W');
             #216:write('X');
             #217:write('Y');
             #218:write('Z');
             #219:write('');
             #220:write('');
             #221:write('');
             #222:write('');
             #223:write('');
             #232:write('');
             #188:write('');
             #190:write('');
             #191:write('');
             #186:write('');
             #187:write('');
             #172:write('');
             #127:write('');
             #169:write('');
             #160:write(' ');
             #233:write('');
             #224:write(' ');
             #225:write('');
             #226:write('');
             #227:write('');
             #228:write('');
             #229:write('');
             #230:write('');
             #231:write('');
             #232:write('');
             #233:write('');
             #234:write('');
             #235:write('');
             #236:write('');
             #237:write('');
             #238:write('');
             #239:write('');
             #240:write('');
             #241:write('');
             #242:write('');
             #243:write('');
             #244:write('');
             #245:write('');
             #246:write('');
             #247:write('');
             #248:write('');
             #249:write('');
             #250:write('');
             #251:write('');
             #252:write('');
             #253:write('');
             #254:write('');
             #170:write('');
            else
           WRITE( Ch );
         end;
                                   (* Read character from keyboard  *)
                                   (* and send out port, unless it  *)
                                   (* is ^B or ^C.                  *)
                                   (* ^B -- send a break            *)
                                   (* ^C -- quit                    *)
      IF KeyPressed THEN
         BEGIN
            READ( Kbd, KCh );
            CASE KCh OF
               ^B: Async_Send_Break;
               ^C: ;
               #8: Async_Send(#20);
               ELSE
                  Async_Send( Kch );
            END (* CASE *);
         END;

   UNTIL ( Kch = ^C );

END   (* Emulate_Dumb_Terminal *);

(*--------------------------------------------------------------------------*)

PROCEDURE Finish_Communications;

BEGIN (* Finish_Communications *)
                                   (* Close port and drop DTR *)
   Async_Close( TRUE );
                                   (* Release space allocated for buffers *)
   Async_Release_Buffers;

END   (* Finish_Communications *);

(*--------------------------------------------------------------------------*)

BEGIN (* DumbTrm *)

                                   (* Request serial port parameters     *)
   Get_Comm_Params;
                                   (* Initialize port                    *)

   IF Initialize_Communications THEN
      BEGIN
                                   (* Emulate dumb terminal until ^C hit *)
         Emulate_Dumb_Terminal;
                                   (* Close down port                    *)
         Finish_Communications;

      END;

END   (* DumbTrm *).