// this might look like 'C', but it's really  -*-c++-*-
/* cfged.cc
 *
 * Implementation of class MyWindow and main function for CFGED
 *
 * Language        : C++
 * Operating System: OS/2 V2.0 and higher
 * Compiler        : GNU GCC V2.1 and higher
 *
 *
 * $Id: cfged.cc,v 1.1 1992/07/17 00:23:27 gruen Exp $
 * $Log: cfged.cc,v $
// Revision 1.1  1992/07/17  00:23:27  gruen
// Initial revision
//
 *
 * Copyright (c) 1992 Lutz Grueneberg
 *
 * This library is free software; you can redistribute it and/or modify
 * it under the terms of the GNU Library General Public License as
 * published by the Free Software Foundation; either version 2 of the
 * License, or (at your option) any later version.  This library is
 * distributed in the hope that it will be useful, but WITHOUT ANY WARRANTY;
 * without even the implied warranty of MERCHANTABILITY or FITNESS FOR
 * A PARTICULAR PURPOSE.  See the GNU Library General Public License for
 * more details. You should have received a copy of the GNU Library
 * General Public License along with this library; if not, write to the
 * Free Software Foundation, 675 Mass Ave, Cambridge, MA 02139, USA.
 */
#define INCL_WIN
#include <os2.h>
#include <Regx.h>
#include <Strng.h>
#include <pmviews/session.h>
#include <pmviews/window.h>
#include <pmviews/dialog.h>
#include <pmviews/controls.h>

#include "pmctool.h"
#include "cfged.h"
#include "maindlg.h"
#include "cfgfile.h"
#include "lbmain.h"
#include "about.h"

MainBrowserDlg    *pMainBrowser;


class MyWindow: public StdWindow {
public:
  MyWindow( Session *ps,           /* Konstruktor der Klasse */
	   USHORT  idRes);
  virtual MRESULT msgClose( HWND hwnd, USHORT msg, 
			   MPARAM mp1, MPARAM mp2, BOOL *fDoDefault);
  virtual MRESULT msgCommand( HWND hwnd, USHORT msg, 
			     MPARAM mp1, MPARAM mp2, BOOL *fDoDefault);
  virtual MRESULT msgPaint( HWND hwnd, USHORT msg, 
			   MPARAM mp1, MPARAM mp2, BOOL *fDoDefault);
  VOID browseVariable( MainBrowserDlg *pDlg, Regex* pr);
};

  MyWindow::MyWindow( Session *ps, USHORT  idRes)
:( ps, idRes) {}

MRESULT MyWindow::msgClose(HWND hwnd, USHORT msg, 
		     MPARAM mp1, MPARAM mp2, BOOL *fDoDefault)
{
  if( PmUserRequest
     ( HWND_DESKTOP, 
      "Do you really want to exit the OS/2 configuration editor?"))
    *fDoDefault = TRUE;
  else
    *fDoDefault = FALSE;
  return 0;
}

MRESULT MyWindow::msgCommand(HWND hwnd, USHORT msg, 
		     MPARAM mp1, MPARAM mp2, BOOL *fDoDefault)
{
  if( SHORT1FROMMP( mp2) == CMDSRC_MENU) {   
    switch (SHORT1FROMMP(mp1)) {   
    case IDM_OPEN:		// Save Menu selected
      pMainBrowser->loadCfgList();
      *fDoDefault = FALSE;
      return 0;

    case IDM_EXIT:
      WinPostMsg( hwnd, WM_CLOSE, 0L, 0L);
      return 0;

    case IDM_SAVE:		// Save Menu selected
      pMainBrowser->saveCfgList();
      *fDoDefault = FALSE;
      return 0;

    case IDM_ABOUT:		// OK Button Pressed
      AboutDlg about( this, ABOUT_DLG);
      about.create();		// blocks until OK
      *fDoDefault = FALSE;
      return 0;

    case IDM_PATH:		// Browse Path button pressed
      {
	Regex rp( "\\(SET[ \n\t]+PATH[ \n\t]*=\\)");
	browseVariable( pMainBrowser, &rp);
      }
      *fDoDefault = FALSE;
      return 0;

    case IDM_DPATH:		// Browse DataPath button pressed
      {
	Regex rp( "\\(SET[ \n\t]+DPATH[ \n\t]*=\\)");
	browseVariable( pMainBrowser, &rp);
      }
      *fDoDefault = FALSE;
      return 0;

    case IDM_LIBPATH:		// Browse LibraryPath button pressed
      {
	Regex rp( "\\(LIBPATH[ \n\t]*=\\)");
	browseVariable( pMainBrowser, &rp);
      }
      *fDoDefault = FALSE;
      return 0;
    }
  }
  return 0;
}
MRESULT MyWindow::msgPaint(HWND hwnd, USHORT msg, 
			   MPARAM mp1, MPARAM mp2, BOOL *fDoDefault)
{
  /* paint the window */
  RECTL    INVLDRECT;

  HPS hPresSp = WinBeginPaint (hwnd, NULL, NULL);
  WinQueryWindowRect (hwnd, &INVLDRECT);
  WinFillRect (hPresSp, &INVLDRECT, CLR_BACKGROUND);
  WinEndPaint (hPresSp);

  *fDoDefault = FALSE;
  return 0;
}

VOID MyWindow::browseVariable( MainBrowserDlg *pDlg, Regex *pr)
{
  String str;
  SHORT  j;
  Pix    i;

  for(i = pDlg->cfile.strList.last(), j = pDlg->cfile.strList.length() - 1;
      i != 0 && j >= 0;
      pDlg->cfile.strList.prev(i), j--) {
    str = pDlg->cfile.strList(i); // copy entry
    str = upcase( str);		  // set upcase
    if( str.contains( *pr)) {
      // browse entry
      pDlg->browseEntry( j);
      pDlg->cfile.printToListBox( pDlg->plbMain);
      pDlg->setState(0);
      break;
    }
  }
}

MyWindow          *pSW;


int     main (int       argc,
              char *    argv[])
{
  Session   ms;

  pSW          = new MyWindow( &ms, ID_RESOURCE);

  pSW->setFlags( FCF_TITLEBAR | FCF_TASKLIST |
		FCF_DLGBORDER| FCF_SHELLPOSITION |
		FCF_MINBUTTON| FCF_SYSMENU |
		FCF_MENU);
  pSW->setStyle( FS_STANDARD);
  pSW->setTitle( "OS/2 configuration editor");
  pSW->create();
  pMainBrowser = new MainBrowserDlg( pSW, MAIN_BROWSER, pSW->queryHwnd());
  pMainBrowser->load();
  ms.run();
  pSW->destroy();
}

