// this might look like 'C', but it's really  -*-c++-*-
/* lbmain.cc
 *
 * Implementation of class MainBrowserDlg for CFGED
 *
 * Language        : C++
 * Operating System: OS/2 V2.0 and higher
 * Compiler        : GNU GCC V2.1 and higher
 *
 *
 * $Id: lbmain.cc,v 1.1 1992/07/17 00:23:31 gruen Exp $
 * $Log: lbmain.cc,v $
// Revision 1.1  1992/07/17  00:23:31  gruen
// Initial revision
//
 *
 * Copyright (c) 1992 Lutz Grueneberg
 *
 * This library is free software; you can redistribute it and/or modify
 * it under the terms of the GNU Library General Public License as
 * published by the Free Software Foundation; either version 2 of the
 * License, or (at your option) any later version.  This library is
 * distributed in the hope that it will be useful, but WITHOUT ANY WARRANTY;
 * without even the implied warranty of MERCHANTABILITY or FITNESS FOR
 * A PARTICULAR PURPOSE.  See the GNU Library General Public License for
 * more details. You should have received a copy of the GNU Library
 * General Public License along with this library; if not, write to the
 * Free Software Foundation, 675 Mass Ave, Cambridge, MA 02139, USA.
 */
#define INCL_PM
#include <os2.h>
#include <stdio.h>
#include <stdlib.h>
#include <unistd.h>
#include <pmviews/pmviews.h>
#include "cfgfile.h"
#include "lbmain.h"
#include "maindlg.h"
#include "prompter.h"
#include "pmctool.h"
#include "sbrowser.h"

     MainBrowserDlg::MainBrowserDlg( StdWindow *pStdWindow, 
				    USHORT  idResNew,
                                    HWND hwndParentNew=HWND_DESKTOP)
:( pStdWindow, idResNew, hwndParentNew) {
	      
  plbMain = new ListBox( this, MAIN_LB);
  pbtEdit   = new CntrlWindow( this, EDIT_BUTT);
  pbtBrowse = new CntrlWindow( this, BROWSE_BUTT);
  pbtInsert = new CntrlWindow( this, INSERT_BUTT);
  pbtAppend = new CntrlWindow( this, APPEND_BUTT);
  pbtDelete = new CntrlWindow( this, DELETE_BUTT);
  pLdCfgDlg = NULL;
}

VOID MainBrowserDlg::setState( int stateNew) {
  switch( stateNew) {
  case 0: 	
    plbMain->enable( TRUE);
    pbtEdit->enable( FALSE);
    pbtBrowse->enable( FALSE);
    pbtInsert->enable( FALSE);
    pbtAppend->enable( FALSE);
    pbtDelete->enable( FALSE);
    break;

  case 1:
    plbMain->enable( TRUE);
    pbtEdit->enable( TRUE);
    pbtBrowse->enable( TRUE);
    pbtInsert->enable( TRUE);
    pbtAppend->enable( TRUE);
    pbtDelete->enable( TRUE);
    break;
  }
}

VOID MainBrowserDlg::loadCfgList( VOID){
  /* query the right CONFIG.SYS */
  if( !pLdCfgDlg) 
    pLdCfgDlg = new LoadConfigDlg( queryOwnerWindow(), LDCFG_DLG);
  pLdCfgDlg->create();
  /* read the CONFIG.SYS */
  cfile.read( (char*)(*(pLdCfgDlg->pSelected)));
  cfile.printToListBox( plbMain);
  setState(0);
}

VOID MainBrowserDlg::saveCfgList( VOID){
  CHAR   szBuf[300];
  String str("c:\\config.old");

  sprintf( szBuf, "%s%s%s%s",
	  "Do you really want to save the actual configuration ",
	  "to the file '",
	  (char*)(*(pLdCfgDlg->pSelected)),
	  "'?");
  if( PmUserRequest( HWND_DESKTOP, szBuf)) {
    str[0] = (*(pLdCfgDlg->pSelected))[0];
    cfile.save( (char*)(*(pLdCfgDlg->pSelected)), (char*)str);
    sprintf( szBuf, "%s%s%s%s%s%s", 
	    "The actual configuration was stored to the file '",
	    (char*)(*(pLdCfgDlg->pSelected)),
	    "'.\nThe old configuration was saved to the file '",
	    (char*)str,
            "'.\nThe changed version of the configuration takes",
	    "affect after the next shutdown!");
    PmUserMessage( HWND_DESKTOP, szBuf);
  }

  cfile.printToListBox( plbMain);
  setState(0);
}

VOID MainBrowserDlg::editEntry( VOID)
{ SHORT iSelect;
  SHORT iTopIndex;
  
  PrompterDlg Prompter( queryOwnerWindow(), PR_DLG);
  String test = "Hallo";
  CHAR   *szComment="Edit the line, press OK to accept the change.";
  iTopIndex = plbMain->queryTopIndex();
  // find the selected line
  Prompter.setString
    (cfile.retrieve(iSelect=plbMain->querySelection( LIT_NONE)));
  Prompter.setComment( szComment);
  Prompter.create();
  cfile.printToListBox( plbMain);
  plbMain->setTopIndex( iTopIndex);
  plbMain->selectItem( iSelect, TRUE);
  setState( 1);
}


VOID MainBrowserDlg::browseEntry( SHORT iItem)
{ String    *pString;
  StrDLList strList;
  String    strgComment;
  String    strgRemainer;
  String*   pstrgTemp;
  BOOL      fSemicolon = FALSE;

  // build list
  pString = cfile.retrieve( iItem);
  // verify browsability
  if( !pString->contains( "=")) {
    PmUserMessage( HWND_DESKTOP, 
		  "This entry can't be browsed.\nUse EDIT instead!");
    return;
  }
  strgComment  = pString->before( "=");
  strgRemainer = pString->after( "=");
  while( strgRemainer.contains( ";")){
    pstrgTemp = new String( strgRemainer.before( ";"));
    strList.append( *pstrgTemp);
    strgRemainer = strgRemainer.after( ";");
  }
  if( strgRemainer.length()) {
    pstrgTemp = new String( strgRemainer);
    strList.append( *pstrgTemp);
  }
  else fSemicolon = TRUE;
  // display Dialog
  SingleBrowser sb( queryOwnerWindow(), SB_DLG, "SingleBrowser",
		   (char*)strgComment, &strList);
  sb.create();
  // assemble string
  *pString = strgComment;
  *pString += "=";
  for(Pix i = strList.first();
      i != 0;
      strList.next(i)) {
    if( i != strList.first()) *pString += ";";
    *pString += strList(i);
  }
  if( fSemicolon) *pString+=';';
}
    
MRESULT MainBrowserDlg::msgInitDlg( HWND hwnd, USHORT msg, 
				   MPARAM mp1, MPARAM mp2, BOOL *fDoDefault) {
  SIZEL     sizl;
  POINTL    ptl = {0,0};
  StdWindow *pSW;
  
  /* SetUp the position */
  pSW = queryOwnerWindow();
  pSW->show( TRUE);		// display the complete window
  querySize( &sizl);
  pSW->setClientSize( &sizl);
  setPos( &ptl);
  pSW->setFramePos( &ptl);
  /* loadCfgList to ListBox */
  loadCfgList();
  return 0;
}

MRESULT MainBrowserDlg::msgControl( HWND hwnd, USHORT msg, 
				   MPARAM mp1, MPARAM mp2, BOOL *fDoDefault) {
  USHORT usID;

  usID = SHORT1FROMMP(mp1);

  switch (SHORT2FROMMP(mp1)) {   
  case LN_ENTER:  /* Auswahl eines Item oder Double-Click */
    editEntry();
    *fDoDefault = FALSE;
    return 0;

  case LN_SELECT: /* selection of a item of the list */
    setState( 1);
    *fDoDefault = 0;
    return 0;
  }
  return 0;
}

// this method reacts on the click to buttons
MRESULT MainBrowserDlg::msgCommand( HWND hwnd, USHORT msg, 
				   MPARAM mp1, MPARAM mp2, BOOL *fDoDefault) {
  if( SHORT1FROMMP( mp2) == CMDSRC_PUSHBUTTON) {   
    switch (SHORT1FROMMP(mp1)) {   
    case EDIT_BUTT:		// OK Button Pressed
      editEntry();
      *fDoDefault = FALSE;
      return 0;               
   
    case BROWSE_BUTT:		// OK Button Pressed
      { SHORT iSelect;
	SHORT iTopIndex;

	iTopIndex = plbMain->queryTopIndex();
	browseEntry( iSelect = plbMain->querySelection( LIT_NONE));
	cfile.printToListBox( plbMain);
	plbMain->setTopIndex( iTopIndex);
	plbMain->selectItem( iSelect, TRUE);
	setState(1);
      }
      *fDoDefault = FALSE;
      return 0;

    case INSERT_BUTT:		// INSERT Button pressed
      {	PrompterDlg Prompter( queryOwnerWindow(), PR_DLG);
	SHORT i = plbMain->querySelection( LIT_NONE);// retrieve active Element
	String strNew = "";
	Prompter.setString( &strNew);
	Prompter.setComment( "Enter new property:");
	Prompter.create();
	if( strNew.length()){
	  String *pStrg = new String( strNew);
	  cfile.strList.ins_before( (Pix)(cfile.retrievePix( i)), *pStrg);
	}
	SHORT j = plbMain->queryTopIndex();
	cfile.printToListBox( plbMain);
	plbMain->setTopIndex(j);
	plbMain->selectItem( i, TRUE);
      }
      *fDoDefault = FALSE;
      return 0;

    case APPEND_BUTT:
      // First this was implemented as an append at the end of the list.
      // But this wasn't intuitive and so I've changed it. Now append means
      // an insertion of an item after the actual one.
      {	PrompterDlg Prompter( queryOwnerWindow(), PR_DLG);
	SHORT i = plbMain->querySelection( LIT_NONE);// retrieve active Element
	String strNew = "";
	Prompter.setString( &strNew);
	Prompter.setComment( "Enter new property:");
	Prompter.create();
	if( strNew.length()){
	  String *pStrg = new String( strNew);
	  cfile.strList.ins_after( (Pix)(cfile.retrievePix( i)), *pStrg);
	  SHORT j = plbMain->queryTopIndex();
	  cfile.printToListBox( plbMain);
	  plbMain->setTopIndex(j);
	  plbMain->selectItem( i+1, TRUE);
	} else {
	  SHORT j = plbMain->queryTopIndex();
	  cfile.printToListBox( plbMain);
	  plbMain->setTopIndex(j);
	  plbMain->selectItem( i, TRUE);
	}
      }
      *fDoDefault = FALSE;
      return 0;

    case DELETE_BUTT:
      {	SHORT iTopIndex;

	iTopIndex = plbMain->queryTopIndex();
	SHORT i = plbMain->querySelection( LIT_NONE); // retrieve active
	Pix p = i ? (Pix)cfile.retrievePix(i-1) : NULL;
	cfile.strList.del_after( p);
	cfile.printToListBox( plbMain);
	plbMain->setTopIndex( iTopIndex);
	setState(0);
      }
      *fDoDefault = FALSE;
      return 0;
    }
  }
  return 0;
}

