/*
	MR/2 - UNQWK.CMD

	Author: 	Nick Knight
	Created:	03/26/93
	Usage:		unqwk packet.qwk
	Purpose:	Unqwk.cmd will analyze the file named as a parameter.
				It will check the file for a valid archiver signiture
				and branch to an appropriate unarchiving command.  This
				file, as is, should accomodate most existing QWK packet
				archivers.	This utility is easily extensible, either
				by the original author, or by anyone with an urge to
				tinker.

	This was my first REXX program.  I'm sure it will be enhanced and
	extended ... and I'm sure there are plenty of inefficiencies.  Feel
	free to provide me with pointers, or just send me a copy of any
	improvements/enhancements.

	The author claims no copyright to this particular REXX script.
	Feel free to copy it and/or use it for other purposes.	I *would*
	like to see the results of any improvements to it.

	US Mail:	Nick Knight, 1823 David Ave.,  Parma, Ohio 44134
	Fidonet:	1:157/2 or 1:/157/200
	Internet:	nick.knight@pcohio.com
	Compuserve: 76066,1240
	BBS:		Private messages on Nerd's Nook, 356-1772 or 356-1872
*/

/***********************************************************************/
/*		A R C H I V E R 	C O M M A N D	 D E F I N I T I O N S	   */
/***********************************************************************/
/*	To add support for a new unpacker, simply supply a new command
	definition here.  The file name to unpack will be appended to
	the end of the supplied command.  You can customize in more detail
	by modifying the code directly, if need be.
*/

/*path = 'c:\utility\'*/
path = ''

zip_command =	'pkunzip -o'
arj_command =	'arj x'
zoo_command =	'zoo x'
lharc_command = 'lha x'
lha_command =	'lh x'
arc_command =	'arc x'


/***********************************************************************/
/*					U N Q W K	 F I L E N A M E					   */
/***********************************************************************/
/*
	Returns -1 if it the file appears not to be a packed "archive".
	Returns -2 if the file doesn't exist
	Otherwise, the "archive_id" is returned (1 -> 6).
*/

parse arg filename

/*
  06/10/93 - Check for long file name - copy to 'shorter' 8.3 name for packer
*/

flongname = length(filename) - lastpos('\',filename) - 12
if flongname < 0 then do
	flongname = length(filename) - pos('.',filename) - 3
end
if flongname > 0 then do
	'copy "'filename'" MR2$TMP.QWK'
	filename = 'MR2$TMP.QWK'
	flongname = 1
end

if stream(filename,'c','query exists') = "" then do
	return -2
end

	/*
	Book says file is open in read/write by default.  This worried me,
	although my tests proved that the file's datestamp remained unchanged.
	Just to be safe, I wanted to open the file in read-only mode.
	*/
status = stream(filename,'c','open read')           /* read only */
header = charin(filename,1,16)

	/*	If it doesn't have at least 16 chars, it probably isn't real */
if chars(filename) = 0 then do
	status = stream(filename,'c','close')
    return -1
end

status = stream(filename,'c','close')       /* Close the file - Important! */

archiver_id = which_archiver(header)		/* call analyzer function, below */

select										/* execute the corresponding command */
	when archiver_id = -1 then do
		say "UNKNOWN ARCHIVE TYPE: " filename
		return -1
	end
	when archiver_id = 1 then path || zip_command '"'||filename'"'
	when archiver_id = 2 then path || arj_command filename
	when archiver_id = 3 then path || zoo_command filename
	when archiver_id = 4 then path || lharc_command filename
	when archiver_id = 5 then path || lha_command filename
	when archiver_id = 6 then path || arc_command filename
	otherwise
end

if RC <> 0 then return RC

idfile = "archiver.id"                      /* important for packing replies */
status = lineout(idfile,archiver_id,1)		/* record unpacker id so */
status = lineout(idfile)					/* compatible packer can be used */

if flongname > 0 then
	'del MR2$TMP.QWK'

return archive_id							/* return the ID type */


/***********************************************************************/
/*				   W H I C H	 A R C H I V E R					   */
/***********************************************************************/
/*
	Returns -1 if it can't tell, otherwise it returns the archiver id
	that I've assigned to the ones I know about.  Others can be easily
	added.	Some of this may not be correct (lha vs lharc), but I tested
	as much of it as I could.  Looks OK.
*/

which_archiver:

parse arg header				/* header is the first 16 bytes of file */

select
	when substr(header,1,2) = "PK" then id = 1              /* PKWare */
	when substr(header,1,1) = '`' && substr(header,2,1) = '\xEA' then id = 2 /* ARJ */
	when substr(header,1,3) = "ZOO" then id = 3             /* ZOO */
	when substr(header,3,5) = "-lh0-" then id = 4           /* LHARC */
	when substr(header,3,5) = "-lh1-" then id = 4           /* LHARC */
	when substr(header,3,3) = "-lh" then id = 5             /* LHA */
	when c2d(substr(header,1,1)) = 26 then id = 6			/* ARC */
	otherwise
		id = -1 			/* Archiver unknown or not an archive */
end

return id


