/* INSTALL Version 1.0 (c) Bernd Wetzel 1993                                  */
/* procedure to install PM Diskcopy on the harddisk                           */
CALL RxFuncAdd 'SysLoadFuncs', 'RexxUtil', 'SysLoadFuncs'
CALL SysLoadFuncs 

title = 'Installation of PM Diskcopy'
targetpath = 'C:\PMDSKCPY'
file.0 = 5
file.1 = 'PMDSKCPY.EXE'
file.2 = 'PMDSKCPY.HLP'
file.3 = 'README.DOC'
file.4 = 'HISTORY.DOC'
file.5 = 'REGISTER.DOC'

/* Intro, ask where to install PM Diskcopy                                    */
CALL SysCls
SAY 
SAY '[36m'title'[0;0m'
SAY 'By default PM Diskcopy will be installed to' targetpath'.'
SAY 'Enter "Y" to confirm, "N" to exit or enter a new path (e.g. D:\TOOLS) where PM Diskcopy should be installed.'
SAY 'Press <ENTER> when ready.'
PULL answer .
IF (answer <> 'Y') THEN DO
  IF (answer = 'N') THEN EXIT 1
  targetpath = answer
END

/* Check for all the files in the current directory                           */
filemissing = 0
DO i = 1 TO file.0
  search = file.i
  sysrc = SysFileTree(search, ret, 'FO')
  IF (ret.0 = 0 | sysrc <> 0) THEN DO
    SAY file.i 'is missing in the current directory'
    filemissing = 1
  END
END
IF filemissing = 1 THEN DO
  EXIT 1
END

/* Now create the target directory                                            */
sysrc = SysMkDir(targetpath)
IF (sysrc <> 0) THEN DO
  SAY 'Directory' targetpath 'could not be created !'
  IF (sysrc = 5) THEN SAY 'Directory already exists !'
  SAY title 'will be terminated.'
  EXIT 3
END

/* Now copy all the files to the target directory                             */
SAY 'PM Diskcopy will be installed to 'targetpath' ...'
DO i = 1 TO file.0
  target = targetpath || '\' || file.i
  '@COPY' file.i '/B' target '/V >nul 2>nul'
  IF (rc <> 0) THEN DO
    SAY 'File' file.i 'could not be copied to' targetpath '!'
    SAY title 'will be terminated.'
    EXIT 3
  END
END

/* Now create an object on the desktop                                        */
SAY 'PM Diskcopy will be created as object on the desktop ...'
sysrc = SysCreateObject('WPProgram','PM Diskcopy','<WP_DESKTOP>','EXENAME='|| targetpath || '\' || file.1';PROGTYPE=PM;STARTUPDIR='||targetpath)
IF (sysrc <> 1) THEN DO
  SAY 'Object could not be created on the desktop !'
  SAY title 'will be terminated.'
  EXIT 4
END

SAY 'PM Diskcopy was successfully installed to 'targetpath'.'
EXIT 0
