/*------------------------------------------------------------------
 * killsock.cmd :
 *------------------------------------------------------------------
 * 08-05-92 originally by Patrick J. Mueller
 *------------------------------------------------------------------*/

/*------------------------------------------------------------------
 * get parameters
 *------------------------------------------------------------------*/
parse arg socks

if (socks = "") | (socks = "?") then
   Usage()

/*------------------------------------------------------------------
 * load function package
 *------------------------------------------------------------------*/
if RxFuncQuery("SockLoadFuncs") then
   do
   rc = RxFuncAdd("SockLoadFuncs","RxSock","SockLoadFuncs")
   rc = SockLoadFuncs()
   end

/*------------------------------------------------------------------
 * close each socket
 *------------------------------------------------------------------*/
do i = 1 to words(socks)
   sock = word(socks,i)

   if datatype(sock,"W") then
      say "closing" right(sock,5) ":" SockSoClose(sock)
   else
      say sock "is not a valid socket number."
end

exit

/*------------------------------------------------------------------
 * some simple help
 *------------------------------------------------------------------*/
Usage: procedure
   parse source . . me .
   parse value filespec("name",me) with me "." .

   say "usage:"
   say "   " me "<socket> <socket> ..."
   say "is used to close sockets passed as parameters"
   say
   say "where:"
   say "   <socket> - decimal socket number to close"
   say
   say "Convenient for closing sockets after running netstat -s for"
   say "misbehaving applications"

   exit
