/*------------------------------------------------------------------
 * rnr.cmd :
 *------------------------------------------------------------------
 * 08-09-92 originally by Patrick J. Mueller
 *------------------------------------------------------------------*/

trace off

parse arg server .

if (server = "") then
   do
   say "Expecting a news server name to be passed as a parameter."
   exit 1
   end

/*------------------------------------------------------------------
 * initialize socket function package
 *------------------------------------------------------------------*/
if RxFuncQuery("SockLoadFuncs") then
   do
   rc = RxFuncAdd("SockLoadFuncs","RxSock","SockLoadFuncs")
   rc = SockLoadFuncs()
   end

/*------------------------------------------------------------------
 * get address of server
 *------------------------------------------------------------------*/
rc = SockGetHostByName(server,"host.!")
if (rc = 0) then
   do
   say "Unable to resolve server name" server
   exit
   end

server = host.!addr

/*------------------------------------------------------------------
 * open socket
 *------------------------------------------------------------------*/
sock = SockSocket("AF_INET","SOCK_STREAM",0)
if (sock = -1) then
   do
   say "Error opening socket:" errno
   exit
   end

/*------------------------------------------------------------------
 * connect socket
 *------------------------------------------------------------------*/
server.!family = "AF_INET"
server.!port   = 119
server.!addr   = server

rc = SockConnect(sock,"server.!")
if (rc = -1) then
   Error(sock,rc,"Error connecting to newsserver :" errno)

trc = GetResponse(sock)
do i = 1 to line.0
   say line.i
end

rc = Interact(sock)

/*------------------------------------------------------------------
 * quittin' time!
 *------------------------------------------------------------------*/
rc = SendMessage(sock,"quit")
rc = SockSoclose(sock)

exit

/*------------------------------------------------------------------
 * get command and execute in a loop
 *------------------------------------------------------------------*/
Interact:        procedure expose !.
   sock = arg(1)

   do forever
      say "Enter rn command (or quit)"
      parse pull command

      if ("QUIT" == translate(command)) then
         leave

      if ("HELP" == translate(command)) then
         do
         rc = Help()
         iterate
         end

      if ("" = command) then
         iterate

      trc = SendMessage(sock,command)
      trc = GetResponse(sock)

      do i = 1 to line.0
         say line.i
      end

   end

   return ""

/*------------------------------------------------------------------
 * help
 *------------------------------------------------------------------*/
Help: procedure
   say "commands:"
   say
   say "quit    - to quit"
   say "group   - to change to a particular group"
   say "article - to see an article"
   say
   return ""

/*------------------------------------------------------------------
 * get a response from the server
 *------------------------------------------------------------------*/
GetResponse:     procedure expose !. line.
   sock = arg(1)

   moreids = "100 215 220 221 222 223 230 231"

   line.0 = 1
   line.1 = GetResponseLine(sock)

   parse var line.1 rid .

   if (wordpos(rid,moreids) = 0) then
      return ""

   do forever
      o = line.0 + 1

      line.o = GetResponseLine(sock)

      if (line.o = ".") then
         return ""

      line.0 = o
   end

   return ""

/*------------------------------------------------------------------
 * get a line from the server
 *------------------------------------------------------------------*/
GetResponseLine: procedure expose !.
   sock = arg(1)

   crlf = d2c(13) || d2c(10)

   if (symbol('!.buff') = "LIT") then
      !.buff = ""

   do while (pos(crlf,!.buff) = 0)
      rc = SockRecv(sock,"data",8000)
      !.buff = !.buff || data
   end

   p = pos(crlf,!.buff)

   line = substr(!.buff,1,p-1)
   !.buff = substr(!.buff,p+2)

   return line

/*------------------------------------------------------------------
 * send a string to the server
 *------------------------------------------------------------------*/
SendMessage:     procedure expose !.
   sock = arg(1)
   data = arg(2) || d2c(13) || d2c(10)

   len = length(data)
   do while (len > 0)
      i = SockSend(sock,data);

      if (errno <> 0) then
         Error(-1,rc,"Error sending data to server.")

      if (i <= 0) then
         Error(sock,100,"Server closed the connection.")

      data = substr(data,len+1)
      len  = length(data)
   end

   return 0

/*------------------------------------------------------------------
 * halting ...
 *------------------------------------------------------------------*/
Halting:
   Error(sock,1,"error on line" sigl)

/*------------------------------------------------------------------
 * exit with a message and return code
 *------------------------------------------------------------------*/
Error: procedure
   sock = arg(1)
   retc = arg(2)
   msg  = arg(3)

   if (sock <> -1) then
      rc = SockSoClose(sock)

   say msg

   exit retc

