/*------------------------------------------------------------------
 * test_c.cmd :
 *------------------------------------------------------------------
 * 08-05-92 originally by Patrick J. Mueller
 *------------------------------------------------------------------*/

trace off

/*------------------------------------------------------------------
 * get server name
 *------------------------------------------------------------------*/
parse arg server .

if (server = "?") then
   Usage()

if (server = "") then
   server = SockGetHostId()

else
   do
   rc = SockGetHostByName(server,"host.!")
   if (rc = 0) then
      do
      say "Error" h_errno "calling SockGetHostByName("server")"
      exit
      end

   server = host.!addr;
   end

/*------------------------------------------------------------------
 * choose port number
 *------------------------------------------------------------------*/
port = 923

/*------------------------------------------------------------------
 * load function package
 *------------------------------------------------------------------*/
if RxFuncQuery("SockLoadFuncs") then
   do
   rc = RxFuncAdd("SockLoadFuncs","RxSock","SockLoadFuncs")
   rc = SockLoadFuncs()
   end

/*---------------------------------------------------------------
 * open socket
 *---------------------------------------------------------------*/
socket  = SockSocket("AF_INET","SOCK_STREAM",0)
if (socket = -1) then
   do
   say "Error on SockSocket:" errno
   exit
   end

/*------------------------------------------------------------------
 * catch breaks
 *------------------------------------------------------------------*/
signal on halt

/*---------------------------------------------------------------
 * connect socket
 *---------------------------------------------------------------*/
server.!family = "AF_INET"
server.!port   = port
server.!addr   = server

rc = SockConnect(socket,"server.!")
if (rc = -1) then
   do
   say "Error on SockConnect:" errno
   exit
   end

/*------------------------------------------------------------------
 * get some data to send over
 *------------------------------------------------------------------*/
data = random(10000,99999)

say "Sending  '"data"' to  " server

/*------------------------------------------------------------------
 * send the data over
 *------------------------------------------------------------------*/
rc = time("r")
rc = SockSend(socket,data)
elapsed = time("e")

if (rc = -1) then
   do
   say "Error on SockSend:" errno
   exit
   end

/*------------------------------------------------------------------
 * receive the result from the server
 *------------------------------------------------------------------*/
rc = time("r")
rc = SockRecv(socket,"newData",length(data))
elapsed = elapsed + time("e")

if (rc = -1) then
   do
   say "Error on SockRecv:" errno
   exit
   end

/*------------------------------------------------------------------
 * print results
 *------------------------------------------------------------------*/
if (reverse(data) <> newData) then
   say "Unexpected results from the server: '"newData"'"

else
   do
   say "Received '"newData"' from" server "(successful!!)"
   say "Elapsed network transit time:" elapsed "seconds"
   end

/*------------------------------------------------------------------
 * close socket (and catch signals)
 *------------------------------------------------------------------*/
halt:

rc = SockSoClose(socket)
if (rc = -1) then
   do
   say "Error on SockSoClose:" errno
   exit
   end

exit

/*------------------------------------------------------------------
 * some simple help
 *------------------------------------------------------------------*/
Usage: procedure
   parse source . . me .
   parse value filespec("name",me) with me "." .

   say "usage:"
   say "   " me "<server>"
   say "is used to run the rxSock tester"
   say
   say "where:"
   say "   <server> - tcp/ip host name running test_s (default = current host)"

   exit
