/*------------------------------------------------------------------
 * test_h.cmd :
 *------------------------------------------------------------------
 * 08-05-92 originally by Patrick J. Mueller
 *------------------------------------------------------------------*/

trace off

/*------------------------------------------------------------------
 * load socket functions, if needed
 *------------------------------------------------------------------*/
if RxFuncQuery("SockLoadFuncs") then
   do
   rc = RxFuncAdd("SockLoadFuncs","RxSock","SockLoadFuncs")
   rc = SockLoadFuncs()
   end

/*------------------------------------------------------------------
 * initialize sockets (not technically required)
 *------------------------------------------------------------------*/
if (1 = SockInit()) then
   do
   say "tcp/ip is not available."
   exit 1
   end

/*------------------------------------------------------------------
 * get current host address, and host info
 *------------------------------------------------------------------*/
addr = SockGetHostId()
rc   = SockGetHostByAddr(addr,"host.!")
name = host.!name

/*------------------------------------------------------------------
 * query information by name and by address
 *------------------------------------------------------------------*/
rc = SockGetHostByName(name,"name.!")
rc = SockGetHostByAddr(addr,"addr.!")

/*------------------------------------------------------------------
 * print name info
 *------------------------------------------------------------------*/
say "Info from name"
say "name:      " name.!name
say "addr type: " name.!addrtype
say "addr:      " name.!addr
say "aliases:   " name.!addr
do i = 1 to name.!alias.0
   say name.!alias.i
end

/*------------------------------------------------------------------
 * print host info
 *------------------------------------------------------------------*/
say
say "Info from addr"
say "name:      " addr.!name
say "addr type: " addr.!addrtype
say "addr:      " addr.!addr
say "aliases:   " addr.!addr
do i = 1 to addr.!alias.0
   say addr.!alias.i
end


