/*------------------------------------------------------------------
 * test_s.cmd :
 *------------------------------------------------------------------
 * 08-05-92 originally by Patrick J. Mueller
 *------------------------------------------------------------------*/

trace off

/*------------------------------------------------------------------
 * choose the port
 *------------------------------------------------------------------*/
port = 923

/*------------------------------------------------------------------
 * load the socket package, if needed
 *------------------------------------------------------------------*/
if RxFuncQuery("SockLoadFuncs") then
   do
   rc = RxFuncAdd("SockLoadFuncs","RxSock","SockLoadFuncs")
   rc = SockLoadFuncs()
   end

/*------------------------------------------------------------------
 * create the initial socket
 *------------------------------------------------------------------*/
s  = SockSocket("AF_INET","SOCK_STREAM",0)
if (s = -1) then
   do
   say "Error on SockSocket:" errno
   exit
   end

/*------------------------------------------------------------------
 * catch breaks
 *------------------------------------------------------------------*/
signal on halt

/*------------------------------------------------------------------
 * bind socket to port
 *------------------------------------------------------------------*/
server.!family = "AF_INET"
server.!port   = port
server.!addr   = "INADDR_ANY"

rc = SockBind(s,"server.!")
if (rc = -1) then
   do
   say "Error on SockBind:" errno
   exit
   end

/*------------------------------------------------------------------
 * set queue size
 *------------------------------------------------------------------*/
rc = SockListen(s,10)
if (rc = -1) then
   do
   say "Error on SockListen:" errno
   exit
   end

/*------------------------------------------------------------------
 * infinite loop to handle requests ...
 *------------------------------------------------------------------*/
do forever
   say "Waiting for client"

   /*---------------------------------------------------------------
    * accept a connection
    *---------------------------------------------------------------*/
   ns = SockAccept(s,"client.!")
   if (rc = -1) then
      do
      say "Error on SockAccept:" errno
      exit
      end

   /*---------------------------------------------------------------
    * get clients host name
    *---------------------------------------------------------------*/
   if SockGetHostByAddr(client.!addr,"host.!") then
      clientName = host.!name
   else
      clientName = "Unknown"

   say "Accepted client:" client.!addr clientName

   /*---------------------------------------------------------------
    * get peer host name
    *---------------------------------------------------------------*/
   rc = SockGetPeerName(ns,"peer.!")
   if (rc = -1) then
      do
      say "Error on SockGetPeerName:" errno
      exit
      end

   say "PeerName:" peer.!addr

   /*---------------------------------------------------------------
    * get socket host name
    *---------------------------------------------------------------*/
   rc = SockGetSockName(ns,"sock.!")
   if (rc = -1) then
      do
      say "Error on SockGetSockName:" errno
      exit
      end

   say "SockName:" sock.!addr

   /*---------------------------------------------------------------
    * receive data from client
    *---------------------------------------------------------------*/
   rc = SockRecv(ns,"data",1000)
   if (rc = -1) then
      do
      say "Error on SockRecv:" errno
      exit
      end

   say "Received:" data

   data = reverse(data)

   /*---------------------------------------------------------------
    * send data back
    *---------------------------------------------------------------*/
   rc = SockSend(ns,data)
   if (rc = -1) then
      do
      say "Error on SockSend:" errno
      exit
      end

   /*---------------------------------------------------------------
    * close the new socket from client
    *---------------------------------------------------------------*/
   rc = SockSoClose(ns)
   ns = ""
   if (rc = -1) then
      do
      say "Error on SockSoClose:" errno
      exit
      end

   say "Closing connection"
   say
end

/*------------------------------------------------------------------
 * handle break by closing sockets
 *------------------------------------------------------------------*/
halt:

say
say "Quitting ..."

rc = SockSoClose(s)

if datatype(ns,"W") then
   rc = SockSoClose(ns)

