/**********************************************/
/* SAVEFLDR.CMD                               */
/*                                            */
/* Created by GENDLG version 1.4              */
/*                                            */
/* 03/22/93 11:00:22                          */
/**********************************************/
Trace 'O'
Signal On Syntax
Signal On Halt
 
/**************/
/* Initialize */
/**************/
Parse source . . rexx_name
rexx_dir = Filespec('D',rexx_name)||Filespec('P',rexx_name)
If rexx_dir = '' Then rexx_dir = Directory()||'\'
__dlgs_active = ''
__dlgs_active_name = ''
__wait_active = 0
__dlgfile = rexx_dir||'SAVEFLDR.DLG'
If RxFuncQuery('SysLoadFuncs') Then Do
  Call RxFuncAdd 'SysLoadFuncs', 'REXXUTIL', 'SysLoadFuncs'
  Call SysLoadFuncs
End
If Rxfuncquery('dBoxMgr2') Then Call RxFuncAdd 'dBoxMgr2', 'dBoxMgr2', 'dBoxMgr2'
Call dBoxMgr2 'START'
If result = -1 Then Do
  Say 'dBoxMgr2 could not be started.'
  Call Endit 16
End
TRUE = 1
FALSE = 0
QUIT = FALSE
 
/******************/
/* Initialization */
/******************/
If RxFuncQuery('MyLoadFuncs') Then Do
  Call rxfuncadd myloadfuncs, myutil, myloadfuncs
  Call myloadfuncs
End

/****************************************/
/* Tell user that we are alive and well */
/****************************************/
Call Wait "Processing .INI files."

/**********************/
/* Get the debug flag */
/**********************/
debug = 0
Parse Arg argstring
If WordPos('/D',Translate(argstring)) > 0 Then Do
  debug = 1
  argstring = Subword(argstring,1,Wordpos('/D',Translate(argstring))-1)||Subword(argstring,Wordpos('/D',Translate(argstring))+1)
End
foldername = argstring

/**************/
/* Initialize */
/**************/
inifile = Value('USER_INI',,'OS2ENVIRONMENT')
sysinifile = Value('SYSTEM_INI',,'OS2ENVIRONMENT')
ver = '1.6'
oldver = SysIni(inifile,'SAVEFLDR','Version')
If oldver = 'ERROR:' Then Do
  cmddir = Substr(rexx_dir,1,Length(rexx_dir)-1)
  Call SysCreateObject 'WPProgram', 'Save Folder^Contents', '<WP_DESKTOP>', 'PROGTYPE=WINDOWABLEVIO;MINIMIZED=YES;CCVIEW=NO;EXENAME='||cmddir||'\SAVEFLDR.CMD;OBJECTID=<SAVE_FOLDER>;STARTUPDIR='||cmddir||';', 'R'
  Call SysIni inifile ,'SAVEFLDR','Version',ver
End
Else Do
  If ver <> oldver Then Call SysIni inifile ,'SAVEFLDR','Version',ver
End
dumpfile = 'SAVEFLDR.DAT'
cmdfile = 'MAKEFLDR.CMD'
If debug Then Do
  Call SysFileDelete dumpfile
  Call Lineout dumpfile, "Debugging information of SAVEFLDR version" ver "on" Date() Time()"."
  Call Lineout dumpfile, "Please send this file to 61804212 at VIEVMA."
  Call Stream dumpfile, 'C', 'CLOSE'
  '@SYSLEVEL >>'dumpfile
  Parse Version With rexxversion
  Call Lineout dumpfile, "Rexx version:" rexxversion
End

/*****************/
/* Get the nodes */
/*****************/
handlesapp = SysIni(sysinifile,'PM_Workplace:ActiveHandles', 'HandlesAppName')
If handlesapp = 'ERROR:' Then handlesapp = 'PM_Workplace:Handles'
block1 = ''
Do i = 1 to 999
  block = SysIni('SYSTEM', handlesapp, 'BLOCK'||i)
  If block = 'ERROR:' Then Do
    If i = 1 Then Do
      Say "Unable to locate the INODE table, you are probably using OS/2 without the Service Pack."
      Exit 8
    End
    Leave
  End
  block1 = block1||block
End
l = 0
nodes. = 0
i = 0
Do Until l >= Length(block1)
  If Substr(block1,l+5,4) = 'DRIV' Then Do
    xl = Pos('00'x||'NODE'||'01'x,block1,l+5)-l
    If xl <= 0 Then Leave
    l = l + xl
    Iterate
  End
  Else Do
    If Substr(block1,l+1,4) = 'DRIV' Then Do
      xl = Pos('00'x||'NODE'||'01'x,block1,l+1)-l
      If xl <= 0 Then Leave
      l = l + xl
      Iterate
    End
    Else Do
      data = Substr(block1,l+1,32)
      xl = C2D(Substr(block1,l+31,1))
      If xl <= 0 Then Leave
      data = data||Substr(block1,l+33,xl+1)
      l = l + Length(data)
    End
  End
  i = i + 1
  nodes.i = data
  If debug Then Call Hexdump data, dumpfile
End
nodes.0 = i

/*************************************************/
/* Get the name of the current desktop directory */
/*************************************************/
objnum = SysIni(inifile, 'PM_Workplace:Location', '<WP_DESKTOP>')
desktop = Getpath(Substr(objnum,1,2))

/****************************************/
/* Get the desktop directory file names */
/****************************************/
Call SysFileTree desktop||'\*', 'desk', 'DSO'
/**********************************/
/* Set the output data structures */
/**********************************/
out. = 0
Do i = 1 to desk.0
  f = Translate(desk.i)
  out.f = f
End
cmd. = 0
Do i = 1 to desk.0
  f = Translate(desk.i)
  cmd.f = f
End

/*****************************/
/* Get the association types */
/*****************************/
objtypes. = ''
Call SysIni inifile,'PMWP_ASSOC_TYPE', 'ALL:', 'types'
Do i = 1 to types.0
  objids = SysIni(inifile,'PMWP_ASSOC_TYPE', types.i)
  Do Forever
    If objids = '' Then Leave
    x = Pos('00'x,objids)
    objid = Substr(objids,1,x-1)
    If objtypes.objid <> '' Then objtypes.objid = objtypes.objid||','
    objtypes.objid = objtypes.objid||types.i
    objids = Substr(objids,x+1)
  End
End

/*******************************/
/* Get the association filters */
/*******************************/
filters. = ''
Call SysIni inifile,'PMWP_ASSOC_FILTER', 'ALL:', 'types'
Do i = 1 to types.0
  objids = SysIni(inifile,'PMWP_ASSOC_FILTER', types.i)
  Do Forever
    If objids = '' Then Leave
    x = Pos('00'x,objids)
    objid = Substr(objids,1,x-1)
    If filters.objid <> '' Then filters.objid = filters.objid||','
    filters.objid = filters.objid||types.i
    objids = Substr(objids,x+1)
  End
End

/******************************************/
/* Get the object id's of all WPS objects */
/******************************************/
Call SysIni inifile,'PM_Workplace:Location', 'ALL:', 'locs'
Do i = 1 to locs.0
  objnum = SysIni(inifile, 'PM_Workplace:Location', locs.i)
  locs.i = C2X(Substr(objnum,2,1)||Substr(objnum,1,1)) locs.i
End

/*********************/
/* Create the tables */
/*********************/
list. = 0
fldrfiles. = 0
Call Getname desktop, 0
fldrlist. = 0
fldrdirs. = 0
j = 0
Do i = list.0-1 to 1 by -1
  j = j + 1
  fldrlist.j = Substr(list.i,3)
  fldrdirs.j = fldrfiles.i
End
fldrlist.0 = j

If foldername <> '' Then Do
  Do i = 1 to fldrlist.0
    If foldername = fldrlist.i Then Do
      Call Processfolder fldrdirs.i, foldername
      Call SysFileDelete cmdfile
      Call Make_output
      Call Endit 0
    End
  End
End

/**************/
/* Main logic */
/**************/
Call Unwait
Call Process_dialog 'SAVEFLDR_DIALOG'

Call Endit 0
/*********************/
/* End of main logic */
/*********************/
 
/*************************************************/
/* Fill the fields of the SAVEFLDR_DIALOG dialog */
/*************************************************/
FILL_SAVEFLDR_DIALOG:
Call dBoxListFill SAVEFLDR_DIALOG, SAVEFLDR_LIST, 'fldrlist', LIT_END
dlg_field = SAVEFLDR_LIST   /* This is the field where the cursor will be */
Return 0
 
/*******************************************/
/* Process button SAVEFLDR_DIALOG_GENERATE */
/*******************************************/
SAVEFLDR_DIALOG_GENERATE:
loopi = Dboxquerylistindex(SAVEFLDR_DIALOG, SAVEFLDR_LIST, LIT_FIRST)
If loopi < 0 Then Do
  xrc = DboxCreateMbx(SAVEFLDR_DIALOG,"Please select a folder from the list.",MB_OK)
  Return 0
End
Call Wait "Processing the selected folders."
Do While loopi >= 0
  curdir = loopi + 1
  curfldr = Strip(DboxQuerylisttext(SAVEFLDR_DIALOG, SAVEFLDR_LIST, loopi))
  Call Processfolder fldrdirs.curdir, curfldr
  Call dBoxListSelect SAVEFLDR_DIALOG, SAVEFLDR_LIST, loopi, 0
  loopi = Dboxquerylistindex(SAVEFLDR_DIALOG, SAVEFLDR_LIST, loopi)
End
Call Unwait
done = 1
Return 0
 
/***************************************/
/* Process button SAVEFLDR_DIALOG_EXIT */
/***************************************/
SAVEFLDR_DIALOG_EXIT:
If done = 1 Then Do
/**************************************************************/
/* Now create the .CMD file, and if requested, the debug file */
/**************************************************************/
  saveit = 1
  Call Process_dialog 'OUTPUT_DIALOG'
  If saveit = 0 Then Do
    QUIT = TRUE
    Return 0
  End
  If Stream(cmdfile, 'C', 'QUERY EXISTS') <> '' Then Do
    xrc = Dboxcreatembx(SAVEFLDR_DIALOG, "The output file" cmdfile "already exists, do you want to overwrite it?", MB_YESNO)
    If xrc <> MBID_YES Then Return 0
    Call SysFileDelete cmdfile
  End
  Call Make_output
End
QUIT = TRUE
Return 0
 
/***************************************/
/* Process button SAVEFLDR_DIALOG_HELP */
/***************************************/
SAVEFLDR_DIALOG_HELP:
'@VIEW SAVEFLDR'
Return 0
 
/**************************************/
/* Process button SAVEFLDR_DIALOG_ESC */
/**************************************/
SAVEFLDR_DIALOG_ESC:
QUIT = TRUE
Return 0
 
/***********************************************/
/* Fill the fields of the OUTPUT_DIALOG dialog */
/***********************************************/
FILL_OUTPUT_DIALOG:
Call dBoxSetText OUTPUT_DIALOG, OUTPUT_FILENAME, cmdfile
dlg_field = OUTPUT_FILENAME   /* This is the field where the cursor will be */
Return 0
 
/*************************************/
/* Process button OUTPUT_DIALOG_SAVE */
/*************************************/
OUTPUT_DIALOG_SAVE:
cmdfile = Dboxquerytext(OUTPUT_DIALOG, OUTPUT_FILENAME)
If cmdfile = '' Then Do
  Call Telluser "Please supply a file name, or press Exit."
  Return 0
End
cmdfile = Translate(cmdfile)
QUIT = TRUE
Return 0
 
/*************************************/
/* Process button OUTPUT_DIALOG_EXIT */
/*************************************/
OUTPUT_DIALOG_EXIT:
saveit = 0
QUIT = TRUE
Return 0
 
/************************************/
/* Process button OUTPUT_DIALOG_ESC */
/************************************/
OUTPUT_DIALOG_ESC:
saveit = 0
QUIT = TRUE
Return 0
 
/********************/
/* User subroutines */
/********************/

/******************************/
/* Get the folder information */
/******************************/
Processfolder:
folderdir = Translate(Arg(1))
foldername = Arg(2)
Call SysIni inifile,'PM_Abstract:FldrContent', 'ALL:', 'fldrs'
iconfile = ''
Do i = 1 to fldrs.0
  key = fldrs.i
  flderid = ''
  Do j = 1 to locs.0
    If Word(locs.j,1) = key Then Do
      flderid = Word(locs.j,2)
      Leave
    End
  End
  inode = Right(fldrs.i,4,'0')
  inode = X2C(Substr(inode,3,2)||Substr(inode,1,2))
  fldername = Getpath(inode)
  If fldername = '' Then Iterate
/* Note: On HPFS drives the directory name of the folder */
/*       obtained via the nodes may not be exactly the   */
/*       same as the uppercase directory name due to NLS */
/*       problems. Therefore the following (clumsy) code */
/*       to determine if they are really the same.       */
  If fldername <> folderdir Then Do
    If Length(fldername) <> Length(folderdir) Then Iterate
    If Pos(' ',fldername) = 0 Then Iterate
    tfile = fldername||'\SAVEFLDR.TMP'
    tfile2 = folderdir||'\SAVEFLDR.TMP'
    Call Lineout tfile, 'Test'
    Call Stream tfile, 'C', 'CLOSE'
    If Stream(tfile2, 'C', 'QUERY EXISTS') = '' Then Do
      Call SysFileDelete tfile
      Iterate
    End
    Call SysFileDelete tfile
    fldername = folderdir
  End
  iconfile = ''
  icondata = ''
  xrc = MyGetEA(fldername, '.ICON', 'icondata')
  If Length(icondata) > 5 Then Do
    iconfile = 'F'||Right(key,4,'0')||'.ICO'
    Call SysFileDelete iconfile
    Call Charout iconfile, Substr(icondata,5)
    Call Stream iconfile, 'C', 'CLOSE'
  End
  xrc = MyGetEA(fldername, '.CLASSINFO', 'classinfo')
  If debug Then Call Hexdump classinfo, dumpfile
  settings = ''
  iconview = ''
  treeview = ''
  detailsview = ''
/*
  If substr(classinfo,57,1) <> '04'x Then Do
    views = Substr(classinfo,57,1)
    If views = '01'x Then iconview = iconview||',NONFLOWED,INVISIBLE'
    If views = '02'x Then iconview = iconview||',NONFLOWED,NORMAL'
    If views = '11'x Then iconview = iconview||',FLOWED,INVISIBLE'
    If views = '12'x Then iconview = iconview||',FLOWED,NORMAL'
    If views = '22'x Then iconview = iconview||',NONFLOWED,SMALL'
    If views = '24'x Then iconview = iconview||',NONGRID,SMALL'
    If views = '32'x Then iconview = iconview||',FLOWED,SMALL'
  End
  If Substr(classinfo,61,3) <> '444050'x Then Do
    views = Substr(classinfo,61,3)
    If views = '444010' Then treeview = treeview||',NOLINES,NORMAL'
    If views = '644010' Then treeview = treeview||',NOLINES,SMALL'
    If views = '414010' Then treeview = treeview||',NOLINES,INVISIBLE'
    If views = '644050' Then treeview = treeview||',LINES,SMALL'
    If views = '414050' Then treeview = treeview||',LINES,INVISIBLE'
  End
*/
  wpobject = Substr(classinfo,Pos('WPObject',classinfo))
  If Bitand(Substr(wpobject,28,1),'20'x) <> '00'x Then settings = Strip(settings||'TEMPLATE=YES;')
  If Substr(wpobject,32,1) = '01'x Then settings = Strip(settings||'MINWIN=HIDE;')
  If Substr(wpobject,32,1) = '02'x Then settings = Strip(settings||'MINWIN=VIEWER;')
  If Substr(wpobject,32,1) = '02'x Then settings = Strip(settings||'MINWIN=DESKTOP;')
  If Substr(wpobject,36,1) = '01'x Then settings = Strip(settings||'CCVIEW=YES;')
  If Substr(wpobject,36,1) = '02'x Then settings = Strip(settings||'CCVIEW=NO;')
  If flderid = '' Then flderid = '<USER_'||Word(Filespec('N',foldername),1)||'>'
  If iconview <> '' Then settings = 'ICONVIEW='||Substr(iconview,2)
  If treeview <> '' Then settings = 'TREEVIEW='||Substr(treeview,2)
  xflderid = "'OBJECTID="flderid||";"||settings||"'"
  If iconfile <> '' Then xflderid = Substr(xflderid,1,Length(xflderid)-1)||'ICONFILE='||Directory()||iconfile||";'"
  cmd.fldername = 'Call SysCreateObject "WPFolder", "'foldername'", "<WP_DESKTOP>", 'xflderid', "F"'
  out.fldername = C2X(inode) "Folder" fldername flderid 'Title='foldername
  iconfile = ''
  objs = SysIni(inifile, 'PM_Abstract:FldrContent', key)
  Do j = 1 to Length(objs) by 4
    obj = C2X(Substr(objs,j+1,1)||Substr(objs,j,1))
    If substr(obj,1,1) = '0' Then obj = Substr(obj,2)
    If substr(obj,1,1) = '0' Then obj = Substr(obj,2)
    If substr(obj,1,1) = '0' Then obj = Substr(obj,2)
    objdata = SysIni(inifile,'PM_Abstract:Objects',obj)
    If Pos('WPAbstract',objdata) > 0 Then Do
      objtype = Substr(objdata,5,Pos('00'x,Substr(objdata,5))-1)
      If objtype <> 'WPProgram' & objtype <> 'WPShadow' Then Iterate
      Call Parseobj
      If pgm = '' Then Do
        xobj = Right(C2X(Substr(inode,2,1)||Substr(inode,1,1)),4,'0')
        If substr(xobj,1,1) = '0' Then xobj = Substr(xobj,2)
        If substr(xobj,1,1) = '0' Then xobj = Substr(xobj,2)
        If substr(xobj,1,1) = '0' Then xobj = Substr(xobj,2)
        xobjdata = SysIni(inifile,'PM_Abstract:Objects',xobj)
        If xobjdata <> 'ERROR:' Then Do
          If Pos('WPAbstract',xobjdata) > 0 Then Do
            objdata = xobjdata
            Call Parseobj
            parameters = ''
            settings = ''
            If objid <> '' Then pgm = objid
            iconfile = ''
          End
        End
      End
      setup = ''
      If objtype = 'WPShadow' Then Do
        If pgm <> '' Then setup=setup||'SHADOWID='||pgm||';'
        objid = ''
      End
      Else Do
        If pgm <> '' Then setup=setup||'EXENAME='||pgm||';'
      End
      If parameters <> '' Then setup=setup||'PARAMETERS='parameters||';'
      If settings <> '' Then setup=setup||settings
      If objid <> '' Then setup=setup||'OBJECTID='||objid||';'
      If iconfile <> '' Then setup = setup||'ICONFILE='Directory()||'\'||iconfile||';'
      k = out.fldername.0 + 1
      cmd.fldername.k = '  Call SysCreateObject "'objtype'", "'Translate(Translate(Substr(objdata,xpos+17,title_l),'^','0a'x),' ','0d'x)'", "'flderid'", "'setup'", "F"'
      out.fldername.k = '   ' obj objtype": Title="Translate(Translate(Substr(objdata,xpos+17,title_l),'^','0a'x),' ','0d'x) setup
      out.fldername.0 = k
      cmd.fldername.0 = k
      iconfile = ''
    End
  End
End
Return 0

/********************************/
/* Parse the object information */
/********************************/
/* Note: This routine tries to interpret the various undocumented */
/*       fields of the object data. This routine might not work   */
/*       future OS/2 releases.                                    */
Parseobj:
xpos = LastPos('WPAbstract',objdata)
title_l = C2D(Substr(objdata,xpos+15,1))-1
objid = Substr(objdata,Pos('WPObject',objdata))
If objid <> '' Then Do
  If lastpos('<',objid) > 0 & lastpos('>',objid) > 0 Then Do
    objid = Substr(objdata,Lastpos('<',objdata),Lastpos('>',objdata)-Lastpos('<',objdata)+1)
  End
  Else Do
    objid = ''
  End
End
pgm = ''
parameters = ''
settings = ''
If Substr(objdata,35,12) = 'WPProgramRef' Then Do
  If debug Then Do
    Call Lineout dumpfile, obj
    Call Hexdump objdata, dumpfile
  End
  saveobjdata = objdata
  objdata = Substr(objdata,1,Pos('WPAbstract',objdata))
  If Substr(objdata,48,4) = '04000B00'x Then Do
    pgmdatapos = Pos('04000B00'x,objdata,35)
    pgmdataposl = C2D(Substr(objdata,pgmdatapos+4,1))
    pgmtype = Substr(objdata,pgmdatapos+18,1)
    Select
/*
  Here is the information you are looking for.
  PROG_31_ENH               WIN-OS2 Full Screen Enhanced
  PROG_31_ENHSEAMLESSVDM    WIN-OS2 Separate Session Enhanced
  PROG_31_ENHSEAMLESSCOMMON WIN-OS2 Common Session Enhanced
*/
      When pgmtype = '00'x Then settings = 'PROGTYPE=PM;'
      When pgmtype = '01'x Then settings = 'PROGTYPE=FULLSCREEN;'
      When pgmtype = '02'x Then settings = 'PROGTYPE=WINDOWABLEVIO;'
      When pgmtype = '03'x Then settings = 'PROGTYPE=PM;'
      When pgmtype = '04'x Then settings = 'PROGTYPE=VDM;'
      When pgmtype = '07'x Then settings = 'PROGTYPE=WINDOWEDVDM;'
      When pgmtype = '0C'x Then settings = 'PROGTYPE=WIN;'
      When pgmtype = '0D'x Then settings = 'PROGTYPE=SEPARATEWIN;'
      When pgmtype = '0E'x Then settings = 'PROGTYPE=WINDOWEDWIN;'
      When pgmtype = '0F'x Then settings = 'PROGTYPE=SEPARATEWIN;'
      When pgmtype = '10'x Then settings = 'PROGTYPE=WINDOWEDWIN;'
      When pgmtype = '11'x Then settings = 'PROGTYPE=PROG_31_ENHSEAMLESSVDM;'
      When pgmtype = '12'x Then settings = 'PROGTYPE=PROG_31_ENHSEAMLESSCOMMON;'
      When pgmtype = '13'x Then settings = 'PROGTYPE=PROG_31_ENH;'
      When pgmtype = '14'x Then settings = 'PROGTYPE=WIN;'
      Otherwise Do
        settings = 'PROGTYPE=????????'
      End
    End
    pgm = Getpath(Substr(objdata,pgmdatapos+6,2))
    If pgm = '' & Substr(objdata,pgmdatapos+6,2) = 'FFFF'x Then pgm = '*'
    startupdir = Getpath(Substr(objdata,pgmdatapos+10,2))
    If startupdir <> '' Then settings = Strip(settings||'STARTUPDIR='||startupdir||';')
    pgmdatapos = pgmdatapos+pgmdataposl
    If Pos('04000A00'x,objdata,pgmdatapos) > 0 Then Do
      pgmpos = Pos('04000A00'x,objdata,pgmdatapos)
      pgml = C2D(Substr(objdata,pgmpos+4,1))-5
      If Substr(objdata,pgmpos+6,2) = '0000'x Then Do
        xpgm = Substr(objdata,pgmpos+8,pgml)
        Parse Var xpgm xpgm '00'x .
        pgml = Length(xpgm)+9
        If pgm = '' Then pgm = xpgm
      End
      Else Do
        pgml = 6
      End
      If Substr(objdata,pgmpos+pgml,2) = '0100'x Then Do
        parameters = Substr(objdata,pgmpos+pgml+2)
        Parse Var parameters parameters '00'x .
        pgml = pgml+Length(parameters)+3
      End
      If Substr(objdata,pgmpos+pgml,2) = '0200'x Then Do
        ico = Substr(objdata,pgmpos+pgml+2)
        Parse Var ico ico '00'x .
        If ico <> '' Then settings = Strip(settings||'ICONFILE='||Strip(ico)||';')
      End
    End
    If Pos('04000600'x,objdata,pgmdatapos) > 0 Then Do
      setuppos = Pos('04000600'x,objdata,pgmdatapos)
      setupl = C2D(Substr(objdata,setuppos+4,1))-2
      xsettings = Translate(Substr(objdata,setuppos+6,setupl),';','00'x)||';'
      If xsettings <> '' Then Do
        ysettings = ''
        Do Forever
          Parse Var xsettings sl ';' xsettings
          If sl = '' Then Leave
          sl = 'SET' sl
          ysettings = ysettings||sl||';'
        End
        settings = Strip(settings||ysettings)
      End
    End
    openflags = Substr(objdata,Pos('04000700'x,objdata,pgmdatapos)+7,1)
    If Bitand(openflags,'04'x) <> '00'x Then settings = Strip(settings||'MINIMIZED=YES;')
    If Bitand(openflags,'80'x) <> '00'x Then settings = Strip(settings||'NOAUTOCLOSE=YES;')
    objdata = saveobjdata
    Call Setwpobject Substr(objdata,Pos('WPObject',objdata))
    Return 0
  End
  If Substr(objdata,48,4) = '02000100'x Then Do
    pgmdatapos = Pos('02000100'x,objdata,35)
    If pgmdatapos > 0 Then Do
      pgmtype = Substr(objdata,pgmdatapos+6,1)
      Select
        When pgmtype = '00'x Then settings = 'PROGTYPE=PM;'
        When pgmtype = '01'x Then settings = 'PROGTYPE=FULLSCREEN;'
        When pgmtype = '02'x Then settings = 'PROGTYPE=WINDOWABLEVIO;'
        When pgmtype = '03'x Then settings = 'PROGTYPE=PM;'
        When pgmtype = '04'x Then settings = 'PROGTYPE=VDM;'
        When pgmtype = '07'x Then settings = 'PROGTYPE=WINDOWEDVDM;'
        When pgmtype = '0C'x Then settings = 'PROGTYPE=WIN;'
        When pgmtype = '0D'x Then settings = 'PROGTYPE=SEPARATEWIN;'
        When pgmtype = '0E'x Then settings = 'PROGTYPE=WINDOWEDWIN;'
        When pgmtype = '0F'x Then settings = 'PROGTYPE=SEPARATEWIN;'
        When pgmtype = '10'x Then settings = 'PROGTYPE=WINDOWEDWIN;'
        Otherwise settings = 'PROGTYPE=????????'
      End
      pgmpos = Pos('02000200'x,objdata,pgmdatapos)
      If pgmpos > 0 Then Do
        pgm = Getpath(Substr(objdata,pgmpos+6,2))
        If pgm = '' Then Do
          If Substr(objdata,pgmpos+6,2) = 'FFFF'x Then pgm = '*'
        End
      End
      Else Do
        pgmpos = Pos('03000900'x,objdata,pgmdatapos)
        If pgmpos > 0 Then Do
          pgml = C2D(Substr(objdata,pgmpos+4,1))-1
          pgm = Substr(objdata,pgmpos+6,pgml)
        End
        Else Do
          pgm = '????????.???'
        End
      End
      dirpos = Pos('04000400'x,objdata,pgmpos)
      If dirpos > 0 Then Do
        dirinode = Substr(objdata,dirpos+4,2)
        If dirinode <> '0000'x Then settings = Strip(settings||'STARTUPDIR='||Getpath(dirinode))||';'
      End
      parmpos = Pos('03000300'x,objdata,pgmpos)
      If parmpos > 0 Then Do
        parml = C2D(Substr(objdata,parmpos+4,1))-1
        If parml > 0 Then parameters = Substr(objdata,parmpos+6,parml)
      End
      If Pos('04000600'x,objdata,pgmpos) > 0 Then Do
        setuppos = Pos('04000600'x,objdata,pgmpos)
        setupl = C2D(Substr(objdata,setuppos+4,1))-2
        xsettings = Translate(Substr(objdata,setuppos+6,setupl),';','00'x)||';'
        If xsettings <> '' Then Do
          ysettings = ''
          Do Forever
            Parse Var xsettings sl ';' xsettings
            If sl = '' Then Leave
            sl = 'SET' sl
            ysettings = ysettings||sl||';'
          End
          settings = Strip(settings||ysettings)
        End
      End
      openflags = Substr(objdata,Pos('04000700'x,objdata,pgmpos)+7,1)
      If Bitand(openflags,'04'x) <> '00'x Then settings = Strip(settings||'MINIMIZED=YES;')
      If Bitand(openflags,'80'x) <> '00'x Then settings = Strip(settings||'NOAUTOCLOSE=YES;')
      objdata = saveobjdata
      Call Setwpobject Substr(objdata,Pos('WPObject',objdata))
      Return 0
    End
  End
  Call Telluser "Unsupported object:" obj". Please run SAVEFLDR with the /d flag, and send the file SAVEFLDR.DAT to 61804212 AT VIEVMA."
  If debug Then Call Lineout dumpfile, "Unsupported object:" obj
End
If Pos('WPShadow',objdata,8) > 0 Then Do
  If debug Then Do
    Call Lineout dumpfile, obj
    Call Hexdump objdata, dumpfile
  End
  inode = Substr(objdata,Pos('WPShadow',objdata,8)+15,2)
  pgm = Getpath(inode)
End
Return 0

/***********************************************/
/* Loop through the nodes to get the path info */
/***********************************************/
Getpath: Procedure Expose nodes.
gpinode = Arg(1)
gp = ''
Do gpi = 1 to nodes.0
  If Substr(nodes.gpi,7,2) = gpinode Then Do
    gp = Substr(nodes.gpi,33,Length(nodes.gpi)-33)
    gpparent = Substr(nodes.gpi,9,2)
    Do Until gpparent = '0000'x
      Do gpl = 1 to nodes.0
        If Substr(nodes.gpl,7,2) = gpparent Then Do
          gp = Substr(nodes.gpl,33,Length(nodes.gpl)-33)||'\'||gp
          gpparent = Substr(nodes.gpl,9,2)
          Leave
        End
      End
    End
    Leave
  End
End
Return gp

/***************************/
/* Get the object settings */
/***************************/
Setwpobject: Procedure Expose settings objtypes. filters.
wpobject = Arg(1)
If Bitand(Substr(wpobject,28,1),'20'x) <> '00'x Then settings = Strip(settings||'TEMPLATE=YES;')
If Substr(wpobject,32,1) = '01'x Then settings = Strip(settings||'MINWIN=HIDE;')
If Substr(wpobject,32,1) = '02'x Then settings = Strip(settings||'MINWIN=VIEWER;')
If Substr(wpobject,32,1) = '02'x Then settings = Strip(settings||'MINWIN=DESKTOP;')
If Substr(wpobject,36,1) = '01'x Then settings = Strip(settings||'CCVIEW=YES;')
If Substr(wpobject,36,1) = '02'x Then settings = Strip(settings||'CCVIEW=NO;')
objnum = Substr(wpobject,52)
Parse Var objnum objnum '@' .
If objtypes.objnum <> '' Then settings = Strip(settings||'ASSOCTYPE='||objtypes.objnum';')
If filters.objnum <> '' Then settings = Strip(settings||'ASSOCFILTER='||filters.objnum';')
Return 0

/*********************************/
/* Dump the data in hex and char */
/*********************************/
Hexdump: Procedure
val = Arg(1)
outfile = Arg(2)
hex_string2 = Xrange("00"x, "1F"x)||'FF'x
table_o = Copies("FA"x, Length(hex_string2))
lines = Length(val)/16
Parse Var lines lines '.' .
rest = Length(val) - (lines*16)
curpos = 0
index = 1
data. = ''
data.0 = 0
Do i = 1 to lines
  data.i = Right(curpos,5) D2X(curpos,4)' '
  Do 8
    data.i = data.i C2X(Substr(val,index,2))
    index = index + 2
  End
  data.i = Left(data.i,53) "'"Translate(Substr(val,curpos+1,16),table_o,hex_string2)"'"
  curpos = curpos + 16
  data.0 = i
End
If rest > 0 Then Do
  i = data.0 + 1
  data.i = Right(curpos,5) D2X(curpos,4)' '
  Do Forever
    If rest <= 0 Then Leave
    If rest >= 2 Then Do
      data.i = data.i C2X(Substr(val,index,2))
      index = index + 2
      rest = rest - 2
    End
    Else Do
      data.i = data.i C2X(Substr(val,index,1))
      index = index + 1
      rest = rest - 1
    End
  End
  data.i = Left(data.i,53) "'"Translate(Substr(val,curpos+1,16),table_o,hex_string2)"'"
  data.0 = i
End
Call Lineout outfile, "Data length="Length(val)
Do i = 1 to data.0
  Call Lineout outfile, data.i
End
Return 0

/***********************/
/* Write the .CMD file */
/***********************/
Writeit: Procedure
fn = Arg(1)
data = Arg(2)
x = Pos(',',data)
x = Pos(',',data,x+1)
x = Pos(',',data,x+1)
Call Lineout fn, Substr(data,1,x)','
data = Strip(Substr(data,x+1))
Do While Length(data) > 63
  x = Lastpos(';',data,62)
  If x = 0 Then Leave
  If Substr(data,x+1,1) = '"' Then Leave
  Call Lineout fn, '     ' Substr(data,1,x)||'"||,'
  data = '"'||Substr(data,x+1)
End
Call Lineout fn, '     ' data
Return 0

/*****************************************************/
/* Get the folder names from the desktop directories */
/*****************************************************/
Getname: Procedure Expose list. fldrfiles.
dir = Arg(1)
right = Arg(2)
Call SysFileTree dir||'\*.*', 'dirs', 'DO'
If dirs.0 > 0 Then Do
  Do i = 1 to dirs.0
    Call Getname dirs.i, right + 2
  End
End
xrc = MyGetEA(dir, '.LONGNAME', 'longname')
x = list.0 + 1
list.x = Copies(' ',right)||Translate(Translate(Substr(longname,5),'^','0a'x),' ','0d'x)
/*
Do Forever
  If pos('0d'x,list.x) = 0 Then Leave
  list.x = Substr(list.x,1,Pos('0d'x,list.x)-1) || Substr(list.x,Pos('0d'x,list.x)+1)
End
*/
fldrfiles.x = dir
list.0 = x
Return 0

/**************************/
/* Write the command file */
/**************************/
Make_output:
Call Lineout cmdfile, "/***********************************************************/"
Call Lineout cmdfile, "/* Created by SAVEFLDR Version" ver "at" Date() Time() "*/"
Call Lineout cmdfile, "/***********************************************************/"
Call Lineout cmdfile, " "
Call Lineout cmdfile, "If RxFuncQuery('SysLoadFuncs') Then Do"
Call Lineout cmdfile, "  Call RxFuncAdd 'SysLoadFuncs', 'REXXUTIL', 'SysLoadFuncs'"
Call Lineout cmdfile, "  Call SysLoadFuncs"
Call Lineout cmdfile, "End"
Call Lineout cmdfile, " "
f = Translate(desktop)
If out.f.0 <> 0 Then Do
  Call Writeit cmdfile, cmd.f
  Parse Var cmd.f . ',' '"'cfolder'"' .
  Call Lineout cmdfile, 'If Result <> 1 Then Say "Unable to create the folder' cfolder'"'
  If debug Then Call Lineout dumpfile, out.f
  Do j = 1 to out.f.0
    Call Writeit cmdfile, cmd.f.j
    Parse Var cmd.f.j . ',' '"'otitle'"' .
    Call Lineout cmdfile, '  If Result <> 1 Then Say "Unable to create the object' otitle 'in the folder' cfolder'"'
    If debug Then Call Lineout dumpfile, out.f.j
  End
  Call Lineout cmdfile, " "
End
Do i = 1 to desk.0
  f = Translate(desk.i)
  If out.f.0 = 0 Then Iterate
  Call Writeit cmdfile, cmd.f
  Parse Var cmd.f . ',' '"'cfolder'"' .
  Call Lineout cmdfile, 'If Result <> 1 Then Say "Unable to create the folder' cfolder'"'
  If debug Then Call Lineout dumpfile, out.f
  Do j = 1 to out.f.0
    Call Writeit cmdfile, cmd.f.j
    Parse Var cmd.f.j . ',' '"'otitle'"' .
    Call Lineout cmdfile, '  If Result <> 1 Then Say "Unable to create the object' otitle 'in the folder' cfolder'"'
    If debug Then Call Lineout dumpfile, out.f.j
  End
  Call Lineout cmdfile, " "
End
Call Lineout cmdfile, "Exit 0"
Call Stream cmdfile, 'C', 'CLOSE'
Return 0

/***************************/
/* End of user subroutines */
/***************************/
 
/****************/
/* Exit program */
/****************/
Endit:
__exitrc = Arg(1)
/************************/
/* User exit processing */
/************************/
 
/*******************************/
/* End of user exit processing */
/*******************************/
If __exitrc = '' Then __exitrc = 0
Do i = 1 to Words(__dlgs_active)
  Call dBoxDestroy Word(__dlgs_active,i)
End
If __wait_active Then Call dBoxDestroy __WAIT_DIALOG
Exit __exitrc
 
/***********************/
/* Process the dialogs */
/***********************/
Process_dialog:
__cur_dialog_name = Arg(1)
Call Dlg_Process __dlgfile, __cur_dialog_name, 1
__cur_dialog = Value(__cur_dialog_name)
__dlgs_active = __dlgs_active __cur_dialog
__dlgs_active_name = __dlgs_active_name __cur_dialog_name
Interpret 'Call FILL_'||__cur_dialog_name
Do Forever
  __dlg_button = Dboxprocess(__cur_dialog, dlg_field, 1)
  If __dlg_button > 0 Then __dlg_button = __Fix_button(Dboxquerytext(__cur_dialog,__dlg_button))
  Else Do
    If __dlg_button = 0 Then __dlg_button = 'ESC'
    Else Do
      Call Telluser "Invalid button" __dlg_button", dialog="__cur_dialog"."
      Call Endit 99
    End
  End
  QUIT = FALSE
  Interpret 'Call' __cur_dialog_name||'_'||__dlg_button
  __cur_dialog = Word(__dlgs_active,Words(__dlgs_active))
  __cur_dialog_name = Word(__dlgs_active_name,Words(__dlgs_active_name))
  If QUIT = TRUE Then Leave
End
QUIT = FALSE
Call dBoxDestroy __cur_dialog
__dlgs_active = Subword(__dlgs_active,1,Words(__dlgs_active)-1)
__dlgs_active_name = Subword(__dlgs_active_name,1,Words(__dlgs_active_name)-1)
Return 0

/************************************************************************/
/* Subroutine: Dlg_process                                              */
/*                                                                      */
/* Security Classification: IBM Internal Use Only                       */
/*                                                                      */
/*   Function: Create and optionally execute the dBoxMgr calls from     */
/*             an OS/2 .DLG file.                                       */
/*                                                                      */
/*   Written by:  George Haschek (61804212 at VIEVMA)                   */
/*                                                                      */
/* Input Parameters:                                                    */
/*      Parameter 1: .DLG Filename                                      */
/*                2: Dialog name withing the .DLG file.                 */
/*                3: Flag:                                              */
/*                      0 = Don't process dialog. The calls for dBoxMgr */
/*                          are saved in the stem __dlgp_stem. The      */
/*                          variable __dlgp_stem.0 contains the number  */
/*                          of entries in the stem.                     */
/*                      1 = Call dBoxMgr directly.                      */
/*      Return codes:                                                   */
/*            -100 ... Dialog file not found                            */
/*            -101 ... Dialog not found in DLG file                     */
/*               0 ... OK                                               */
/*           other ... Return codes from dBoxMgr                        */
/*                                                                      */
/* Note: This routine will create a NOVALUE condition the first time it */
/*       is called.                                                     */
/*                                                                      */
/*   Summary of Changes:                                                */
/*                                                                      */
/*      05/06/91 V1.0 Shipped                                           */
/*      ---------------------------------------------------------       */
/*      05/06/91      Entry field should not allow WS_GROUP             */
/*      05/06/91      Push Button should not allow WS_GROUP             */
/*      05/06/91      Fix dialog size and position                      */
/*      05/06/91      Change return codes (-100 = .DLG file not found,  */
/*                                       -101 = dialog not found in     */
/*                                              .DLG file.              */
/*      05/07/91 V1.1 Shipped                                           */
/*      ---------------------------------------------------------       */
/*      05/09/91      Make it work with OS/2 2.0 dialog files           */
/*      05/10/91 V1.2 Shipped                                           */
/*      ---------------------------------------------------------       */
/*      07/27/92      Add MLE                                           */
/*      07/27/92 V1.3 Shipped                                           */
/*      ---------------------------------------------------------       */
/*      08/20/92      Numerous fixes by Greg Smyth                      */
/*      08/27/92 V1.4 Shipped                                           */
/*                                                                      */
/************************************************************************/
Dlg_Process:
If Translate(Arg(1)) <> __dlgp_filename Then Do
  __dlgp_filename = Translate(Arg(1))
  __dlgp_data. = ''
End
__dlgp_dlgname = Translate(Arg(2))
__dlgp_switch = Arg(3)
__dlgp_rc = -101
__dlgp_i = 0
If Datatype(__dlgp_data.0) <> 'NUM' Then Do
  If Stream(__dlgp_filename,'C','QUERY EXISTS') <> '' Then Do
    __dlgp_data. = ''
    Do Until Lines(__dlgp_filename) = 0
      __dlgp_i = __dlgp_i + 1
      __dlgp_data.__dlgp_i = Strip(Linein(__dlgp_filename))
      If Wordpos(Word(__dlgp_data.__dlgp_i,1),'DLGINCLUDE DLGTEMPLATE BEGIN DIALOG CONTROL END PUSHBUTTON DEFPUSHBUTTON LTEXT RTEXT CTEXT CHECKBOX AUTOCHECKBOX RADIOBUTTON AUTORADIOBUTTON ENTRYFIELD COMBOBOX LISTBOX MLE { } GROUPBOX') = 0 Then Do
        __dlgp_j = __dlgp_i - 1
        If Right(__dlgp_data.__dlgp_j, 1) = '"' & Left(__dlgp_data.__dlgp_i, 1) = '"' Then Do
          __dlgp_data.__dlgp_j = Left(__dlgp_data.__dlgp_j, Length(__dlgp_data.__dlgp_j) - 1)||SubStr(__dlgp_data.__dlgp_i, 2)
        End
        Else Do
/*
          If Left(__dlgp_data.__dlgp_j,1) = '|' Then __dlgp_data.__dlgp_j = __dlgp_data.__dlgp_j || ' '
          __dlgp_data.__dlgp_j = __dlgp_data.__dlgp_j||__dlgp_data.__dlgp_i
*/
          __dlgp_data.__dlgp_j = __dlgp_data.__dlgp_j __dlgp_data.__dlgp_i
        End
        __dlgp_data.__dlgp_i = ''
        __dlgp_i = __dlgp_i - 1
      End
    End
    Call Stream __dlgp_filename, 'C', 'CLOSE'
    __dlgp_data.0 = __dlgp_i
  End
  Else Do
    Call Telluser "Unable to find the file" __dlgp_filename".",1
    Call Endit 16
  End
End
__dlgp_line = ''
__dlgp_found = 0
__dlgp_stem. = ''
__dlgp_stem.0 = 0
Do __dlgp_i = 1 to __dlgp_data.0
  Parse Var __dlgp_data.__dlgp_i __dlgp_cmd __dlgp_parms
  __dlgp_cmd = Translate(__dlgp_cmd)
  If __dlgp_found = 0 Then Do
    If __dlgp_cmd <> 'DIALOG' Then Iterate
  End
  __dlgp_text_end = LastPos('"', __dlgp_parms)
  __dlgp_text = Left(__dlgp_parms, __dlgp_text_end)
  __dlgp_rest = SubStr(__dlgp_parms, __dlgp_text_end + 1)
  Parse Var __dlgp_rest . ',' __dlgp_id ',' __dlgp_x ',' __dlgp_y ',' __dlgp_cx ',' __dlgp_cy ',' __dlgp_class ',' __dlgp_style
  If Datatype(__dlgp_id) = 'NUM' Then Do
    If __dlgp_id < 0 Then __dlgp_id = 0-__dlgp_id
    __dlgp_id = 0 + __dlgp_id
    __dlgp_id = 'DLG_'||Strip(__dlgp_id)
  End
  __dlgp_id = Strip(__dlgp_id)
  __dlgp_class = Translate(__dlgp_class)
  __dlgp_style = Translate(__dlgp_style)
  __dlgp_text = Strip(__dlgp_text)
  Select
    When __dlgp_cmd = 'DIALOG' Then Do
      __dlgp_dlg_id = __dlgp_id
      If __dlgp_found = 0 Then Do
        If __dlgp_dlgname <> Translate(__dlgp_dlg_id) Then Iterate
        __dlgp_found = 1
      End
      Else Do
        Leave
      End
      __dlgp_x = Strip(Format(__dlgp_x / 420 * 1000,5,0))
      __dlgp_y = Strip(Format(__dlgp_y / 240 * 750,5,0))
      __dlgp_cx = __dlgp_cx + 6
      __dlgp_cy = __dlgp_cy + 16
      __dlgp_line = __dlgp_dlg_id '= DBoxCreate('Strip(__dlgp_text)','__dlgp_x','__dlgp_y','__dlgp_cx','__dlgp_cy')'
      __dlgp_stem.__dlgp_found = __dlgp_line
    End
    When __dlgp_cmd = 'CONTROL' Then Do
      Select
        When __dlgp_class = 'WC_BUTTON' Then Do
          If Pos('BS_RADIOBUTTON',__dlgp_style) > 0 | Pos('BS_AUTORADIOBUTTON',__dlgp_style) > 0 Then Do
            Call __dlgp_radio
          End
          If Pos('BS_CHECKBOX',__dlgp_style) > 0 | ,
                Pos('BS_AUTOCHECKBOX',__dlgp_style) > 0 Then Do
             Call __dlgp_check
          End
          If Pos('BS_3STATE',__dlgp_style) > 0 | ,
                Pos('BS_AUTO3STATE',__dlgp_style) > 0 Then Do
             Call __dlgp_3state
          End
          If Pos('BS_PUSHBUTTON',__dlgp_style) > 0 Then Do
            Call __dlgp_push
          End
          __dlgp_found = __dlgp_found + 1
          __dlgp_stem.__dlgp_found = __dlgp_line
        End
        When __dlgp_class = 'WC_LISTBOX' Then Do
          Call __dlgp_list
          __dlgp_found = __dlgp_found + 1
          __dlgp_stem.__dlgp_found = __dlgp_line
        End
        When __dlgp_class = 'WC_ENTRYFIELD' Then Do
          Call __dlgp_entry
          __dlgp_found = __dlgp_found + 1
          __dlgp_stem.__dlgp_found = __dlgp_line
        End
        When __dlgp_class = 'WC_COMBOBOX' Then Do
          Call __dlgp_combo
          __dlgp_found = __dlgp_found + 1
          __dlgp_stem.__dlgp_found = __dlgp_line
        End
        When __dlgp_class = 'WC_STATIC' Then Do
          Call __dlgp_text
          __dlgp_found = __dlgp_found + 1
          __dlgp_stem.__dlgp_found = __dlgp_line
        End
        When __dlgp_class = 'WC_SLIDER' Then Do
          Call __dlgp_slider
          __dlgp_found = __dlgp_found + 1
          __dlgp_stem.__dlgp_found = __dlgp_line
          If Wordpos('CTLDATA',__dlgp_style) > 0 Then Do
            Parse Var __dlgp_style . 'CTLDATA' __dlgp_idx1 ',' __dlgp_idx2 ',' __dlgp_scale1inc ',' __dlgp_scale1space ',' __dlgp_scale2inc ',' __dlgp_scale2space .
            __dlgp_found = __dlgp_found + 1
            __dlgp_stem.__dlgp_found = '__xrc = dBoxInitSlider('__dlgp_dlg_id ',' __dlgp_id ',' __dlgp_idx1 ',' __dlgp_idx2 ',' __dlgp_idx1')'
            __dlgp_found = __dlgp_found + 1
            __dlgp_stem.__dlgp_found = '__xrc = dBoxSetSlider('__dlgp_dlg_id ',' __dlgp_id ',' __dlgp_scale1inc ',' __dlgp_scale1space ',' __dlgp_scale2inc ',' __dlgp_scale2space')'
          End
        End
        When __dlgp_class = 'WC_SPINBUTTON' Then Do
          Call __dlgp_spin
          __dlgp_found = __dlgp_found + 1
          __dlgp_stem.__dlgp_found = __dlgp_line
        End
        Otherwise Do
          Call Telluser "Invalid class found."
          Call Telluser __dlgp_data.__dlgp_i,1
        End
      End
    End
    When __dlgp_cmd = 'PUSHBUTTON' | __dlgp_cmd = 'DEFPUSHBUTTON' Then Do
      __dlgp_style = __dlgp_class
      If __dlgp_cmd = 'DEFPUSHBUTTON' Then Do
        __dlgp_style = __dlgp_style '| BS_DEFAULT'
      End
      If Pos('WS_TABSTOP',__dlgp_style) = 0 Then __dlgp_style = __dlgp_style '| WS_TABSTOP'
      Call __dlgp_push
      __dlgp_found = __dlgp_found + 1
      __dlgp_stem.__dlgp_found = __dlgp_line
    End
    When __dlgp_cmd = 'CHECKBOX' | __dlgp_cmd = 'AUTOCHECKBOX' Then Do
      __dlgp_style = __dlgp_class
      If Pos('WS_TABSTOP',__dlgp_style) = 0 Then __dlgp_style = __dlgp_style '| WS_TABSTOP'
      Call __dlgp_check
      __dlgp_found = __dlgp_found + 1
      __dlgp_stem.__dlgp_found = __dlgp_line
    End
    When __dlgp_cmd = 'RADIOBUTTON' | __dlgp_cmd = 'AUTORADIOBUTTON' Then Do
      __dlgp_style = __dlgp_class
      Call __dlgp_radio
      __dlgp_found = __dlgp_found + 1
      __dlgp_stem.__dlgp_found = __dlgp_line
    End
    When __dlgp_cmd = 'LTEXT' | __dlgp_cmd = 'RTEXT' | __dlgp_cmd = 'CTEXT' Then Do
      __dlgp_style = __dlgp_class
      If Pos('DT_RIGHT',__dlgp_style) = 0 & Pos('DT_LEFT',__dlgp_style) = 0 & Pos('DT_CENTER',__dlgp_style) = 0 Then Do
        If __dlgp_cmd = 'LTEXT' Then __dlgp_style = __dlgp_style '| DT_LEFT'
        If __dlgp_cmd = 'RTEXT' Then __dlgp_style = __dlgp_style '| DT_RIGHT'
        If __dlgp_cmd = 'CTEXT' Then __dlgp_style = __dlgp_style '| DT_CENTER'
      End
      If Pos('DT_TOP',__dlgp_style) = 0 & Pos('DT_BOTTOM',__dlgp_style) = 0 & Pos('DT_VCENTER',__dlgp_style) = 0 Then Do
        __dlgp_style = __dlgp_style '| DT_TOP'
      End
      Call __dlgp_text
      __dlgp_found = __dlgp_found + 1
      __dlgp_stem.__dlgp_found = __dlgp_line
    End
    When __dlgp_cmd = 'ENTRYFIELD' Then Do
      __dlgp_style = __dlgp_class
      If Pos('WS_TABSTOP',__dlgp_style) = 0 Then __dlgp_style = __dlgp_style '| WS_TABSTOP'
      If Pos('ES_AUTOSCROLL',__dlgp_style) = 0 Then __dlgp_style = __dlgp_style '| ES_AUTOSCROLL'
      Call __dlgp_entry
      __dlgp_found = __dlgp_found + 1
      __dlgp_stem.__dlgp_found = __dlgp_line
    End
    When __dlgp_cmd = 'COMBOBOX' Then Do
      __dlgp_style = __dlgp_class
      If Pos('WS_TABSTOP',__dlgp_style) = 0 Then __dlgp_style = __dlgp_style '| WS_TABSTOP'
      If Pos('CBS_SIBPLE',__dlgp_style) = 0 Then __dlgp_style = __dlgp_style '| CBS_SIMPLE'
      Call __dlgp_combo
      __dlgp_found = __dlgp_found + 1
      __dlgp_stem.__dlgp_found = __dlgp_line
    End
    When __dlgp_cmd = 'LISTBOX' Then Do
      Parse Var __dlgp_parms __dlgp_id ',' __dlgp_x ',' __dlgp_y ',' __dlgp_cx ',' __dlgp_cy ',' __dlgp_style
      If Datatype(__dlgp_id) = 'NUM' Then Do
        If __dlgp_id < 0 Then __dlgp_id = 0-__dlgp_id
        __dlgp_id = 0 + __dlgp_id
        __dlgp_id = 'DLG_'||Strip(__dlgp_id)
      End
      __dlgp_id = Strip(__dlgp_id)
      __dlgp_style = Translate(__dlgp_style)
      If Pos('WS_TABSTOP',__dlgp_style) = 0 Then __dlgp_style = __dlgp_style '| WS_TABSTOP'
      Call __dlgp_list
      __dlgp_found = __dlgp_found + 1
      __dlgp_stem.__dlgp_found = __dlgp_line
    End
    When __dlgp_cmd = 'MLE' Then Do
      Parse Var __dlgp_parms . ',' __dlgp_id ',' __dlgp_x ',' __dlgp_y ',' __dlgp_cx ',' __dlgp_cy ',' __dlgp_style
      If Datatype(__dlgp_id) = 'NUM' Then Do
        If __dlgp_id < 0 Then __dlgp_id = 0-__dlgp_id
        __dlgp_id = 0 + __dlgp_id
        __dlgp_id = 'DLG_'||Strip(__dlgp_id)
      End
      __dlgp_id = Strip(__dlgp_id)
      __dlgp_style = Translate(__dlgp_style)
      If Pos('WS_TABSTOP',__dlgp_style) = 0 Then __dlgp_style = __dlgp_style '| WS_TABSTOP'
      Call __dlgp_mle
      __dlgp_found = __dlgp_found + 1
      __dlgp_stem.__dlgp_found = __dlgp_line
    End
    Otherwise Nop
  End
End
__dlgp_stem.0 = __dlgp_found
If __dlgp_found > 0 Then __dlgp_rc = 0
If __dlgp_switch = 1 Then Do
  Do __dlgp_i = 1 to __dlgp_stem.0
    Parse Var __dlgp_stem.__dlgp_i __dlgp_ident .
    Interpret __dlgp_stem.__dlgp_i
    xrc = Value(__dlgp_ident)
    If xrc < 0 Then Do
      __dlgp_rc = xrc
      Call Telluser "RC from dBoxMgr was" __dlgp_rc". The call was: >"Strip(__dlgp_stem.__dlgp_i)"<",1
    End
  End
End
Return __dlgp_rc

/**********************/
/* Process Pushbutton */
/**********************/
__dlgp_push:
__dlgp_style_val = '0'
If Pos('WS_TABSTOP',__dlgp_style) > 0 Then Do
  __dlgp_style_val = __dlgp_style_val'+WS_TABSTOP'
End
If Pos('BS_DEFAULT',__dlgp_style) > 0 Then Do
  __dlgp_style_val = __dlgp_style_val'+BS_DEFAULT'
End
If Pos('BS_NOPOINTERFOCUS',__dlgp_style) > 0 Then Do
  __dlgp_style_val = __dlgp_style_val'+BS_NOPOINTERFOCUS'
End
__dlgp_line = __dlgp_id '= dBoxPush('__dlgp_dlg_id','__dlgp_text','__dlgp_style_val','__dlgp_x','__dlgp_y','__dlgp_cx','__dlgp_cy')'
Return 0

/************************/
/* Process Radio Button */
/************************/
__dlgp_radio:
__dlgp_style_val = '0'
If Pos('WS_TABSTOP',__dlgp_style) > 0 Then Do
  __dlgp_style_val = __dlgp_style_val'+WS_TABSTOP'
End
If Pos('WS_GROUP',__dlgp_style) > 0 Then Do
  __dlgp_style_val = __dlgp_style_val'+WS_GROUP'
End
__dlgp_line = __dlgp_id '= dBoxRadio('__dlgp_dlg_id','__dlgp_text','__dlgp_style_val','__dlgp_x','__dlgp_y','__dlgp_cx','__dlgp_cy')'
Return 0

/*********************/
/* Process Check Box */
/*********************/
__dlgp_check:
__dlgp_style_val = '0'
If Pos('WS_TABSTOP',__dlgp_style) > 0 Then Do
  __dlgp_style_val = __dlgp_style_val'+WS_TABSTOP'
End
__dlgp_line = __dlgp_id '= dBoxCheck('__dlgp_dlg_id','__dlgp_text','__dlgp_style_val','__dlgp_x','__dlgp_y','__dlgp_cx','__dlgp_cy')'
Return 0

/**************************/
/* Process 3 State Button */
/**************************/
__dlgp_3state:
__dlgp_style_val = '0'
If Pos('WS_TABSTOP',__dlgp_style) > 0 Then Do
  __dlgp_style_val = __dlgp_style_val'+WS_TABSTOP'
End
If Pos('BS_NOPOINTERFOCUS',__dlgp_style) > 0 Then Do
  __dlgp_style_val = __dlgp_style_val'+BS_NOPOINTERFOCUS'
End
__dlgp_line = __dlgp_id '= dBox3State('__dlgp_dlg_id','__dlgp_text','__dlgp_style_val','__dlgp_x','__dlgp_y','__dlgp_cx','__dlgp_cy')'
Return 0

/***********************/
/* Process Entry Field */
/***********************/
__dlgp_entry:
__dlgp_style_val = '0'
If Pos('WS_TABSTOP',__dlgp_style) > 0 Then Do
  __dlgp_style_val = __dlgp_style_val'+WS_TABSTOP'
End
Do __dlgp_j = 1 to Words(__dlgp_style)
  If Word(__dlgp_style,__dlgp_j) = 'NOT' Then Do
    __dlgp_j = __dlgp_j + 1
    Iterate
  End
  If Pos(Word(__dlgp_style,__dlgp_j), 'ES_LEFT ES_RIGHT ES_CENTER ES_MARGIN ES_AUTOSCROLL ES_UNREADABLE') > 0 Then Do
    __dlgp_style_val = __dlgp_style_val'+'Word(__dlgp_style,__dlgp_j)
  End
End
__dlgp_line = __dlgp_id '= dBoxEntry('__dlgp_dlg_id','__dlgp_text','__dlgp_style_val','__dlgp_x','__dlgp_y','__dlgp_cx','__dlgp_cy')'
Return 0

/***********************/
/* Process Static Text */
/***********************/
__dlgp_text:
__dlgp_style_val = '0'
If Pos('WS_TABSTOP',__dlgp_style) > 0 Then Do
  __dlgp_style_val = __dlgp_style_val'+WS_TABSTOP'
End
Do __dlgp_j = 1 to Words(__dlgp_style)
  If Word(__dlgp_style,__dlgp_j) = 'NOT' Then Do
    __dlgp_j = __dlgp_j + 1
    Iterate
  End
  If Pos(Word(__dlgp_style,__dlgp_j), 'DT_LEFT DT_RIGHT DT_CENTER DT_TOP DT_BOTTOM DT_VCENTER DT_WORDBREAK') > 0 Then Do
    __dlgp_style_val = __dlgp_style_val'+'Word(__dlgp_style,__dlgp_j)
  End
  firstTilde = Pos('~', __dlgp_text)
  If Word(__dlgp_style, __dlgp_j) = 'DT_MNEMONIC' & firstTilde > 0 Then
    __dlgp_text = Left(__dlgp_text, firstTilde - 1)SubStr(__dlgp_text, firstTilde + 1)
End
__dlgp_line = __dlgp_id '= dBoxText('__dlgp_dlg_id','__dlgp_text','__dlgp_style_val','__dlgp_x','__dlgp_y','__dlgp_cx','__dlgp_cy')'
Return 0

/********************/
/* Process List Box */
/********************/
__dlgp_list:
__dlgp_style_val = '0'
If Pos('WS_TABSTOP',__dlgp_style) > 0 Then Do
  __dlgp_style_val = __dlgp_style_val'+WS_TABSTOP'
End
Do __dlgp_j = 1 to Words(__dlgp_style)
  If Word(__dlgp_style,__dlgp_j) = 'NOT' Then Do
    __dlgp_j = __dlgp_j + 1
    Iterate
  End
  If Pos(Word(__dlgp_style,__dlgp_j), 'LS_MULTIPLESEL LS_HORZSCROLL LS_NOADJUSTPOS') > 0 Then Do
    __dlgp_style_val = __dlgp_style_val'+'Word(__dlgp_style,__dlgp_j)
  End
End
__dlgp_line = __dlgp_id '= dBoxList('__dlgp_dlg_id','__dlgp_style_val','__dlgp_x','__dlgp_y','__dlgp_cx','__dlgp_cy')'
Return 0

/*********************/
/* Process Combo Box */
/*********************/
__dlgp_combo:
__dlgp_style_val = '0'
If Pos('WS_TABSTOP',__dlgp_style) > 0 Then Do
  __dlgp_style_val = __dlgp_style_val'+WS_TABSTOP'
End
Do __dlgp_j = 1 to Words(__dlgp_style)
  If Word(__dlgp_style,__dlgp_j) = 'NOT' Then Do
    __dlgp_j = __dlgp_j + 1
    Iterate
  End
  If Pos(Word(__dlgp_style,__dlgp_j), 'CBS_SIMPLE CBS_DROPDOWN CBS_DROPDOWNLIST') > 0 Then Do
    __dlgp_style_val = __dlgp_style_val'+'Word(__dlgp_style,__dlgp_j)
  End
End
__dlgp_line = __dlgp_id '= dBoxCombo('__dlgp_dlg_id','__dlgp_style_val','__dlgp_x','__dlgp_y','__dlgp_cx','__dlgp_cy')'
Return 0

/***************/
/* Process MLE */
/***************/
__dlgp_mle:
__dlgp_style_val = '0'
If Pos('WS_TABSTOP',__dlgp_style) > 0 Then Do
  __dlgp_style_val = __dlgp_style_val'+WS_TABSTOP'
End
Do __dlgp_j = 1 to Words(__dlgp_style)
  If Word(__dlgp_style,__dlgp_j) = 'NOT' Then Do
    __dlgp_j = __dlgp_j + 1
    Iterate
  End
  If Pos(Word(__dlgp_style,__dlgp_j), 'MLS_BORDER MLS_READONLY MLS_WORDWRAP MLS_HSCROLL MLS_VSCROLL MLS_IGNORETAB MLS_DISABLEUNDO') > 0 Then Do
    __dlgp_style_val = __dlgp_style_val'+'Word(__dlgp_style,__dlgp_j)
  End
End
__dlgp_line = __dlgp_id '= dBoxMLE('__dlgp_dlg_id','__dlgp_style_val','__dlgp_x','__dlgp_y','__dlgp_cx','__dlgp_cy')'
Return 0

/******************/
/* Process Slider */
/******************/
__dlgp_slider:
__dlgp_style_val = '0'
If Pos('WS_TABSTOP',__dlgp_style) > 0 Then Do
  __dlgp_style_val = __dlgp_style_val'+WS_TABSTOP'
End
Do __dlgp_j = 1 to Words(__dlgp_style)
  If Word(__dlgp_style,__dlgp_j) = 'NOT' Then Do
    __dlgp_j = __dlgp_j + 1
    Iterate
  End
  If Wordpos(Word(__dlgp_style,__dlgp_j), 'SLS_HORIZONTAL SLS_VERTICAL SLS_CENTER SLS_BOTTOM SLS_TOP SLS_LEFT SLS_RIGHT SLS_PRIMARYSCALE1 SLS_PRIMARYSCALE2',
     'SLS_HOMELEFT SLS_HOMERIGHT SLS_HOMEBOTTOM SLS_HOMETOP SLS_BUTTONSLEFT SLS_BUTTONSTIGHT SLS_BUTTONSBOTTOM SLS_BUTTONSTOP SLS_SNAPTOINCREMENT SLS_READONLY SLS_RIBBONSTRIP') > 0 Then Do
    __dlgp_style_val = __dlgp_style_val'+'Word(__dlgp_style,__dlgp_j)
  End
End
__dlgp_line = __dlgp_id '= dBoxSlider('__dlgp_dlg_id','__dlgp_style_val','__dlgp_x','__dlgp_y','__dlgp_cx','__dlgp_cy')'
Return 0

/***********************/
/* Process Spin button */
/***********************/
__dlgp_spin:
__dlgp_style_val = '0'
If Pos('WS_TABSTOP',__dlgp_style) > 0 Then Do
  __dlgp_style_val = __dlgp_style_val'+WS_TABSTOP'
End
Do __dlgp_j = 1 to Words(__dlgp_style)
  If Word(__dlgp_style,__dlgp_j) = 'NOT' Then Do
    __dlgp_j = __dlgp_j + 1
    Iterate
  End
  If Wordpos(Word(__dlgp_style,__dlgp_j), 'SPBS_MASTER SPBS_SERVANT SPBS_ALLCHARACTERS SPBS_NUMERICONLY SPBS_READONLY SPBS_JUSTLEFT SPBS_JUSTRIGHT SPBS_JUSTCENTER SPBS_NOBORDER SPBS_FASTSPIN SPBS PADWITHZERO') > 0 Then Do
    __dlgp_style_val = __dlgp_style_val'+'Word(__dlgp_style,__dlgp_j)
  End
End
__dlgp_line = __dlgp_id '= dBoxSpinButton('__dlgp_dlg_id','__dlgp_style_val','__dlgp_x','__dlgp_y','__dlgp_cx','__dlgp_cy')'
Return 0

/**********************************/
/* Show a panel during processing */
/**********************************/
Wait:
__wait_message = Arg(1)
If __wait_message = '' Then __wait_message = "The command is being processed."
Parse source . . __tell_name .
Parse Upper Value Filespec('name',__tell_name) With __tell_name '.' .
__message_length = Format(Max(Length(__wait_message),Length('Please wait...'))*4.8,4,0)
__WAIT_DIALOG = Dboxcreate(__tell_name,0,0,__message_length+15,56)
__dummy1 = Dboxtext(__WAIT_DIALOG,__wait_message,0+DT_CENTER+DT_VCENTER,4,23,__message_length,8)
__dummy2 = Dboxtext(__WAIT_DIALOG,"Please wait...",0+DT_CENTER+DT_VCENTER,4,11,__message_length,8)
Call dBoxShow __WAIT_DIALOG
__wait_active = 1
Return 0

/*************************/
/* Remove the wait panel */
/*************************/
Unwait:
Call DboxDestroy __WAIT_DIALOG
__wait_active = 0
Return 0

/***********************/
/* Fix the button name */
/***********************/
__Fix_button:
__newbutton = Translate(Strip(Arg(1)))
Do Forever
  __cerr = Verify(__newbutton,'abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ0123456789_')
  If __cerr = 0 Then Leave
  __newbutton = Overlay('_',__newbutton,__cerr)
End
Return __newbutton

/***************/
/* Notify user */
/***************/
Telluser:
Parse source . . __tell_name .
Parse Upper Var __tell_name __tell_logfile '.' .
__tell_logfile = __tell_logfile||'.LOG'
Parse Upper Value Filespec('name',__tell_name) With __tell_name '.' .
__tell_log = Arg(2)
If __tell_log = '' Then __tell_log = 0
If __tell_log <> '0' Then Do
  Call Lineout __tell_logfile, Date('U') Time() Arg(1)
  Call Stream __tell_logfile, 'C', 'CLOSE'
  __xrc = dBoxCreateMbx(0,__tell_name||':' Arg(1), MB_ICONHAND)
End
Else Do
  __xrc = dBoxCreateMbx(0,__tell_name||':' Arg(1), MB_OK)
End
Return 0

/*************************/
/* Handle SIGNAL ON HALT */
/*************************/
Halt:
Call Telluser 'Halt signalled in line' SIGL, 1
Call Endit 99

/***************************/
/* Handle SIGNAL ON SYNTAX */
/***************************/
Syntax:
  If symbol('RC') <> 'LIT' Then __error_rc = rc
  Else __error_rc = 0
  __save_sigl = sigl
  Call Telluser 'Rexx error on line' __save_sigl', RC =' __error_rc  errortext(__error_rc),1
  __src_line = Get_source(__save_sigl)
  Call Telluser 'Source line is: "'||__src_line||'"',1
  __src_parse = Parse_src(__src_line)
  __src_line = ''
  Do Until __src_parse = ''
    Parse Var __src_parse  __src_test  '00'x  __src_parse
    if symbol(__src_test) = 'BAD' then
         __src_line = __src_line || value('__src_test')
    else __src_line = __src_line || value(__src_test)
  end
  Call Telluser 'Source line interpreted as: "' || __src_line || '"',1
  Call Endit 99

/*********************************************************************
**  Get a complete line of source code
**   - Gets all source even if continued
**     (assumes continued lines end with a comma)
**   - Deletes simple comments
*********************************************************************/
Get_source: procedure
  parse arg src_line_no
  src_line = ''
  string = sourceline(src_line_no)
  cont = 0
  do until cont = 0          /* get rest if line continued */
    do while string <> ''    /* delete comments            */
      parse var string  src '/*' trash '*/' string
      src_line = src_line || src
    end
    src_line = strip(src_line)
    if substr(src_line,length(src_line)) = ',' then do
      src_line = delstr(src_line,length(src_line))
      cont = cont + 1
      string = sourceline(src_line_no + cont)
    end
    else cont = 0
  end
  return src_line

/*********************************************************************
**  parses line of source code
**   - returns source delimited by '00'x
**   - can be converted to an external function
*********************************************************************/
Parse_src: procedure
  parse arg src_line
  quote_list = '''"'
  delim_list = ' +-/%*|&=^><,;:()'

  src_parse = ''
  do while src_line <> ''
    first = verify(src_line,quote_list,'M')
    if first = 1 then do
      quote = substr(src_line,first,1)
      last = pos(quote,src_line,first+1)
      if last = 0 then last = length(src_line)
      next.1 = substr(src_line,last+1,1)
      next.2 = substr(src_line,last+2,1)
      next.1 = translate(next.1)
      string = substr(src_line,first,last)
      if next.1 = 'X' | next.1 = 'B' then do
         if verify(next.2,delim_list||quote_list,'M') <> 0 then do
           last = last+1
           string = substr(src_line,first,last)
         end
      end
    end
    else do
      if first = 0 then first = length(src_line)+1
      string = substr(src_line,1,first-1)
      x = verify(string,delim_list,'M')
      y = verify(string,delim_list)
      if x = 0 then x = length(string)+1
      if y = 0 then y = length(string)+1
      last = max(x,y) - 1
      if substr(string,last+1,1) = '(' then last=last+1
      string = substr(string,1,last)
    end
    src_parse = src_parse || '00'x || string
    src_line = substr(src_line,last+1)
  end
  return  src_parse
