/* VREXX simple calculator program  */
/* San Diego OS/2 Newsletter        */
/* March 1993 edition               */

/* Program Initialization */

  CALL RxFuncAdd "VInit", "VREXX", "VINIT"          /* Add VInit function to attach to VREXX */
  initcode = VInit()                                /* Initialize VREXX */
  IF initcode = "ERROR" THEN SIGNAL VREXXCleanup    /* Exit program if VInit() failed */

  SIGNAL ON FAILURE NAME VREXXCleanup               /* If the program fails or stops for any    */
  SIGNAL ON HALT NAME VREXXCleanup                  /* reason, the VREXX cleanup must be done   */
                                                    /* in order to leave VREXX in a known state */

  SIGNAL ON SYNTAX NAME SyntaxError     /* Syntax errors should only be triggered by bad  */
                                        /* user input, so when one happens, tell the user */
                                        /* the math expression was bad.                   */

/* Main Program */

  windowTitle = "VREXX Calculator 1.0"  /* Title of input window */
  dialogWidth = 50                      /* Input dialog should be 50 characters wide */
  buttonType = 3                        /* type 3 means use OK and CANCEL buttons */


InputLoop:                              /* Label used for looping back to get more input */

  prompt.0 = 1                                                  /* Only one prompt string */
  prompt.1 = CENTER( "Enter a math expression:", dialogWidth )  /* This is the prompt string. */
  prompt.vstring = ""                                           /* No default expression */

  /* Get input from user */
  button = VInputBox( windowTitle, prompt, dialogWidth, buttonType )

  expr = prompt.vstring                 /* Store the expression the user typed */

  IF button = "OK" THEN DO              /* If the OK button was pressed */
      INTERPRET "result =" || expr      /* evaluate the expression */

      text.0 = 1                        /* and then show a one-line result */
      text.1 = result                   /* in a message box on the screen */

      /* Show the message box */
      CALL VMsgBox "Result of <" || expr || ">", text, 1

      SIGNAL InputLoop                  /* Go get the next expression */
  END

  /* The OK button wasn't pressed, so exit the program. */

/* Program Exit */
VREXXCleanup:
   CALL VExit               /* Clean up the VREXX resources */
   EXIT                     /* Terminate the program        */


/***** ERROR HANDLERS *****/

/* Display an error message */
SyntaxError:
  SIGNAL ON SYNTAX NAME SyntaxError     /* Reinstall error handler */

  text.0 = 2                            /* Show a two line display */
  text.1 = "Bad expression:"            /* of the mistake          */
  text.2 = "  " || expr

  CALL VMsgBox "Error", text, 1         /* Show the message box with just an OK button */

  SIGNAL InputLoop                      /* Go back and get more input */

