/*----------------------------------------------*/
/*-- DLGAPP.CPP                               --*/
/*-- template for an application with a       --*/
/*-- dialog box as its main window            --*/
/*----------------------------------------------*/
/*-- Author:                                  --*/
/*-- Kelly Schrock                            --*/
/*-- 4.15.93                                  --*/
/*----------------------------------------------*/

#define  INCL_PM
#define  INCL_WINDIALOGS
#define  INCL_WINWINDOWMGR
#include <os2.h>
#include <msgmap.h>

#pragma hdrstop
#include "dlgapp.h"


HAB hab;           /*-- anchor block handle --*/
HMQ hmQ;           /*-- msg cue handle      --*/
HWND hMainDlg;     /*-- main window handle  --*/
SWCNTRL sw;        /*-- for switch list     --*/
PID     pid;       /*-- process ID          --*/
HSWITCH hSwitch;

/*-- global names, etc. --*/
PSZ pszShortAppName = "DlgApp";
PSZ pszLongAppName  = "Dialog App";

MSGMAP_BEGIN(messages)
  { WM_INITDLG,         WMInitDlg     },
  { WM_COMMAND,         WMCommand     },
MSGMAP_END(messages, MainDlgProc, WinDefDlgProc)

CMDMAP_BEGIN(commands)
  /*-- you would normally put control IDs here --*/
  /*-- and the addresses of functions that     --*/
  /*-- respond to them here, like this:        --*/
  /*
  { DID_BUTTON1,    DoButton1 },
  
  DoButton1 would be defined as 
  #pragma argsused
  MRESULT DoButton1(HM12) {
    
    return((MRESULT)whatever);
  }
  */
CMDMAP_END(commands, WMCommand)

#pragma argsused
INT main(INT argc, char *argv[]) {
  QMSG qMsg;
  ULONG ulFrameStyle;

  hab = WinInitialize(0);
  hmQ = WinCreateMsgQueue (hab, 0) ;
  hMainDlg = WinLoadDlg(HWND_DESKTOP,
                       HWND_DESKTOP,
                       (PFNWP)MainDlgProc,
                       (HMODULE)0,
                       IDW_MAIN,
                       NULL) ;

  WinProcessDlg(hMainDlg) ;

  WinDestroyMsgQueue(hmQ) ;
  WinTerminate (hab) ;
  return(0);
}

#pragma argsused
MRESULT WMInitDlg(HM12) {
  WinSetWindowULong(hWnd, QWL_USER, (ULONG)mp2) ;

  /* --- add to task switch list --- */
  WinQueryWindowProcess(hWnd, &pid, NULL);
  sw.hwnd = hWnd;
  sw.hwndIcon = WinLoadPointer(HWND_DESKTOP, 0L, IDW_MAIN);
  sw.hprog = 0L;
  sw.idProcess = pid;
  sw.idSession = 0;
  sw.uchVisibility = SWL_VISIBLE;
  sw.fbJump = SWL_JUMPABLE;
  WinQueryWindowText(hWnd, sizeof(sw.szSwtitle),
                           (PSZ)sw.szSwtitle);
  hSwitch = WinAddSwitchEntry(&sw);

  return (MRESULT)0;
}


