/*----------------------------------------------*/
/*-- msgmap.h                                 --*/
/*----------------------------------------------*/
/*-- prototypes and macros for apps that use  --*/
/*-- MSG_MAP to operate                       --*/
/*----------------------------------------------*/

#if !defined(OS2_INCLUDED)
#define INCL_PM
#include <os2.h>
#endif

#ifdef _DEBUG
#define DebugBox(text, title) \
	 WinMessageBox(HWND_DESKTOP,HWND_DESKTOP, \
                      (PSZ)text, (PSZ)title, 0, \
                      MB_OK|MB_INFORMATION|MB_MOVEABLE)
#endif

#define dim(x) (sizeof(x) / sizeof(x[0]))

typedef struct {
  ULONG code;
  MRESULT (*Fn)(HWND, ULONG, MPARAM, MPARAM);
} MSGMAP;

#define HM12 HWND hWnd, ULONG msg, MPARAM mp1, MPARAM mp2
#define callHM12 hWnd, msg, mp1, mp2

/*-- message map #defines --*/
#define MSGMAP_BEGIN(_msgtype) \
  MSGMAP _msgtype[] = {

#define MSGMAP_END(_msgtype, _wndproc, _defproc) \
  { 0L, NULL }, \
}; \
MRESULT EXPENTRY _export _wndproc(HWND hWnd, ULONG msg, MPARAM mp1, MPARAM mp2) { \
  INT i; \
  for(i = 0; i < dim(_msgtype); i++) { \
    if(msg == _msgtype[i].code) \
      return((*_msgtype[i].Fn)(hWnd, msg, mp1, mp2));\
  }\
  return(_defproc(hWnd, msg, mp1, mp2));\
}

/*-- command map #defines --*/
#define CMDMAP_BEGIN(_cmdtype) \
  MSGMAP _cmdtype[] = {

#define CMDMAP_END(_cmdtype, _cmdproc) \
  { 0L, NULL }, \
}; \
MRESULT _cmdproc(HWND hWnd, ULONG msg, MPARAM mp1, MPARAM mp2) { \
  INT i; \
  for(i = 0; i < dim(_cmdtype); i++) { \
    if(SHORT1FROMMP(mp1) == _cmdtype[i].code) \
      return((*_cmdtype[i].Fn)(hWnd, msg, mp1, mp2));\
  }\
  return((MRESULT)0L);\
}

BOOL InitApp(VOID);
BOOL InitHelp(VOID);
VOID ExitProc(USHORT);
VOID TerminateApp(VOID);

/*----------------------------------------------*/
/*-- prototypes for event procs that          --*/
/*-- are included with every application      --*/
/*----------------------------------------------*/
/*-- normal window event procs                --*/
/*----------------------------------------------*/
MRESULT WMCreate(HM12);
MRESULT WMPaint(HM12);
MRESULT WMShow(HM12);
MRESULT WMMove(HM12);
MRESULT WMSize(HM12);
MRESULT WMEraseBkgnd(HM12);
MRESULT WMClose(HM12);
MRESULT WMCommand(HM12);
MRESULT WMHelp(HM12);
/*----------------------------------------------*/
/*-- procs for apps that have dialog box main --*/
/*-- windows                                  --*/
/*----------------------------------------------*/
MRESULT WMInitDlg(HM12);
MRESULT WMControl(HM12);

