#define EDAYOFFS 31717L

#include <dos.h>


/* function to convert date to an integer */
long int condate(year,month,day)
int year; /* year passed */
int month; /* month passed */
int day; /* day passed */
{
    int y1; /* century part of year */
    int y2; /* rest of year */
    int c1,yr; /* temp variables */
    long int l; /* temp variables */
    if(year > 100)
    {
        y1 = year / 100;
        y2 = year % 100;
    } else
    {
        y1 = 19;
        y2 = year;
    }
    /* year range check */
    if((y1 < 0) || (y1 > 99)) return(0);
    /* month range check */
    if((month < 1) || (month > 12)) return(0);
    /* day range check */
    if((month == 4) || (month == 6) || (month == 9) ||
        (month == 11)) c1 = 30;
    else c1 = 31;
    if(month == 2)
        c1 = 29;
    if((day < 1) || (day > c1)) return(0);
    yr = y1*100+y2 -1900;
    if(month > 2)
        month -= 3;
    else
    {
        month += 9;
        yr--;
    }
    l = (((long)1461 *(long)yr) / (long)4) + ((153 * month + 2) / 5) + day - 1;
    return(l);
}

/* get the day month and year of the julian date
 * returns : 0    ok
 *          -1    bad input
 */
int yr_mo_da(julian,year,month,day)
long int julian;
int *year;
int *month;
int *day;
{
    long int te;   /* temporary variable */

    if (julian < 1 ) return(-1);
    te = 4 * julian + 3;
    *year =  (int) (te / 1461);
    *day = (int) (te - ((*year) * 1461));
    *year += 1900;
    *day =  ((*day) / 4) + 1;
    te = 5 * (*day) - 3;
    *month = (int) (te / 153);
    *day = (int) (te - ((*month) * 153));
    *day = ((*day) / 5) + 1;
    if ((*month) < 10)
    {
        *month += 3;
    } else
    {
        *month -= 9;
        (*year)++;
    }
    return(0);
}

int month(julian)
long julian;
{
    int year;
    int mo;
    int day;
    int i;
    if ((i = yr_mo_da(julian,&year,&mo,&day)) < 0)
        return(i);
    else
        return(mo);
}

int year(julian)
long julian;
{
    int yr;
    int month;
    int day;
    int i;
    if ((i = yr_mo_da(julian,&yr,&month,&day)) < 0)
        return(i);
    else
        return(yr);
}

int day(julian)
long julian;
{
    int yr;
    int month;
    int da;
    int i;
    if ((i = yr_mo_da(julian,&yr,&month,&da)) < 0)
        return(i);
    else
        return(da);
}

int eday(julian)
long julian;
{
    register int temp;

    temp = (int) (julian - EDAYOFFS);
    return(temp);
}

long int jday_today()
{
    struct dosdate_t date;

    _dos_getdate(&date);
    return( condate(date.year,date.month,date.day) );
}

int eday_today()
{
    return( (int) (jday_today() - EDAYOFFS) );
}
