/* file to place the FTSC message processing functions in */

#include    "ftsc.h"
#include    "gt16.h"
#include    "datemath.h"
#include    <bios.h>
#include    <conio.h>
#include    <dos.h>
#include    <process.h>
#include    <stdio.h>
#include    <stdlib.h>
#include    <string.h>
#include    <time.h>

extern ADDRTYPE myaddress;

/*----------------------------------------------------------------------*/
int ftsc_addrset(FIDOHEADER *hdr, char *mbuf,ADDRTYPE *t_addr)
{
    char *tptr;

    tptr = strstr(mbuf,"MSGID:");
    if (tptr == NULL)
    {
        t_addr->zone = myaddress.zone;
    }
    else
    {
        t_addr->zone = 0;
        sscanf(tptr+7,"%d",&t_addr->zone);
    }

    tptr = strstr(mbuf,"FMPT");
    if (tptr == NULL)
    {
        t_addr->point = 0;
    }
    else
    {
        t_addr->point = 0;
        sscanf(tptr+5,"%d",&t_addr->point);
    }
        
    t_addr->net = hdr->orig_net;
    t_addr->node = hdr->orig;

    return 1;
}

/*----------------------------------------------------------------------*/
int ftsc_read(int n, char *mp, FIDOHEADER *hdr, char *mtext)
{
   char   *fn;
   char   tmp[14];
   FILE   *fp;

   fn = malloc(80);
   sprintf(tmp,"%d.MSG",n);
   strcpy(fn,mp);
   strcat(fn,tmp);
   if ((fp = fopen(fn,"rb")) == NULL)
   {
      free(fn);
      return(-1);
   }
   fread(hdr,sizeof(FIDOHEADER),1,fp);

   fread(mtext,1,MAXMSGSZ,fp);

   free(fn);
   fclose(fp);
   return(0);

}
/*----------------------------------------------------------------------*/
int ftsc_write(int n, char *mp, FIDOHEADER *hdr, char *mtext)
{
  char *fn;
  char tmp[14];
  FILE *fp;

  fn = malloc(80);
  sprintf(tmp,"%d.MSG",n);
  strcpy(fn,mp);
  strcat(fn,tmp);
  if ((fp = fopen(fn,"wb")) == NULL)
  {
     free(fn);
     return(-1);
  }
  fwrite(hdr,sizeof(FIDOHEADER),1,fp);

  fclose(fp);

  if ((fp = fopen(fn,"at")) == NULL)
  {
     free(fn);
     return(-1);
  }
  fwrite(mtext,1,strlen(mtext)+1,fp); /* +1 is so that NULL byte goes out to */

  free(fn);
  fclose(fp);
  return(0);
}
/*----------------------------------------------------------------------*/

int ftsc_delete(int n, char *mp)

/* n     message number to delete    */
/* *mp   ftsc path to delete it from */

{
    char *fn;
    char tmp[14];

    fn = malloc(80);
    sprintf(tmp,"%d.MSG",n);
    strcpy(fn,mp);
    strcat(fn,tmp);
    remove(fn);
    free(fn);
    return(0);

}

/**/

int ftsc_append(char *mp, FIDOHEADER *hdr, char *mtext)

{
   int  fidohigh,i;

   fidohigh = get_ftsc_high(mp);
   fidohigh++;
   if (fidohigh == 1) fidohigh = 2;
   i = ftsc_write(fidohigh,mp,hdr,mtext);
   return(i);
}

/*  */

int get_ftsc_high(char *mp)
{
   char    *fn;                         /* file masking string */
   struct  find_t  fileinfo;
   int     status;                      /* status of last file search */
   int     got;                         /* place to hold current msgnum */
   int     fidohigh;                    /* highest message number       */

   fn = malloc(80);
   strcpy(fn,mp);
   strcat(fn,"*.MSG");

   fidohigh = 0;

   status = _dos_findfirst(fn, _A_NORMAL, &fileinfo);
   while (status == 0)
   {
      sscanf(fileinfo.name,"%d.MSG",&got);
      if (got > fidohigh) fidohigh = got;
      status = _dos_findnext(&fileinfo);
   }

   free(fn);
   return(fidohigh);
}
/*  */

int prn_ftsc_hdr(FIDOHEADER *fhdr)
{
   printf("\n");
   printf("\nFrom: %s",fhdr->from);
   printf("\n  To: %s",fhdr->to);
   printf("\nSubj: %s",fhdr->subj);
   printf("\nDate: %s",fhdr->date);
   printf("\n Binary Data Follows ");
   printf("\nTimes read: %d  Dest: %d  Orig: %d  Cost: %d",fhdr->times, fhdr->dest, fhdr->orig, fhdr->cost);
   printf("\nOrig Net: %d  Dest Net: %d",fhdr->orig_net, fhdr->dest_net);
   printf("\nDate written: %d/%d/%d",fhdr->written.day, fhdr->written.mon, fhdr->written.year);
   printf("\nDate arrived: %d/%d/%d",fhdr->arrived.day, fhdr->arrived.mon, fhdr->arrived.year);
   printf("\n\n");
   return(0);
}


unsigned long msgid_idval(void)
{
    unsigned long       timeval, dateval;
    struct _dostime_t   mtime;
    unsigned int        tempval;
    unsigned long       templong;

    _dos_gettime( &mtime );

    tempval = eday_today();
    tempval -= 2000;

    if (tempval > 4095) tempval -= 4000;    /* should give 20 years of life! */
    if (tempval > 4095) tempval -= 4000;    /* should give 20 years of life! */
    if (tempval > 4095) tempval -= 4000;    /* should give 20 years of life! */

    templong = tempval;
    dateval = templong * 1048575L;  /* 0xFFFFF */

    templong = (unsigned) mtime.hour;
    timeval = (templong * (60L * 60L));

    templong = (unsigned) mtime.minute;
    timeval += (templong * (60L));

    templong = (unsigned) mtime.second;
    timeval += (templong);

    templong = timeval;
    timeval = templong * 10;

    timeval += (unsigned) (mtime.hsecond / 10);

    templong = timeval + dateval;

    return(templong);
}
    
