/*  As some of the information contained herein is derived from information
    gained through the distibution of source code by P&M Software, the
    following notice is required:

******************************************************************************

          Copyright (C)  P&M Software Co 1990.  All rights reserved

                  THIS PROGRAM BELONGS TO P&M SOFTWARE CO.

          The copyright owner hereby grants to you the right to
	  use this program as long as you abide by the following
	  restrictions:

          1.  Any product developed on information obtained herein
	      must be distributed free of charge.  In the same manner
	      this program was distributed.

          2.  Any product developed on information obtained herein
	      must be distributed in source code form.  In the same
	      manner this program was distributed.

          3.  This notice must not be removed.  And it must be included
	      in any product developed on information obtained herein.


******************************************************************************
*/


/* using 16.00 control structures for GT area */

#define TMPMSGCTL    "MESSAGE.TMP"    /* temp file to write work data for out */
#define MSGCTL       "MESSAGE.CTL"    /* message headers                      */
#define USRMSG       "USER_MSG.CTL"   /* user pointers in area                */
#define USERFILE     "USER.CTL"       /* user security file                   */
#define GTCONFIG     "GT.CNF"         /* configuration file for GT lanpath    */
#define FILEPATH     "GTMSGS\\"       /* subdirectory for message texts       */
#define MAXMSGSZ     0xF000           /* size of mbuffer                      */
#define MAXGTLLEN    300              /* maximum length of a line in GT msg   */
#define MSGCTLSZ     128              /* size of message.ctl entry            */
#define MAX_USR_MSG  256              /* maximum number of users in one area  */

#define SUNDAYOFFS (EDAYOFFS + 1515 - (7 * 500))  /* julian date of a sunday */

#define PRIV_MASK    0x0001
                                             /*  OFFSETS */
typedef struct   _usrrec      {              /*==========*/
    char         user_deleted;               /*      0   */
    char         user_name[31];              /*      1   */
    char         user_first_date[9];         /*     32   */
    char         user_first_time[6];         /*     41   */
    char         user_last_date[9];          /*     47   */
    char         user_last_time[6];          /*     56   */
    int          user_credit;                /*     62   */
    int          user_charges;               /*     64   */
    int          user_times_on;              /*     66   */
    char         user_banned;                /*     68   */
    char         user_expert;                /*     69   */
    char         user_more;                  /*     70   */
    char         user_home[31];              /*     71   */
    char         user_phone[11];             /*    102   */
    char         user_password[21];          /*    113   */
    char         user_privel;                /*    134   */
    int          user_calls;                 /*    135   */
    int          user_accum_time;            /*    137   */
    char         user_protocol;              /*    139   */
    int          user_screen_lgth;           /*    140   */
    int          user_upload_k;              /*    142   */
    int          user_upload_files;          /*    144   */
    int          user_dnload_k;              /*    146   */
    int          user_dnload_files;          /*    148   */
    long         user_caller_no;             /*    150   */
    int          user_hash_code;             /*    154   */
    char         user_cb_handle[10];         /*    156   */
    char         user_filler[10];            /*    166   */
} USER_RECORD;

typedef struct _usrmsgrec {
    char       user_msg_deleted;
    int        user_msg_prior_read;
    int        user_msg_highest_scan;
    long       user_msg_caller_no;
    int        user_msg_hash_code;
    char       user_msg_banned;
    int        user_msg_marked[2];
} USER_MSG_RECORD ;

typedef struct _mdirbbs {
    char    mdesc[70];
    char    mpath[50];
    char    mflag[5];
    char    mlevl[2];
} GTMDIR;



struct flag_attrib {
   unsigned int sticky:1;
   unsigned int fidoorg:1;
   unsigned int b1:1;
   unsigned int b2:1;
   unsigned int b3:1;
   unsigned int b4:1;
   unsigned int b5:1;
   unsigned int b6:1;
};

typedef struct _msgrec {
    char          msg_deleted;
    int           msg_number;
    char          msg_sender[31];
    char          msg_addressee[31];
    char          msg_topic[31];
    char          msg_date[9];
    int           msg_dest_net;
    char          msg_time[6];
    char          msg_weekday;

    struct flag_attrib   msg_flags;      /*   0x01 - STICKY BIT         */
                                         /*   0x02 - Fidonet Processed  */
    int           msg_dest_node;
    char          msg_perm_priv;    /* 0x00 = public non-kp */
    char          msg_received;     /* 0x01 = msg received */
    char          msg_filler;
    int           msg_reply_no[3];
    int           msg_orig_no;
} MSG_RECORD;

/* prototypes from gtmsg.c, add on to these as you increase that file */

long get_gt_callernum(char *);    /* get caller number for specified user     */
                                  /* -1L indicates an error condition         */

int get_gt_lowest(char *);        /* get lowest message number in spec. dir   */
                                  /* -1 indicates an error condition          */

int get_gt_highest(char *);       /* get highest message number in spec. dir  */
                                  /* -1 indicates an error condition          */

int get_gt_lastread(long,char *); /* get lastread for specified caller number */
                                  /* -1 indicates an error conditions         */

int prn_gt_msg_hdr(void *);       /* prints out a gt message header record    */


int get_gt_message(int, char *, void *, char *);  /* read a GT message */
                             /***********************************************/
                             /* int = message number to get                 */
                             /* 1st char * = message base path              */
                             /* void * = pointer to msg.ctl struct          */
                             /* 2nd char * = message text buffer            */
                             /* return value:                               */
                             /*       0 = success                           */
                             /*      -1 = failure                           */
                             /***********************************************/

int append_gt_message(char *, void *, char *);  /* writes a GT message */
/* should return either the message number written, or -1 if failure */

int set_gt_lastread(long, char *, int);
                      /* set lastread pointer for specified caller # */
                      /* return -1 if failure */

int get_next_nf(char *, int);
                        /*  Get next message number that has fidoorg = 0
                            1) message path
                            2) message number to start with
                        */


char *get_gt_nmaildir(void);
                        /*   careful with this one it ALLOCATES memory
                             permanently for the char* it returns */

/*   Dos type file handling functions  */

int filecopy(char *, char *);



