/*  As some of the information contained herein is derived from information
    gained through the distibution of source code by P&M Software, the
    following notice is required:

******************************************************************************

          Copyright (C)  P&M Software Co 1990.  All rights reserved

                  THIS PROGRAM BELONGS TO P&M SOFTWARE CO.

          The copyright owner hereby grants to you the right to
	  use this program as long as you abide by the following
	  restrictions:

          1.  Any product developed on information obtained herein
	      must be distributed free of charge.  In the same manner
	      this program was distributed.

          2.  Any product developed on information obtained herein
	      must be distributed in source code form.  In the same
	      manner this program was distributed.

          3.  This notice must not be removed.  And it must be included
	      in any product developed on information obtained herein.


******************************************************************************
*/




/* code module for controlling the GT 16 message files */

/* #define DEBUGGING 1 */

#include    <bios.h>
#include    <conio.h>
#include    <dos.h>
#include    <process.h>
#include    <stdio.h>
#include    <stdlib.h>
#include    <string.h>
#include    <time.h>
#include    "datemath.h"
#include    "gt16.h"

#include    <cxl\cxldef.h>  /* these are used for string comparisons */
#include    <cxl\cxlstr.h>  /* if you have a need to recompile, they should */
                            /* be pretty simple to figure out and replicate */

/**/

int get_gt_lowest( char *msgpath )
{
   char        *fn;
   FILE        *fp;
   int         i;
   MSG_RECORD  *temp_rec;

   fn = malloc(80);
   temp_rec = malloc(sizeof(MSG_RECORD));

   if (fn == NULL) exit(0);
   if (temp_rec == NULL) exit(0);

   strcpy(fn,msgpath);
   strcat(fn,MSGCTL);

   if ((fp = fopen(fn,"rb")) == NULL)
   {
      free(temp_rec);
      free(fn);
      printf("\nFailure to open: %s",fn);
      return(-1);
   }
   if (fread(temp_rec,MSGCTLSZ,1,fp) == 0)
   {
      fclose(fp);
      free(temp_rec);
      free(fn);
      printf("\nFailure reading: %s",fn);
      return(-1);
   }

   i = temp_rec->msg_number;

   fclose(fp);
   free(temp_rec);
   free(fn);

   return(i);
}

/**/

int get_gt_highest ( char *msgpath )
{
   char         *fn;
   FILE         *fp;
   int          i;
   MSG_RECORD   *temp_rec;


   fn = malloc(80);
   temp_rec = malloc(sizeof(MSG_RECORD));

   if (fn == NULL) exit(0);
   if (temp_rec == NULL) exit(0);

   strcpy(fn,msgpath);
   strcat(fn,MSGCTL);

   if ((fp = fopen(fn,"rb")) == NULL)
   {
      free(temp_rec);
      free(fn);
      printf("\nFailed opening %s",fn);
      return(-1);
   }
   if (fseek(fp,-128L,SEEK_END) == -1L)
   {
      fclose(fp);
      free(temp_rec);
      free(fn);
      printf("\nFailed seeking %s",fn);
      return(-1);
   }
   if (fread(temp_rec,MSGCTLSZ,1,fp) == 0)
   {
      fclose(fp);
      free(temp_rec);
      free(fn);
      printf("\nFailed reading from %s",fn);
      return(-1);
   }

   i = temp_rec->msg_number;

   fclose(fp);
   free(temp_rec);
   free(fn);

   return(i);
}

/**/

long get_gt_callernum( char *username )
{
    char        *fn,*tmpstr,*gtpath;
    FILE        *fp;
    USER_RECORD *usr_rec;
    long        caller_number;
    int         loopgo,got,ret_val;

    
    usr_rec = malloc(300);
    fn = malloc(100);
    tmpstr = malloc(100);

    if (usr_rec == NULL) exit(0);
    if (fn == NULL) exit(0);
    if (tmpstr == NULL) exit(0);

    gtpath = getenv("GTPATH");
    strcpy(fn,gtpath);
    if (fn[(strlen(fn)-1)] != (char) 0x5C) strcat(fn,"\\");
    strcat(fn,USERFILE);

    if ((fp = fopen(fn,"rb")) == NULL)
    {
        /* user.ctl file not found in GTPATH, so lets go look for a LANPATH */
        strcpy(fn,gtpath);
        if (fn[(strlen(fn)-1)] != (char) 0x5C) strcat(fn,"\\");
        strcat(fn,GTCONFIG);
        if ((fp = fopen(fn,"rt")) != NULL)
        {
            loopgo = 1;
            while(loopgo)
            {
                memset(fn,0,80);
                if (fgets(fn,80,fp) == NULL) {fclose(fp); loopgo = 0; fp = NULL;}
                strchg(fn,0x0A,0x00);
                strchg(fn,0x0D,0x00);
                strtrim(fn);
                strupr(fn);
                if (strstr(fn,"LR=") == fn)
                {
                    fclose(fp);
                    fp = NULL;
                    loopgo = 0;
                    if (fn[3] != (char) 0)
                    {
                        fn[80] = (char) 0;
                        strcpy(tmpstr,fn+3);
                        if (tmpstr[(strlen(tmpstr)-1)] != (char) 0x5C) strcat(tmpstr,"\\");
                        strcat(tmpstr,USERFILE);
                        strcpy(fn,tmpstr);
                        fp = fopen(fn,"rb");
                    }
                }
            }
        }
    }

    
    if (fp == NULL)
    {
        free(tmpstr);
        free(fn);
        free(usr_rec);
        printf("\nON FIRST OPENING - %s\n",fn);
        return(-1L);
    }

    
    caller_number = (long) 0;
    loopgo = 1;
    while(loopgo)
    {
       got = fread(usr_rec,sizeof(USER_RECORD),1,fp);
       if (got==0)
       {
           printf("\nReached end of fn: %s",fn);
           loopgo = 0;
       }
       else
       {
           ret_val = stricmp(usr_rec->user_name,username);
           if (ret_val == 0)
           {
              loopgo = 0;
              caller_number = usr_rec->user_caller_no;
           }
       }
    }

    fclose(fp);

    if (caller_number == 0)
    {
       free(tmpstr);
       free(fn);
       free(usr_rec);
       return(-1L);
    }

    free(tmpstr);
    free(fn);
    free(usr_rec);
    return(caller_number);

    /* end of getting caller number section. */
}

/**/

int get_gt_lastread(long usernum, char *mpath )
/* usernum is caller number */
/* mpath is message area path */

{
    int                 loopgo,last_processed,got, low;
    char                *fn;
    USER_MSG_RECORD     *usr_msg;
    FILE                *fp;

    low = get_gt_lowest(mpath);

    fn = malloc(80);
    usr_msg = malloc(300);

    if (fn == NULL) exit(0);
    if (usr_msg == NULL) exit(0);

    strcpy(fn,mpath);
    strcat(fn,USRMSG);

    if ((fp = fopen(fn,"rb")) == NULL)
    {
        free(usr_msg);
        free(fn);
        printf("\nFailed to open fn: %s",fn);
        return(-1);
    }

    last_processed = -1L;
    loopgo = 1;

    while (loopgo)
    {
        got = fread(usr_msg,sizeof(USER_MSG_RECORD),1,fp);
        if (got==0)
        {
            printf("\nReached end of file: %s",fn);
            loopgo = 0;
        }
        else
        {
            if (usr_msg->user_msg_caller_no == usernum)
            {
               last_processed = usr_msg->user_msg_prior_read;
               if (last_processed < low) last_processed = low;
               loopgo = 0;
            }
        }
     }
     fclose(fp);

     free(usr_msg);
     free(fn);
     return(last_processed);
}

/**/

int get_gt_message(int msgnumber,        char *msgpath,
                   MSG_RECORD *msg_rec,  char *mbuffer)
{
   int          lowest, highest, i, som_offset;
   long         offset;

   char         *fn, *tempstr;
   char         som_start[10],som_end[10];
   FILE         *fp;

   fn = malloc(80);
   tempstr = malloc(MAXGTLLEN + 1);

   lowest = get_gt_lowest(msgpath);
   highest = get_gt_highest(msgpath);

   if ((msgnumber < lowest) || (msgnumber > highest))
   {
      free(tempstr);
      free(fn);
      return(-1);
   }

   offset = (long) (msgnumber - lowest);
   offset = (offset * (long) MSGCTLSZ);

   strcpy(fn,msgpath);
   strcat(fn,MSGCTL);
   if ((fp = fopen(fn,"rb")) == NULL)
   {
      free(tempstr);
      free(fn);
      return(-1);
   }
   if (fseek(fp,offset,SEEK_SET) == -1L)
   {
      fclose(fp);
      free(tempstr);
      free(fn);
      return(-1);
   }
   if (fread(msg_rec,MSGCTLSZ,1,fp) == 0)
   {
      fclose(fp);
      free(tempstr);
      free(fn);
      return(-1);
   }
   fclose(fp);

#ifdef DEBUGGING
   prn_gt_msg_hdr((void *) msg_rec);
#endif

   strcpy(fn,msgpath);
   strcat(fn,FILEPATH);

   i = ((msgnumber - 1) / 10) + 1;
   sprintf(fn,"%s%s%05d.MES",msgpath,FILEPATH,i );

#ifdef DEBUGGING
   printf("\nReading from: %s\n",fn);
#endif

   if ((fp = fopen(fn,"r")) == NULL)
   {
      free(tempstr);
      free(fn);
      return(-1);
   }

   i = (msgnumber - 1) % 10;
   som_offset = i;
   sprintf(som_start,"%c%s%d",(char) 24,"SOM",i);
   i++;
   sprintf(som_end,"%c%s",(char) 24,"SOM");
   strcpy(tempstr," ");
   i = 0;


#ifdef DEBUGGING
   printf("\nSearching for SOM start: %s",som_start);
#endif

   while (strncmp(tempstr,som_start,5))
   {
      fgets(tempstr,MAXGTLLEN,fp);
      if (ferror(fp))
      {
         fclose(fp);
         free(tempstr);
         free(fn);
         return(-1);
      }
      if (feof(fp))
      {
         fclose(fp);
         free(tempstr);
         free(fn);
         return(-1);
      }
   }

   strcpy(mbuffer,"");

   fgets(tempstr,MAXGTLLEN,fp);
   while ((strncmp(tempstr,som_end,4)) && !(feof(fp)))
   {
      strcat(mbuffer,tempstr);
      fgets(tempstr,MAXGTLLEN,fp);
   }

#ifdef DEBUGGING
   puts("\nMessage Text follows: \n");
   puts(mbuffer);
#endif

   fclose(fp);
   free(tempstr);
   free(fn);

   return(0);
}

/**/

/* should return either the message number written, or zero if failure */

int append_gt_message(char *msgpath, MSG_RECORD *msg_rec, char *mbuffer)
{
   int     highest, som_offset, nextmsg, i;
   char    *fn, *tempstr;
   char    som_next[10];
   FILE    *fp;

   fn = malloc(80);
   tempstr = malloc(100);

   highest = get_gt_highest(msgpath);
   nextmsg = highest + 1;
   msg_rec->msg_number = nextmsg;

   strcpy(fn,msgpath);
   strcat(fn,MSGCTL);
   if ((fp = fopen(fn,"ab")) == NULL)
   {
      free(tempstr);
      free(fn);
      return(-1);
   }

   if (fwrite(msg_rec,MSGCTLSZ,1,fp) == 0)
   {
      fclose(fp);
      free(tempstr);
      free(fn);
      return(-1);
   }
   fclose(fp);

   som_offset = (nextmsg - 1) % 10;
   sprintf(som_next,"%c%s%d",(char) 24,"SOM",som_offset);

   strcpy(fn,msgpath);
   strcat(fn,FILEPATH);
   i = ((nextmsg - 1) / 10) + 1;
   sprintf(fn,"%s%s%05d.MES",msgpath,FILEPATH,i );

   if ((fp = fopen(fn,"at")) == NULL)
   {
      free(tempstr);
      free(fn);
      return(-1);
   }
   fputs(som_next,fp);
   fputs("\n",fp);
   fputs(mbuffer,fp);
   fputs("\n",fp);
   fclose(fp);

   free(tempstr);
   free(fn);
   return(nextmsg);

}

/**/

int prn_gt_msg_hdr(MSG_RECORD *msg_rec)
{
   printf("\n");
   printf("\nMessage number: %d",msg_rec->msg_number);
   printf("\nFrom: %s   To: %s",msg_rec->msg_sender,msg_rec->msg_addressee);
   printf("\nAbout: %s   Entered on: %s",msg_rec->msg_topic,msg_rec->msg_date);
   printf("\nFlags  Sticky: %d   Fidoorg: %d ",msg_rec->msg_flags.sticky,msg_rec->msg_flags.fidoorg);
   printf("\n");
   printf("\n\n");
   return(0);
}

/**/

int set_gt_lastread(long callernum, char *mpath, int pnter)
{
    int                 loopgo,got,found,i,j;
    char                *fn;
    USER_MSG_RECORD     *uma[MAX_USR_MSG];
    FILE                *fp;

    fn = malloc(80);
    if (fn == NULL)
    {
        printf("\nMemory allocation error on fn");
        exit(0);
    }

    for (j=0;j<MAX_USR_MSG;j++)
    {
        uma[j]=malloc(sizeof(USER_MSG_RECORD));

        if (uma[j]==NULL)
        {
            printf("\nMemory allocation error at position: %d",j);
            exit(0);
        }
    }

    strcpy(fn,mpath);
    strcat(fn,USRMSG);

    if ((fp = fopen(fn,"r+b")) == NULL)
    {
        for (j=(MAX_USR_MSG - 1);j>=0;j--) free(uma[j]);
        free(fn);
        return(-1);
    }

    loopgo = 1;  found = -1;  i = 0;

    while (loopgo)
    {
       got = fread(uma[i],sizeof(USER_MSG_RECORD),1,fp);

       if (got==0)
       {
           loopgo = 0;
       }
       else
       {
           if (uma[i]->user_msg_caller_no == callernum)
           {
              found = i;
              uma[i]->user_msg_prior_read = pnter;
           }
           i++;
       }
    }
    fclose(fp);

    if (found > -1)
    {
        if ((fp = fopen(fn,"wb")) == NULL)
        {
            for (j=(MAX_USR_MSG - 1);j>=0;j--) free(uma[j]);
            free(fn);
            return(-1);
        }

        for (j=0;j<i;j++)
        {
            fwrite(uma[j],sizeof(USER_MSG_RECORD),1,fp);
        }
        fclose(fp);
    }
    for (j=(MAX_USR_MSG - 1);j>=0;j--) free(uma[j]);
    free(fn);
    return(0);
}

/*  */

#define MAXBUFSZ 30000
int filecopy(char *source, char *dest)
{

    FILE    *fin,*fout;
    char    *buffer;
    int     datalen,written;

    buffer = malloc(MAXBUFSZ);

    if ((fin = fopen(source,"rb")) == NULL)
    {
        free(buffer);
        return(-1);
    }

    if ((fout = fopen(dest,"wb")) == NULL)
    {
        free(buffer);
        return(-1);
    }
    while (!(feof(fin)))
    {
        datalen = fread(buffer,1,MAXBUFSZ,fin);
        if (datalen) written = fwrite(buffer,1,datalen,fout);
        if (datalen != written)
        {
            printf("\nOoops...GTMSG.C lib API failure\n");
            exit(0);
        }
    }
    fclose(fout);
    fclose(fin);
    free(buffer);
    return(0);

}

/*  */

int get_next_nf(char *mpath, int stnum)
{
    char        *fn;
    MSG_RECORD  *wk_rec;
    int         i,j;
    FILE        *msgctl;
    long        offset;
    int         highest,lowest,startnum;

    startnum = stnum;   /* don't particularly like the possibility of modifying
                           a function parameter value, even though it probably
                           would work file...   */

    highest = get_gt_highest(mpath);
    lowest = get_gt_lowest(mpath);

    if (startnum >= highest) return(highest + 1);
    if (startnum < lowest) startnum = lowest;

    fn = malloc(80);
    wk_rec = malloc(MSGCTLSZ+1);

    if (fn == NULL) exit(0);
    if (wk_rec == NULL) exit(0);

    strcpy(fn,mpath);
    strcat(fn,MSGCTL);
    if ((msgctl = fopen(fn,"rb")) == NULL)
    {
        printf("\nFailed to open: %s",fn);
        free(wk_rec);
        free(fn);
        return(-1);
    }
    if (startnum > lowest)   /* seek to starting location */
    {
        offset = (long) (startnum - lowest);
        offset = (offset * (long) MSGCTLSZ);
        if (fseek(msgctl,offset,SEEK_SET) == -1L)
        {
           fclose(msgctl);
           free(wk_rec);
           free(fn);
           return(-1);
        }
    }

    i = highest;

    while (!(feof(msgctl)))
    {
        j = fread(wk_rec,MSGCTLSZ,1,msgctl);
        if (j==0) break;
        if ( (wk_rec->msg_number > startnum) && (wk_rec->msg_flags.fidoorg == 0) )
        {
            i = wk_rec->msg_number;
            fclose(msgctl);
            free(wk_rec);
            free(fn);
            return(i);
        }
    }
    i++;
    fclose(msgctl);
    free(wk_rec);
    free(fn);
    return(i);
}

/*  */

char *get_gt_nmaildir(void)
{
    char    *gtpath;
    char    *fn;
    char    *workstr;
    FILE    *fpcnf;
    char    *nmail;
    char    *access_lvl, *direntry;

    nmail = malloc(80);    /* this STAYS!!! */
    fn = malloc(100);
    workstr = malloc(110);
    access_lvl = malloc(100);
    direntry = malloc(100);

    gtpath = getenv("GTPATH");
    strcpy(fn,gtpath);
    strcat(fn,"\\gtmdir.bbs");
    if ((fpcnf = fopen(fn,"rt")) == NULL)
    {
        printf("\nError opening fn: %s\n",fn);
        free(direntry);
        free(access_lvl);
        free(workstr);
        free(fn);
        free(nmail);
        return(NULL);
    }

    memset(workstr,0,20);  /* don't forget to initialize variables you are
                              going to test against blindly */

    while (1)
    {
        memset(workstr,0,20);

        if (fgets(workstr,110,fpcnf) == NULL)
        {
            free(direntry);
            free(access_lvl);
            free(workstr);
            free(fn);
            free(nmail);
            return(NULL);
        }

        sscanf(workstr,"%s %s",access_lvl,direntry);

        if (strstr(direntry,"~"))
        {
            strcpy(nmail, (strstr(direntry,":") - 1) );
            strcat(nmail,"\\");
            fclose(fpcnf);
            free(direntry);
            free(access_lvl);
            free(workstr);
            free(fn);
            return(nmail);
        }
    } /* should NOT get past here, but.... */
    fclose(fpcnf);
    free(direntry);
    free(access_lvl);
    free(workstr);
    free(fn);
    free(nmail);
    return(NULL);
}

