#include    "gt16.h"
#include    "ftsc.h"
#include    "transfer.h"
#include    <bios.h>
#include    <conio.h>
#include    <dos.h>
#include    <process.h>
#include    <stdio.h>
#include    <stdlib.h>
#include    <string.h>
#include    <time.h>
#include    <cxl\cxldef.h>  /* these are used for string comparisons */
#include    <cxl\cxlstr.h>  /* if you have a need to recompile, they should */
                            /* be pretty simple to figure out and replicate */

#define     LOWMODE  1
#define     STRIPA   2
#define     NETMAIL  9



/* set this to 1 for OZ desired custom netmail hi stripping */
#define OZ_CUSTOM    0


#define VERSION "v1.160 "
#define GTMAIL  "\n\n--- GTMail 1.160 "




/* GLOBAL THINGS */

ADDRTYPE    myaddress;
ADDRTYPE    inetgate;

int  exitlevel = 0;     /* 0 = no imp/ext   1 = imp only   2 = exp only   3 = both */

char tempstr[200];
char *origin;

int  main(int,char *[]);
int  gtfido_bridge(int, char *, char *, long);
int  address_comp(ADDRTYPE, ADDRTYPE);
unsigned long msgid_idval(void);

int     main(int argc, char *argv[])
{
    FILE        *fpcnf;
    char        *fn;
    char        *gtpath;
    int         br_ret;
    int         areamode;
    char        *area_gt,*area_fido;
    char        *workstr;
    long        fido_id;

    myaddress.point = 0;
    myaddress.node = 0;
    myaddress.net = 0;
    myaddress.zone = 0;

    inetgate.point = 0;
    inetgate.node = 0;
    inetgate.net = 0;
    inetgate.zone = 0;
    
/*   PRINT OUT TITLE FRAME   */

    printf("[2J");      /* clear screen ??? */
    printf("\nFido GT 16/17 Interface %s Copyright 1991-1993, Richard W. Walker.",VERSION);
    printf("\nPortions copyright P&M Software Co. 1989 - 1993.");
    printf("\nNo fee may be charged for use or distribution of this software.\n");
    origin = malloc(300);
    if (origin == NULL) { printf("\nMem alloc err\n"); exit(0); }
    fn = malloc(80);
    if (fn == NULL) { printf("\nMem alloc err\n"); exit(0); }
    area_gt = malloc(120);
    if (area_gt == NULL) { printf("\nMem alloc err\n"); exit(0); }
    area_fido = malloc(120);
    if (area_fido == NULL) { printf("\nMem alloc err\n"); exit(0); }
    workstr = malloc(200);
    if (workstr == NULL) { printf("\nMem alloc err\n"); exit(0); }

    if (argc > 2)
    {
        printf("\n Command line: %s",argv[1]);
        printf("\nSoftware has been converted to .cnf file driven mode ");
        printf("\nPlease re-read the documentation file.  It is important.\n\n");
        exit(0);
    }

/*   LOAD CONFIGURATION INFORMATION   */

    gtpath = getenv("GTPATH");
    strcpy(fn,gtpath);
    strcat(fn,"\\fidogate.cnf");
    if ((fpcnf = fopen(fn,"rt")) == NULL)
    {
        printf("\nON FIRST OPENING - %s\n",fn);
        printf("\nInsure that this configuration file is in the GTPATH ");
        exit(0);
    }
    fgets(tempstr,200,fpcnf);
    sscanf(tempstr,"%d:%d/%d.%d",&myaddress.zone,&myaddress.net,&myaddress.node,&myaddress.point);

    fgets(tempstr,200,fpcnf);
    strchg(tempstr,0x0A,0x00);
    strchg(tempstr,0x0D,0x00);
    strltrim(tempstr);
    tempstr[60] = (char) 0;
    strcpy(fn,tempstr);

    memset(origin,0,250);
    strcpy(origin,"\n * Origin: ");
    strcat(origin,fn);

    sprintf(fn," (%d:%d/%d.%d)",myaddress.zone,myaddress.net,myaddress.node,myaddress.point);
    strcat(origin,fn);

    printf("\nBridging: %s",origin);
    printf("\n");

    memset(workstr,0,20);  /* don't forget to initialize variables you are
                              going to test against blindly */

    fido_id = get_gt_callernum("Fido Gate");

    while (strstr(workstr,"END") != workstr)
    {
        areamode = -1;
        memset(workstr,0,20);
        fgets(workstr,110,fpcnf);
        sscanf(workstr,"AREA=%04d %s %s",&areamode,area_gt,area_fido);
        if (areamode != -1)
        {
            br_ret = gtfido_bridge(areamode,area_gt,area_fido,fido_id);
            printf("\n\n");
            memset(workstr,0,20);
        }
        if (feof(fpcnf)) break;
    }

    printf("\n\n\n");

    fclose(fpcnf);

    free(area_fido);
    free(area_gt);
    free(fn);
    free(origin);
    return(exitlevel);
}

/*  */

int     gtfido_bridge(int transmode, char *gtmsgpath, char *fidomsgpath, long usr_id)
{
    int         i,top;
    int         bufadj;
    int         ret_val,nextout,initread;
    int         fidonum;
    MSG_RECORD  *ghdr;
    FIDOHEADER  *fhdr;
    ADDRTYPE    addr_tran;
    char        *mbuffer;
    char        *workbuf; /* thing to build CTL fields in */
    char        *fn;
    char        *pathmark;
    struct      find_t  fileinfo;
    int         status;
    unsigned long templong;
    unsigned long lastmsgid = 0L;


/*   ALLOCATING MEMORY TO BE USED BY PROGRAM  */


    ghdr = malloc(sizeof(MSG_RECORD));
    fhdr = malloc(sizeof(FIDOHEADER));
    mbuffer = malloc((unsigned) MAXMSGSZ + (unsigned) 100);
    workbuf = malloc((unsigned) MAXMSGSZ + (unsigned) 100);
    fn = malloc(80);
    if (ghdr == NULL) { printf("\nMem alloc err\n"); exit(0); }
    if (fhdr == NULL) { printf("\nMem alloc err\n"); exit(0); }
    if (mbuffer == NULL) { printf("\nMem alloc err\n"); exit(0); }
    if (workbuf == NULL) { printf("\nMem alloc err\n"); exit(0); }
    if (fn == NULL) { printf("\nMem alloc err\n"); exit(0); }

/*   Display Parameters  */

    printf("\nGT: %s FIDO: %s\n",gtmsgpath,fidomsgpath);


/*   IMPORT FROM FIDO   */


    if (transmode == NETMAIL)
        bufadj = 30;
    else
        bufadj = 0;
        
    strcpy(fn,fidomsgpath);
    strcat(fn,"*.MSG");

    status = _dos_findfirst(fn, _A_NORMAL, &fileinfo);

    printf("\nImporting from FIDONET: ");
    /* if (status != 0) printf("\b\b\b\b\bNONE "); */

    while (status == 0)
    {
       sscanf(fileinfo.name,"%d.MSG",&fidonum);
       memset(mbuffer,0,MAXMSGSZ);
       
       if (ftsc_read(fidonum,fidomsgpath,fhdr,mbuffer+bufadj) == -1) {  printf("\b\b\b\b\bERR01"); return(1); }

       
       if (fhdr->attrib.attached == 0)
       {
           if (transmode == NETMAIL)
           {
               ftsc_addrset(fhdr,mbuffer+bufadj,&addr_tran); /* load the address of the originator */
               
               sprintf(tempstr,"FTN-> %d:%d/%d.%d",addr_tran.zone,addr_tran.net,addr_tran.node,addr_tran.point);
               strsetsz(tempstr,bufadj-1);
               strcat(tempstr,"\n");
               strsetsz(tempstr,bufadj+5);
               memcpy(mbuffer,tempstr,bufadj);
           }
       
           if (   (strstr(fhdr->from,QMAILSTR)) || (strstr(fhdr->from,SQUISHSTR))   )
           {
              strcpy(fn,fidomsgpath);
              strcat(fn,fileinfo.name);
              remove(fn);
           }
           else
           {
              pathmark = strstr(mbuffer,"PATH: ");
              ftsc2gt_buf(mbuffer);    /* have to prep buffer in order to test */
              ftsc2gt_hdr(ghdr,fhdr);  /* want to keep these two together */

              if (transmode == NETMAIL)
              {
                ghdr->msg_perm_priv = (char) 0x01; /* force netmail to be private */
                ghdr->msg_received  = (char) 0x00;
                ghdr->msg_dest_net  = 0;
                ghdr->msg_dest_node = 0;
              }


              if (transmode == NETMAIL)
              {
                    if (address_comp(addr_tran,myaddress)) 
                    {
                        /* message does not originate on home computer  -  so go ahead and import it. */
                        printf("\b\b\b\b\b%05d",fidonum);
 
                        if (append_gt_message(gtmsgpath,ghdr,mbuffer) == -1)
                        {
                           printf("\nError appending to %s",gtmsgpath);
                           return(1);
                        }
                        exitlevel = (exitlevel | 1);
                        strcpy(fn,fidomsgpath);
                        strcat(fn,fileinfo.name);
                        remove(fn);
                    }
                    else
                    {
                        /* message originates on home system */
                        if (strstr(mbuffer,"Via GTFIDO ") == NULL)
                        {
                            /* message entered with external ftsc message editor  so go ahead and import it. */
                             printf("\b\b\b\b\b%05d",fidonum);
    
                             if (append_gt_message(gtmsgpath,ghdr,mbuffer) == -1)
                             {
                                printf("\nError appending to %s",gtmsgpath);
                                return(1);
                             }
                             exitlevel = (exitlevel | 1);
                             strcpy(fn,fidomsgpath);
                             strcat(fn,fileinfo.name);
                             remove(fn);
                        }
                        else
                        {
                            if (fhdr->attrib.sent)
                            {
                                /* message has been sent - so go ahead and kill it */
                                 printf("\b\b\b\b\bOUTMS");
                                 strcpy(fn,fidomsgpath);
                                 strcat(fn,fileinfo.name);
                                 remove(fn);
                            }
                            else
                            {
                                /* message has not been sent yet */
                                 printf("\b\b\b\b\bMYMSG");
                            }
                        }
                    } /* end of if address_comp section */
              }
              else
              {
                  /* process echomail */
                  if (strstr(mbuffer,origin) == NULL)
                  {
                     printf("\b\b\b\b\b%05d",fidonum);
    
                     if (append_gt_message(gtmsgpath,ghdr,mbuffer) == -1)
                     {
                        printf("\nError appending to %s",gtmsgpath);
                        return(1);
                     }
                     exitlevel = (exitlevel | 1);
                     strcpy(fn,fidomsgpath);
                     strcat(fn,fileinfo.name);
                     remove(fn);
                  } /* if not originated AND scanned */
                  else
                  {
                     if (pathmark == NULL)
                     {  
                         printf("\b\b\b\b\bMYMSG");
                     }
                     else
                     {
                         printf("\b\b\b\b\bOUTMS");
                         strcpy(fn,fidomsgpath);
                         strcat(fn,fileinfo.name);
                         remove(fn);
                     }
                  }
              } /* end of echomail processing section */

          
           }
       }
       status = _dos_findnext(&fileinfo);
    }  /* END OF WHILE LOOP */


/*   EXPORT FROM GT   */

    bufadj = 0;

    printf("             Exporting to FIDONET: ");
    if (usr_id == -1L)
    {
        printf("\n\nFido Gate not a registered user\n");
        free(fn);
        free(mbuffer);
        free(fhdr);
        free(ghdr);
        exit(0);
    }

    initread = get_gt_lastread(usr_id,gtmsgpath);

    if (initread < 0)
    {
        printf("\n\nFido Gate not registered to msg base\n");
        free(fn);
        free(mbuffer);
        free(fhdr);
        free(ghdr);
        return(1);
    }

    nextout = get_next_nf(gtmsgpath,initread); /* get next non fido-scan message */

    top = get_gt_highest(gtmsgpath);

    if (top < 0)
    {
        printf("\n\nError reading highest read pointer for Fido Gate");
        free(fn);
        free(mbuffer);
        free(fhdr);
        free(ghdr);
        return(1);
    }

    if (top < initread)
    {
        /* error trap invalid user high message read marker */
        set_gt_lastread(usr_id,gtmsgpath,top);
        free(fn);
        free(mbuffer);
        free(fhdr);
        free(ghdr);
        return(1);
    }
    
    if (nextout <= top)
    {
        while (nextout <= top)
        {
            memset(workbuf,0,MAXMSGSZ);
            ret_val = get_gt_message(nextout,gtmsgpath,ghdr,mbuffer);
            bufadj = 0;
            if ( ret_val == 0)
            {
                brag_stomp(mbuffer);  /* stomp down multiple brag lines, and line one ; markers */
                if (ghdr->msg_flags.fidoorg == 0)
                {
                    printf("\b\b\b\b\b%05d",ghdr->msg_number);
                    gt2ftsc_hdr(fhdr,ghdr);
                    
                    if (transmode == LOWMODE)
                    {
                        gt2ftsc_buf(mbuffer);   /* zap high order ascii, and other illegals */
                    }
                    
                    if (transmode == STRIPA)
                    {
                        i = 0;
                        while(mbuffer[i])
                        {
                            if (mbuffer[i] == (char) 0x01) mbuffer[i] = (char) 0x20;
                            i++;
                        }
                    }
                    
                    if (transmode == NETMAIL)
                    {
                        if (OZ_CUSTOM) gt2ftsc_buf(mbuffer);
                        
                        fhdr->attrib.private = 1;
                        fhdr->attrib.killsent = 1;
                        addr_tran.zone = 0;  addr_tran.net = 0;  addr_tran.node = 0;  addr_tran.point = 0;
                        
                        bufadj = 0; i = 0;
                        while(mbuffer[bufadj])
                        {
                            if (mbuffer[bufadj] == '\n')
                            {
                                if (i) break; else i = 1;
                            }
                            if ((mbuffer[bufadj] >= '0') && (mbuffer[bufadj] <= '9')) break;
                            bufadj++;
                        }
                        sscanf(mbuffer+bufadj,"%d:%d/%d.%d",&addr_tran.zone,&addr_tran.net,&addr_tran.node,&addr_tran.point);
                        bufadj = 0;
                        
                        if (addr_tran.node && addr_tran.net)
                        {
                            /* remove address line from text */
                            while(mbuffer[bufadj])
                            {
                                if (mbuffer[bufadj] == '\n') break;
                                bufadj++;
                            }
                            if (mbuffer[bufadj] == 0) bufadj = 0;  /* avoid major screw up */
                        }
                        if (bufadj)
                        {
                            strcpy(workbuf,mbuffer+bufadj);
                            strcpy(mbuffer,workbuf);
                            memset(workbuf,0,MAXMSGSZ);
                        }
                        bufadj = 0;
                        
                        fhdr->dest = addr_tran.node;
                        fhdr->dest_net = addr_tran.net;

                        /* use char *fn for the tempstr to build addressing control lines */
                        
                        if (addr_tran.point != 0)
                        {
                            memset(fn,0,79);
                            sprintf(fn,"\n\x01TOPT %u",addr_tran.point);
                            strcat(workbuf,fn);
                        }
                        
                        if (myaddress.point != 0)
                        {
                            memset(fn,0,79);
                            sprintf(fn,"\n\x01FMPT %u",myaddress.point);
                            strcat(workbuf,fn);
                        }
                        
                        if (addr_tran.zone != myaddress.zone)
                        {
                            if (addr_tran.zone != 0)
                            {
                                memset(fn,0,79);
                                sprintf(fn,"\n\x01INTL %u:%u/%u %u:%u/%u",     addr_tran.zone,addr_tran.net,addr_tran.node,
                                                                               myaddress.zone,myaddress.net,myaddress.node);
                                strcat(workbuf,fn);
                            }
                        }
                    } /* end of NETMAIL only processing section */

                    memset(fn,0,79);
                    templong = msgid_idval();
                    if (templong == lastmsgid)  /* insure that the msgid string is reasonably unique */
                    {
                        templong++;
                        lastmsgid++;
                    }
                    else
                    {
                        lastmsgid = templong;
                    }
                    sprintf(fn,"\n\x01MSGID: %d:%d/%d.%d %lx ",myaddress.zone,myaddress.net,myaddress.node,myaddress.point,templong );
                    strcat(workbuf,fn);
                    strcat(workbuf,"\n");
                    
                    if (transmode != NETMAIL)
                    {
                        strcat(mbuffer,GTMAIL);
                        strcat(mbuffer,origin);
                        strcat(mbuffer,"\n");
                        strcat(workbuf,mbuffer);
                        ftsc_append(fidomsgpath,fhdr,workbuf);
                        exitlevel = (exitlevel | 2);
                    }
                    else
                    {
                        strcat(mbuffer,"\n\x01Via GTFIDO ");
                        strcat(mbuffer,VERSION);
                        strcat(mbuffer,"\n");
                        strcat(workbuf,mbuffer);
                        if (addr_tran.net != 0) { ftsc_append(fidomsgpath,fhdr,workbuf);  exitlevel = (exitlevel | 2); }
                    }
                }
            }
            nextout = get_next_nf(gtmsgpath,nextout); /* get next non fido-scan message */
        }
    }

    if (initread < top)
    {
        printf("\nUpdating last scanned pointer");
        set_gt_lastread(usr_id,gtmsgpath,top);
    }

/*  */

    free(fn);
    free(workbuf);
    free(mbuffer);
    free(fhdr);
    free(ghdr);

    return(0);
}


int  address_comp(ADDRTYPE addr1, ADDRTYPE addr2)
{
    if (addr1.zone == addr2.zone)
        if (addr1.net == addr2.net)
            if (addr1.node == addr2.node)
                if (addr1.point == addr2.point)  return 0;

    return 1;
}                

