#include "gt16.h"
#include "ftsc.h"
#include "transfer.h"
#include "datemath.h"
#include    <stdio.h>
#include    <conio.h>
#include    <stdlib.h>
#include    <string.h>
#include    <malloc.h>

#define WRAP_MARGIN  79

char  *monthstr[] = {"Jan", "Feb", "Mar", "Apr", "May", "Jun", "Jul", "Aug", "Sep", "Oct", "Nov", "Dec", NULL};

extern ADDRTYPE myaddress;

/*  Ŀ  */
/*                                                               */
/*   This module handles conversion between the message formats  */
/*                                                               */
/*    */

/* internal prototypes */

int ftsc_striphid(char *buf);
int stripgtorig(char *buf);
int textwrap(char *buf, int rmargin);

/* convert from fido to gt header */
int ftsc2gt_hdr(MSG_RECORD *gthd, FIDOHEADER *fidohd)
{
   long   julian_msg;
   int    msg_eday;
   int    dayofwk;

   char   mnstr[5];
   int    yrnum,monnum,daynum;
   int    hrnum,minnum;

   memset(gthd,0,127);
   gthd->msg_deleted = (unsigned char) 0;
   gthd->msg_number = 0;          /* needs to be set during appending */

   strncpy(gthd->msg_sender,fidohd->from,30);
   gthd->msg_sender[30] = (unsigned char) 0;
   strncpy(gthd->msg_addressee,fidohd->to,30);
   gthd->msg_addressee[30] = (unsigned char) 0;
   strncpy(gthd->msg_topic,fidohd->subj,30);
   gthd->msg_topic[30] = (unsigned char) 0;

   /* user fidohd->written to parse the fidohd->date string variable */
   /* format is dd Jan yy hh:mm:ss */

   sscanf(fidohd->date,"%02d %s %02d %02d:%02d",&daynum, mnstr, &yrnum,
                                                     &hrnum, &minnum);

   monnum = 0;
   while ((strstr(mnstr,monthstr[monnum]) == NULL) && (monnum < 11)) monnum++;
   monnum++;

   sprintf(gthd->msg_date,"%02d-%02d-%02d",monnum,daynum,yrnum);
   sprintf(gthd->msg_time,"%02d:%02d",hrnum,minnum);

   julian_msg = 0L;
   julian_msg = condate((yrnum + 1900),monnum,daynum);
   msg_eday = eday(julian_msg);

   dayofwk = ((msg_eday + 4) % 7) + 1;

   gthd->msg_weekday = (unsigned char) dayofwk;

   gthd->msg_flags.sticky = 0;
   gthd->msg_flags.fidoorg = 1;

   gthd->msg_filler = (unsigned char) 0;

   gthd->msg_dest_net = 0;
   gthd->msg_dest_node = 0;

   gthd->msg_perm_priv = (unsigned char) fidohd->attrib.private;
   gthd->msg_received = (unsigned char) 0;

   gthd->msg_reply_no[1] = 0;
   gthd->msg_reply_no[2] = 0;
   gthd->msg_reply_no[3] = 0;
   gthd->msg_orig_no = 0;

   return 0;
}


/**/

/* convert from gt to fido header */

int gt2ftsc_hdr(FIDOHEADER *fidohd, MSG_RECORD *gthd)

{
   long   julian_msg;
   /* int    msg_eday; */
   /* int    dayofwk; */
   int    mn,dy,yr,hr,mi;


   memset(fidohd,0,sizeof(FIDOHEADER));
   strncpy(fidohd->from,gthd->msg_sender,30);
   fidohd->from[30] = (unsigned char) 0;
   strncpy(fidohd->to,gthd->msg_addressee,30);
   fidohd->to[30] = (unsigned char) 0;
   strncpy(fidohd->subj,gthd->msg_topic,30);
   fidohd->subj[30] = (unsigned char) 0;

   sscanf(gthd->msg_date,"%02d-%02d-%02d",&mn,&dy,&yr);
   fidohd->written.mon = mn;
   fidohd->written.day = dy;
   fidohd->written.year = (yr - 80);

   julian_msg = jday_today();
   fidohd->arrived.mon = month(julian_msg);
   fidohd->arrived.day = day(julian_msg);
   fidohd->arrived.year = year(julian_msg) - 1980;

   sscanf(gthd->msg_time,"%02d:%02d",&hr,&mi);
   fidohd->written.hour = hr;
   fidohd->written.min = mi;
   fidohd->written.sec = 0;
   fidohd->arrived.hour = hr;
   fidohd->arrived.min = mi;
   fidohd->arrived.sec = 0;
   sprintf(fidohd->date,"%02d %s %02d %02d:%02d:00",dy,monthstr[mn - 1],yr,hr,mi);

   if (gthd->msg_perm_priv == 1)    /* allow private mail in echos if allowed on GT */
       fidohd->attrib.private = 1;
   else
       fidohd->attrib.private = 0;
       
   fidohd->attrib.crash = 0;
   fidohd->attrib.recvd = 0;
   fidohd->attrib.sent = 0;
   fidohd->attrib.attached = 0;
   fidohd->attrib.forward = 0;
   fidohd->attrib.orphan = 0;
   fidohd->attrib.killsent = 0;
   fidohd->attrib.local = 1;
   fidohd->attrib.hold = 0;
   fidohd->attrib.direct = 0;
   fidohd->attrib.freq = 0;
   fidohd->attrib.rreq = 0;
   fidohd->attrib.rcpt = 0;
   fidohd->attrib.areq = 0;
   fidohd->attrib.ureq = 0;

   fidohd->times = 1;
   fidohd->dest = 0;
   fidohd->orig = myaddress.node;
   fidohd->cost = 1;
   fidohd->orig_net = myaddress.net;
   fidohd->dest_net = 0;

   return 0;
}

/*  */
/* clean up the text buffer read in from fido for use in GT */

int ftsc2gt_buf(char *inbuf)
{
    ftsc_striphid(inbuf);
    textwrap(inbuf,WRAP_MARGIN);
    return 0;
}

int textwrap(char *buf, int rmargin)
{
    unsigned    int tmpoffs, moved;
    register    unsigned    int  curroffs;
    register    int currcol;

    curroffs = 0; currcol = 0; tmpoffs = 0; moved = 0;
    while(buf[curroffs])
    {
        if (currcol > rmargin)   /* wrap it */
        {
            if (moved)
            {
                buf[tmpoffs] = (unsigned char) 0x0A;
                curroffs = tmpoffs + 1;
                currcol = 0;
                moved = 0;
            }
            else
            {
                buf[curroffs] = (unsigned char) 0x0A;
                curroffs++;
                currcol = 0;
                moved = 0;
            }
        }
        if (buf[curroffs] == (unsigned char) 0x0A)
        {
            currcol = 0;
            moved = 0;
        }
        if (buf[curroffs] == (unsigned char) 0x20)
        {
            tmpoffs = curroffs;
            moved = 1;
        }
        curroffs++;
        currcol++;
    }
    return 0;
}

/*  */
/*  ftsc_striphid Ŀ */
/*   skip ^A lines                         */
/*   skip SEEN-BY lines                    */
/*   strip leading carriage returns        */
/*   strip solo 0x0D's                     */
/*   convert soft returns to hard returns  */
/*  */

int ftsc_striphid(char *buf)
{
    unsigned    char       *wk_buf,ch;
    register    unsigned   int     outoffs,inoffs,column;

    wk_buf = malloc(MAXMSGSZ);
    if (wk_buf == NULL)
    {
        printf("\nMemory allocation error _ftsc_striphid()\n\n ");
        exit(1);
    }
    memset(wk_buf,0,MAXMSGSZ);
    inoffs= 0;
    outoffs = 0;
    column = 0;

    while(buf[inoffs])
    {
        ch = (unsigned char) buf[inoffs];
        switch(ch)
        {
            case (unsigned char) 0x01:
                /* read to next EOL 0x0D or 0x0A */
                /* strchr returns pointer to found char */
                while(!(strchr("\n\r",buf[inoffs]))) inoffs++; /* read until new line */
                while(strchr("\n\r",buf[inoffs]))
                {
                    if (buf[inoffs] == (unsigned char) 0) break;
                    inoffs++; /* read till non lf char */
                }
                column = 0;
                break;

            case (unsigned char) 0x0A:
                /* end of line */
                if (column)
                {
                    wk_buf[outoffs] = (unsigned char) 0x0A;
                    outoffs++;
                    inoffs++;
                }
                else
                {
                    inoffs++;
                }
                column = 0;
                break;

            case (unsigned char) 0x0D:
                /* end of line */
                column = 0;
                wk_buf[outoffs] = (unsigned char) 0x0A;
                outoffs++;
                inoffs++;
                break;

            case (unsigned char) 0x8D:
                /* end of line */
                column = 0;
                wk_buf[outoffs] = (unsigned char) 0x0A;
                outoffs++;
                inoffs++;
                break;

            case 'S':
                /* check for SEEN-BY line */
                if ((strnicmp(&buf[inoffs],"SEEN-BY",7) == 0) && (column == 0))
                {
                    while(!(strchr("\n\r",buf[inoffs]))) inoffs++; /* read until new line */
                    while(strchr("\n\r",buf[inoffs]))
                    {
                        if (buf[inoffs] == (unsigned char) 0) break;
                        inoffs++; /* read till non lf char */
                    }
                }
                else
                {
                    wk_buf[outoffs] = (unsigned char) ch;
                    column++;
                    outoffs++;
                    inoffs++;
                }
                break;

            default:
                /* add char to line, check if overflow and count++ */
                wk_buf[outoffs] = (unsigned char) ch;
                outoffs++;
                inoffs++;
                column++;
                break;

        } /* end of switch */
    } /* end of while buf[inoffs] <> 0 */

    wk_buf[outoffs] = (unsigned char) 0; /* exited while loop because next char == 0 */

    strcpy(buf,wk_buf);
    free(wk_buf);
    return(0);
}

int gt2ftsc_buf(char *buf)
{
    register int  i;

    i = 0;
    while(buf[i])
    {
        if (buf[i] & 128) buf[i] = '#';
        if (buf[i] == '') buf[i] = ' ';
        i++;
    }
    stripgtorig(buf);
    return(0);
}

int stripgtorig(char *buf)
{
    char *rt_ptr;
    char *or_ptr;

    or_ptr = strstr(buf,"\n.ORIGIN:");
    if (or_ptr == NULL) return(1);

    rt_ptr = strstr(buf,"\n  Route: ");

    if (rt_ptr == NULL)
    {
        or_ptr[0] = (unsigned char) 0;
    }
    else
    {
        rt_ptr[0] = (unsigned char) 0;
    }
    return(0);
}

int brag_stomp(char *buf)
{
    char    *cptr,*nptr;

    cptr = strstr(buf,"\n--- ");
    while (cptr != NULL)
    {
        cptr[1] = (unsigned char) '_';
        cptr[2] = (unsigned char) '_';
        cptr[3] = (unsigned char) '_';

        cptr = strstr(buf,"\n--- ");
    }
    cptr = strstr(buf,"\r--- ");
    while (cptr != NULL)
    {
        cptr[1] = (unsigned char) '_';
        cptr[2] = (unsigned char) '_';
        cptr[3] = (unsigned char) '_';

        cptr = strstr(buf,"\r--- ");
    }

    if (buf[0] == ';')
    {
        /* kill leading ;rep line,etc */
        cptr = buf;
        nptr = strchr(buf,'\n');
        if (nptr == NULL) return 0;
        nptr++;

        while(nptr[0])
        {
            cptr[0] = nptr[0];
            cptr++;
            nptr++;
        }
        cptr[0] = (unsigned char) 0;
    }
    
    return(0);
}

