' FPCHECK.BAS - FaxTalk(TM) Plus Send Log Check v1.01
'
'             Written by:  Rod L Renner, SysOp
'                          The Lightning Rod BBS
'                          Silver Spring MD 20904
'                          phone 301-622-0708 (SupraFAX v.32bis)
'
'             This program is used in conjunction with Mark Herring's
'             PCB/FaxMail v1.01 gateway to provide the VERIFY function
'             when using FAXTalk Plus facsimile software.  It reads the
'             last entry in the SEND.LOG file and writes the OK file in
'             the current directory based on the last entry.
'             The possible entries in the first line of the OK file are:
'                 SUCCESS     - the file was successfully sent
'                 BUSY        - the phone was busy
'                 NOGOOD      - any other condition including inability
'                               for this program to read the SEND.LOG file.
'
'             If line 1 reports SUCCESS, line 2 of the OK file contains
'             the word "STATUS: " followed by additional information
'             from the log entry, including the status from the log,
'             the fax transmission time, connect speed, and recipient
'             fax's ID.  If line 2 reports BUSY or NOGOOD, additional
'             information in line 2 may give an indication as to the
'             problem.
'
' Calling sequence (in FaxMail's VERIFY command line):     
'
'             FPCHECK </B>  <filename-of-SEND.LOG>
'     where:
'             </B> tells FPCHECK to return a BUSY instead of a NOGOOD status
'             if the log file reports 'Failed'.  This is used to allow the
'             system to reschedule the fax via the /BUSY command.  At least
'             once in awhile, FPCHECK should be called w/o the /B to prevent
'             an infinite BUSY loop caused by a failure to connect.
'
'             <filename-of-SEND.LOG> is the path and filename of the
'             SEND.LOG file created by the FaxTalk Plus software
'             (FAXPLUS.EXE or SENDAFAX.EXE).  If this parameter is omitted,
'             FPCHECK assumes the name SEND.LOG in the default directory.
'
'             FPCHECK always writes the file OK in the default directory.
'                                  ------------
'             The program FPCHECK.BAS is Copyright 1993 by Rod L. Renner
'
'             The program is provided free of charge and may be run or
'             modified by the user for personal use. This file may also be
'             distributed so long as this original source code including all
'             remarks and documentation is not altered and is included with
'             distribution.
'
'             This program has been successfully tested using FaxTalk Plus
'             v1.65c for the SupraFAXModem(TM) v.32bis.  However, this
'             program is provided AS IS and WITHOUT WARRANTY OF ANY KIND.
'             Use at your own personal risk and expense!
'
'             FPCHECK was written and compiled in Microsoft QuickBASIC v4.5
'
'             FaxTalk(TM) is a Trademark of Thought Communications, Inc.
'             PCB/FaxMail 1.01 is Copyright 1993 by Mark Herring.
'             SupraFAXModem is a Trademark of Supra Corporation.
'
'  History:   03/08/93 - Release of version 1.0
'             03/11/93 - Release of version 1.01  - added the /B option
'
'
DEFINT A-Z
DIM logstat$(14), status$(14)
FOR i = 0 TO 14: READ logstat$(i): NEXT i
FOR i = 0 TO 14: READ status$(i): NEXT i
DATA LogErr,NoMatch,Abort,Busy,Failed,NoAns,NoLine,NoFile,Sent,SentBF
DATA SentEC,No BFT,No 2-D,ERR 01,ERR 02
DATA NOGOOD,NOGOOD,NOGOOD,BUSY,NOGOOD,NOGOOD,NOGOOD,NOGOOD,SUCCESS,SUCCESS
DATA SUCCESS,NOGOOD,NOGOOD,NOGOOD,NOGOOD
PRINT "FPCHECK v1.01 - Copyright 1993 by Rod L. Renner - Freeware"
PRINT "Check status of last entry in FaxTalk(TM) Plus' SEND.LOG file"

l$ = UCASE$(COMMAND$)
IF LEN(l$) > 0 THEN
   i = INSTR(l$, "/B")
   IF i > 0 THEN
      status$(4) = "BUSY"
      l$ = LEFT$(l$, i - 1) + MID$(l$, i + 2)
   END IF
END IF
l$ = LTRIM$(RTRIM$(l$))
IF LEN(l$) = 0 THEN l$ = "SEND.LOG"

ON ERROR GOTO oops
OPEN "I", 1, l$
i$ = INPUT$(2, 1)
nentry = CVI(i$) + 1
IF nentry <= 0 THEN GOTO logerr

i$ = INPUT$(2, 1)
loglength = CVI(i$) + 2
IF loglength < 76 THEN GOTO logerr

FOR i = 1 TO nentry
  IF EOF(1) THEN GOTO logerr
  i$ = INPUT$(loglength, 1)
  IF ASC(RIGHT$(i$, 1)) <> 0 THEN GOTO logerr
NEXT i

lstatus$ = RTRIM$(MID$(i$, 70, 6))

FOR nlog = 2 TO 14
   IF lstatus$ = logstat$(nlog) THEN GOTO wrtstatus
NEXT nlog

nlog = 1

wrtstatus:
IF nlog > 0 THEN
   extra$ = RTRIM$(MID$(i$, 70, loglength - 70)) + RTRIM$("  " + MID$(i$, 29, 21))
END IF

OPEN "O", 2, "OK"
PRINT #2, status$(nlog)
PRINT #2, "STATUS: "; extra$
CLOSE
PRINT "OK file: "; status$(nlog)
PRINT "         STATUS: "; extra$
END

oops:
RESUME logerr
logerr:
nlog = 0: extra$ = "Something is wrong with the log file: " + l$
GOTO wrtstatus

