#include <stdio.h>
#include <stdlib.h>     // needed for prototype of exit() etc.
#include <string.h>     // needed for the strcat routine

#include <dos.h>        // needed for Borland's findfirst/findnext
#include <dir.h>        // needed for MAXPATH define

#include "bool.h"       // Needed for BOOLEAN define

FILE *filelist;         //  Some globals cause I got lazy
FILE *pathlist;
char dirname[MAXPATH];
long i = 0;

void strip_trailing_spaces (char *s)
{
  register char *p;

  for (p = s + strlen (s) - 1;
       p >= s && *p == ' ';
       *(p--) = '\0')
  /* no body */ ;
}

// gets the directory name from argv[1]

BOOLEAN get_directory(void)
{
  BOOLEAN result = TRUE;

   dirname[0] = 0;
   (void) fscanf(pathlist,"%s", &dirname);
   strip_trailing_spaces(dirname);

   if(dirname[0] == 0){
    result = FALSE;
   }
   return result;
}

void usage(void)
{
 (void) fprintf(stderr,"Usage:  BldLst <pathfile> <filelist>\n");
 (void) fprintf(stderr,"PathFile: List of paths to search\n");
 (void) fprintf(stderr,"FileList: Name of file to contain files found\n");
 fcloseall();
 exit(1);
}

// files the files in each directory listed

BOOLEAN find_files(void)
{
 struct find_t ffblk;
 int done;

  if(!get_directory()){
    return FALSE;
  }

  (void) fprintf(stderr,"Processing: %s\n", dirname);
  strcat(dirname,"*.*"); // You could put some check for a backslash here
  done = _dos_findfirst(dirname, _A_NORMAL, &ffblk);
  while(!done){
    (void) fprintf(filelist,"%s\n", ffblk.name);
    i++;
    done = _dos_findnext(&ffblk);
  }
 return TRUE;
}

// opens up the files 1 for reading and 1 for writing

void open_files(char *first_name, char *second_name)
{
 if((pathlist = fopen(first_name,"r")) == (FILE *) NULL){
   (void) printf("Can not open PATHLIST\n");
   usage();
 }

 if((filelist = fopen(second_name,"w+")) == (FILE *) NULL){
   (void) printf("Can not open FILELIST\n");
   usage();
 }
}


int main (int argc, char *argv[])
{
  if(argc < 3){
   usage();
  }

  open_files(argv[1],argv[2]);

  while(find_files()){
   /* no body to while loop */
  }

  (void) fprintf(stderr,"\nNumber of Files found: %ld\n", i);
  fcloseall();
  return 0;
}

