;
;               MAKEPTS.LSP
;
;   Writes northing and easting to a file and places a point number
;   on the drawing by allowing the user to pick the endpoints of drawing
;   entities.
;
;   Copyright (c) 1991, D I Management Corporation
;
;
;
;
;
(prompt "\nLoading . . . .\n")

(defun makerr (s)

   (if (/= s "Function cancelled")
       (princ (strcat "\nError: " s))
   )
   (command "osnap" "none")
   (setvar "cmdecho" ocmd)
   (setq *error* olderr)
   (princ)
)

(defun C:makepts ()
    (setq ocmd (getvar "cmdecho"))
    (setvar "cmdecho" 0)
    (setq olderr  *error*
          *error* makerr)
    (setq nbr 1)
    (setq nmbr (itoa nbr))
    (setq pfx (getvar "dwgprefix"))             ; Get the output file name
    (prompt "\nEnter points file name -- no extension.")
    (setq fil (getstring "\n(Data will be appended to existing file:) "))
    (setq cfl (strcat pfx fil ".pts"))
    (setq datafile (open cfl "a"))              ; Open the data file
    (setq t1 "Text Height: <default = ")
    (setq t2 " >: ")
    (setq t3 (getvar "textsize"))
    (terpri)
    (setq tht (getreal (strcat t1 (rtos t3 2 2) t2)))
    (if (= tht nil)
        (setq tht t3))
    (setq finis "Y")
    (while (= finis "Y")
        (command "osnap" "end")
        (setq p1 (getpoint "\nCoordinates of which point? "))  ; Get the point
        (setq pquest (strcat "\nPoint number <" nmbr ">: "))   ; Get the number
        (setq nmbr (getstring pquest))
        (if (/= nmbr "")
            (setq nbr (atoi nmbr)))
        (setq e (rtos (car p1) 2 4))        ; Build the output string
        (setq n (rtos (cadr p1) 2 4))
        (setq nmbr (itoa nbr))
        (setq coord (strcat nmbr "    " n "    " e))
        (command "osnap" "none")
        (setq p2 (getpoint "\nPoint number location: "))
        (command "text" "m" p2 tht "" nmbr)                ; Write the point
        (write-line coord datafile)
        (setq finis (getstring "\nContinue <Y>: "))
        (if (= finis "")
            (setq finis "Y"))
        (setq nbr (atoi nmbr))         ; Increment point number
        (setq nbr (+ nbr 1))
        (setq nmbr (itoa nbr))
    )                                  ; All done
    (close datafile)                   ; Close data file
    (setq *error* olderr)              ; Restore old *error* handler
    (setvar "cmdecho" ocmd)            ; Restore old cmdecho
    (princ)
)
